/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.builder;

import com.huawei.ism.drm.topo.sdk.consts.TopoServiceConstants;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.utils.NodeDemension;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.twaver.DataBox;
import com.huawei.twaver.ElementBox;
import com.huawei.twaver.IData;
import com.huawei.twaver.IElement;
import com.huawei.twaver.Node;
import com.huawei.twaver.XMLSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TopoLegendBuilder {
    private static final double LEGEND_GROUP_INNER_SONS_GAP = 13.0;
    private static final double LEGEND_GROUP_INNER_LEFT_GAP = 15.0;
    private static final double LEGEND_GROUP_INNER_TOP_GAP = 5.0;
    private static final double CUTLINE_IMAGE_GAP = 60.0;
    private static final List<String> IMAGE_WITHOUT_CUTLINE = new ArrayList<String>(Arrays.asList("/theme/recoverydirector/images/topo/site2.png"));
    private static final List<String> IMAGE_COLOR_CUTLINE = new ArrayList<String>(Arrays.asList("/theme/recoverydirector/images/topo/cutline_color_normal.png", "/theme/recoverydirector/images/topo/cutline_color_offline.png", "/theme/recoverydirector/images/topo/cutline_color_fault.png", "/theme/recoverydirector/images/topo/cutline_color_unknown.png", "/theme/recoverydirector/images/topo/cutline_color_warning.png"));
    private ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();

    public String getLegendBoxString(ElementBox topobox) {
        ElementBox legend = new ElementBox();
        Node root = new Node();
        root.setClient("layout", (Object)"leftright");
        root.setClient("sonsGap", 60.0);
        root.setClient("leftGap", 1.0);
        this.defaultConfig(root);
        Node root1 = new Node();
        root1.setClient("layout", (Object)"topbottom");
        root1.setClient("sonsGap", 13.0);
        root1.setClient("leftGap", 15.0);
        this.defaultConfig(root1);
        Node root2 = new Node((Object)"legendColor-ID");
        root2.setClient("layout", (Object)"topbottom");
        root2.setClient("sonsGap", 13.0);
        root2.setClient("leftGap", 1.0);
        this.defaultConfig(root2);
        legend.getLayerBox().getDefaultLayer().setMovable(false);
        legend.getLayerBox().getDefaultLayer().setEditable(false);
        legend.setStyle("select.alpha", 1.0);
        legend.setStyle("select.style", (Object)"none");
        TopoServiceUtil.addElementToBox(legend, (IData)root);
        root.addChild((IData)root1);
        TopoServiceUtil.addElementToBox(legend, (IData)root1);
        root.addChild((IData)root2);
        TopoServiceUtil.addElementToBox(legend, (IData)root2);
        this.addRootLegend(topobox, legend, root1, root2);
        TopoServiceUtil.computeNodeWidthAndHight(root);
        return new XMLSerializer((DataBox)legend).serializeCommon();
    }

    private void defaultConfig(Node root2) {
        root2.setClient("topGap", 5.0);
        root2.setStyle("vector.fill", false);
        root2.setStyle("content.type", (Object)"vector");
        root2.setStyle("vector.shape", (Object)"rectangle");
        root2.setClient("TopoModel", (Object)"instanceGroup");
    }

    private void addRootLegend(ElementBox topobox, ElementBox legend, Node root1, Node root2) {
        boolean hasAsynImg = false;
        for (Object obj : topobox.getDatas()) {
            hasAsynImg = this.eachBoxData(legend, root1, hasAsynImg, obj);
        }
        if (hasAsynImg) {
            this.buildColourImg(legend, root1, "/theme/recoverydirector/images/topo/cutline_replicationpolice.png", this.resourceManager.getText("ism.drm.topo.instance.replicationpolice"));
        }
        if (root1.hasChildren()) {
            this.addColorLegend(legend, root2);
        }
    }

    private boolean eachBoxData(ElementBox legend, Node root1, boolean hasAsynImg, Object obj) {
        Node node;
        if (obj instanceof IElement) {
            IElement element = (IElement)obj;
            element.setStyle("select.alpha", (Object)1.0);
            element.setStyle("select.style", (Object)"none");
            Object styleObj = element.getStyle("icons.names");
            if (null != styleObj && "/theme/recoverydirector/images/topo/ic_asynchronous.png".equalsIgnoreCase(styleObj.toString())) {
                hasAsynImg = true;
            }
        }
        if (obj instanceof Node && !this.addLegend(legend, root1, (node = (Node)obj).getImage())) {
            this.addLegend(legend, root1, node.getIcon());
        }
        return hasAsynImg;
    }

    private void addColorLegend(ElementBox legend, Node root) {
        for (String imagePath : IMAGE_COLOR_CUTLINE) {
            String label = this.constrcutLegendLabelByImage(imagePath);
            this.buildColourImg(legend, root, imagePath, label);
        }
    }

    private void buildColourImg(ElementBox legend, Node root, String imagePath, String label) {
        Node legendNode = new Node((Object)imagePath);
        legendNode.setStyle("label.position", (Object)"right.right");
        legendNode.setImage(imagePath);
        this.legendDefaultConfig(imagePath, label, legendNode);
        root.addChild((IData)legendNode);
        TopoServiceUtil.addElementToBox(legend, (IData)legendNode);
    }

    private void legendDefaultConfig(String imagePath, String label, Node legendNode) {
        NodeDemension.update((Node)legendNode, (String)imagePath);
        legendNode.setName(label);
        legendNode.setToolTip(label);
        legendNode.setStyle("label.font", (Object)this.resourceManager.getText("ism.drm.topo.label.font"));
        legendNode.setStyle("select.alpha", 1.0);
        legendNode.setStyle("select.style", (Object)"none");
    }

    private boolean addLegend(ElementBox legend, Node root, String image) {
        if (image == null || !image.contains("/theme/recoverydirector/images/topo")) {
            return false;
        }
        image = image.replace("_invalid", "").replace("_inactive", "").replace("_switched", "").replace("_offline", "").replace("_unknown", "").replace("_faulty", "").replace("_warning", "").replace("_active", "");
        if (legend.containsByID((Object)(image = image.replace("/theme/recoverydirector/images/topo/esxserver.png", "/theme/recoverydirector/images/topo/host.png").replace("/theme/recoverydirector/images/topo/fusionspherehost.png", "/theme/recoverydirector/images/topo/host.png").replace("/theme/recoverydirector/images/topo/vmcluster.png", "/theme/recoverydirector/images/topo/hostgroup.png").replace("/theme/recoverydirector/images/topo/fusionspherecluster.png", "/theme/recoverydirector/images/topo/hostgroup.png"))) || IMAGE_WITHOUT_CUTLINE.contains(image)) {
            return true;
        }
        Node legendNode = new Node((Object)image);
        String cutlineImage = "";
        legendNode.setStyle("label.position", (Object)"right.right");
        if (!image.isEmpty() && image.indexOf("/") != -1) {
            String imagePath = image.substring(0, image.lastIndexOf("/") + 1);
            String imageName = image.substring(image.lastIndexOf("/") + 1);
            cutlineImage = imagePath + "cutline_" + imageName;
            legendNode.setImage(cutlineImage);
            String label = this.constrcutLegendLabelByImage(cutlineImage);
            this.legendDefaultConfig(cutlineImage, label, legendNode);
        }
        root.addChild((IData)legendNode);
        TopoServiceUtil.addElementToBox(legend, (IData)legendNode);
        return true;
    }

    private String constrcutLegendLabelByImage(String image) {
        for (Map.Entry entry : TopoServiceConstants.CUTLINE_IMAGE_MAP.entrySet()) {
            if (!((String)entry.getKey()).equals(image)) continue;
            return this.resourceManager.getText((String)entry.getValue());
        }
        return "--";
    }
}

