/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.element;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.topo.skin.BucketSkin;
import com.huawei.ism.drm.topo.twaver.TopoElement;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import java.util.Map;
import java.util.Set;

public class BucketElement
extends TopoElement {
    public BucketElement() {
    }

    public BucketElement(Object id) {
        super(id);
    }

    public BucketElement(Object id, String name) {
        super(id, name);
        this.use(new BucketSkin());
    }

    public BucketElement(Object id, String name, String type, Set<Map<String, String>> replicaParams) {
        super(id, name);
        this.use(new BucketSkin());
        if (type.equals("7")) {
            this.setImage("/theme/recoverydirector/images/topo/backup_bucket_icon.png");
        } else if (type.equals("100")) {
            this.setImage("/theme/recoverydirector/images/topo/cloud_bucket_icon.png");
        }
        String tipMsg = this.createToolTip(name, type, replicaParams);
        if (!VerifyUtil.isEmpty((String)tipMsg)) {
            this.setToolTip(tipMsg);
        } else {
            this.setToolTip("----");
        }
    }

    private String createToolTip(String bucketName, String type, Set<Map<String, String>> replicaParams) {
        StringBuilder builder = new StringBuilder();
        if (type.equals("7")) {
            TooltipUtil.appendTooltip(builder, "ism.drm.topo.instance.backup.bucket", bucketName);
        } else if (type.equals("100")) {
            TooltipUtil.appendTooltip(builder, "ism.drm.topo.instance.cloud.vault", bucketName);
        }
        if (VerifyUtil.isEmpty(replicaParams)) {
            TooltipUtil.appendTooltip(builder, "ism.drm.topo.duplicate.amount", "0");
            return builder.toString();
        }
        replicaParams.remove(null);
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.duplicate.amount", String.valueOf(replicaParams.size()));
        for (Map<String, String> map : replicaParams) {
            if (VerifyUtil.isEmpty(map)) continue;
            Set<Map.Entry<String, String>> replicaParamSet = map.entrySet();
            for (Map.Entry<String, String> replicaParam : replicaParamSet) {
                this.appendTooltipNoKey(builder, String.valueOf(replicaParam.getValue()));
            }
        }
        return builder.toString();
    }
}

