/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.utils;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.topo.element.PGElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.model.Topo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.twaver.ElementBox;
import com.huawei.twaver.IData;
import com.huawei.twaver.Layer;
import com.huawei.twaver.Node;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

public class TopoBuildUtil {
    public static final Log logger = LogFactory.getInstance(TopoBuildUtil.class);
    public static final String SRC_DEVICE_SN = "srcDeviceSn";
    public static final String TGT_DEVICE_SN = "tgtDeviceSn";
    public static final String TGT_LUN_ID = "tgtLunId";
    public static final String DEV_SN = "devSn";
    public static final String TGT_DEV_SN = "tgtDevSN";

    public static ElementBox initializeContext(TopoBaseContext context) {
        PGElement root = new PGElement(null);
        ElementBox box = context.getElementBox();
        box.setStyle("background.type", (Object)"image");
        box.setStyle("background.image", (Object)"/theme/recoverydirector/images/topo/default.png");
        box.setStyle("background.image.stretch", (Object)"tile");
        context.setRootNode((Node)root);
        context.add((IData)root);
        String linkLayerId = "linkLayer";
        Layer layer = new Layer((Object)linkLayerId);
        box.getLayerBox().add((IData)layer);
        box.getLayerBox().moveTo((IData)layer, 1);
        Layer layer0 = new Layer((Object)"layer0");
        box.getLayerBox().add((IData)layer0);
        box.getLayerBox().moveTo((IData)layer0, 0);
        layer.setEditable(false);
        layer.setMovable(false);
        return box;
    }

    public static List<HyperCloneTargetLun> getTrgLunListFromDB(String srcSN, List<String> trgLunIds) {
        List<Object> listCloneTargetLun = new ArrayList<HyperCloneTargetLun>();
        try {
            HashMap<String, Object> trgProps = new HashMap<String, Object>();
            trgProps.put(DEV_SN, srcSN);
            trgProps.put("id", trgLunIds.toArray());
            listCloneTargetLun = CommonDAOLocator.getMoDao().findMoBy(HyperCloneTargetLun.class, trgProps);
        }
        catch (Exception e) {
            logger.error((Object)("get TargetLuns By devSn And LunID failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return listCloneTargetLun;
    }

    public static List<ReplicationTargetLun> getTrgLunListFromDB(String srcSN, String trgSN, List<String> listTrgLunID) {
        List<Object> listReplicationTargetLun = new ArrayList<ReplicationTargetLun>();
        try {
            HashMap<String, Object> trgProps = new HashMap<String, Object>();
            trgProps.put(TGT_DEV_SN, trgSN);
            trgProps.put(DEV_SN, srcSN);
            trgProps.put(TGT_LUN_ID, listTrgLunID.toArray());
            listReplicationTargetLun = CommonDAOLocator.getMoDao().findMoBy(ReplicationTargetLun.class, trgProps);
        }
        catch (Exception e) {
            logger.error((Object)("get TargetLuns By devSn And LunID failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return listReplicationTargetLun;
    }

    public static Map<String, Object> buildUriVariables(String srcSN, String trgSN, List<String> lunIDs) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put(SRC_DEVICE_SN, srcSN);
        uriVariables.put(TGT_DEVICE_SN, trgSN);
        StringBuilder tgtLunIds = new StringBuilder();
        for (String lunID : lunIDs) {
            tgtLunIds.append(lunID).append(';');
        }
        String tgtLunIdStr = tgtLunIds.toString();
        uriVariables.put(TGT_LUN_ID, tgtLunIdStr.substring(0, tgtLunIdStr.length() - 1));
        return uriVariables;
    }

    public static String getLayoutXml(String topoIndexId) {
        String info = null;
        try {
            Topo topoInfo = (Topo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Topo.class, (Serializable)((Object)topoIndexId));
            if (topoInfo != null) {
                info = topoInfo.getTopoDetail();
            }
        }
        catch (DataAccessException ex) {
            logger.error((Object)"unable to get sites", (Throwable)ex, 90160758786873L);
        }
        return info;
    }
}

