/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.discovery.process;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.StorageArray;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessorEx;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.drm.storage.sdk.model.ReplicationLink;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReplicationLinkProcessorEx
implements IProcessorEx {
    private static final int LINK_TYPE_FC = 1;
    private static final int LINK_TYPE_ISCSI = 2;
    private static final int LINK_TYPE_IP = 3;
    private static final Log logger = LogFactory.getInstance(ReplicationLinkProcessorEx.class);

    public void clean(AbstractContext context) {
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void postProcess(AbstractContext context) {
    }

    public boolean process(AbstractContext context) {
        StorageArray storageArray = (StorageArray)context.getAttribute("StorageArray");
        HvsUnit hvsUnit = (HvsUnit)context.getAttribute("ArrayUnit");
        if (null == storageArray || null == hvsUnit) {
            logger.error((Object)"storageArray or hvsUnit is null", 90160777658373L);
            return false;
        }
        String devSn = hvsUnit.getDevSn();
        HashMap<String, String> deviceWWNAndSNMAP = new HashMap<String, String>();
        HashMap<String, String> deviceIDAndSNMAP = new HashMap<String, String>();
        RestConnection hvsConnection = (RestConnection)HvsRestConnectionManager.getInstance().getConnectionOptional(devSn).orElseThrow(() -> new LegoCheckedException(104401L));
        String url = "/rest/${deviceID}/remote_device";
        logger.debug((Object)"Get RemoteDevices: url = %s, devSn = %s", new Object[]{url, devSn});
        List resultMapList = hvsConnection.getBatch(url, null);
        this.getDeviceMapInfo(resultMapList, deviceWWNAndSNMAP, deviceIDAndSNMAP, devSn);
        this.queryFcLink(hvsUnit, devSn, deviceWWNAndSNMAP, hvsConnection);
        this.queryIscsiLink(hvsUnit, devSn, deviceIDAndSNMAP, hvsConnection);
        this.queryIpLink(hvsUnit, devSn, deviceIDAndSNMAP, hvsConnection);
        return true;
    }

    private void queryIpLink(HvsUnit hvsUnit, String deviceSN, Map<String, String> deviceIDAndSNMAP, RestConnection hvsConnection) {
        String url = "/rest/${deviceID}/iplink";
        try {
            logger.debug((Object)"Get ip_link: url = %s, devSn = %s", new Object[]{url, deviceSN});
            List resultIpLinkMapList = hvsConnection.getBatch(url, null);
            for (Map record : resultIpLinkMapList) {
                String linkUsage = (String)record.get("LINKUSAGE");
                if (null == linkUsage) {
                    logger.error((Object)"linkUsage is null");
                    continue;
                }
                if (linkUsage.equalsIgnoreCase("false")) continue;
                ReplicationLink replicationLink = new ReplicationLink();
                replicationLink.setLinkType(3);
                replicationLink.setDeviceId(deviceSN);
                String strDevID = (String)record.get("DEVICEID");
                replicationLink.setLinkId(deviceSN + ":" + strDevID);
                replicationLink.setUuid(replicationLink.getLinkId());
                replicationLink.setRemoteArrayId(deviceIDAndSNMAP.get(strDevID));
                replicationLink.setLinkStatus(Integer.parseInt((String)record.get("RUNNINGSTATUS")));
                hvsUnit.addChildMo((ManagedObject)replicationLink);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Get IP_link: url = " + url + " Storage[" + deviceSN + "] transition to IP replication link failed"), 90160777658373L);
        }
    }

    private void queryIscsiLink(HvsUnit hvsUnit, String deviceSN, Map<String, String> deviceIDAndSNMAP, RestConnection hvsConnection) {
        String url = "/rest/${deviceID}/iscsi_link";
        logger.debug((Object)"Get iscsi_link: url = %s, devSn = %s", new Object[]{url, deviceSN});
        List resultIscsiLinkMapList = hvsConnection.getBatch(url, null);
        for (Map record : resultIscsiLinkMapList) {
            try {
                String linkUsage = (String)record.get("LINKUSAGE");
                if (null == linkUsage) {
                    logger.error((Object)"linkUsage is null");
                    continue;
                }
                if (linkUsage.equalsIgnoreCase("false")) continue;
                ReplicationLink replicationLink = new ReplicationLink();
                replicationLink.setDeviceId(deviceSN);
                replicationLink.setLinkType(2);
                String strDevID = (String)record.get("DEVICEID");
                replicationLink.setLinkId(deviceSN + ":" + strDevID);
                replicationLink.setUuid(replicationLink.getLinkId());
                replicationLink.setRemoteArrayId(deviceIDAndSNMAP.get(strDevID));
                replicationLink.setLinkStatus(Integer.parseInt((String)record.get("RUNNINGSTATUS")));
                hvsUnit.addChildMo((ManagedObject)replicationLink);
            }
            catch (Exception e) {
                logger.error((Object)("Get iscsi_link: url = " + url + " Storage[" + deviceSN + "] transition to iscsi replication link failed"), 90160777658373L);
            }
        }
    }

    private void queryFcLink(HvsUnit hvsUnit, String deviceSN, Map<String, String> deviceWWNAndSNMAP, RestConnection hvsConnection) {
        String url = "/rest/${deviceID}/fc_link";
        logger.debug((Object)"Get fc_link: url = %s, deviceSn = %s", new Object[]{url, deviceSN});
        List resultLinkMapList = hvsConnection.getBatch(url, null);
        for (Map record : resultLinkMapList) {
            try {
                if ("false".equalsIgnoreCase((String)record.get("LINKUSAGE"))) continue;
                ReplicationLink replicationLink = new ReplicationLink();
                replicationLink.setDeviceId(deviceSN);
                replicationLink.setLinkType(1);
                replicationLink.setLinkId(deviceSN + ":" + (String)record.get("DEVICEID"));
                replicationLink.setUuid(replicationLink.getLinkId());
                String strWWN = (String)record.get("DEVICEWWN");
                replicationLink.setRemoteArrayId(deviceWWNAndSNMAP.get(strWWN));
                replicationLink.setLinkStatus(Integer.parseInt((String)record.get("RUNNINGSTATUS")));
                hvsUnit.addChildMo((ManagedObject)replicationLink);
            }
            catch (Exception e) {
                logger.error((Object)("Get fc_link:  url = " + url + "Storage[" + deviceSN + "] transition to FC replication link failed"), 90160777658373L);
            }
        }
    }

    private void getDeviceMapInfo(List<Map<String, String>> resultMapList, Map<String, String> deviceWWNAndSNMAP, Map<String, String> deviceIDAndSNMAP, String deviceSN) {
        if (resultMapList != null) {
            for (Map<String, String> record : resultMapList) {
                try {
                    String strWWN = record.get("WWN");
                    String strSN = record.get("SN");
                    String strDevID = record.get("ID");
                    if (strSN == null) continue;
                    if (strWWN != null) {
                        deviceWWNAndSNMAP.put(strWWN, strSN);
                    }
                    if (strDevID == null) continue;
                    deviceIDAndSNMAP.put(strDevID, strSN);
                }
                catch (Exception e) {
                    logger.warn((Object)("Storage[" + deviceSN + "] transition to remote device failed"), 90160777658373L);
                }
            }
        }
    }

    public Set<String> getSupportedManagementProtocolTypes() {
        HashSet<String> protocolTypes = new HashSet<String>();
        protocolTypes.add("REST");
        return protocolTypes;
    }
}

