/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.discovery.proxy;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.QuorumServer;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceProxyExtend;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.sdk.model.HyperClone;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.ism.unistor.sdk.model.HyperDRRing;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HvsDeviceProxyExtendImpl
implements HvsDeviceProxyExtend {
    private static final Log logger = LogFactory.getInstance(HvsDeviceProxyExtendImpl.class);

    @Override
    public List<HyperClone> getAllHyperClones(RestConnection conn, String deviceSN) {
        if (VerifyUtil.isEmpty((String)deviceSN) || null == conn) {
            return new ArrayList<HyperClone>();
        }
        String url = "/rest/${deviceID}/splitmirror?range=[0-65536]";
        logger.debug((Object)"Get hyperClones: url = %s, deviceSn = %s", new Object[]{url, deviceSN});
        List hyperCloneResults = conn.getBatch(url, null);
        ArrayList<HyperClone> hyperClones = new ArrayList<HyperClone>();
        for (Map record : hyperCloneResults) {
            try {
                HyperClone hyperClone = HVSRestTransitionExtend.transitionHyperClone(record, deviceSN);
                hyperClones.add(hyperClone);
                List<HyperCloneTargetLun> hyperCloneTargetLuns = this.getHyperCloneTargetLuns(conn, deviceSN, hyperClone.getId());
                for (HyperCloneTargetLun targetLun : hyperCloneTargetLuns) {
                    targetLun.setParentMo((ManagedObject)hyperClone);
                    hyperClone.addChildMo((ManagedObject)targetLun);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Storage[" + deviceSN + "] transition to hyper clone failed, url is " + url + ", response map is " + record.toString()), 90160777658373L);
            }
        }
        return hyperClones;
    }

    @Override
    public List<HyperCloneTargetLun> getHyperCloneTargetLuns(RestConnection hvsRestConnection, String deviceSN, String hyperCloneId) {
        if (VerifyUtil.isEmpty((String)deviceSN) || null == hvsRestConnection || VerifyUtil.isEmpty((String)hyperCloneId)) {
            return new ArrayList<HyperCloneTargetLun>();
        }
        String requestUrl = "/rest/${deviceID}/SPLITMIRRORTARGETLUN/targetLun?TYPE=228&PARENTID=" + hyperCloneId + "&PARENTTYPE=220";
        logger.debug((Object)"Get hyperCloneTgtLun: url = %s, deviceID = %s", new Object[]{requestUrl, deviceSN});
        List hyperCloneTgtLunResults = hvsRestConnection.getBatch(requestUrl, null);
        ArrayList<HyperCloneTargetLun> hyperCloneTgtLuns = new ArrayList<HyperCloneTargetLun>();
        for (Map record : hyperCloneTgtLunResults) {
            try {
                HyperCloneTargetLun hyperCloneTgtLun = HVSRestTransitionExtend.transitionHyperCloneTargetLun(record, deviceSN);
                hyperCloneTgtLuns.add(hyperCloneTgtLun);
            }
            catch (Exception e) {
                logger.warn((Object)("Storage[" + deviceSN + "] transition to hyper clone target lun failed, url is " + requestUrl + ", response map is " + record.toString()), 90160777658373L);
            }
        }
        return hyperCloneTgtLuns;
    }

    @Override
    public List<QuorumServer> getQuorumServers(RestConnection hvsRestConnection) {
        String devSn = hvsRestConnection.getDeviceId();
        ArrayList<QuorumServer> servers = new ArrayList<QuorumServer>();
        String url = "/rest/${deviceID}/QuorumServer?range=[0-65536]";
        logger.debug((Object)"Get quorumServers: url = %s, deviceId = %s", new Object[]{url, devSn});
        List records = hvsRestConnection.getBatch(url, null);
        for (Map record : records) {
            QuorumServer quorumServer = HVSRestTransitionExtend.transitionQuorumServer(devSn, record);
            servers.add(quorumServer);
        }
        return servers;
    }

    @Override
    public List<QuorumServerLink> getQuorumServerLinks(RestConnection hvsRestConnection) {
        String devSn = hvsRestConnection.getDeviceId();
        ArrayList<QuorumServerLink> links = new ArrayList<QuorumServerLink>();
        String url = "/rest/${deviceID}/QuorumServerLink?range=[0-65536]";
        logger.debug((Object)"Get quorumServerLinks: url = %s, deviceId = %s", new Object[]{url, devSn});
        List records = hvsRestConnection.getBatch(url, null);
        for (Map record : records) {
            QuorumServerLink link = HVSRestTransitionExtend.transitionQuorumServerLink(devSn, record);
            links.add(link);
        }
        return links;
    }

    @Override
    public List<HyperMetroDomain> getHyperMetroDomains(RestConnection hvsRestConnection) {
        String devSn = hvsRestConnection.getDeviceId();
        ArrayList<HyperMetroDomain> domains = new ArrayList<HyperMetroDomain>();
        String url = "/rest/${deviceID}/HyperMetroDomain?range=[0-65536]";
        logger.debug((Object)"Get hyperMetroDomains: url = %s, deviceId = %s", new Object[]{url, devSn});
        List records = hvsRestConnection.getBatch(url, null);
        for (Map record : records) {
            HyperMetroDomain domain = HVSRestTransitionExtend.transitionHyperMetroDomain(devSn, record);
            domains.add(domain);
        }
        return domains;
    }

    @Override
    public List<HyperMetroPair> getHyperMetroPairs(RestConnection hvsRestConnection, String vstoreId) {
        String devSn = hvsRestConnection.getDeviceId();
        ArrayList<HyperMetroPair> pairs = new ArrayList<HyperMetroPair>();
        String url = "/rest/${deviceID}/HyperMetroPair?range=[0-65536]";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&vstoreId=" + vstoreId;
        }
        logger.debug((Object)"Get hyperMetroPairs: url = %s, deviceId = %s", new Object[]{url, devSn});
        List records = hvsRestConnection.getBatch(url, null);
        for (Map record : records) {
            HyperMetroPair pair = HVSRestTransitionExtend.transitionHyperMetroPair(devSn, record);
            pairs.add(pair);
        }
        return pairs;
    }

    @Override
    public List<HyperMetroConsistentGroup> getHyperMetroConsistentGroups(RestConnection hvsRestConnection) {
        String devSn = hvsRestConnection.getDeviceId();
        ArrayList<HyperMetroConsistentGroup> groups = new ArrayList<HyperMetroConsistentGroup>();
        String url = "/rest/${deviceID}/HyperMetro_ConsistentGroup?range=[0-65536]";
        logger.debug((Object)"Get HyperMetro_ConsistentGroup: url = %s, deviceId = %s", new Object[]{url, devSn});
        List records = hvsRestConnection.getBatch(url, null);
        for (Map record : records) {
            HyperMetroConsistentGroup group = HVSRestTransitionExtend.transitionHyperMetroCg(devSn, record);
            groups.add(group);
        }
        return groups;
    }

    @Override
    public List<VstoreHyperMetroPair> getVstoreHyperMetroPairs(RestConnection conn) {
        if (VerifyUtil.isEmpty((Object)conn)) {
            return Collections.emptyList();
        }
        String devSn = conn.getDeviceId();
        List records = null;
        String url = "/rest/${deviceID}/vstore_pair?range=[0-65536]";
        logger.debug((Object)"Get vstore_pair: url = %s, deviceId = %s", new Object[]{url, devSn});
        try {
            records = conn.getBatch(url, null);
        }
        catch (LegoCheckedException e) {
            if (404L == e.getErrorCode()) {
                logger.error((Object)"the device can not support vstore pair, url = %s, device = %s", new Object[]{url, conn.getDeviceId()});
                return Collections.emptyList();
            }
            logger.error((Object)"get vstore pair error by device, url = %s, device = %s", new Object[]{url, conn.getDeviceId()});
            throw e;
        }
        if (VerifyUtil.isEmpty((Collection)records)) {
            return Collections.emptyList();
        }
        ArrayList<VstoreHyperMetroPair> vstoreHyperMetroPairs = new ArrayList<VstoreHyperMetroPair>();
        for (Map record : records) {
            VstoreHyperMetroPair vstoreHyperMetroPair = HVSRestTransitionExtend.transitionVstoreHyperMetroPair(devSn, record);
            vstoreHyperMetroPairs.add(vstoreHyperMetroPair);
        }
        return vstoreHyperMetroPairs;
    }

    @Override
    public List<VstoreReplicationPair> getVstoreReplicationPairs(RestConnection conn) {
        if (VerifyUtil.isEmpty((Object)conn)) {
            return Collections.emptyList();
        }
        String devSn = conn.getDeviceId();
        List records = null;
        String url = "/rest/${deviceID}/REPLICATION_VSTOREPAIR?range=[0-65536]";
        logger.debug((Object)"Get vstoreReplicationPairs: url = %s, deviceId = %s", new Object[]{url, devSn});
        try {
            records = conn.getBatch(url, null);
        }
        catch (LegoCheckedException e) {
            if (404L == e.getErrorCode()) {
                logger.error((Object)"the device can not support replication vstore pair, url = %s, deviceID = %s", new Object[]{url, conn.getDeviceId()});
                return Collections.emptyList();
            }
            logger.error((Object)"get replication vstore pair error by device, url = %s, deviceID = %s", new Object[]{url, conn.getDeviceId()});
            throw e;
        }
        if (VerifyUtil.isEmpty((Collection)records)) {
            return Collections.emptyList();
        }
        ArrayList<VstoreReplicationPair> vstoreReplicationPairs = new ArrayList<VstoreReplicationPair>();
        for (Map record : records) {
            VstoreReplicationPair vstoreHyperMetroPair = HVSRestTransitionExtend.transitionVstoreReplicationPair(devSn, record);
            vstoreReplicationPairs.add(vstoreHyperMetroPair);
        }
        return vstoreReplicationPairs;
    }

    @Override
    public List<HyperDRRing> getHyperDRRings(RestConnection conn) {
        String devSn = conn.getDeviceId();
        ArrayList<HyperDRRing> rings = new ArrayList<HyperDRRing>();
        String url = "/rest/${deviceID}/dr_star?range=[0-65536]";
        logger.debug((Object)"Get dr_star: url = %s, deviceId = %s", new Object[]{url, devSn});
        List records = conn.getBatch(url, null);
        this.constructHyperDRRing(devSn, records, rings);
        return rings;
    }

    @Override
    public List<HyperDRRing> getHyperDRRings(RestConnection conn, Set<String> ids) {
        String devSn = conn.getDeviceId();
        ArrayList<HyperDRRing> rings = new ArrayList<HyperDRRing>();
        if (VerifyUtil.isEmpty(ids)) {
            return rings;
        }
        for (String id : ids) {
            if (VerifyUtil.isEmpty((String)id)) continue;
            String url = "/rest/${deviceID}/dr_star/" + id;
            logger.debug((Object)"Get dr_star: url = %s, deviceId = %s", new Object[]{url, devSn});
            List records = conn.getBatch(url, null);
            this.constructHyperDRRing(devSn, records, rings);
        }
        return rings;
    }

    private void constructHyperDRRing(String devSn, List<Map<String, String>> records, List<HyperDRRing> rings) {
        if (VerifyUtil.isEmpty(records)) {
            return;
        }
        for (Map<String, String> record : records) {
            HyperDRRing ring = HVSRestTransitionExtend.transitionHyperDRRing(devSn, record);
            rings.add(ring);
        }
    }
}

