/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.discovery.util;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.QuorumServer;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveTLVParent;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.storage.constant.HcResourceType;
import com.huawei.ism.drm.storage.hvs.model.CreateHyperMetroConsistentGroupRes;
import com.huawei.ism.drm.storage.hvs.model.CreateHyperMetroPairResponse;
import com.huawei.ism.drm.storage.manager.sdk.model.StorageHyperMetroDomain;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.DoradoHyperClone;
import com.huawei.ism.drm.storage.sdk.model.HyperClone;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.ism.drm.storage.sdk.model.LunConsistencyGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.SnapshotConsistentGroup;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroGroup;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.ism.unistor.sdk.model.HyperDRRing;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public final class HVSRestTransitionExtend {
    private static final Log logger = LogFactory.getInstance(HVSRestTransitionExtend.class);

    private HVSRestTransitionExtend() {
    }

    public static ReplicationPair transitionReplicationPair(Map<String, String> record, String ownerDeviceId) {
        String consistentGroupId;
        ReplicationPair replicationPair = new ReplicationPair();
        Boolean isPrimary = Boolean.valueOf(record.get("ISPRIMARY"));
        String localLunId = record.get("LOCALRESID");
        String remoteLunId = record.get("REMOTERESID");
        String priLunName = record.get("LOCALRESNAME");
        String srcDeviceName = "";
        if (!isPrimary.booleanValue()) {
            localLunId = remoteLunId;
            priLunName = record.get("REMOTERESNAME");
            srcDeviceName = record.get("REMOTEDEVICENAME");
        }
        if (null != (consistentGroupId = record.get("CGID")) && (consistentGroupId.isEmpty() || consistentGroupId.equals("ffffffffffffffff"))) {
            consistentGroupId = null;
        }
        String replicationId = record.get("ID");
        Integer replicationMode = NumberUtil.convertToInteger((Object)record.get("REPLICATIONMODEL"), (int)Integer.MIN_VALUE);
        String remoteDeviceSN = record.get("REMOTEDEVICESN");
        String priArrayWWN = ownerDeviceId;
        if (!isPrimary.booleanValue()) {
            priArrayWWN = remoteDeviceSN;
        }
        Integer runningStatus = NumberUtil.convertToInteger((Object)record.get("RUNNINGSTATUS"), (int)Integer.MIN_VALUE);
        Integer healthStatus = NumberUtil.convertToInteger((Object)record.get("HEALTHSTATUS"), (int)Integer.MIN_VALUE);
        HVSRestTransitionExtend.solveLocalResType(record, replicationPair);
        replicationPair.setSrcLunId(localLunId);
        replicationPair.setSrcLunName(priLunName);
        Long priLunCapacity = NumberUtil.convertToLong((Object)record.get("CAPACITY"), (long)Long.MIN_VALUE);
        double srcLunCapacity = UnitConvert.convert((Double)priLunCapacity.doubleValue(), (IUnitType)CapabilityUnitType.KB, (IUnitType)CapabilityUnitType.MB);
        replicationPair.setSrcLunCapacity(Double.valueOf(srcLunCapacity));
        replicationPair.setSrcDevSN(priArrayWWN);
        replicationPair.setConsistentGroupId(consistentGroupId);
        replicationPair.setReplicationId(replicationId);
        replicationPair.setReplicationName(replicationId);
        replicationPair.setReplicationMode(replicationMode);
        replicationPair.setIsPrimary(isPrimary);
        replicationPair.setRelationType(Integer.valueOf(0));
        replicationPair.setRunningState(String.valueOf(runningStatus));
        replicationPair.setHealthState(String.valueOf(healthStatus));
        replicationPair.setDevSn(ownerDeviceId);
        replicationPair.setSrcDeviceName(srcDeviceName);
        replicationPair.setDrRingId(!"--".equals(record.get("DRRINGID")) ? record.get("DRRINGID") : null);
        HVSRestTransitionExtend.solveUuidAndVstorePairId(record, ownerDeviceId, replicationPair, replicationId);
        ArrayList<ReplicationTargetLun> targetLuns = new ArrayList<ReplicationTargetLun>();
        ReplicationTargetLun targetLun = HVSRestTransitionExtend.transitionReplicationTargetLun(record, ownerDeviceId);
        targetLuns.add(targetLun);
        HVSRestTransitionExtend.processReplicationTargetLuns(targetLuns, replicationPair);
        return replicationPair;
    }

    private static void solveLocalResType(Map<String, String> record, ReplicationPair replicationPair) {
        String strLocalResType = record.get("LOCALRESTYPE");
        if (null != strLocalResType) {
            replicationPair.setLocalResType(NumberUtil.convertToInteger((Object)strLocalResType, (int)Integer.MIN_VALUE));
        } else {
            replicationPair.setLocalResType(Integer.valueOf(XveMOType.LUN.getValue()));
        }
    }

    private static void solveUuidAndVstorePairId(Map<String, String> record, String ownerDeviceId, ReplicationPair replicationPair, String replicationId) {
        String vstorePairId = record.get("VSTOREPAIRID");
        if (!VerifyUtil.isEmpty((String)vstorePairId)) {
            replicationPair.setVstorePairId(vstorePairId);
            replicationPair.setUuid(DrmStorageUtil.generateMoUuid((String)replicationId, (String)XveMOType.REMOTEREPLICATION.name(), (String)(ownerDeviceId + "_vstorePairId=" + vstorePairId)));
        } else {
            replicationPair.setUuid(DrmStorageUtil.generateMoUuid((String)replicationId, (String)XveMOType.REMOTEREPLICATION.name(), (String)ownerDeviceId));
        }
    }

    private static void processReplicationTargetLuns(List<ReplicationTargetLun> allRepTargetLuns, ReplicationPair replicationPair) {
        if (null == allRepTargetLuns || allRepTargetLuns.isEmpty()) {
            return;
        }
        for (ReplicationTargetLun repTargetLun : allRepTargetLuns) {
            if (!repTargetLun.getReplicationPairId().equals(replicationPair.getReplicationId())) continue;
            repTargetLun.setParentMo((ManagedObject)replicationPair);
            replicationPair.addChildMo((ManagedObject)repTargetLun);
            replicationPair.getRepTgtLuns().add(repTargetLun);
        }
    }

    public static ReplicationGroup transitionReplicationGroup(Map<String, String> record, String ownerDeviceId) {
        ReplicationGroup replicationGroup = new ReplicationGroup();
        String strResumePolicy = record.get(XveTLVParent.ConsistentGroup.RECOVERYPOLICY.getTagName());
        Integer resumePolicy = NumberUtil.convertToInteger((Object)strResumePolicy, (int)Integer.MIN_VALUE);
        Integer speedLevel = NumberUtil.convertToInteger((Object)record.get(XveTLVParent.ConsistentGroup.SPEED.getTagName()), (int)Integer.MIN_VALUE);
        String strSyncType = record.get(XveTLVParent.ConsistentGroup.SYNCHRONIZETYPE.getTagName());
        Integer syncType = NumberUtil.convertToInteger((Object)strSyncType, (int)Integer.MIN_VALUE);
        Long timing = NumberUtil.convertToLong((Object)record.get(XveTLVParent.ConsistentGroup.TIMINGVALINSEC.getTagName()), (long)Long.MIN_VALUE);
        Boolean isPrimary = Boolean.valueOf(record.get(XveTLVParent.ConsistentGroup.ISPRIMARY.getTagName()));
        String replicationId = record.get(XveTLVParent.ConsistentGroup.ID.getTagName());
        String strReplicationMode = record.get(XveTLVParent.ConsistentGroup.REPLICATIONMODEL.getTagName());
        Integer replicationMode = NumberUtil.convertToInteger((Object)strReplicationMode, (int)Integer.MIN_VALUE);
        String replicationName = record.get(XveTLVParent.ConsistentGroup.NAME.getTagName());
        String strRunningStatus = record.get(XveTLVParent.ConsistentGroup.RUNNINGSTATUS.getTagName());
        Integer runningStatus = NumberUtil.convertToInteger((Object)strRunningStatus, (int)Integer.MIN_VALUE);
        String strHealthStatus = record.get(XveTLVParent.ConsistentGroup.HEALTHSTATUS.getTagName());
        Integer healthStatus = NumberUtil.convertToInteger((Object)strHealthStatus, (int)Integer.MIN_VALUE);
        replicationGroup.setResumePolicy(resumePolicy);
        replicationGroup.setSpeedLevel(speedLevel);
        replicationGroup.setSyncType(syncType);
        replicationGroup.setTiming(timing);
        replicationGroup.setReplicationId(replicationId);
        replicationGroup.setReplicationMode(replicationMode);
        replicationGroup.setReplicationName(replicationName);
        replicationGroup.setDevSn(ownerDeviceId);
        if (isPrimary.booleanValue()) {
            replicationGroup.setSrcDevSN(ownerDeviceId);
        }
        replicationGroup.setIsPrimary(isPrimary);
        replicationGroup.setRelationType(Integer.valueOf(1));
        replicationGroup.setRunningState(String.valueOf(runningStatus));
        replicationGroup.setHealthState(String.valueOf(healthStatus));
        replicationGroup.setName(replicationName);
        replicationGroup.setDrRingId(!"--".equals(record.get("DRRINGID")) ? record.get("DRRINGID") : null);
        replicationGroup.setUuid(DrmStorageUtil.generateMoUuid((String)replicationId, (String)XveMOType.CONSISTENTGROUP.name(), (String)ownerDeviceId));
        return replicationGroup;
    }

    public static ReplicationTargetLun transitionReplicationTargetLun(Map<String, String> record, String ownerDeviceId) {
        ReplicationTargetLun replicationTargetLun = new ReplicationTargetLun();
        Integer dataStatus = NumberUtil.convertToInteger((Object)record.get("SECRESDATASTATUS"), (int)Integer.MIN_VALUE);
        String replicationPairId = record.get("ID");
        Boolean isPrimary = Boolean.valueOf(record.get("ISPRIMARY"));
        String remoteDeviceSN = record.get("REMOTEDEVICESN");
        String tgtDeviceName = record.get("REMOTEDEVICENAME");
        String tgtDevSN = remoteDeviceSN;
        if (!isPrimary.booleanValue()) {
            tgtDevSN = ownerDeviceId;
            tgtDeviceName = "";
        }
        String localLunId = record.get("LOCALRESID");
        String remoteLunId = record.get("REMOTERESID");
        String tgtLunName = record.get("REMOTERESNAME");
        String tgtLunId = remoteLunId;
        if (!isPrimary.booleanValue()) {
            tgtLunId = localLunId;
            tgtLunName = record.get("LOCALRESNAME");
        }
        Integer resumePolicy = NumberUtil.convertToInteger((Object)record.get("RECOVERYPOLICY"), (int)Integer.MIN_VALUE);
        Integer speedLevel = NumberUtil.convertToInteger((Object)record.get("SPEED"), (int)Integer.MIN_VALUE);
        Integer syncType = NumberUtil.convertToInteger((Object)record.get("SYNCHRONIZETYPE"), (int)Integer.MIN_VALUE);
        Integer runningState = NumberUtil.convertToInteger((Object)record.get("RUNNINGSTATUS"), (int)Integer.MIN_VALUE);
        Integer healthState = NumberUtil.convertToInteger((Object)record.get("HEALTHSTATUS"), (int)Integer.MIN_VALUE);
        Long timing = NumberUtil.convertToLong((Object)record.get(XveTLVParent.ConsistentGroup.TIMINGVAL.getTagName()), (long)Long.MIN_VALUE);
        replicationTargetLun.setStartTime(record.get("STARTTIME"));
        replicationTargetLun.setEndTime(record.get("ENDTIME"));
        replicationTargetLun.setDataStatus(dataStatus);
        replicationTargetLun.setPairStatus(runningState);
        replicationTargetLun.setReplicationPairId(replicationPairId);
        replicationTargetLun.setTgtDeviceName(tgtDeviceName);
        replicationTargetLun.setTgtDevSN(tgtDevSN);
        replicationTargetLun.setTgtLunId(tgtLunId);
        replicationTargetLun.setTgtLunName(tgtLunName);
        replicationTargetLun.setResumePolicy(resumePolicy);
        replicationTargetLun.setSpeedLevel(speedLevel);
        replicationTargetLun.setSyncType(syncType);
        replicationTargetLun.setDevSn(ownerDeviceId);
        replicationTargetLun.setRunningState(String.valueOf(runningState));
        replicationTargetLun.setHealthState(String.valueOf(healthState));
        replicationTargetLun.setName(tgtLunName);
        replicationTargetLun.setUuid(DrmStorageUtil.generateTargetLunMoUuid((String)String.valueOf(tgtLunId), (String)XveMOType.REMOTEREPLICATIONMEMBERLUN.name(), (String)ownerDeviceId, (String)tgtDevSN, (String)replicationPairId));
        if (!VerifyUtil.isEmpty((String)record.get("REPLICATIONPROGRESS"))) {
            Long progressRatio = NumberUtil.convertToLong((Object)record.get("REPLICATIONPROGRESS"), (long)Long.MIN_VALUE);
            replicationTargetLun.setProgressRatio(Integer.valueOf(progressRatio.intValue()));
        }
        replicationTargetLun.setTiming(timing);
        replicationTargetLun.setSecresAccess(record.get("SECRESACCESS"));
        replicationTargetLun.setIsPrimary(isPrimary);
        return replicationTargetLun;
    }

    public static HyperClone transitionHyperClone(Map<String, String> record, String ownerDeviceId) {
        HyperClone hyperClone = new HyperClone();
        String id = record.get("ID");
        String name = record.get("NAME");
        String description = record.get("DESCRIPTION");
        Integer runningState = NumberUtil.convertToInteger((Object)record.get("RUNNINGSTATUS"), (int)Integer.MIN_VALUE);
        Integer healthState = NumberUtil.convertToInteger((Object)record.get("HEALTHSTATUS"), (int)Integer.MIN_VALUE);
        String priLunId = record.get("PRILUNID");
        String priLunName = record.get("PRILUNNAME");
        Long priLunCapacity = NumberUtil.convertToLong((Object)record.get("PRILUNCAPACITY"), (long)Long.MIN_VALUE);
        Long priLunCapacityByte = NumberUtil.convertToLong((Object)record.get("PRILUNCAPACITYBYTE"), (long)Long.MIN_VALUE);
        Integer silentTime = NumberUtil.convertToInteger((Object)record.get("SILENTTIME"), (int)Integer.MIN_VALUE);
        hyperClone.setId(id);
        hyperClone.setName(name);
        hyperClone.setDescription(description);
        hyperClone.setRunningState(String.valueOf(runningState));
        hyperClone.setHealthState(String.valueOf(healthState));
        hyperClone.setPriLunCapacity(priLunCapacity);
        hyperClone.setPriLunCapacityByte(priLunCapacityByte);
        hyperClone.setPriLunId(priLunId);
        hyperClone.setPriLunName(priLunName);
        hyperClone.setSilentTime(silentTime);
        hyperClone.setDevSn(ownerDeviceId);
        hyperClone.setUuid(new XveUUID(ownerDeviceId, XveMOType.SPLITMIRROR, id).toString());
        return hyperClone;
    }

    public static HyperCloneTargetLun transitionHyperCloneTargetLun(Map<String, String> record, String ownerDeviceId) {
        HyperCloneTargetLun hyperCloneTargetLun = new HyperCloneTargetLun();
        Integer dataStatus = NumberUtil.convertToInteger((Object)record.get("DATASTATUS"), (int)Integer.MIN_VALUE);
        Integer runningState = NumberUtil.convertToInteger((Object)record.get("RUNNINGSTATUS"), (int)Integer.MIN_VALUE);
        Integer healthState = NumberUtil.convertToInteger((Object)record.get("HEALTHSTATUS"), (int)Integer.MIN_VALUE);
        Long lunCapacity = NumberUtil.convertToLong((Object)record.get("LUNCAPACITY"), (long)Long.MIN_VALUE);
        Long lunCapacityByte = NumberUtil.convertToLong((Object)record.get("LUNCAPACITYBYTE"), (long)Long.MIN_VALUE);
        hyperCloneTargetLun.setId(record.get("ID"));
        hyperCloneTargetLun.setName(record.get("NAME"));
        hyperCloneTargetLun.setDescription(record.get("DESCRIPTION"));
        hyperCloneTargetLun.setStartTime(record.get("STARTTIME"));
        hyperCloneTargetLun.setEndTime(record.get("ENDTIME"));
        hyperCloneTargetLun.setSplitTime("SPLITTIME");
        hyperCloneTargetLun.setRunningState(String.valueOf(runningState));
        hyperCloneTargetLun.setHealthState(String.valueOf(healthState));
        hyperCloneTargetLun.setLunCapacity(lunCapacity);
        hyperCloneTargetLun.setLunCapacityByte(lunCapacityByte);
        hyperCloneTargetLun.setSpeed(NumberUtil.convertToInteger((Object)record.get("SPEED"), (int)Integer.MIN_VALUE));
        hyperCloneTargetLun.setResumePolicy(NumberUtil.convertToInteger((Object)record.get("RESUMEPOLICY"), (int)Integer.MIN_VALUE));
        hyperCloneTargetLun.setHyperCloneId(record.get("PARENTID"));
        hyperCloneTargetLun.setPairId(record.get("PAIRID"));
        hyperCloneTargetLun.setDataStatus(dataStatus);
        hyperCloneTargetLun.setLunType(NumberUtil.convertToInteger((Object)record.get("LUNTYPE"), (int)Integer.MIN_VALUE));
        hyperCloneTargetLun.setPoolName(record.get("POOLNAME"));
        hyperCloneTargetLun.setProcess(NumberUtil.convertToInteger((Object)record.get("PROCESS"), (int)Integer.MIN_VALUE));
        hyperCloneTargetLun.setProtectModel(NumberUtil.convertToInteger((Object)record.get("PROTECTMODEL"), (int)Integer.MIN_VALUE));
        hyperCloneTargetLun.setDevSn(ownerDeviceId);
        hyperCloneTargetLun.setUuid(new XveUUID(ownerDeviceId, XveMOType.SPLITMIRRORTARGETLUN, hyperCloneTargetLun.getId()).toString());
        return hyperCloneTargetLun;
    }

    public static QuorumServer transitionQuorumServer(String devSn, Map<String, String> record) {
        QuorumServer server = new QuorumServer();
        String id = record.get("ID");
        String name = record.get("NAME");
        String runningStatus = record.get("RUNNINGSTATUS");
        String serverIpA = record.get("SERVERIPA");
        String serverPortA = record.get("SERVERPORTA");
        String serverIpB = record.get("SERVERIPB");
        String serverPortB = record.get("SERVERPORTB");
        String sn = record.get("DEVICESN");
        server.setId(id);
        server.setName(name);
        server.setRunningState(runningStatus);
        server.setServerIpA(serverIpA);
        if (!VerifyUtil.isEmpty((String)serverPortA)) {
            server.setServerPortA(NumberUtil.convertToInteger((Object)serverPortA, (int)Integer.MIN_VALUE));
        }
        server.setServerIpB(serverIpB);
        if (!VerifyUtil.isEmpty((String)serverPortB)) {
            server.setServerPortB(NumberUtil.convertToInteger((Object)serverPortB, (int)Integer.MIN_VALUE));
        }
        server.setSn(sn);
        server.setDevSn(devSn);
        server.setUuid(new XveUUID(devSn, XveMOType.QuorumServer, id).toString());
        return server;
    }

    public static QuorumServerLink transitionQuorumServerLink(String devSn, Map<String, String> record) {
        QuorumServerLink link = new QuorumServerLink();
        String id = record.get("ID");
        String parentId = record.get("PARENTID");
        String runningStatus = record.get("RUNNINGSTATUS");
        String localControllerId = record.get("LOCALCONTROLLERID");
        String localPortId = record.get("LOCALPORTID");
        String localControllerName = record.get("LOCALCONTROLLERNAME");
        String localPortName = record.get("LOCALPORTNAME");
        String quorumServerIp = record.get("QUORUMSERVERIP");
        link.setId(id);
        link.setQuorumServerId(parentId);
        link.setRunningState(runningStatus);
        link.setLocalControllerId(localControllerId);
        link.setLocalPortId(localPortId);
        link.setLocalControllerName(localControllerName);
        link.setLocalPortName(localPortName);
        link.setQuorumServerIp(quorumServerIp);
        link.setDevSn(devSn);
        link.setUuid(new XveUUID(devSn, XveMOType.QuorumServerLink, id).toString());
        return link;
    }

    public static HyperMetroDomain transitionHyperMetroDomain(String devSn, Map<String, String> record) {
        HyperMetroDomain domain = new HyperMetroDomain();
        String id = record.get("ID");
        String name = record.get("NAME");
        String runningStatus = record.get("RUNNINGSTATUS");
        Integer domainType = NumberUtil.convertToInteger((Object)record.get("DOMAINTYPE"), (int)Integer.MIN_VALUE);
        String remoteDevices = record.get("REMOTEDEVICES");
        String cpsId = record.get("CPSID");
        String cpsName = record.get("CPSNAME");
        Integer cpType = NumberUtil.convertToInteger((Object)record.get("CPTYPE"), (int)Integer.MIN_VALUE);
        domain.setId(id);
        domain.setName(name);
        domain.setRunningState(runningStatus);
        domain.setDomainType(domainType);
        domain.setRemoteDevices(remoteDevices);
        domain.setCpsId(cpsId);
        domain.setCpsName(cpsName);
        domain.setCpType(cpType);
        domain.setDevSn(devSn);
        domain.setUuid(new XveUUID(devSn, XveMOType.HyperMetroDomain, id).toString());
        return domain;
    }

    public static StorageHyperMetroDomain transitionHyperMetroDomain(String devSn, HyperMetroDomain hyperMetroDomain) {
        String remoteDeviceId;
        StorageHyperMetroDomain storageHyperMetroDomain = new StorageHyperMetroDomain();
        storageHyperMetroDomain.setHyperMetroDomainId(hyperMetroDomain.getId());
        storageHyperMetroDomain.setDomainType(hyperMetroDomain.getDomainType());
        storageHyperMetroDomain.setName(hyperMetroDomain.getName());
        storageHyperMetroDomain.setType(hyperMetroDomain.getType());
        storageHyperMetroDomain.setCpType(hyperMetroDomain.getCpType());
        storageHyperMetroDomain.setRunningStatus(hyperMetroDomain.getRunningState());
        JSONArray remoteDevices = JSONArray.fromObject((Object)hyperMetroDomain.getRemoteDevices());
        if (remoteDevices.size() == 0) {
            remoteDeviceId = hyperMetroDomain.getRemoteDevices();
        } else {
            JSONObject remoteDevice = remoteDevices.getJSONObject(0);
            remoteDeviceId = devSn + ":" + remoteDevice.getString("devId");
        }
        storageHyperMetroDomain.setRemoteDeviceId(remoteDeviceId);
        return storageHyperMetroDomain;
    }

    public static HyperMetroPair transitionHyperMetroPair(String devSn, Map<String, String> record) {
        HyperMetroPair pair = new HyperMetroPair();
        String id = record.get("ID");
        pair.setId(id);
        pair.setName(record.get("NAME"));
        pair.setHealthState(record.get("HEALTHSTATUS"));
        pair.setRunningState(record.get("RUNNINGSTATUS"));
        pair.setDomainId(record.get("DOMAINID"));
        pair.setLinkStatus(NumberUtil.convertToInteger((Object)record.get("LINKSTATUS"), (int)Integer.MIN_VALUE));
        pair.setResourceType(NumberUtil.convertToInteger((Object)record.get("HCRESOURCETYPE"), (int)-1));
        pair.setLocalObjId(record.get("LOCALOBJID"));
        pair.setLocalObjName(record.get("LOCALOBJNAME"));
        pair.setRemoteObjId(record.get("REMOTEOBJID"));
        pair.setRemoteObjName(record.get("REMOTEOBJNAME"));
        pair.setIsPrimary(Boolean.valueOf(record.get("ISPRIMARY")));
        pair.setResourceWwn(record.get("RESOURCEWWN"));
        pair.setLocalDataState(NumberUtil.convertToInteger((Object)record.get("LOCALDATASTATE"), (int)Integer.MIN_VALUE));
        pair.setLocalHostAccessState(NumberUtil.convertToInteger((Object)record.get("LOCALHOSTACCESSSTATE"), (int)Integer.MIN_VALUE));
        pair.setRemoteDataState(NumberUtil.convertToInteger((Object)record.get("REMOTEDATASTATE"), (int)Integer.MIN_VALUE));
        pair.setRemoteHostAccessState(NumberUtil.convertToInteger((Object)record.get("REMOTEHOSTACCESSSTATE"), (int)Integer.MIN_VALUE));
        pair.setSyncProgress(NumberUtil.convertToInteger((Object)record.get("SYNCPROGRESS"), (int)-1));
        pair.setSyncDirection(NumberUtil.convertToInteger((Object)record.get("SYNCDIRECTION"), (int)-1));
        pair.setInCg(Boolean.valueOf(record.get("ISINCG")));
        pair.setCgId(record.get("CGID"));
        pair.setRemoteDevSn(record.get("remoteDevSn"));
        pair.setDrRingId(!"--".equals(record.get("HDRINGID")) ? record.get("HDRINGID") : null);
        pair.setDevSn(devSn);
        String vstorePairId = record.get("VSTOREPAIRID");
        if (!VerifyUtil.isEmpty((String)vstorePairId)) {
            pair.setVstorePairId(vstorePairId);
            pair.setUuid(new XveUUID(devSn, XveMOType.HyperMetroPair, id + "_vstorePairId=" + vstorePairId).toString());
        } else {
            pair.setUuid(new XveUUID(devSn, XveMOType.HyperMetroPair, id).toString());
        }
        return pair;
    }

    public static HyperMetroConsistentGroup transitionHyperMetroCg(String devSn, Map<String, String> record) {
        HyperMetroConsistentGroup group = new HyperMetroConsistentGroup();
        String id = record.get("ID");
        String name = record.get("NAME");
        String healthStatus = record.get("HEALTHSTATUS");
        String runningStatus = record.get("RUNNINGSTATUS");
        int priorityStationType = NumberUtil.convertToInteger((Object)record.get("PRIORITYSTATIONTYPE"), (int)-1);
        String domainId = record.get("DOMAINID");
        int resourceType = NumberUtil.convertToInteger((Object)record.get("RESOURCETYPE"), (int)-1);
        boolean isEmpty = Boolean.parseBoolean(record.get("ISEMPTY"));
        Integer syncDirection = NumberUtil.convertToInteger((Object)record.get("SYNCDIRECTION"), (int)-1);
        String speed = record.get("SPEED");
        group.setId(id);
        group.setName(name);
        group.setHealthState(healthStatus);
        group.setRunningState(runningStatus);
        group.setPriorityStationType(priorityStationType);
        group.setDomainId(domainId);
        group.setResourceType(Integer.valueOf(resourceType));
        group.setIsEmpty(Boolean.valueOf(isEmpty));
        group.setSyncDirection(syncDirection);
        group.setSpeed(VerifyUtil.isEmpty((String)speed) ? String.valueOf(DmEnumDefine.SpeedLevelE.SPEED_LEVEL_MIDDLE.getValue()) : speed);
        group.setRecoveryPolicy(record.get("RECOVERYPOLICY"));
        group.setDevSn(devSn);
        group.setDrRingId(!"--".equals(record.get("HDRINGID")) ? record.get("HDRINGID") : null);
        group.setUuid(new XveUUID(devSn, XveMOType.HyperMetroConsistentGroup, id).toString());
        return group;
    }

    public static ArraySnapshot transitionSnapshot(String devSn, Map<String, String> resultMap) {
        ArraySnapshot snapshot = new ArraySnapshot();
        String id = resultMap.get("ID");
        String name = resultMap.get("NAME");
        String healthStatus = resultMap.get("HEALTHSTATUS");
        String runningStatus = resultMap.get("RUNNINGSTATUS");
        String wwn = resultMap.get("WWN");
        snapshot.setDevSn(devSn);
        snapshot.setId(id);
        snapshot.setName(name);
        snapshot.setHealthState(healthStatus);
        snapshot.setRunningState(runningStatus);
        snapshot.setWwn(wwn);
        snapshot.setSrcResourceId(NumberUtil.convertToInteger((Object)resultMap.get("SOURCELUNID"), (int)-1));
        snapshot.setIsScheduledSnap(Boolean.valueOf("1".equals(resultMap.get("ISSCHEDULEDSNAP"))));
        snapshot.setTimeStamp(resultMap.get("TIMESTAMP"));
        return snapshot;
    }

    public static VstoreHyperMetroPair transitionVstoreHyperMetroPair(String devSn, Map<String, String> record) {
        logger.debug((Object)("sn=" + devSn + ", record=" + record));
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty(record)) {
            logger.error((Object)("parameter error, sn=" + devSn));
            throw new LegoCheckedException(1073947393L);
        }
        VstoreHyperMetroPair vstorePair = new VstoreHyperMetroPair();
        vstorePair.setConfigStatus(record.get("CONFIGSTATUS"));
        vstorePair.setDomainId(record.get("DOMAINID"));
        vstorePair.setDomainName(record.get("DOMAINNAME"));
        vstorePair.setHealthStatus(record.get("HEALTHSTATUS"));
        vstorePair.setVstorePairId(record.get("ID"));
        vstorePair.setLinkStatus(record.get("LINKSTATUS"));
        vstorePair.setLocalVstoreId(record.get("LOCALVSTOREID"));
        vstorePair.setLocalVstoreName(record.get("LOCALVSTORENAME"));
        vstorePair.setRemoteVstoreId(record.get("REMOTEVSTOREID"));
        vstorePair.setRemoteVstoreName(record.get("REMOTEVSTORENAME"));
        vstorePair.setRole(record.get("ROLE"));
        vstorePair.setRunningStatus(record.get("RUNNINGSTATUS"));
        vstorePair.setPreferredMode(record.get("PREFERREDMODE"));
        vstorePair.setActiveOrPassive(record.get("ACTIVEORPASSIVE"));
        vstorePair.setUuid(new XveUUID(devSn, XveMOType.VSTORE_HYPERMETRO_PAIR, record.get("ID")).toString());
        return vstorePair;
    }

    public static VstoreReplicationPair transitionVstoreReplicationPair(String devSn, Map<String, String> record) {
        logger.debug((Object)("sn=" + devSn + ", record=" + record));
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty(record)) {
            logger.error((Object)("parameter error, sn=" + devSn));
            throw new LegoCheckedException(1073947393L);
        }
        VstoreReplicationPair vstorePair = new VstoreReplicationPair();
        vstorePair.setConfigStatus(record.get("VSTCFGSTATUS"));
        vstorePair.setHealthStatus(record.get("HEALTHSTATUS"));
        vstorePair.setVstorePairId(record.get("ID"));
        vstorePair.setLinkStatus(record.get("LINKSTATUS"));
        vstorePair.setLocalVstoreId(record.get("LOCALVSTOREID"));
        vstorePair.setLocalVstoreName(record.get("LOCALVSTORENAME"));
        vstorePair.setRemoteVstoreId(record.get("REMOTEVSTOREID"));
        vstorePair.setRemoteVstoreName(record.get("REMOTEVSTORENAME"));
        vstorePair.setRemoteDeviceId(record.get("REMOTEDEVICEID"));
        vstorePair.setRemoteDeviceName(record.get("REMOTEDEVICENAME"));
        vstorePair.setRemoteDeviceSn(record.get("REMOTEDEVICESN"));
        vstorePair.setRole(record.get("ROLE"));
        if (String.valueOf(DrmEnumDefine.RoleType.PRIORITY.getValue()).equals(vstorePair.getRole())) {
            vstorePair.setSrcDevSN(devSn);
        }
        vstorePair.setRunningStatus(record.get("RUNNINGSTATUS"));
        vstorePair.setIdentityPerserve(record.get("IDENTITYPERSERVE"));
        vstorePair.setSecVstoreAccess(record.get("SECVSTOREACCESS"));
        vstorePair.setLocalPortStatus(record.get("FORCIBLYDEACTIVATELOGICALPORT"));
        vstorePair.setUuid(new XveUUID(devSn, XveMOType.VSTORE_REPLICATION_PAIR, record.get("ID")).toString());
        return vstorePair;
    }

    public static HyperDRRing transitionHyperDRRing(String devSn, Map<String, String> record) {
        logger.debug((Object)("sn=" + devSn + ", record=" + record));
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty(record)) {
            logger.error((Object)("parameter error, sn=" + devSn));
            throw new LegoCheckedException(1073947393L);
        }
        HyperDRRing drRing = new HyperDRRing();
        drRing.setId(record.get("ID"));
        drRing.setDevSn(devSn);
        drRing.setHealthState(record.get("HEALTHSTATUS"));
        drRing.setRunningState(record.get("RUNNINGSTATUS"));
        drRing.setMemberType(record.get("memberType"));
        drRing.setDrStrategy(record.get("disasterRecoveryStrategy"));
        drRing.setUuid(new XveUUID(devSn, XveMOType.HYPER_DR_RING, record.get("ID")).toString());
        return drRing;
    }

    public static SnapshotSchedule transitionSnapshotSchedule(Map<String, String> resultMap) {
        if (VerifyUtil.isEmpty(resultMap)) {
            logger.error((Object)"The input parameter resultMap is null");
            throw new LegoCheckedException(1073947393L);
        }
        SnapshotSchedule schedule = new SnapshotSchedule();
        schedule.setId(resultMap.get("ID"));
        schedule.setName(resultMap.get("NAME"));
        schedule.setHealthState(resultMap.get("HEALTHSTATUS"));
        schedule.setRunningState(resultMap.get("RUNNINGSTATUS"));
        schedule.setFrequencyValue(NumberUtil.convertToLong((Object)resultMap.get("FREQUENCYVALUE"), (long)Long.MIN_VALUE));
        schedule.setSnapshotMaxNum(NumberUtil.convertToInteger((Object)resultMap.get("FREQUENCYNUM"), (int)-1));
        schedule.setLastExecutionTime(NumberUtil.convertToLong((Object)resultMap.get("LASTEXECUTIONTIME"), (long)Long.MIN_VALUE));
        schedule.setLastExecutionResult(NumberUtil.convertToInteger((Object)resultMap.get("LASTEXECUTIONRESULT"), (int)-1));
        schedule.setEnableSchedule(Boolean.valueOf(resultMap.get("ENABLESCHEDULE")));
        return schedule;
    }

    public static SnapshotSchedule transitionHyperCDPSchedule(Map<String, String> resultMap) {
        if (VerifyUtil.isEmpty(resultMap)) {
            logger.error((Object)"The input parameter resultMap is null");
            throw new LegoCheckedException(1073947393L);
        }
        SnapshotSchedule schedule = new SnapshotSchedule();
        schedule.setId(resultMap.get("ID"));
        schedule.setScheduleType(NumberUtil.convertToInteger((Object)resultMap.get("SCHEDULETYPE"), (int)Integer.MIN_VALUE).intValue());
        schedule.setName(resultMap.get("NAME"));
        schedule.getProps().put("DESCRIPTION", resultMap.get("DESCRIPTION"));
        if ("-1".equals(resultMap.get("DAILYSNAPSHOTNUM"))) {
            schedule.getProps().put("DAYHOURS", "[]");
            schedule.getProps().put("DAYMINUTE", "");
            schedule.getProps().put("DAILYSNAPSHOTNUM", "0");
        } else {
            schedule.getProps().put("DAYHOURS", resultMap.get("DAYHOURS"));
            schedule.getProps().put("DAILYSNAPSHOTNUM", resultMap.get("DAILYSNAPSHOTNUM"));
            schedule.getProps().put("DAYMINUTE", resultMap.get("DAYMINUTE"));
        }
        if ("-1".equals(resultMap.get("WEEKLYSNAPSHOTNUM"))) {
            schedule.getProps().put("WEEKLYDAYS", "[]");
            schedule.getProps().put("STARTTIMEOFWEEK", "");
            schedule.getProps().put("WEEKLYSNAPSHOTNUM", "0");
        } else {
            schedule.getProps().put("WEEKLYDAYS", resultMap.get("WEEKLYDAYS"));
            schedule.getProps().put("STARTTIMEOFWEEK", resultMap.get("STARTTIMEOFWEEK"));
            schedule.getProps().put("WEEKLYSNAPSHOTNUM", resultMap.get("WEEKLYSNAPSHOTNUM"));
        }
        if ("-1".equals(resultMap.get("MONTHSNAPSHOTNUM"))) {
            schedule.getProps().put("MONTHDAYS", "[]");
            schedule.getProps().put("STARTTIMEOFMONTH", "");
            schedule.getProps().put("MONTHSNAPSHOTNUM", "0");
        } else {
            schedule.getProps().put("MONTHDAYS", resultMap.get("MONTHDAYS"));
            schedule.getProps().put("STARTTIMEOFMONTH", resultMap.get("STARTTIMEOFMONTH"));
            schedule.getProps().put("MONTHSNAPSHOTNUM", resultMap.get("MONTHSNAPSHOTNUM"));
        }
        schedule.setHealthState(resultMap.get("HEALTHSTATUS"));
        schedule.setRunningState(resultMap.get("RUNNINGSTATUS"));
        schedule.setFrequencyValue(NumberUtil.convertToLong((Object)resultMap.get("FREQUENCYVALUE"), (long)Long.MIN_VALUE));
        schedule.setSnapshotMaxNum(NumberUtil.convertToInteger((Object)resultMap.get("FREQUENCYNUM"), (int)-1));
        schedule.setLastExecutionTime(NumberUtil.convertToLong((Object)resultMap.get("LASTEXECUTIONTIME"), (long)Long.MIN_VALUE));
        schedule.setLastExecutionResult(NumberUtil.convertToInteger((Object)resultMap.get("LASTEXECUTIONRESULT"), (int)-1));
        schedule.setEnableSchedule(Boolean.valueOf(resultMap.get("ENABLESCHEDULE")));
        return schedule;
    }

    public static LunConsistencyGroup transitionLunConsistencyGroup(Map<String, String> resultMap) {
        if (VerifyUtil.isEmpty(resultMap)) {
            logger.error((Object)"The input parameter resultMap is null");
            throw new LegoCheckedException(1073947393L);
        }
        LunConsistencyGroup consistencyGroup = new LunConsistencyGroup();
        consistencyGroup.setId(resultMap.get("ID"));
        consistencyGroup.setName(resultMap.get("NAME"));
        consistencyGroup.setCgType(NumberUtil.convertToInteger((Object)resultMap.get("CGTYPE"), (int)Integer.MAX_VALUE).intValue());
        consistencyGroup.setHyperCDPScheduleDisable(Boolean.parseBoolean(resultMap.get("HYPERCDPSCHEDULEDISABLE")));
        consistencyGroup.setDescription(resultMap.get("DESCRIPTION"));
        consistencyGroup.setRemoveSnapshot(NumberUtil.convertToInteger((Object)resultMap.get("REMOVESNAP"), (int)Integer.MAX_VALUE).intValue());
        consistencyGroup.setSnapshotScheduleId(resultMap.get("SNAPSCHEDULEID"));
        return consistencyGroup;
    }

    public static SnapshotConsistentGroup transitionSnapshotConsistencyGroup(Map<String, String> resultMap) {
        if (VerifyUtil.isEmpty(resultMap)) {
            logger.error((Object)"The input parameter resultMap is null");
            throw new LegoCheckedException(1073947393L);
        }
        SnapshotConsistentGroup consistencyGroup = new SnapshotConsistentGroup();
        consistencyGroup.setId(resultMap.get("ID"));
        consistencyGroup.setName(resultMap.get("NAME"));
        consistencyGroup.setSrcLunConsistentGroupName(resultMap.get("PARENTNAME"));
        consistencyGroup.setTimeStamp(resultMap.get("TIMESTAMP"));
        return consistencyGroup;
    }

    public static DoradoHyperClone transitionDoradoHyperClone(JSONObject jsonRes, String ownerDeviceId) {
        DoradoHyperClone hyperClone = new DoradoHyperClone();
        hyperClone.setClone(true);
        hyperClone.setResourceId(jsonRes.getString("ID"));
        hyperClone.setCaption(jsonRes.getString("NAME"));
        hyperClone.setCloneDescription(jsonRes.getString("DESCRIPTION"));
        hyperClone.setCapacity(Long.valueOf(jsonRes.getLong("CAPACITY")));
        hyperClone.setSourceId(jsonRes.getString("CLONESOURCEID"));
        hyperClone.setSourceType(Integer.valueOf(jsonRes.getInt("CLONESOURCETYPE")));
        hyperClone.setSplitSpeed(Integer.valueOf(jsonRes.getInt("SPLITSPEED")));
        hyperClone.setRunningStatus(jsonRes.getString("RUNNINGSTATUS"));
        hyperClone.setHealthStatus(jsonRes.getString("HEALTHSTATUS"));
        hyperClone.setWorkLoadType(jsonRes.getString("WORKLOADTYPENAME"));
        return hyperClone;
    }

    public static HypermetroPair transitionHyperMetroPair(String devSn, CreateHyperMetroPairResponse response) {
        HypermetroPair pair = new HypermetroPair();
        if (response == null) {
            logger.error((Object)"The input parameter is null.");
            return pair;
        }
        pair.setId(response.getId());
        pair.setCgId(response.getCgId());
        pair.setDomainid(response.getDomainId());
        pair.setSrcDevSN(devSn);
        pair.setRemoteobjid(response.getRemoteObjId());
        pair.setRemoteobjname(response.getRemoteObjName());
        pair.setLocalobjid(response.getLocalObjId());
        pair.setLocalobjname(response.getLocalObjName());
        pair.setHealthstatus(response.getHealthStatus());
        pair.setRunningState(response.getRunningStatus());
        pair.setHcresourcetype(HcResourceType.valueOf((int)Integer.parseInt(response.getHcResourceType())).getName());
        pair.setCgname(response.getCgName());
        pair.setDomainName(response.getDomainName());
        pair.setIsPrimary(Boolean.valueOf(Boolean.parseBoolean(response.getIsPrimary())));
        pair.setLinkstatus(response.getLinkStatus());
        pair.setLocaldatastate(response.getLocalDataState());
        pair.setLocalhostaccessstatus(response.getLocalHostAccessState());
        pair.setRecoveryPolicy(response.getRecoveryPolicy());
        pair.setRemotehostaccessstate(response.getRemoteHostAccessState());
        pair.setSrcLunWWN(response.getResourceWwn());
        pair.setType(String.valueOf(response.getType()));
        pair.setSyncDirection(response.getSyncDirection());
        return pair;
    }

    public static HypermetroGroup transitionHyperMetroGroup(String controlClusterId, String srcDevSn, CreateHyperMetroConsistentGroupRes response) {
        VerifyUtil.checkObjs((Object[])new Object[]{response});
        VerifyUtil.checkStrs((String[])new String[]{srcDevSn});
        logger.debug((Object)"Param response is %s.", new Object[]{response});
        HypermetroGroup hypermetroGroup = new HypermetroGroup();
        hypermetroGroup.setId(response.getId());
        hypermetroGroup.setHealStatus(response.getHealthStatus());
        hypermetroGroup.setSpeed(response.getSpeed() == null ? DmEnumDefine.SpeedLevelE.SPEED_LEVEL_MIDDLE.getValue() : Integer.parseInt(response.getSpeed()));
        hypermetroGroup.setPriorityStationType(response.getPriorityStationType());
        hypermetroGroup.setRecoveryPolicy(response.getRecoveryPolicy());
        hypermetroGroup.setRunningStatus(response.getRunningStatus());
        hypermetroGroup.setResourceType(response.getResourceType());
        hypermetroGroup.setControlClusterId(controlClusterId);
        hypermetroGroup.setSrcDevSN(srcDevSn);
        hypermetroGroup.setEmpty(Boolean.parseBoolean(response.getIsEmpty()));
        hypermetroGroup.setDomainid(response.getDomainId());
        hypermetroGroup.setSyncDirection(response.getSyncDirection());
        hypermetroGroup.setName(response.getName());
        return hypermetroGroup;
    }

    public static HypermetroPair transitionHyperMetroPO2BO(HyperMetroPair pairPO) {
        HypermetroPair pairBO = new HypermetroPair();
        BeanUtils.copyProperties((Object)pairPO, (Object)pairBO);
        pairBO.setHcresourcetype(HcResourceType.valueOf((int)pairPO.getResourceType()).getName());
        pairBO.setLinkstatus(String.valueOf(pairPO.getLinkStatus()));
        pairBO.setSrcLunWWN(pairPO.getResourceWwn());
        pairBO.setLocaldatastate(String.valueOf(pairPO.getLocalDataState()));
        pairBO.setLocalhostaccessstatus(String.valueOf(pairPO.getLocalHostAccessState()));
        pairBO.setRemotehostaccessstate(String.valueOf(pairPO.getRemoteHostAccessState()));
        pairBO.setSyncDirection(String.valueOf(pairPO.getSyncDirection()));
        pairBO.setRunningStatus(pairPO.getRunningState());
        pairBO.setSrcDevSN(pairPO.getDevSn());
        pairBO.setLocalobjid(pairPO.getLocalObjId());
        pairBO.setLocalobjname(pairPO.getLocalObjName());
        pairBO.setRemoteobjid(pairPO.getRemoteObjId());
        pairBO.setRemoteobjname(pairPO.getRemoteObjName());
        pairBO.setDomainid(pairPO.getDomainId());
        pairBO.setHealthstatus(pairPO.getHealthState());
        return pairBO;
    }

    public static HypermetroGroup transitionHyperMetroCGroup(String srcDevSn, String controlClusterId, HyperMetroConsistentGroup hyperMetroConsistentGroup) {
        VerifyUtil.checkObjs((Object[])new Object[]{hyperMetroConsistentGroup});
        VerifyUtil.checkObjs((Object[])new Object[]{srcDevSn});
        logger.debug((Object)"Param hyperMetroConsistentGroup is %s.", new Object[]{hyperMetroConsistentGroup});
        HypermetroGroup hypermetroGroup = new HypermetroGroup();
        hypermetroGroup.setId(hyperMetroConsistentGroup.getId());
        hypermetroGroup.setEmpty(hyperMetroConsistentGroup.getIsEmpty().booleanValue());
        hypermetroGroup.setHealStatus(hyperMetroConsistentGroup.getHealthState());
        hypermetroGroup.setSpeed(Integer.parseInt(hyperMetroConsistentGroup.getSpeed()));
        hypermetroGroup.setPriorityStationType(String.valueOf(hyperMetroConsistentGroup.getPriorityStationType()));
        hypermetroGroup.setRecoveryPolicy(hyperMetroConsistentGroup.getRecoveryPolicy());
        hypermetroGroup.setRunningStatus(hyperMetroConsistentGroup.getRunningState());
        hypermetroGroup.setResourceType(String.valueOf(hyperMetroConsistentGroup.getResourceType()));
        hypermetroGroup.setControlClusterId(controlClusterId);
        hypermetroGroup.setSrcDevSN(srcDevSn);
        return hypermetroGroup;
    }
}

