/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.drm.backup.model.BackupStoragePool;
import com.huawei.ism.drm.backup.model.BackupStorageRepository;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.handler.IStorageBackupStorageHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageBackupStorageHandlerImpl
extends AbstractRestStorageHandler
implements IStorageBackupStorageHandler {
    private static final Log logger = LogFactory.getInstance(StorageBackupStorageHandlerImpl.class);

    @Override
    protected RestConnection getConnection(String devSn) {
        return super.getConnection(devSn);
    }

    @Override
    protected Map<String, String> transform(Map<String, Object> info) {
        return super.transform(info);
    }

    BackupStoragePool transitionBackupStoragePool(Map<String, String> resultMap, String backupEngineId) {
        if (VerifyUtil.isEmpty(resultMap)) {
            logger.error((Object)"resultMap is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        BackupStoragePool backupStoragePool = new BackupStoragePool();
        backupStoragePool.setBackupEngineId(backupEngineId);
        backupStoragePool.setPoolId(resultMap.get("ID"));
        backupStoragePool.setName(resultMap.get("NAME"));
        backupStoragePool.setDescription(VerifyUtil.isEmpty((String)resultMap.get("DESCRIPTION")) ? "" : resultMap.get("DESCRIPTION"));
        if (!VerifyUtil.isEmpty((String)resultMap.get("brickList"))) {
            List brickList = CommUtil.convertToListMap((String)resultMap.get("brickList"));
            for (Map map : brickList) {
                backupStoragePool.setUseOfflineStorage(false);
                if ("7".equals(map.get("fileSystemType"))) {
                    this.parsingPoolS3Unit(backupStoragePool, map);
                }
                if (!String.valueOf(2).equals(map.get("fileSystemType"))) continue;
                backupStoragePool.setUseOfflineStorage(true);
                backupStoragePool.setOfflieStoragePath((String)map.get("path"));
            }
        }
        backupStoragePool.setBrickList(resultMap.get("brickList"));
        Long offlineTotalCapacity = NumberUtil.convertToLong((Object)resultMap.get("offlineTotalCapacity"), (long)Long.MIN_VALUE);
        Long offlineFreeCapacity = NumberUtil.convertToLong((Object)resultMap.get("offlineFreeCapacity"), (long)Long.MIN_VALUE);
        Long totalCapacity = NumberUtil.convertToLong((Object)resultMap.get("totalCapacity"), (long)Long.MIN_VALUE);
        Long freeCapacity = NumberUtil.convertToLong((Object)resultMap.get("freeCapacity"), (long)Long.MIN_VALUE);
        Integer utilization = NumberUtil.convertToInteger((Object)resultMap.get("utilization"), (int)Integer.MIN_VALUE);
        Integer offlineUtilization = NumberUtil.convertToInteger((Object)resultMap.get("offlineUtilization"), (int)Integer.MIN_VALUE);
        Integer offlineStatus = NumberUtil.convertToInteger((Object)resultMap.get("offlineStatus"), (int)Integer.MIN_VALUE);
        Integer healthStatus = NumberUtil.convertToInteger((Object)resultMap.get("RUNNINGSTATUS"), (int)Integer.MIN_VALUE);
        Integer alarmThreshold = NumberUtil.convertToInteger((Object)resultMap.get("alarmThreshold"), (int)Integer.MIN_VALUE);
        backupStoragePool.setOfflineFreeCapacity(offlineFreeCapacity);
        backupStoragePool.setOfflineTotalCapacity(offlineTotalCapacity);
        backupStoragePool.setOfflineUtilization(offlineUtilization.intValue());
        backupStoragePool.setOfflineStatus(offlineStatus.intValue());
        backupStoragePool.setTotalCapacity(totalCapacity);
        backupStoragePool.setFreeCapacity(freeCapacity);
        backupStoragePool.setUtilization(utilization.intValue());
        backupStoragePool.setAlarmThreshold(alarmThreshold.intValue());
        backupStoragePool.setRunningStatus(healthStatus.intValue());
        return backupStoragePool;
    }

    private void parsingPoolS3Unit(BackupStoragePool backupStoragePool, Map<String, String> map) {
        backupStoragePool.setBrickS3Id(map.get("id"));
        int storageType = Integer.parseInt(map.get("fileSystemType"));
        backupStoragePool.setStorageType(storageType);
        if (!VerifyUtil.isEmpty((String)map.get("wanAcce"))) {
            boolean wanAcce = Integer.parseInt(map.get("wanAcce")) != 0;
            backupStoragePool.setWanAcceleration(wanAcce);
        }
        backupStoragePool.setProxyId(map.get("proxyId"));
        backupStoragePool.setUserName(map.get("userName"));
        int protocolType = VerifyUtil.isEmpty((String)map.get("protocol")) ? -1 : Integer.parseInt(map.get("protocol"));
        backupStoragePool.setProtocolType(protocolType);
        String path = map.get("path");
        if (VerifyUtil.isEmpty((String)path)) {
            return;
        }
        String[] pathArray = path.split("/");
        backupStoragePool.setAddress(this.parseAddress(pathArray[0]));
        String containerName = pathArray.length - 1 <= 0 ? "" : pathArray[pathArray.length - 1];
        backupStoragePool.setContainerName(containerName);
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteByBackupBucketOrPath(path);
        if (!VerifyUtil.isEmpty((Object)site)) {
            backupStoragePool.setSiteId(site.getSiteId());
            backupStoragePool.setStorageType(100);
        }
    }

    private String parseAddress(String path) {
        if (path.endsWith(":")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private BackupStorageRepository transitionResponseRepository(Map<String, String> resultMap, String backupEngineId) {
        if (VerifyUtil.isEmpty(resultMap)) {
            logger.error((Object)"resultMap is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        BackupStorageRepository repository = new BackupStorageRepository();
        repository.setBackupEngineId(backupEngineId);
        repository.setName(resultMap.get("NAME"));
        repository.setRepositoryId(String.valueOf(resultMap.get("ID")));
        repository.setDescription(resultMap.get("DESCRIPTION"));
        repository.setStoragePoolName(resultMap.get("PARENTNAME"));
        repository.setStoragePoolId(resultMap.get("PARENTID"));
        Long freeCapacity = NumberUtil.convertToLong((Object)resultMap.get("freeCapacity"), (long)Long.MIN_VALUE);
        Long totalCapacity = NumberUtil.convertToLong((Object)resultMap.get("totalCapacity"), (long)Long.MIN_VALUE);
        Integer alarmThreshold = NumberUtil.convertToInteger((Object)resultMap.get("alarmThreshold"), (int)Integer.MIN_VALUE);
        Long usageCapacity = totalCapacity - freeCapacity;
        DecimalFormat df = new DecimalFormat("0.000");
        int usage = 0;
        if (totalCapacity != 0L) {
            BigDecimal usageBigDecimal = new BigDecimal(df.format((double)usageCapacity.longValue() / (double)totalCapacity.longValue()));
            BigDecimal bignum1 = new BigDecimal("1000");
            usage = usageBigDecimal.multiply(bignum1).intValue();
        }
        repository.setFreeCapcity(freeCapacity);
        repository.setCapacity(totalCapacity);
        repository.setAlarmThreshold(alarmThreshold.intValue());
        boolean fullTotalFlag = Integer.parseInt(resultMap.get("fullTotalFlag")) == 1;
        repository.setUsage(usage);
        repository.setUseFullQuota(fullTotalFlag);
        return repository;
    }

    private Map<String, String> constructCreateRepositoryParameter(BackupStorageRepository repository) {
        if (VerifyUtil.isEmpty((Object)repository)) {
            logger.error((Object)"repository is null.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> responseMap = new HashMap<String, String>();
        responseMap.put("NAME", repository.getName());
        responseMap.put("DESCRIPTION", repository.getDescription());
        responseMap.put("totalCapacity", String.valueOf(repository.getCapacity()));
        responseMap.put("alarmThreshold", String.valueOf(repository.getAlarmThreshold()));
        responseMap.put("fullTotalFlag", repository.isUseFullQuota() ? "1" : "0");
        responseMap.put("PARENTNAME", repository.getStoragePoolName());
        return responseMap;
    }

    private Map<String, String> constructCreatePoolParameter(BackupStoragePool pool) {
        if (VerifyUtil.isEmpty((Object)pool)) {
            logger.error((Object)"pool is null.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> responseMap = new HashMap<String, String>();
        responseMap.put("NAME", pool.getName());
        responseMap.put("DESCRIPTION", pool.getDescription());
        responseMap.put("alarmThreshold", String.valueOf(pool.getAlarmThreshold()));
        JSONArray json = new JSONArray();
        HashMap<String, String> brickListMap = new HashMap<String, String>();
        brickListMap.put("offlineType", "0");
        brickListMap.put("fileSystemType", String.valueOf(pool.getStorageType()));
        if (pool.getStorageType() == 100) {
            brickListMap.put("fileSystemType", "7");
        }
        StringBuffer address = new StringBuffer();
        address.append(pool.getAddress()).append(":/").append(pool.getContainerName());
        brickListMap.put("path", address.toString());
        brickListMap.put("protocol", String.valueOf(pool.getProtocolType()));
        brickListMap.put("userName", pool.getUserName());
        brickListMap.put("password", pool.getPassword());
        brickListMap.put("proxyId", VerifyUtil.isEmpty((String)pool.getBackupProxyId()) ? "0" : pool.getBackupProxyId());
        brickListMap.put("wanAcce", pool.isWanAcceleration() ? "1" : "0");
        if (pool.isUseOfflineStorage()) {
            brickListMap.put("offlineDevice", pool.getOfflieStoragePath());
        }
        json.add(brickListMap);
        if (pool.isUseOfflineStorage()) {
            HashMap<String, String> offlineMap = new HashMap<String, String>();
            offlineMap.put("offlineType", pool.isUseOfflineStorage() ? "2" : "");
            offlineMap.put("fileSystemType", "2");
            offlineMap.put("path", pool.getOfflieStoragePath());
            json.add(offlineMap);
        }
        responseMap.put("brickList", json.toString());
        return responseMap;
    }

    public BackupStoragePool createBackupStoragePool(BackupStoragePool pool) {
        if (null == pool) {
            logger.error((Object)"create pool error param, pool is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String backupEngineId = pool.getBackupEngineId();
        VerifyUtil.checkStrs((String[])new String[]{pool.getBackupEngineId()});
        String url = "/rest/${deviceID}/backup_storage_pool";
        Map<String, String> paramMap = this.constructCreatePoolParameter(pool);
        logger.debug((Object)"start create backupStoragePool, url: %s, paramMap: %s .", new Object[]{url, paramMap});
        try {
            RestConnection connection = this.getConnection(pool.getBackupEngineId());
            Map map = connection.post(url, paramMap);
            BackupStoragePool newPool = this.transitionBackupStoragePool(map, backupEngineId);
            logger.debug((Object)("end create backup storage pool:" + newPool.toString()));
            return newPool;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("create backup pool failed, url: " + url + "pool: " + pool.toString()), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("create backup pool failed, url: " + url + "pool: " + pool.toString()), (Throwable)e);
            throw new LegoCheckedException("create backup pool failed." + pool.toString(), (Throwable)e);
        }
    }

    public void updateBackupStoragePool(String backupEngineId, String poolId, BackupStoragePool newPool) {
        if (null == newPool) {
            logger.error((Object)"update pool error param, pool is null.");
            throw new LegoCheckedException(1073947393L);
        }
        VerifyUtil.checkStrs((String[])new String[]{backupEngineId, poolId});
        HashMap<String, String> modifyMap = new HashMap<String, String>();
        modifyMap.put("ID", poolId);
        modifyMap.put("NAME", newPool.getName());
        modifyMap.put("DESCRIPTION", newPool.getDescription());
        modifyMap.put("alarmThreshold", String.valueOf(newPool.getAlarmThreshold()));
        if (!VerifyUtil.isEmpty((String)newPool.getBrickList())) {
            modifyMap.put("brickList", newPool.getBrickList());
        }
        String url = "/rest/${deviceID}/backup_storage_pool/" + poolId;
        logger.debug((Object)"start update backupStoragePool, url: %s, devSn: %s, modifyMap: %s", new Object[]{url, backupEngineId, modifyMap});
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            connection.put(url, modifyMap);
            logger.debug((Object)("end update backup storage pool" + poolId));
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("update backup pool failed, url:" + url + "devSn: " + backupEngineId), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("update backup pool failed, url:" + url + "devSn: " + backupEngineId), (Throwable)e);
            throw new LegoCheckedException("update backup pool failed." + poolId, (Throwable)e);
        }
    }

    public void deleteBackupStoragePool(String backupEngineId, String poolId) {
        VerifyUtil.checkStrs((String[])new String[]{backupEngineId, poolId});
        String url = "/rest/${deviceID}/backup_storage_pool/" + poolId;
        logger.debug((Object)"start delete backupStoragePool, url: %s, devSn: %s, poolId: %s", new Object[]{url, backupEngineId, poolId});
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            connection.delete(url, null);
            logger.debug((Object)("delete backup storage pool:" + poolId));
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("end delete backup storage pool failed, url: " + url + "devsn: " + backupEngineId), (Throwable)le);
            if (335599618L == le.getErrorCode()) {
                return;
            }
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("delete backup storage pool failed, url: " + url + "devsn: " + backupEngineId), (Throwable)e);
            throw new LegoCheckedException("delete backup storage pool failed." + poolId, (Throwable)e);
        }
    }

    public List<BackupStoragePool> listBackupStoragePool(String backupEngineId, Map<String, String> filter) {
        VerifyUtil.checkStrs((String[])new String[]{backupEngineId});
        String poolName = filter.get("poolName");
        String type = filter.get("storageType");
        StringBuilder url = new StringBuilder("/rest/${deviceID}/backup_storage_pool");
        Boolean isHasName = !VerifyUtil.isEmpty((String)poolName);
        Boolean isHasType = !VerifyUtil.isEmpty((String)type);
        url.append("?range=[0-512]");
        if (isHasName.booleanValue()) {
            url.append("&filter=").append("NAME:" + poolName);
        }
        if (isHasType.booleanValue()) {
            url.append("&type=").append(type);
        }
        logger.debug((Object)"start query backupStoragePool list, url: %s, devSn: %s, poolName: %s, type : %s", new Object[]{url.toString(), backupEngineId, poolName, type});
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            List records = connection.getBatch(url.toString(), null, true);
            logger.debug((Object)"end query backupStoragePool list.");
            ArrayList<BackupStoragePool> list = new ArrayList<BackupStoragePool>();
            for (Map record : records) {
                try {
                    BackupStoragePool backupStoragePool = this.transitionBackupStoragePool(record, backupEngineId);
                    list.add(backupStoragePool);
                }
                catch (Exception e) {
                    logger.warn((Object)"Error while bckupStoragePool transition", 90160777658373L);
                }
            }
            return list;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query backupStoragePool error. url: " + url), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query backupStoragePool failed. url: " + url), (Throwable)e);
            throw new LegoCheckedException("query backupStoragePool failed.", (Throwable)e);
        }
    }

    public BackupStoragePool getBackupStoragePool(String backupEngineId, String poolId) {
        VerifyUtil.checkStrs((String[])new String[]{backupEngineId, poolId});
        String url = "/rest/${deviceID}/backup_storage_pool/" + poolId;
        logger.debug((Object)"start query backupStoragePool, url: %s, devSn: %s, poolId: %s", new Object[]{url, backupEngineId, poolId});
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            Map responseMap = connection.get(url, null);
            logger.debug((Object)"end query backupStoragePool.");
            if (!VerifyUtil.isEmpty((Map)responseMap)) {
                return this.transitionBackupStoragePool(responseMap, backupEngineId);
            }
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query BackupStoragePool error. url: " + url + "devsn: " + backupEngineId), (Throwable)le);
            if (335599618L == le.getErrorCode()) {
                return null;
            }
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query BackupStoragePool failed. url: " + url + "devsn: " + backupEngineId), (Throwable)e);
            throw new LegoCheckedException("query BackupStoragePool failed.", (Throwable)e);
        }
        return null;
    }

    public void createBackupStorageRepository(BackupStorageRepository repository) {
        if (null == repository) {
            logger.error((Object)"create repository error param, repository is null.");
            throw new LegoCheckedException(1073947393L);
        }
        VerifyUtil.checkStrs((String[])new String[]{repository.getBackupEngineId()});
        String url = "/rest/${deviceID}/repository";
        Map<String, String> paramMap = this.constructCreateRepositoryParameter(repository);
        logger.debug((Object)"start create backupStorageRepository, url: %s, devsn: %s, paramMap: %s", new Object[]{url, repository.getBackupEngineId(), paramMap});
        try {
            RestConnection connection = this.getConnection(repository.getBackupEngineId());
            Map map = connection.post(url, paramMap);
            BackupStorageRepository result = this.transitionResponseRepository(map, repository.getBackupEngineId());
            result.setBackupEngineId(repository.getBackupEngineId());
            logger.debug((Object)("end create backup storage repository:" + result.toString()));
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("create backup storage repository failed, url: " + url + "repository: " + repository), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("create backup storage repository failed, url: " + url + "repository: " + repository), (Throwable)e);
            throw new LegoCheckedException("create backup storage repository failed." + repository.toString(), (Throwable)e);
        }
    }

    public void updateBackupStorageRepository(String backupEngineId, String repositoryId, BackupStorageRepository repository) {
        if (null == repository) {
            logger.error((Object)"update repository error param, repository is null.");
            throw new LegoCheckedException(1073947393L);
        }
        VerifyUtil.checkStrs((String[])new String[]{backupEngineId, repositoryId});
        HashMap<String, String> modifyMap = new HashMap<String, String>();
        modifyMap.put("ID", repositoryId);
        modifyMap.put("NAME", repository.getName());
        modifyMap.put("DESCRIPTION", repository.getDescription());
        modifyMap.put("alarmThreshold", String.valueOf(repository.getAlarmThreshold()));
        if (!VerifyUtil.isEmpty((Object)repository.getCapacity())) {
            modifyMap.put("totalCapacity", String.valueOf(repository.getCapacity()));
        }
        modifyMap.put("fullTotalFlag", repository.isUseFullQuota() ? "1" : "0");
        String url = "/rest/${deviceID}/repository/" + repositoryId;
        logger.debug((Object)"start update backupStorageRepository: url: %s, devSn: %s", new Object[]{url, backupEngineId});
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            Map map = connection.put(url, modifyMap);
            logger.debug((Object)("end update backup storage repository:" + map.toString()));
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("update backup storage repository failed. url: " + url + "devsn: " + backupEngineId), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("update backup storage repository failed. url: " + url + "devsn: " + backupEngineId), (Throwable)e);
            throw new LegoCheckedException("update backup storage repository failed." + repositoryId, (Throwable)e);
        }
    }

    public void deleteBackupStorageRepository(String backupEngineId, String repositoryId) {
        VerifyUtil.checkStrs((String[])new String[]{backupEngineId, repositoryId});
        String url = "/rest/${deviceID}/repository/" + repositoryId;
        logger.debug((Object)"start delete backupStorageRepository: url: %s, devSn: %s, repositoryId: %s", new Object[]{url, backupEngineId, repositoryId});
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            connection.delete(url, null);
            logger.debug((Object)("end delete backup storage repository:" + repositoryId));
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("delete backup storage repository failed, url: " + url + "devsn: " + backupEngineId), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("delete backup storage repository failed, url: " + url + "devsn: " + backupEngineId), (Throwable)e);
            throw new LegoCheckedException("delete backup storage repository failed." + repositoryId, (Throwable)e);
        }
    }

    public List<BackupStorageRepository> listBackupStorageRepository(String backupEngineId, Map<String, String> filter) {
        if (VerifyUtil.isEmpty((String)backupEngineId)) {
            throw new LegoCheckedException(1073947393L);
        }
        HashMap paramMap = new HashMap();
        String repoName = filter.get("name");
        String type = filter.get("storageType");
        Boolean isHasName = !VerifyUtil.isEmpty((String)repoName);
        Boolean isHasType = !VerifyUtil.isEmpty((String)type);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/repository");
        url.append("?range=[0-512]");
        if (isHasName.booleanValue()) {
            url.append("&filter=").append("NAME:" + repoName);
        }
        if (isHasType.booleanValue()) {
            url.append("&type=").append(type);
        }
        logger.debug((Object)"start query backupStorageRepository list, url: %s, devSn: %s, repoName: %s, type : %s", new Object[]{url.toString(), backupEngineId, repoName, type});
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            ArrayList<BackupStorageRepository> repositories = new ArrayList<BackupStorageRepository>();
            List records = connection.getBatch(url.toString(), paramMap, true);
            logger.debug((Object)"end query backupStorageRepository list.");
            if (!VerifyUtil.isEmpty((Collection)records)) {
                for (Map record : records) {
                    BackupStorageRepository repository = this.transitionResponseRepository(record, backupEngineId);
                    repositories.add(repository);
                }
            }
            return repositories;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query repositories error, url: " + url + "devsn: " + backupEngineId), (Throwable)le);
            if (1077948996L == le.getErrorCode()) {
                return null;
            }
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query repositories failed, url: " + url + "devsn: " + backupEngineId), (Throwable)e);
            throw new LegoCheckedException("query repositories failed.", (Throwable)e);
        }
    }

    public BackupStorageRepository getBackupStorageRepository(String backupEngineId, String repositoryId) {
        if (VerifyUtil.isEmpty((String)backupEngineId)) {
            logger.error((Object)("query repository: devSn:" + backupEngineId + ", repositoryId:" + backupEngineId));
            throw new LegoCheckedException(1073947393L);
        }
        StringBuilder url = new StringBuilder("/rest/${deviceID}/repository/" + repositoryId);
        logger.debug((Object)"start query backupStorageRepository, url: %s, devSn: %s, backupEngineId: %s", new Object[]{url.toString(), backupEngineId, repositoryId});
        try {
            RestConnection connection = this.getConnection(backupEngineId);
            Map responseMap = connection.get(url.toString(), null);
            logger.debug((Object)"end  query backupStorageRepository.");
            if (!VerifyUtil.isEmpty((Map)responseMap)) {
                BackupStorageRepository repository = this.transitionResponseRepository(responseMap, backupEngineId);
                return repository;
            }
            return null;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query repository error, url: " + url.toString() + "devsn: " + backupEngineId), (Throwable)le);
            if (1077948996L == le.getErrorCode()) {
                return null;
            }
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query repository failed, url: " + url.toString() + "devsn: " + backupEngineId), (Throwable)e);
            throw new LegoCheckedException("query repository failed.", (Throwable)e);
        }
    }
}

