/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.drm.storage.handler.IStorageHyperCDPHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.StorageLunConsistencyGroupHandlerImpl;
import com.huawei.ism.drm.storage.sdk.model.HyperCDP;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StorageHyperCDPHandlerImpl
implements IStorageHyperCDPHandler {
    private static final Log logger = LogFactory.getInstance(StorageLunConsistencyGroupHandlerImpl.class);
    private HvsRestConnectionManager connMgr = HvsRestConnectionManager.getInstance();

    protected RestConnection getConnection(String devSn) {
        return this.connMgr.getConnection(devSn);
    }

    private HyperCDP transitionHyperCDP(String devSn, Map<String, String> result) {
        HyperCDP cdp = new HyperCDP();
        cdp.setConsistentGroupId(result.get("CONSISTENCYGROUPID"));
        cdp.setScheduledCDP(Boolean.valueOf(result.get("ISSCHEDULEDCDP").equals("1")));
        cdp.setRunningState(result.get("RUNNINGSTATUS"));
        cdp.setRestoreProgress(NumberUtil.convertToInteger((Object)result.get("RESTOREPROGRESS")));
        cdp.setSrcResourceId(NumberUtil.convertToInteger((Object)result.get("PARENTID")));
        cdp.setId(result.get("ID"));
        cdp.setName(result.get("NAME"));
        cdp.setTimeStamp(result.get("TIMESTAMP"));
        cdp.setDevSn(devSn);
        return cdp;
    }

    public HyperCDP query(String devSn, String id) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/cdp/" + id;
        try {
            logger.debug((Object)"Start queryHyperCDP, url: %s, devSn: %s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            Map map = connection.get(url, null);
            logger.debug((Object)"End queryHyperCDP, url: %s, devSn: %s, result: %s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn), map});
            if (!VerifyUtil.isEmpty((Map)map)) {
                return this.transitionHyperCDP(devSn, map);
            }
            return null;
        }
        catch (LegoCheckedException le) {
            logger.error((Throwable)le, (Object)"Query HyperCDP failed, url: %s, devSn: %s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            throw le;
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Object)"Query HyperCDP failed, url: %s, devSn: %s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException("Query HyperCDP failed.", (Throwable)e);
        }
    }

    public List<HyperCDP> queryHyperCDPByCgId(String devSn, String consistentGroupId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, consistentGroupId});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/cdp?filter=CONSISTENCYGROUPID::" + consistentGroupId;
        try {
            ArrayList<HyperCDP> hyperCDPs = new ArrayList<HyperCDP>();
            logger.debug((Object)"Start queryHyperCDPList, url: %s, devSn: %s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            List results = connection.getBatch(url, null);
            logger.debug((Object)"End queryHyperCDPList, url: %s, devSn: %s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            for (Map result : results) {
                hyperCDPs.add(this.transitionHyperCDP(devSn, result));
            }
            return hyperCDPs;
        }
        catch (LegoCheckedException le) {
            logger.error((Throwable)le, (Object)"Query HyperCDPs error, url: %s, devSn: %s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            throw le;
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Object)"Query HyperCDPs error, url: %s, devSn: %s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException("query HyperCDPs failed.", (Throwable)e);
        }
    }
}

