/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageLunConsistencyGroupHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.sdk.model.LunConsistencyGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageLunConsistencyGroupHandlerImpl
implements IStorageLunConsistencyGroupHandler {
    private static final Log logger = LogFactory.getInstance(StorageLunConsistencyGroupHandlerImpl.class);
    private HvsRestConnectionManager connMgr = HvsRestConnectionManager.getInstance();

    public LunConsistencyGroup createLunConsistencyGroup(String devSn, String name, String description) {
        LunConsistencyGroup result;
        VerifyUtil.checkStrs((String[])new String[]{devSn, name});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("NAME", name);
        paramMap.put("DESCRIPTION", description);
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP";
        try {
            logger.debug((Object)"start to create lun consistency group.url=%s,param=%s", new Object[]{url, paramMap});
            Map map = connection.post(url, paramMap);
            result = HVSRestTransitionExtend.transitionLunConsistencyGroup(map);
            result.setDevSn(devSn);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("create Lun consistency group failed.url=" + url + ", params=" + paramMap), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("create Lun consistency group failed.url=" + url + ", params=" + paramMap), (Throwable)e);
            throw new LegoCheckedException("create Lun consistency group failed.", (Throwable)e);
        }
        logger.debug((Object)("Create Lun consistency group:" + result.toString()));
        return result;
    }

    protected RestConnection getConnection(String devSn) {
        return this.connMgr.getConnection(devSn);
    }

    public void addLun(String devSn, String consistencyGroupId, String lunId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, consistencyGroupId, lunId});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", consistencyGroupId);
        paramMap.put("ASSOCIATEOBJTYPE", String.valueOf(XveMOType.LUN.getValue()));
        paramMap.put("ASSOCIATEOBJID", lunId);
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP/CREATE_ASSOCIATE";
        try {
            logger.debug((Object)"Start to add lun to group. url=%s, devSn=%s, param=%s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn), paramMap});
            connection.post("/rest/${deviceID}/LUN_CONSISTENCY_GROUP/CREATE_ASSOCIATE", paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Throwable)le, (Object)"Add lun to consistencyGroup failed. url=%s, devSn=%s, param=%s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn), paramMap});
            throw le;
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Object)"Add lun to consistencyGroup failed. url=%s, devSn=%s, param=%s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn), paramMap});
            throw new LegoCheckedException("Add lun to consistencyGroup failed.", (Throwable)e);
        }
    }

    public void removeLun(String devSn, String consistencyGroupId, String lunId, boolean removeSnapshot) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, consistencyGroupId, lunId});
        String request = "?ID=" + consistencyGroupId + "&ASSOCIATEOBJTYPE=" + String.valueOf(XveMOType.LUN.getValue()) + "&ASSOCIATEOBJID=" + lunId;
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP/associate" + request;
        try {
            logger.debug((Object)"Start to remove lun to group. url=%s, devSn=%s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            connection.delete(url, null);
        }
        catch (LegoCheckedException le) {
            logger.error((Throwable)le, (Object)"Add lun to consistencyGroup failed. url=%s, devSn=%s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            throw le;
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Object)"Add lun to consistencyGroup failed. url=%s, devSn=%s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException("Add lun to consistencyGroup failed.", (Throwable)e);
        }
    }

    public void deleteConsistencyGroup(String devSn, String lunConsistencyGroupId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, lunConsistencyGroupId});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP/" + lunConsistencyGroupId;
        try {
            logger.debug((Object)"Start to delete group. url=%s, devSn=%s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            connection.delete(url, null);
        }
        catch (LegoCheckedException le) {
            logger.error((Throwable)le, (Object)"Delete consistencyGroup failed. url=%s, devSn=%s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            throw le;
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Object)"Delete consistencyGroup failed. url=%s, devSn=%s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException("add lun to consistencyGroup failed.", (Throwable)e);
        }
    }

    public LunConsistencyGroup queryConsistencyGroup(String devSn, String id) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP/" + id;
        try {
            logger.debug((Object)"Start to query lun consisten group. url=%s, devSn=%s", new Object[]{url, SecurityUtil.desensitizeId((String)devSn)});
            Map result = connection.get(url, null);
            if (VerifyUtil.isEmpty((Map)result)) {
                return null;
            }
            return HVSRestTransitionExtend.transitionLunConsistencyGroup(result);
        }
        catch (LegoCheckedException le) {
            if (1073748824L == le.getErrorCode()) {
                return null;
            }
            logger.error((Object)"Add lun to consistencyGroup failed.", (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"Add lun to consistencyGroup failed.", (Throwable)e);
            throw new LegoCheckedException("Add lun to consistencyGroup failed.", (Throwable)e);
        }
    }

    public List<LunConsistencyGroup> queryConsistencyGroups(String devSn, XveMOType associateObjType, String associateObjId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, associateObjId});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP/associate?ASSOCIATEOBJID=" + associateObjId + "&ASSOCIATEOBJTYPE=" + associateObjType.getValue();
        try {
            ArrayList<LunConsistencyGroup> list = new ArrayList<LunConsistencyGroup>();
            logger.debug((Object)"Start to query lun consisten groups. url=%s, devSn=%s", new Object[]{url, devSn});
            List records = connection.getBatch(url, null);
            if (!VerifyUtil.isEmpty((Collection)records)) {
                records.forEach(map -> list.add(HVSRestTransitionExtend.transitionLunConsistencyGroup(map)));
            }
            return list;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"Add lun to consistencyGroup failed.", (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"Add lun to consistencyGroup failed.", (Throwable)e);
            throw new LegoCheckedException("Add lun to consistencyGroup failed.", (Throwable)e);
        }
    }
}

