/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.constant.HvsGroupType;
import com.huawei.ism.drm.storage.hvs.handler.impl.constant.HvsRequestDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.ubase.adaptor.hvs.discovery.util.HVSRestTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class StorageLunHandlerRestImpl
extends AbstractRestStorageHandler
implements IStorageLunHandler {
    private static final Log LOG = LogFactory.getInstance(StorageLunHandlerRestImpl.class);
    private static final String PARAM_LUN_NAME = "NAME";
    private static final String PARAM_LUN_CAPACITY = "CAPACITY";
    private static final String PARAM_LUN_PARENTID = "PARENTID";
    private static final String DEFAULT_VALUE = "0";

    public Lun queryStorageLun(String deviceSn, String lunId) {
        VerifyUtil.checkObjs((Object[])new Object[]{deviceSn, lunId});
        RestConnection connection = this.getConnection(deviceSn);
        String url = String.format(Locale.ENGLISH, HvsRequestDefine.GET_SINGLE_LUN_BY_ID.getUri(), lunId);
        LOG.debug((Object)"Start to query lun. lunId:%s.", new Object[]{lunId});
        Map record = connection.get(url, null);
        return record.isEmpty() ? null : HVSRestTransition.transitionXveLun((String)deviceSn, (Map)record);
    }

    public Lun queryStorageLunByName(String deviceSn, String lunName) {
        List response;
        VerifyUtil.checkObjs((Object[])new Object[]{deviceSn, lunName});
        LOG.debug((Object)"Start to query lun. lunName:%s.", new Object[]{lunName});
        String url = String.format(Locale.ENGLISH, HvsRequestDefine.QUERY_LUNS_BY_NAME.getUri(), lunName);
        try {
            response = this.getConnection(deviceSn).getBatch(url, null);
        }
        catch (LegoCheckedException exception) {
            logger.error((Object)"Connect to dev fail, deviceSn: %s, error: %s.", new Object[]{SecurityUtil.desensitizeId((String)deviceSn), ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073947398L, exception.getParameters());
        }
        Map result = response.stream().filter(record -> lunName.equals(record.get(PARAM_LUN_NAME))).findAny().orElse(Collections.emptyMap());
        if (result.isEmpty()) {
            LOG.warn((Object)"Query storage lun by name return empty, lun name: %s", new Object[]{lunName});
            return null;
        }
        LOG.debug((Object)"End to query lun. lunName:%s.", new Object[]{lunName});
        return HVSRestTransition.transitionXveLun((String)deviceSn, result);
    }

    public Lun createLun(Lun lun) {
        VerifyUtil.checkObjs((Object[])new Object[]{lun});
        VerifyUtil.checkObjs((Object[])new Object[]{lun.getDevSn(), lun.getName(), lun.getCapacity(), lun.getStoragePoolId()});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(PARAM_LUN_NAME, lun.getName());
        paramMap.put(PARAM_LUN_CAPACITY, String.valueOf(lun.getCapacity() >> 9));
        paramMap.put(PARAM_LUN_PARENTID, lun.getStoragePoolId());
        LOG.debug((Object)"Start to create lun. param= %s.", new Object[]{paramMap});
        RestConnection connection = this.getConnection(lun.getDevSn());
        Map res = connection.post(HvsRequestDefine.CREATE_SINGE_LUN.getUri(), paramMap);
        return HVSRestTransition.transitionXveLun((String)lun.getDevSn(), (Map)res);
    }

    public Optional<Lun> getLunByWWN(String deviceSn, String wwn) {
        VerifyUtil.checkStrs((String[])new String[]{deviceSn, wwn});
        LOG.debug((Object)"Start to query lun. wwn:%s.", new Object[]{wwn});
        RestConnection connection = this.getConnection(deviceSn);
        String url = String.format(Locale.ENGLISH, HvsRequestDefine.QUERY_LUNS_BY_WWN.getUri(), wwn);
        List result = connection.getBatch(url, null);
        if (VerifyUtil.isEmpty((Collection)result)) {
            LOG.warn((Object)"Query storage lun by wwn return empty, lun wwn: %s", new Object[]{wwn});
            return Optional.empty();
        }
        LOG.debug((Object)"End to query lun. wwn:%s.", new Object[]{wwn});
        return Optional.of(HVSRestTransition.transitionXveLun((String)deviceSn, (Map)((Map)result.get(0))));
    }

    public void expandVolById(String devSn, String lunId, Long capacity) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            LOG.error((Object)"Param devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)lunId)) {
            LOG.error((Object)"Param lunId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)capacity)) {
            LOG.error((Object)"Param capacity is null.");
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"Enter expandVolById.");
        Lun lun = this.queryStorageLun(devSn, lunId);
        if (lun == null) {
            LOG.error((Object)"Expand lun doesn't exist, devSn: %s, lunId:%s, capacity:%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), lunId, String.valueOf(capacity)});
            throw new LegoCheckedException(201L);
        }
        RestConnection connection = this.getConnection(devSn);
        JSONObject param = new JSONObject();
        param.put((Object)PARAM_LUN_CAPACITY, (Object)capacity);
        param.put((Object)"ID", (Object)lunId);
        connection.putForObject(HvsRequestDefine.EXPAND_LUN.getUri(), (Object)param);
        LOG.info((Object)"Leave expandVolById.");
    }

    public void deleteLun(String deviceSn, String lunId) {
        VerifyUtil.checkObjs((Object[])new Object[]{deviceSn, lunId});
        RestConnection connection = this.getConnection(deviceSn);
        String url = String.format(Locale.ENGLISH, HvsRequestDefine.DELETE_SINGLE_LUN_BY_ID.getUri(), lunId);
        LOG.debug((Object)"Start to delete lun. lunId=%s.", new Object[]{lunId});
        connection.delete(url, null);
    }

    public List<Lun> queryLuns(String devSn, XveMOType associateObjType, String associateObjId) {
        VerifyUtil.checkObjs((Object[])new Object[]{devSn, associateObjType, associateObjId});
        RestConnection connection = this.getConnection(devSn);
        String url = String.format(Locale.ENGLISH, HvsRequestDefine.ASSOCIATE_QUERY_LUNS.getUri(), XveMOType.LUN.getValue(), associateObjType.getValue(), associateObjId);
        ArrayList<Lun> luns = new ArrayList<Lun>();
        LOG.debug((Object)"Start to query lun batch, associateObjType:%s, associateObjId: %s.", new Object[]{String.valueOf(associateObjType.getValue()), associateObjId});
        List records = connection.getBatch(url, null);
        if (!VerifyUtil.isEmpty((Collection)records)) {
            records.forEach(record -> luns.add((Lun)HVSRestTransition.transitionXveLun((String)devSn, (Map)record)));
        }
        return luns;
    }

    public XveLunGroup createLunGroup(String devSn, String name) {
        VerifyUtil.checkObjs((Object[])new Object[]{devSn, name});
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("APPTYPE", Integer.toString(XveEnumDefine.APP_TYPE_E.OTHER.getValue()));
        params.put("GROUPTYPE", HvsGroupType.LUN_GROUP.getValue());
        params.put(PARAM_LUN_NAME, name);
        LOG.debug((Object)"Start to create lun group. param= %s.", new Object[]{params});
        RestConnection connection = this.getConnection(devSn);
        Map record = connection.post(HvsRequestDefine.CREATE_SINGE_LUNGROUP.getUri(), params);
        return HVSRestTransition.transitionXveLunGroup((String)connection.getDeviceId(), (Map)record);
    }

    public List<XveLunGroup> queryLunGroups(String devSn, XveMOType associateObjType, String associateObjId) {
        VerifyUtil.checkObjs((Object[])new Object[]{devSn, associateObjType, associateObjId});
        RestConnection connection = this.getConnection(devSn);
        String url = String.format(Locale.ENGLISH, HvsRequestDefine.ASSOCIATE_QUERY_LUNGROUPS.getUri(), XveMOType.LUNGROUP.getValue(), associateObjType.getValue(), associateObjId);
        LOG.debug((Object)"Start to query lun groups, associateObjType:%s, associateObjId: %s.", new Object[]{String.valueOf(associateObjType.getValue()), associateObjId});
        List records = connection.getBatch(url, null);
        ArrayList<XveLunGroup> lunGroups = new ArrayList<XveLunGroup>();
        if (!VerifyUtil.isEmpty((Collection)records)) {
            records.forEach(record -> lunGroups.add(HVSRestTransition.transitionXveLunGroup((String)devSn, (Map)record)));
        }
        return lunGroups;
    }
}

