/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.Mapping;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageMappingHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.ubase.adaptor.hvs.discovery.util.HVSRestTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageMappingHandlerRestImpl
extends AbstractRestStorageHandler
implements IStorageMappingHandler {
    public void addLunToMappingView(String deviceSN, MappingView mappingView, Lun lun) {
        RestConnection connection = this.getConnection(deviceSN);
        try {
            XveLunGroup lunGroup = this.queryLunGroupByMappingView(connection, mappingView);
            if (null == lunGroup) {
                logger.error((Object)("The lun group does not exist. DevSN:" + deviceSN + ", MappingViewID:" + mappingView.getMappingViewId()), 371635742965770L);
                throw new LegoCheckedException(1073948746L);
            }
            this.addObjectToLunGroup(deviceSN, lunGroup.getLunGroupId(), XveMOType.LUN, lun.getLunId());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Adding LUN to MappingView failed. DevSN:" + deviceSN + ",lunID:" + lun.getLunId()), (Throwable)e, 371635742965770L);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Adding LUN to mappingView failed. DevSN:" + deviceSN + ",lunID:" + lun.getLunId()), (long)1073948676L, (String[])new String[0], (Log)logger);
        }
    }

    private XveLunGroup queryLunGroupByMappingView(RestConnection connection, MappingView mappingView) {
        StringBuilder associateUrl = new StringBuilder("/rest/${deviceID}/lungroup/associate");
        associateUrl.append("?TYPE=").append(XveMOType.LUNGROUP.getValue());
        associateUrl.append("&ASSOCIATEOBJTYPE=").append(XveMOType.MAPPINGVIEW.getValue());
        associateUrl.append("&ASSOCIATEOBJID=").append(mappingView.getMappingViewId());
        logger.debug((Object)"query lun group by mappingView start. connect address=%s, mappingViewId=%s, request url=%s.", new Object[]{connection.getIpAddress(), mappingView.getMappingViewId(), associateUrl.toString()});
        Map result = connection.get(associateUrl.toString(), null);
        XveLunGroup xveLunGroup = null;
        if (!VerifyUtil.isEmpty((Map)result)) {
            xveLunGroup = new XveLunGroup();
            xveLunGroup.setLunGroupId((String)result.get("ID"));
            xveLunGroup.setName((String)result.get("NAME"));
            logger.debug((Object)"query lun group by mappingView finished. mappingViewId=%s, lunGroupId=%s.", new Object[]{mappingView.getMappingViewId(), xveLunGroup.getLunGroupId()});
        }
        return xveLunGroup;
    }

    public void removeLunFromMappingView(String devSn, MappingView mappingView, Lun lun) {
        RestConnection connection = this.getConnection(devSn);
        try {
            XveLunGroup lunGroup = this.queryLunGroupByMappingView(connection, mappingView);
            if (null == lunGroup) {
                logger.error((Object)("The lun group does not exist. MappingView=" + mappingView.getMappingViewId()), 371635742965770L);
                throw new LegoCheckedException(1073948746L);
            }
            this.removeObjectFromLunGroup(connection, lunGroup, XveMOType.LUN.getValue(), lun.getResourceId());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Remove LUN from MappingView failed, DevSn=" + devSn + ", lunID=" + lun.getLunId() + ", mappingViewID=" + mappingView.getMappingViewId()), (Throwable)e, 371635742965770L);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Remove LUN from mappingView failed, DevSn=" + devSn + ", lunID=" + lun.getLunId() + ", mappingViewID=" + mappingView.getMappingViewId()), (long)1073948697L, (String[])new String[0], (Log)logger);
        }
    }

    public void removeLunFromMappingView(String devSn, MappingView mappingView, String resourceId) {
        RestConnection connection = this.getConnection(devSn);
        try {
            XveLunGroup lunGroup = this.queryLunGroupByMappingView(connection, mappingView);
            if (null == lunGroup) {
                if (this.deleteMappingByLunId(devSn, resourceId)) {
                    return;
                }
                logger.error((Object)("The lun group does not exist. DevSN:" + devSn + ", mappingViewID=" + mappingView.getMappingViewId()), 371635742965770L);
                throw new LegoCheckedException(1073948746L);
            }
            this.removeObjectFromLunGroup(connection, lunGroup, XveMOType.LUN.getValue(), resourceId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Remove LUN from MappingView failed, DevSn=" + devSn + ", lunID=" + resourceId + ", mappingViewID=" + mappingView.getMappingViewId()), (Throwable)e, 371635742965770L);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Remove LUN from mappingView failed, DevSn=" + devSn + ", lunID=" + resourceId + ", mappingViewID=" + mappingView.getMappingViewId()), (long)1073948697L, (String[])new String[0], (Log)logger);
        }
    }

    public MappingView removeSnapshotFromMappingView(String deviceSN, MappingView mappingView, String snapshotId) {
        RestConnection connection = this.getConnection(deviceSN);
        try {
            XveLunGroup lunGroup = this.queryLunGroupByMappingView(connection, mappingView);
            if (null != lunGroup) {
                this.removeObjectFromLunGroup(connection, lunGroup, XveMOType.SNAPSHOT.getValue(), snapshotId);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("remove snapshot failed. DevSN:" + deviceSN + ", Id:" + snapshotId + ", mappingViewID=" + mappingView.getMappingViewId()), (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("remove snapshot failed. DevSN:" + deviceSN + ", Id:" + snapshotId + ", mappingViewID=" + mappingView.getMappingViewId()), (long)1073948678L, (String[])new String[0], (Log)logger);
        }
        return mappingView;
    }

    public MappingView addSnapshotToMappingView(String deviceSN, MappingView mappingView, String snapshotId) {
        RestConnection connection = this.getConnection(deviceSN);
        MappingView resultView = new MappingView();
        try {
            XveLunGroup lunGroup = this.queryLunGroupByMappingView(connection, mappingView);
            if (null == lunGroup) {
                logger.error((Object)("The lun group does not exist. devSn:" + deviceSN + ", mappingViewID:" + mappingView.getMappingViewId()), 371635742965770L);
                throw new LegoCheckedException(1073948746L);
            }
            this.addObjectToLunGroup(deviceSN, lunGroup.getLunGroupId(), XveMOType.SNAPSHOT, snapshotId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Adding Snapshot to MappingView failed. DevSN:" + deviceSN + ",snapshotID:" + snapshotId + ", mappingViewID=" + mappingView.getMappingViewId()), (Throwable)e, 371635742965770L);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Adding Snapshot to mappingView failed. DevSN:" + deviceSN + ", snapshotID:" + snapshotId + ", mappingViewID=" + mappingView.getMappingViewId()), (long)1073948683L, (String[])new String[0], (Log)logger);
        }
        return resultView;
    }

    public MappingView getMappingViewByLunId(String deviceSN, String lunId) {
        return this.getMappingView(deviceSN, XveMOType.LUN, lunId);
    }

    public MappingView getMappingViewBySnapshotId(String deviceSN, String snapshotId) {
        return this.getMappingView(deviceSN, XveMOType.SNAPSHOT, snapshotId);
    }

    private void removeObjectFromLunGroup(RestConnection connection, XveLunGroup lunGroup, int objType, String objId) {
        StringBuilder associateUrl = new StringBuilder("/rest/${deviceID}/lungroup/associate");
        associateUrl.append("?ID=").append(lunGroup.getLunGroupId());
        associateUrl.append("&ASSOCIATEOBJTYPE=").append(String.valueOf(objType));
        associateUrl.append("&ASSOCIATEOBJID=").append(objId);
        logger.debug((Object)"remove Object from lun group. connect address=%s, lunGroupId=%s, objType=%s, objId=%s, request url=%s. ", new Object[]{connection.getIpAddress(), lunGroup.getLunGroupId(), objId, objType, associateUrl});
        connection.delete(associateUrl.toString(), null);
    }

    private MappingView getMappingView(String deviceSN, XveMOType xveMoType, String associateObjId) {
        RestConnection connection = this.getConnection(deviceSN);
        StringBuilder associateUrl = new StringBuilder("/rest/${deviceID}/mappingview/associate");
        associateUrl.append("?TYPE=").append(XveMOType.MAPPINGVIEW.getValue());
        associateUrl.append("&ASSOCIATEOBJTYPE=").append(xveMoType.getValue());
        associateUrl.append("&ASSOCIATEOBJID=").append(associateObjId);
        logger.debug((Object)"get mapping view start. devSN=%s, type=%s, objId=%s, request url=%s. ", new Object[]{connection.getIpAddress(), xveMoType, associateObjId, associateUrl});
        MappingView retMappingView = null;
        try {
            Map result = connection.get(associateUrl.toString(), null);
            if (!VerifyUtil.isEmpty((Map)result)) {
                retMappingView = new MappingView();
                retMappingView.setMappingViewId((String)result.get("ID"));
                retMappingView.setName((String)result.get("NAME"));
                logger.debug((Object)"get mapping view finished. devSN=%s, type=%s, objId=%s, mappingViewId=%s.", new Object[]{deviceSN, xveMoType, associateObjId, retMappingView.getMappingViewId()});
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Getting mapping view failed. devSN=" + deviceSN + ", type=" + xveMoType + ", objId=" + associateObjId), (Throwable)e, 371635742965770L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Getting mapping view failed. devSN=" + deviceSN + ", type=" + xveMoType + ", objId=" + associateObjId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return retMappingView;
    }

    private boolean deleteMappingByLunId(String devSn, String lunId) {
        try {
            List<Mapping> mappings = this.getMapping(devSn, XveMOType.LUN, lunId);
            for (Mapping mapping : mappings) {
                this.deleteMapping(devSn, lunId, mapping);
            }
            return true;
        }
        catch (LegoCheckedException le) {
            if (le.getErrorCode() == 404L) {
                logger.error((Object)"current version not support this url, only after dorado v6 support.");
                return false;
            }
            throw le;
        }
    }

    public List<Mapping> getMapping(String deviceSN, XveMOType xveMoType, String associateObjId) {
        VerifyUtil.checkObjs((Object[])new Object[]{deviceSN, xveMoType, associateObjId});
        RestConnection connection = this.getConnection(deviceSN);
        StringBuilder associateUrl = new StringBuilder("/rest/${deviceID}/mapping/associate");
        associateUrl.append("?ASSOCIATEOBJTYPE=").append(xveMoType.getValue());
        associateUrl.append("&ASSOCIATEOBJID=").append(associateObjId);
        logger.debug((Object)"get mapping view start. devSN=%s, type=%s, objId=%s, request url=%s. ", new Object[]{connection.getIpAddress(), xveMoType, associateObjId, associateUrl});
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        try {
            List results = connection.getBatch(associateUrl.toString(), null, true);
            if (!VerifyUtil.isEmpty((Collection)results)) {
                for (Map result : results) {
                    if (VerifyUtil.isEmpty((Map)result)) continue;
                    Mapping retMapping = this.constructMapping(result);
                    logger.debug((Object)"get mapping view finished. devSN=%s, type=%s, objId=%s, mappingViewId=%s.", new Object[]{deviceSN, xveMoType, associateObjId, retMapping.getId()});
                    mappings.add(retMapping);
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Getting mapping view failed. devSN=" + deviceSN + ", type=" + xveMoType + ", objId=" + associateObjId), (Throwable)e, 371635742965770L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Getting mapping view failed. devSN=" + deviceSN + ", type=" + xveMoType + ", objId=" + associateObjId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return mappings;
    }

    private Mapping constructMapping(Map<String, String> result) {
        Mapping mapping = new Mapping();
        mapping.setId(result.get("ID"));
        mapping.setName(result.get("NAME"));
        mapping.setType(NumberUtil.convertToInteger((Object)result.get("TYPE")).intValue());
        mapping.setHostGroupId(result.get("hostGroupId"));
        mapping.setHostGroupName(result.get("hostGroupName"));
        mapping.setHostId(result.get("hostId"));
        mapping.setHostName(result.get("hostName"));
        mapping.setLunGroupId(result.get("lunGroupId"));
        mapping.setLunId(result.get("lunId"));
        mapping.setLunName(result.get("lunName"));
        mapping.setMappingType(result.get("mappingType"));
        mapping.setPortGroupId(result.get("portGroupId"));
        mapping.setPortGroupName(result.get("portGroupName"));
        return mapping;
    }

    private void deleteMapping(String deviceSN, String lunId, Mapping mapping) {
        VerifyUtil.checkObjs((Object[])new Object[]{deviceSN, lunId, mapping});
        RestConnection connection = this.getConnection(deviceSN);
        StringBuilder deleteUrl = new StringBuilder("/rest/${deviceID}/mapping");
        logger.info((Object)"Delete mapping start. devSN=%s, lunId=%s. ", new Object[]{connection.getIpAddress(), lunId});
        try {
            HashMap paramMap = new HashMap();
            if (lunId.equals(mapping.getLunId())) {
                deleteUrl.append("?lunId=").append(lunId);
                if (!VerifyUtil.isEmpty((String)mapping.getHostGroupId())) {
                    deleteUrl.append("&hostGroupId=").append(mapping.getHostGroupId());
                } else if (!VerifyUtil.isEmpty((String)mapping.getHostId())) {
                    deleteUrl.append("&hostId=").append(mapping.getHostId());
                } else {
                    logger.error((Object)"mapping doesn't have either hostId or hostGroupId. lunId:%s", new Object[]{lunId});
                    throw new LegoCheckedException(1073947394L);
                }
                connection.delete(deleteUrl.toString(), paramMap);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Delete mapping failed. devSN=" + deviceSN + ", lunId=" + lunId), (Throwable)e, 371635742965770L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Delete mapping failed. devSN=" + deviceSN + ", lunId=" + lunId), (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public MappingView createMappingView(String devSn, String name, String description) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"create MappingView error. devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)name)) {
            logger.error((Object)"create MappingView error. name is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/mappingview";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TYPE", Integer.toString(XveMOType.MAPPINGVIEW.getValue()));
        params.put("NAME", name);
        params.put("DESCRIPTION", null == description ? "" : description);
        logger.debug((Object)"create mapping view start. devSN=%s, name=%s, request url=%s. ", new Object[]{connection.getIpAddress(), name, url});
        Map record = connection.post(url, params);
        MappingView mv = HVSRestTransition.transitionMappingView((String)devSn, (Map)record);
        logger.debug((Object)"create mapping view finished. devSN=%s, name=%s, mvId=%s. ", new Object[]{connection.getIpAddress(), name, mv.getMappingViewId()});
        return mv;
    }

    public void addObjectToMappingView(String devSn, String mappingViewId, XveMOType associateObjType, String associateObjId) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"add Object to MappingView error. devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)mappingViewId)) {
            logger.error((Object)"add Object to MappingView error. mappingViewId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == associateObjType) {
            logger.error((Object)"add Object to MappingView error. associateObjType is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)associateObjId)) {
            logger.error((Object)"add Object to MappingView error. associateObjId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/mappingview/create_associate";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TYPE", Integer.toString(XveMOType.MAPPINGVIEW.getValue()));
        params.put("ID", mappingViewId);
        params.put("ASSOCIATEOBJTYPE", Integer.toString(associateObjType.getValue()));
        params.put("ASSOCIATEOBJID", associateObjId);
        logger.debug((Object)"add Object to MappingView. devSn=%s, mappingViewId=%s, associateObjType=%s, associateObjId=%s, request url=%s. ", new Object[]{devSn, mappingViewId, associateObjType, associateObjId, url});
        connection.put(url, params);
    }

    public List<MappingView> queryMappingView(String devSn, XveMOType associateObjType, String associateObjId) {
        List records;
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"Query MappingView by associate error. devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == associateObjType) {
            logger.error((Object)"Query MappingView by associate error. associateObjType is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)associateObjId)) {
            logger.error((Object)"Query MappingView by associate error. associateObjId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/mappingview/associate");
        url.append("?TYPE=").append(XveMOType.MAPPINGVIEW.getValue());
        url.append("&ASSOCIATEOBJTYPE=").append(associateObjType.getValue());
        url.append("&ASSOCIATEOBJID=").append(associateObjId);
        url.append("&range=[0-65536]");
        logger.debug((Object)"Query MappingView by associate start. devSN=%s, associateObjType=%s, associateObjId=%s, request url=%s.", new Object[]{devSn, associateObjType, associateObjId, url.toString()});
        try {
            records = connection.getBatch(url.toString(), null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Query MappingView by associate fail,devSn:" + devSn + "associateObjType:" + associateObjType + ", associateObjId:" + associateObjId), (Throwable)e, 90160758784000L);
            return Collections.emptyList();
        }
        ArrayList<MappingView> mvs = new ArrayList<MappingView>();
        for (Map record : records) {
            MappingView mv = HVSRestTransition.transitionMappingView((String)devSn, (Map)record);
            mvs.add(mv);
        }
        logger.debug((Object)"Query MappingView by associate finished. devSN=%s, associateObjType=%s, associateObjId=%s, mappingView Size=%s.", new Object[]{devSn, associateObjType, associateObjId, mvs.size()});
        return mvs;
    }

    public void addObjectToLunGroup(String devSn, String lunGroupId, XveMOType associateObjType, String associateObjId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, lunGroupId, associateObjId});
        if (null == associateObjType) {
            logger.error((Object)"add object to lun group fail: associateObjType is null. devSN=%s, lunGroupId=%s, associateObjId=%s.", new Object[]{devSn, lunGroupId, associateObjId});
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/lungroup/associate";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TYPE", Integer.toString(XveMOType.LUNGROUP.getValue()));
        params.put("ID", lunGroupId);
        params.put("ASSOCIATEOBJTYPE", Integer.toString(associateObjType.getValue()));
        params.put("ASSOCIATEOBJID", associateObjId);
        logger.debug((Object)"add object to lun group start. devSN=%s, lunGroupId=%s, associateObjId=%s, associateObjType=%s, request url=%s.", new Object[]{devSn, lunGroupId, associateObjId, associateObjType, url});
        try {
            connection.post(url, params);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("add lun or snapshot to lungroup error! devSn:" + devSn + "lunGroupId:" + lunGroupId + ", associateObjType:" + associateObjType + ", associateObjId:" + associateObjId), (Throwable)e);
            long errorCode = e.getErrorCode();
            if (errorCode == 1077948997L) {
                logger.warn((Object)"The object existed in the lungroup!");
                return;
            }
            throw e;
        }
    }
}

