/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageReplicationHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StorageReplicationHandlerRestImpl
extends AbstractRestStorageHandler
implements IStorageReplicationHandler {
    public ReplicationRelation queryReplication(String deviceSn, String replicationId, boolean isConsistentGroup) {
        ReplicationGroup replicationRelation;
        RestConnection connection = this.getConnection(deviceSn);
        logger.debug((Object)"Query Replication start. devSn=%s, id=%s, isConsistentGroup=%s.", new Object[]{SecurityUtil.desensitizeId((String)deviceSn), replicationId, isConsistentGroup});
        try {
            if (isConsistentGroup) {
                String url = "/rest/${deviceID}/consistentgroup/" + replicationId;
                Map record = connection.get(url, null);
                replicationRelation = HVSRestTransitionExtend.transitionReplicationGroup(record, deviceSn);
            } else {
                String url = "/rest/${deviceID}/replicationpair/" + replicationId;
                Map record = connection.get(url, null);
                replicationRelation = HVSRestTransitionExtend.transitionReplicationPair(record, deviceSn);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while replicationRelation transition, devSn=%s, id=%s, isConsistentGroup=%s, error=%s.", new Object[]{SecurityUtil.desensitizeId((String)deviceSn), replicationId, isConsistentGroup, ExceptionUtil.getErrorMessage((Throwable)e)});
            replicationRelation = null;
        }
        logger.debug((Object)"Query Replication finished.");
        return replicationRelation;
    }

    public List<ReplicationPair> queryReplicationByAssociation(String devSn, int assObjType, String assObjId) {
        StringBuilder sb = new StringBuilder("/rest/${deviceID}/replicationpair/associate");
        sb.append("?TYPE=").append(XveMOType.REPLICATIONPAIR.getValue());
        sb.append("&ASSOCIATEOBJTYPE=").append(assObjType);
        sb.append("&ASSOCIATEOBJID=").append(assObjId);
        logger.debug((Object)"Query replication by association start. devSn=%s, url=%s.", new Object[]{devSn, sb.toString()});
        RestConnection connection = this.getConnection(devSn);
        List records = connection.getBatch(sb.toString(), null);
        ArrayList<ReplicationPair> list = new ArrayList<ReplicationPair>();
        for (Map record : records) {
            try {
                ReplicationPair replicationPair = HVSRestTransitionExtend.transitionReplicationPair(record, devSn);
                list.add(replicationPair);
            }
            catch (Exception e) {
                logger.error((Object)"Error while Replication transition, devSn=%s, assObjType=%s, assObjID=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), assObjType, assObjId});
            }
        }
        logger.debug((Object)"Query replication by association finished. devSn=%s, assObjID=%s, returned replicationPair size=%s.", new Object[]{devSn, assObjId, list.size()});
        return list;
    }

    public void modify(String sn, String id, boolean isCg, Map<String, Object> params) {
        logger.debug((Object)"Begin modify, sn=%s, id=%s, isCg=%s.", new Object[]{SecurityUtil.desensitizeId((String)sn), id, isCg, params});
        VerifyUtil.checkStrs((String[])new String[]{sn, id});
        if (VerifyUtil.isEmpty(params)) {
            logger.error((Object)"Info can not be empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String url = isCg ? "/rest/${deviceID}/consistentgroup/" + id : "/rest/${deviceID}/replicationpair/" + id;
        Map<String, String> paramsNew = this.transform(params);
        logger.debug((Object)"Transform result=%s.", new Object[]{paramsNew});
        this.getConnection(sn).put(url, paramsNew);
        logger.debug((Object)"End modify.");
    }
}

