/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageSnapshotConsistencyGroupHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.hvs.handler.impl.StorageLunConsistencyGroupHandlerImpl;
import com.huawei.ism.drm.storage.sdk.model.SnapshotConsistentGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;

public class StorageSnapshotConsistencyGroupHandlerImpl
implements IStorageSnapshotConsistencyGroupHandler {
    protected static final Log logger = LogFactory.getInstance(StorageLunConsistencyGroupHandlerImpl.class);
    private HvsRestConnectionManager connMgr = HvsRestConnectionManager.getInstance();

    public SnapshotConsistentGroup createSnapshotCgFromHyperCDPCg(String devSn, String name, String copySourceId) {
        SnapshotConsistentGroup snapshotCG;
        VerifyUtil.checkStrs((String[])new String[]{devSn, name, copySourceId});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("NAME", name);
        paramMap.put("SOURCECDPCGID", copySourceId);
        paramMap.put("TYPE", String.valueOf(XveMOType.HYPERCDP_CONSISTENCY_GROUP.getValue()));
        RestConnection connection = this.getConnection(devSn);
        try {
            Map map = connection.post("/rest/${deviceID}/CONSISTENCY_GROUP/createcopy", paramMap);
            snapshotCG = HVSRestTransitionExtend.transitionSnapshotConsistencyGroup(map);
        }
        catch (LegoCheckedException le) {
            logger.error((Throwable)le, (Object)"Creating a Snapshot CG Copy by HyperCDP CG failed. devSN=%s, cgName=%s, copySourceID=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), name, copySourceId});
            throw le;
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Object)"Creating a Snapshot CG Copy by HyperCDP CG failed. devSN=%s, cgName=%s, copySourceID=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), name, copySourceId});
            throw new LegoCheckedException("Creating a Snapshot Consistency Group Copy failed.", (Throwable)e);
        }
        return snapshotCG;
    }

    public SnapshotConsistentGroup createSnapshotConsistencyGroupCopy(String devSn, String name, String copySourceId) {
        SnapshotConsistentGroup snapshotCG;
        VerifyUtil.checkStrs((String[])new String[]{devSn, name, copySourceId});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("NAME", name);
        paramMap.put("COPYSOURCEID", copySourceId);
        paramMap.put("TYPE", String.valueOf(XveMOType.SNAPSHOT_CONSISTENCY_GROUP.getValue()));
        RestConnection connection = this.getConnection(devSn);
        try {
            Map map = connection.post("/rest/${deviceID}/CONSISTENCY_GROUP/createcopy", paramMap);
            snapshotCG = HVSRestTransitionExtend.transitionSnapshotConsistencyGroup(map);
        }
        catch (LegoCheckedException le) {
            logger.error((Throwable)le, (Object)"Creating a Snapshot CG Copy by SNAPSHOT CG failed. devSN=%s, cgName=%s, copySourceID=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), name, copySourceId});
            throw le;
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Object)"Creating a Snapshot CG Copy by SNAPSHOT CG failed. devSN=%s, cgName=%s, copySourceID=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), name, copySourceId});
            throw new LegoCheckedException("Creating a Snapshot Consistency Group Copy by SNAPSHOT CG failed.", (Throwable)e);
        }
        return snapshotCG;
    }

    public void rollback(String devSn, String id, String restoreSpeed) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        if (VerifyUtil.isEmpty((String)restoreSpeed)) {
            restoreSpeed = String.valueOf(DmEnumDefine.SpeedLevelE.SPEED_LEVEL_MIDDLE.getValue());
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TYPE", String.valueOf(XveMOType.SNAPSHOT_CONSISTENCY_GROUP.getValue()));
        paramMap.put("ID", id);
        paramMap.put("RESTORESPEED", restoreSpeed);
        logger.debug((Object)"Rollback snapshotCG. devSn=%s, cgID=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), id});
        RestConnection connection = this.getConnection(devSn);
        try {
            connection.put("/rest/${deviceID}/snapshot_consistency_group/rollback", paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Throwable)le, (Object)"Rollback snapShotCG failed. devSn=%s, cgId=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), id});
            throw le;
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Object)"Rollback snapShotCG failed. devSn=%s, cgId=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), id});
            throw new LegoCheckedException("Rollback snapShotCG failed.", (Throwable)e);
        }
    }

    public void delete(String devSn, String id) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        logger.debug((Object)"Delete Snapshot Consistency Group Copy. devSn=%s, cgID=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), id});
        RestConnection connection = this.getConnection(devSn);
        try {
            connection.delete("/rest/${deviceID}/SNAPSHOT_CONSISTENCY_GROUP/" + id, null);
        }
        catch (LegoCheckedException le) {
            logger.error((Throwable)le, (Object)"Delete a Snapshot Consistency Group Copy failed. devSn=%s, cgId=%s", new Object[]{devSn, id});
            throw le;
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Object)"Delete a Snapshot Consistency Group Copy failed. devSn=%s, cgId=%s", new Object[]{devSn, id});
            throw new LegoCheckedException("Delete a Snapshot Consistency Group Copy failed.", (Throwable)e);
        }
    }

    private String getCondition(Map<String, String> filter) {
        StringBuilder condition = new StringBuilder();
        if (!VerifyUtil.isEmpty(filter)) {
            condition.append("?filter=");
            for (Map.Entry<String, String> entry : filter.entrySet()) {
                if (!condition.toString().equals("filter=")) {
                    condition.append(" and ");
                }
                condition.append(entry.getKey());
                condition.append("::");
                condition.append(entry.getValue());
            }
        }
        return condition.toString();
    }

    public SnapshotConsistentGroup query(String devSn, String id) {
        SnapshotConsistentGroup snapshotCG;
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        RestConnection connection = this.getConnection(devSn);
        try {
            Map map = connection.get("/rest/${deviceID}/SNAPSHOT_CONSISTENCY_GROUP/" + id, null);
            snapshotCG = HVSRestTransitionExtend.transitionSnapshotConsistencyGroup(map);
        }
        catch (LegoCheckedException le) {
            logger.error((Throwable)le, (Object)"Query Snapshot Consistency Group failed. devSN=%s, cgId=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), id});
            if (Long.valueOf(1073748837L).equals(le.getErrorCode())) {
                logger.error((Object)"SnapshotConsistencyGroup not exist.");
                return null;
            }
            throw le;
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Object)"Query Snapshot Consistency Group failed. devSN=%s, cgId=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), id});
            throw new LegoCheckedException("Query Snapshot Consistency Group failed.", (Throwable)e);
        }
        return snapshotCG;
    }

    protected RestConnection getConnection(String devSn) {
        return this.connMgr.getConnection(devSn);
    }
}

