/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.array.sdk.model.Mapping;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.storage.handler.IStorageHostHandler;
import com.huawei.ism.drm.storage.handler.IStorageInitiatorHandler;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.handler.IStorageMappingHandler;
import com.huawei.ism.drm.storage.hvs.manager.RestStorageHandlerManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class BaseHvsStorageManager {
    private static final Log LOGGER = LogFactory.getInstance(BaseHvsStorageManager.class);
    private static final int MAPPING_STATE_NO = 1;
    private static final int MAPPING_STATE_PARTIAL = 2;
    private static final int MAPPING_STATE_UNAVAILABLE = 4;
    private static final int MAPPING_STATE_ALL = 8;

    BaseHvsStorageManager() {
    }

    private List<Initiator> queryInitiators(String devSn, HostVO hostVo) {
        List initsFromAgent = hostVo.getInitiators();
        if (VerifyUtil.isEmpty((Collection)initsFromAgent)) {
            LOGGER.error((Object)"There is no initiator info from agent: %s.", new Object[]{hostVo.getIpAddress()});
            throw new LegoCheckedException(1073947443L, new String[]{hostVo.getIpAddress()});
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Initiators from agent[").append(hostVo.getName()).append("]: ");
        for (Initiator initiator : initsFromAgent) {
            sb.append(initiator.getHbaType()).append("=").append(initiator.getIdentity()).append("; ");
        }
        LOGGER.info((Object)sb.toString());
        ArrayList<Initiator> initsRealTime = new ArrayList<Initiator>();
        boolean available = false;
        IStorageInitiatorHandler initiatorHandler = RestStorageHandlerManager.getInstance().getInitiatorHandler();
        if (initiatorHandler == null) {
            LOGGER.error((Object)"QueryInitiators failed, getInitiatorHandler is null, devSn:%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073947395L);
        }
        for (Initiator initiator : initsFromAgent) {
            String type = initiator.getHbaType();
            String identity = initiator.getIdentity();
            try {
                LOGGER.info((Object)"Query initiator ifo, type=%s, id=%s.", new Object[]{type, identity});
                Initiator realInfo = initiatorHandler.queryInitiator(devSn, initiator);
                LOGGER.info((Object)"RealInfo=%s.", new Object[]{realInfo});
                if (realInfo == null) continue;
                initsRealTime.add(realInfo);
                if (realInfo.getRunningStatus() != 0) continue;
                available = true;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Query realtime initiator info failed, error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
        if (initsRealTime.isEmpty()) {
            LOGGER.error((Object)"No initiator found from storage device, check whether initiators on the host are connected, hostName: %s.", new Object[]{hostVo.getName()});
            throw new LegoCheckedException(1073948684L);
        }
        if (!available) {
            LOGGER.error((Object)"No online initiator on the storage device from the host, hostName is %s.", new Object[]{hostVo.getName()});
            throw new LegoCheckedException(1073947444L);
        }
        return initsRealTime;
    }

    protected List<ArrayHost> prepareHosts(String devSn, HostVO hostVo, boolean strict) {
        List<Initiator> inits = this.queryInitiators(devSn, hostVo);
        HashMap<String, ArrayHost> hosts = new HashMap<String, ArrayHost>();
        ArrayList<Initiator> initsFree = new ArrayList<Initiator>();
        ArrayHost commonHost = null;
        IStorageHostHandler hostHandler = this.getHandlerMgr().getHostHandler();
        if (hostHandler == null) {
            LOGGER.error((Object)"PrepareHosts failed, gethostHandler is null, devSn:%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073947395L);
        }
        for (Initiator init : inits) {
            if (init.getIsFree().booleanValue()) {
                initsFree.add(init);
                continue;
            }
            ArrayHost host = hostHandler.queryHost(devSn, init);
            if (host == null) {
                LOGGER.error((Object)"The initiator is abnormal, initiator is %s.", new Object[]{init});
                initsFree.add(init);
                continue;
            }
            hosts.put(host.getHostId(), host);
            commonHost = host;
        }
        if (strict && hosts.size() > 1) {
            LOGGER.error((Object)"In strict mode, but more than one host, hosts is %s.", new Object[]{hosts});
            throw new LegoCheckedException(1073947446L);
        }
        if (commonHost == null) {
            String hostName = "RD_Host_" + System.currentTimeMillis();
            String desc = hostVo.getName();
            String ip = hostVo.getIpAddress();
            int osType = hostVo.getOsType();
            osType = XveEnumDefinePParent.OS_TYPE_E.valueOf((int)osType) == null ? XveEnumDefinePParent.OS_TYPE_E.Linux.getValue() : osType;
            LOGGER.info((Object)"Create Host, name=%s, os=%s, ip=%s.", new Object[]{hostName, String.valueOf(osType), ip});
            commonHost = hostHandler.createHost(devSn, hostName, osType, desc, ip);
            hosts.put(commonHost.getHostId(), commonHost);
        }
        LOGGER.info((Object)"Hit Host, id=%s, name=%s.", new Object[]{commonHost.getHostId(), commonHost.getName()});
        IStorageInitiatorHandler initiatorHandler = RestStorageHandlerManager.getInstance().getInitiatorHandler();
        if (initiatorHandler == null) {
            LOGGER.error((Object)"prepareHosts failed, getInitiatorHandler is null, devSn:%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073947395L);
        }
        BaseHvsStorageManager.addInitiatorToHost(devSn, initsFree, commonHost, initiatorHandler);
        return Arrays.asList(hosts.values().toArray(new ArrayHost[0]));
    }

    private static void addInitiatorToHost(String devSn, List<Initiator> initsFree, ArrayHost commonHost, IStorageInitiatorHandler initiatorHandler) {
        for (Initiator init : initsFree) {
            XveMOType initiatorType = XveMOType.FC_INITIATOR;
            if ("ISCSI".equals(init.getHbaType())) {
                initiatorType = XveMOType.ISCSI_INITIATOR;
            }
            initiatorHandler.addInitiatorToHost(devSn, commonHost.getHostId(), initiatorType, init.getIdentity());
            LOGGER.info((Object)"Add init [%s] to host [%s].", new Object[]{init, commonHost});
        }
    }

    protected ArrayHostGroup prepareHostGroup(String devSn, List<ArrayHost> hosts) {
        HashMap<String, ArrayHostGroup> hgs = new HashMap<String, ArrayHostGroup>();
        IStorageHostHandler hostHandler = this.getHandlerMgr().getHostHandler();
        if (hostHandler == null) {
            LOGGER.error((Object)"Param hostHandler is null.");
            throw new LegoCheckedException(1073947395L);
        }
        for (ArrayHost host : hosts) {
            List realHostGroups = hostHandler.queryHostGroups(devSn, XveMOType.HOST, host.getHostId());
            Iterator iterator = realHostGroups.iterator();
            while (iterator.hasNext()) {
                ArrayHostGroup realHostGroup = (ArrayHostGroup)iterator.next();
                hgs.put(realHostGroup.getHostGroupId(), realHostGroup);
            }
        }
        ArrayHostGroup hitHg = null;
        int tempLevel = -1;
        for (ArrayHostGroup hostGroup : hgs.values()) {
            int level = this.getCandidateLevel(devSn, hostGroup, hosts);
            if (level > tempLevel) {
                tempLevel = level;
                hitHg = hostGroup;
            }
            if (tempLevel != 2) continue;
            break;
        }
        if (hitHg == null) {
            String hgName = "RD_HG_" + System.currentTimeMillis();
            LOGGER.info((Object)"Create HG, name=%s.", new Object[]{hgName});
            hitHg = hostHandler.createHostGroup(devSn, hgName, "");
        }
        if (2 != tempLevel) {
            for (ArrayHost host : hosts) {
                LOGGER.info((Object)"Add Host to HG, hostId=%s, hgId=%s.", new Object[]{host.getHostId(), hitHg.getHostGroupId()});
                hostHandler.addHostToHostGroup(devSn, hitHg.getHostGroupId(), host.getHostId());
            }
        }
        LOGGER.info((Object)"Hit HG, id=%s, name=%s.", new Object[]{hitHg.getHostGroupId(), hitHg.getName()});
        return hitHg;
    }

    private int getCandidateLevel(String devSn, ArrayHostGroup hg, List<ArrayHost> hosts) {
        IStorageHostHandler hostHandler = this.getHandlerMgr().getHostHandler();
        if (hostHandler == null) {
            LOGGER.error((Object)"GetCandidateLevel failed, get host handler is null, devSn: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073947395L);
        }
        List realHosts = hostHandler.queryHostsByHostGroup(devSn, hg.getHostGroupId());
        if (VerifyUtil.isEmpty((Collection)realHosts)) {
            return 0;
        }
        if (realHosts.size() > hosts.size()) {
            return -1;
        }
        for (ArrayHost arrayHost : realHosts) {
            boolean isFind = false;
            for (ArrayHost host : hosts) {
                if (!arrayHost.getHostId().equals(host.getHostId())) continue;
                isFind = true;
                break;
            }
            if (isFind) continue;
            return -1;
        }
        if (realHosts.size() == hosts.size()) {
            return 2;
        }
        return 1;
    }

    private MappingView intersectionMappingView(List<MappingView> hgMvs, List<MappingView> resMvs) {
        MappingView mv = null;
        if (VerifyUtil.isEmpty(hgMvs)) {
            LOGGER.info((Object)"Param hgMvs is empty, return null.");
            return null;
        }
        if (VerifyUtil.isEmpty(resMvs)) {
            LOGGER.info((Object)"Param resMvs is empty, select the first one from hgMvs.");
            return hgMvs.get(0);
        }
        LOGGER.info((Object)"MV associated with HG, size=%s.", new Object[]{String.valueOf(hgMvs.size())});
        LOGGER.info((Object)"MV associated with Resource, size=%s.", new Object[]{String.valueOf(resMvs.size())});
        for (MappingView hgMv : hgMvs) {
            for (MappingView resMv : resMvs) {
                if (!hgMv.getMappingViewId().equals(resMv.getMappingViewId())) continue;
                mv = hgMv;
                break;
            }
            if (mv == null) continue;
            LOGGER.info((Object)"Intersect a MV, id=%s, name=%s.", new Object[]{mv.getMappingViewId(), mv.getName()});
            break;
        }
        if (mv == null) {
            mv = hgMvs.get(0);
            LOGGER.info((Object)"Intersect a MV, id=%s, name=%s.", new Object[]{mv.getMappingViewId(), mv.getName()});
        }
        return mv;
    }

    protected MappingView prepareMappingView(String devSn, String hostGroupId, XveMOType resourceType, String resourceId) {
        List lunMvs;
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        List hgMvs = mappingHandler.queryMappingView(devSn, XveMOType.HOSTGROUP, hostGroupId);
        MappingView mv = this.intersectionMappingView(hgMvs, lunMvs = mappingHandler.queryMappingView(devSn, resourceType, resourceId));
        if (mv == null) {
            mv = this.prepareMappingViewByHg(devSn, hostGroupId);
        }
        LOGGER.info((Object)"Hit MV, id=%s, name=%s.", new Object[]{mv.getMappingViewId(), mv.getName()});
        return mv;
    }

    protected MappingView prepareMappingViewByHg(String devSn, String hostGroupId) {
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        List hgMvs = mappingHandler.queryMappingView(devSn, XveMOType.HOSTGROUP, hostGroupId);
        MappingView mv = null;
        if (!VerifyUtil.isEmpty((Collection)hgMvs)) {
            IStorageLunHandler lunHandler = this.getHandlerMgr().getLunHandler();
            if (lunHandler == null) {
                LOGGER.error((Object)"GetLunHandler is empty, devSn=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
                throw new LegoCheckedException(1073947395L);
            }
            for (MappingView mappingView : hgMvs) {
                String mvId = mappingView.getMappingViewId();
                List lunGroups = lunHandler.queryLunGroups(devSn, XveMOType.MAPPINGVIEW, mvId);
                if (VerifyUtil.isEmpty((Collection)lunGroups)) continue;
                mv = mappingView;
                break;
            }
            if (mv == null) {
                mv = (MappingView)hgMvs.get(0);
            }
        }
        if (mv == null) {
            String mvName = "RD_MV_" + System.currentTimeMillis();
            LOGGER.info((Object)"Create MV, name=%s.", new Object[]{mvName});
            mv = mappingHandler.createMappingView(devSn, mvName, null);
            LOGGER.info((Object)"Add HG to MV, hgId=%s, mvId=%s.", new Object[]{hostGroupId, mv.getMappingViewId()});
            mappingHandler.addObjectToMappingView(devSn, mv.getMappingViewId(), XveMOType.HOSTGROUP, hostGroupId);
        }
        LOGGER.info((Object)"Hit MV, id=%s, name=%s.", new Object[]{mv.getMappingViewId(), mv.getName()});
        return mv;
    }

    protected XveLunGroup prepareLunGroup(String devSn, MappingView mv) {
        XveLunGroup lg;
        String mvId = mv.getMappingViewId();
        IStorageLunHandler lunHandler = this.getHandlerMgr().getLunHandler();
        if (lunHandler == null) {
            LOGGER.error((Object)"GetLunHandler is empty, devSn=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073947395L);
        }
        List lunGroups = lunHandler.queryLunGroups(devSn, XveMOType.MAPPINGVIEW, mvId);
        LOGGER.info((Object)"LunGroup associated with MappingView, mvId=%s, lgSize=%s.", new Object[]{mvId, String.valueOf(lunGroups.size())});
        if (VerifyUtil.isEmpty((Collection)lunGroups)) {
            String lgName = "RD_LG_" + System.currentTimeMillis();
            LOGGER.info((Object)"Create LG, name=%s.", new Object[]{lgName});
            lg = lunHandler.createLunGroup(devSn, lgName);
            LOGGER.info((Object)"Associate LunGroup to MappingView, lgId=%s, mvId=%s.", new Object[]{lg.getLunGroupId(), mvId});
            this.getHandlerMgr().getMappingHandler().addObjectToMappingView(devSn, mvId, XveMOType.LUNGROUP, lg.getLunGroupId());
        } else {
            lg = (XveLunGroup)lunGroups.get(0);
        }
        LOGGER.info((Object)"Hit LG, id=%s, name=%s.", new Object[]{lg.getLunGroupId(), lg.getName()});
        return lg;
    }

    protected OperationResult generateOperationResult(LegoCheckedException ex, String operationName, String[] successParameters) {
        LOGGER.trace((Object)"generateOperationResult");
        OperationResult operationResult = ex.getErrorCode() != 1077951827L ? new OperationResult(operationName, true, false, String.valueOf(ex.getErrorCode()), ex.getParameters()) : new OperationResult(operationName, true, true, successParameters);
        return operationResult;
    }

    public boolean isMapping(String devSn, XveMOType resourceType, String resourceId, List<HostVO> hostVos) {
        if (!this.isResourceMapped(devSn, resourceId)) {
            return false;
        }
        HashMap<String, List<Initiator>> drHost2RealTimeInitsMap = new HashMap<String, List<Initiator>>();
        for (HostVO hostVo : hostVos) {
            List<Initiator> temp = this.queryInitiators(devSn, hostVo);
            drHost2RealTimeInitsMap.put(hostVo.getId(), temp);
        }
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        List lunMvs = mappingHandler.queryMappingView(devSn, resourceType, resourceId);
        if (VerifyUtil.isEmpty((Collection)lunMvs)) {
            LOGGER.debug((Object)"MappingView queried through resource is empty.");
            return false;
        }
        ArrayList hgsRealtime = new ArrayList();
        IStorageHostHandler hostHandler = this.getHandlerMgr().getHostHandler();
        if (hostHandler == null) {
            LOGGER.error((Object)"HostHandler is null!devSn: %s,type: %s,resourceId: %s.", new Object[]{devSn, resourceType, resourceId});
            throw new LegoCheckedException(1073947395L);
        }
        for (Object lunMv : lunMvs) {
            List hgsByMvRealTime = hostHandler.queryHostGroups(devSn, XveMOType.MAPPINGVIEW, lunMv.getMappingViewId());
            hgsRealtime.addAll(hgsByMvRealTime);
        }
        ArrayList<ArrayHost> hosts = new ArrayList<ArrayHost>();
        for (ArrayHostGroup hg : hgsRealtime) {
            hosts.addAll(hostHandler.queryHostsByHostGroup(devSn, hg.getHostGroupId()));
        }
        this.addLunMappedHost(devSn, resourceType, resourceId, hosts);
        if (hosts.isEmpty()) {
            LOGGER.debug((Object)"HostGroup queried through resource is empty.");
            return false;
        }
        ArrayList<Initiator> initsRealTime = new ArrayList<Initiator>(this.queryHostVoInitiators(devSn, hosts));
        if (initsRealTime.isEmpty()) {
            LOGGER.debug((Object)"Initiator queried through resource is empty.");
            return false;
        }
        int mappingState = this.calcMappingState(initsRealTime, drHost2RealTimeInitsMap);
        return this.parseMappingState(mappingState);
    }

    private void addLunMappedHost(String devSn, XveMOType resourceType, String resourceId, List<ArrayHost> hosts) {
        try {
            IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
            List mappings = mappingHandler.getMapping(devSn, resourceType, resourceId);
            IStorageHostHandler hostHandler = this.getHandlerMgr().getHostHandler();
            for (Mapping mapping : mappings) {
                ArrayHost host;
                String hostId = mapping.getHostId();
                if (VerifyUtil.isEmpty((String)hostId) || VerifyUtil.isEmpty((Object)(host = hostHandler.queryHost(devSn, hostId))) || hosts.contains(host)) continue;
                hosts.add(host);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"This api only support on dorado v6, plz check it. devSn:%s", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
        }
    }

    private List<Initiator> queryHostVoInitiators(String devSn, List<ArrayHost> hosts) {
        IStorageInitiatorHandler initiatorHandler = RestStorageHandlerManager.getInstance().getInitiatorHandler();
        if (initiatorHandler == null) {
            LOGGER.error((Object)"InitiatorHandler is null!devSn: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073947395L);
        }
        ArrayList<Initiator> initsRealTime = new ArrayList<Initiator>();
        for (ArrayHost host : hosts) {
            List temp = initiatorHandler.queryInitiatorsByHost(devSn, host.getHostId());
            initsRealTime.addAll(temp);
        }
        return initsRealTime;
    }

    private int calcMappingState(List<Initiator> initsRealTime, Map<String, List<Initiator>> drHost2RealTimeInitsMap) {
        int mappingState = 0;
        Set<Map.Entry<String, List<Initiator>>> entrySet = drHost2RealTimeInitsMap.entrySet();
        for (Map.Entry<String, List<Initiator>> entry : entrySet) {
            String hostSn = entry.getKey();
            LOGGER.info((Object)"Check drHost=%s.", new Object[]{SecurityUtil.desensitizeId((String)hostSn)});
            List<Initiator> drHostInits = entry.getValue();
            if (initsRealTime.containsAll(drHostInits)) {
                LOGGER.info((Object)"Contain all.");
                mappingState |= 8;
                continue;
            }
            boolean isContain = false;
            boolean isAvailable = false;
            for (Initiator init : drHostInits) {
                if (!initsRealTime.contains(init)) continue;
                isContain = true;
                if (init.getRunningStatus() != 0) continue;
                isAvailable = true;
            }
            if (isContain) {
                if (isAvailable) {
                    LOGGER.info((Object)"Contain partial.");
                    mappingState |= 2;
                    continue;
                }
                LOGGER.info((Object)"Contain, but unavailable.");
                mappingState |= 4;
                continue;
            }
            LOGGER.info((Object)"Contain no.");
            mappingState |= 1;
        }
        LOGGER.info((Object)"Contain result=%s.", new Object[]{String.valueOf(mappingState)});
        return mappingState;
    }

    public boolean parseMappingState(int mappingState) {
        if ((4 & mappingState) > 0) {
            LOGGER.error((Object)"The mapping is available, mappingState is %s.", new Object[]{String.valueOf(mappingState)});
            throw new LegoCheckedException(1073947445L);
        }
        if (mappingState == 1) {
            return false;
        }
        if (mappingState == 8 || mappingState == 2) {
            return true;
        }
        if ((1 & mappingState) > 0) {
            LOGGER.error((Object)"There is part mapping, mappingState is %s.", new Object[]{String.valueOf(mappingState)});
            throw new LegoCheckedException(1073947442L);
        }
        return true;
    }

    public String prepareMapping(String devSn, HostVO hostVo) {
        LOGGER.info((Object)"Enter prepareMapping, sn=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
        if (VerifyUtil.isEmpty((String)devSn)) {
            LOGGER.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (hostVo == null) {
            LOGGER.error((Object)"hostVo is null.");
            throw new LegoCheckedException(1073947393L);
        }
        List<ArrayHost> hosts = this.prepareHosts(devSn, hostVo, false);
        ArrayHostGroup hg = this.prepareHostGroup(devSn, hosts);
        MappingView mv = this.prepareMappingViewByHg(devSn, hg.getHostGroupId());
        XveLunGroup lunGroup = this.prepareLunGroup(devSn, mv);
        if (VerifyUtil.isEmpty((Object)lunGroup)) {
            LOGGER.error((Object)"Param lunGroup is empty.");
            return null;
        }
        LOGGER.info((Object)"End prepareMapping, sn=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
        return lunGroup.getLunGroupId();
    }

    public String prepareMapping(String devSn, HostGroupVO hostGroupVo) {
        LOGGER.info((Object)"Enter prepareMapping, HostGroup, sn=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
        if (VerifyUtil.isEmpty((String)devSn)) {
            LOGGER.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (hostGroupVo == null) {
            LOGGER.error((Object)"hostGroupVo is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<ArrayHost> hosts = new ArrayList<ArrayHost>();
        for (HostVO hostVo : hostGroupVo.getHostVOs()) {
            List<ArrayHost> temp = this.prepareHosts(devSn, hostVo, false);
            hosts.addAll(temp);
        }
        ArrayHostGroup hg = this.prepareHostGroup(devSn, hosts);
        MappingView mv = this.prepareMappingViewByHg(devSn, hg.getHostGroupId());
        XveLunGroup lunGroup = this.prepareLunGroup(devSn, mv);
        if (VerifyUtil.isEmpty((Object)lunGroup)) {
            LOGGER.error((Object)"lunGroup is empty!");
            return null;
        }
        LOGGER.info((Object)"End prepareMapping, HostGroup, sn=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
        return lunGroup.getLunGroupId();
    }

    protected RestStorageHandlerManager getHandlerMgr() {
        return RestStorageHandlerManager.getInstance();
    }

    protected abstract boolean isResourceMapped(String var1, String var2);
}

