/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HvsStorageFileSystemSnapshotManager
implements IStorageFileSystemSnapshotManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageFileSystemSnapshotManager.class);

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public List<Snapshot> querySnapshot(String devSn, String fsId) {
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/FSSNAPSHOT");
        url.append("?TYPE=").append(XveMOType.FSSNAPSHOT.getValue());
        url.append("&PARENTID=").append(fsId);
        url.append("&sortby=TIMESTAMP,d");
        logger.debug((Object)"Get snapshots: url = %s", new Object[]{url.toString()});
        List records = connection.getBatch(url.toString(), null);
        ArrayList<Snapshot> snapshotIdList = new ArrayList<Snapshot>();
        for (Map map : records) {
            Snapshot snapshot = new Snapshot();
            snapshot.setId((String)map.get("ID"));
            snapshot.setName((String)map.get("NAME"));
            snapshotIdList.add(snapshot);
        }
        return snapshotIdList;
    }

    public String createSnapshot(String devSn, String fsId, String name) {
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/FSSNAPSHOT");
        JSONObject paramMap = new JSONObject();
        paramMap.put((Object)"TYPE", (Object)XveMOType.FSSNAPSHOT.getValue());
        paramMap.put((Object)"NAME", (Object)name);
        paramMap.put((Object)"PARENTTYPE", (Object)XveMOType.FILESYSTEM.getValue());
        paramMap.put((Object)"PARENTID", (Object)fsId);
        logger.debug((Object)"Post createSnapshot: url = %s, params = %s", new Object[]{url, paramMap});
        Map record = connection.post(url.toString(), (Map)paramMap);
        return (String)record.get("ID");
    }

    public OperationResult deleteSnapshot(String devSn, String snapshotId) {
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/fssnapshot";
        try {
            logger.debug((Object)"Delete snapshot: url = %s", new Object[]{url + "/" + snapshotId});
            connection.delete(url + "/" + snapshotId, null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Delete snapshot failed: url = %s", new Object[]{url + "/" + snapshotId});
            if (1073754118L == e.getErrorCode()) {
                return new OperationResult("ism.drm.create.fssnapshot.operation", true, true, new String[]{snapshotId});
            }
            return new OperationResult("ism.drm.create.fssnapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return new OperationResult("ism.drm.create.fssnapshot.operation", true, true, new String[]{snapshotId});
    }

    public OperationResult rollBackSnapshot(String devSn, String snapshotId) {
        OperationResult operationResult;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", snapshotId);
        paramMap.put("TYPE", String.valueOf(XveMOType.FSSNAPSHOT.getValue()));
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/FSSNAPSHOT/ROLLBACK_FSSNAPSHOT";
        try {
            logger.debug((Object)"Put rollBackSnapshot: url = %s, param = %s", new Object[]{url, paramMap});
            connection.put(url, paramMap);
            operationResult = new OperationResult("ism.drm.restore.snapshot.operation", true, true, new String[]{snapshotId});
        }
        catch (LegoCheckedException e) {
            logger.error((Throwable)e, (Object)"Rollback snapshot failed. DevSN:%s, Id:%s, url:%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), snapshotId, url});
            operationResult = new OperationResult("ism.drm.restore.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Object)"Rollback snapshot failed. DevSN:%s, Id:%s, url:%s, message:%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), snapshotId, url, ExceptionUtil.getErrorMessage((Throwable)e)});
            operationResult = new OperationResult("ism.drm.restore.snapshot.operation", true, false, String.valueOf(1073948712L), new String[0]);
        }
        return operationResult;
    }
}

