/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceProxyExtendImpl;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.manager.sdk.model.HyperClonePolicyVO;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCloneManager;
import com.huawei.ism.drm.storage.sdk.model.DoradoHyperClone;
import com.huawei.ism.drm.storage.sdk.model.HyperClone;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HvsStorageHyperCloneManager
implements IStorageHyperCloneManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageHyperCloneManager.class);

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public HyperClone createHyperClone(String deviceSN, String lunId, String name, String description) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TYPE", String.valueOf(XveMOType.SPLITMIRROR.getValue()));
        paramMap.put("NAME", name);
        paramMap.put("PRILUNID", lunId);
        paramMap.put("DESCRIPTION", description);
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(deviceSN);
        String url = "/rest/${deviceID}/SPLITMIRROR";
        logger.debug((Object)"Post createHyperClone: url = %s, params = %s", new Object[]{url, paramMap});
        Map record = connection.post(url, paramMap);
        logger.debug((Object)"createHyperClone result = %s", new Object[]{record});
        HyperClone hyperClone = HVSRestTransitionExtend.transitionHyperClone(record, deviceSN);
        return hyperClone;
    }

    public DoradoHyperClone createDoradoHyperClone(String deviceSN, DoradoHyperClone clone) {
        if (VerifyUtil.isEmpty((String)clone.getName()) || VerifyUtil.isEmpty((String)clone.getSourceId())) {
            logger.error((Object)"name or sourceid of clone is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)deviceSN)) {
            logger.error((Object)"device SN is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject params = new JSONObject();
        params.put((Object)"ISCLONE", (Object)true);
        params.put((Object)"NAME", (Object)clone.getName());
        if (!VerifyUtil.isEmpty((String)clone.getCloneDescription())) {
            params.put((Object)"DESCRIPTION", (Object)clone.getCloneDescription());
        }
        if (!VerifyUtil.isEmpty((String)clone.getWorkLoadType())) {
            params.put((Object)"DESCRIPTION", (Object)clone.getWorkLoadType());
        }
        params.put((Object)"CLONESOURCEID", (Object)Integer.valueOf(clone.getSourceId()));
        if (!VerifyUtil.isEmpty((Object)clone.getSplitSpeed())) {
            params.put((Object)"SPLITSPEED", (Object)String.valueOf(clone.getSplitSpeed()));
        } else {
            params.put((Object)"SPLITSPEED", (Object)4);
        }
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(deviceSN);
        String url = "/rest/${deviceID}/lun";
        logger.debug((Object)"Post createDoradoHyperClone: url = %s, param = %s", new Object[]{url, params.toString()});
        String jsonRes = connection.postForObject(url, (Object)params);
        logger.debug((Object)"createDoradoHyperClone result = %s", new Object[]{jsonRes});
        return HVSRestTransitionExtend.transitionDoradoHyperClone(JSONObject.fromObject((Object)jsonRes), deviceSN);
    }

    public OperationResult addTargetLun(String deviceSN, String pairId, String lunId, HyperClonePolicyVO policyVO) {
        OperationResult operationResult;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TYPE", String.valueOf(XveMOType.SPLITMIRRORTARGETLUN.getValue()));
        paramMap.put("PARENTTYPE", String.valueOf(XveMOType.SPLITMIRROR.getValue()));
        paramMap.put("PARENTID", pairId);
        paramMap.put("ID", lunId);
        paramMap.put("SPEED", String.valueOf(policyVO.getSpeed()));
        paramMap.put("RESUMEPOLICY", String.valueOf(policyVO.getResumePolicy()));
        paramMap.put("FIRSTSYNC", String.valueOf(policyVO.getFirstSync()));
        paramMap.put("PROTECTMODEL", String.valueOf(policyVO.getProtectModel()));
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(deviceSN);
        String url = "/rest/${deviceID}/SPLITMIRRORTARGETLUN/addtargetlun";
        try {
            logger.debug((Object)"Put addLun: url = %s, prams = %s", new Object[]{url, paramMap});
            connection.put(url, paramMap);
            operationResult = new OperationResult("ism.drm.addhyperclonetargetlun.operation", true, true, new String[0]);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Adding hyper clone target lun failed. url = " + url), (Throwable)e, 90160758784001L);
            operationResult = new OperationResult("ism.drm.addhyperclonetargetlun.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return operationResult;
    }

    public OperationResult splitMultiHyperClone(String deviceSN, List<String> pairIds) {
        OperationResult operationResult;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("PAIRID", StringUtil.arrayToStrWithSplit((Object[])pairIds.toArray(), (String)","));
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(deviceSN);
        String url = "/rest/${deviceID}/splitmirror/split_multihyperclone_slave";
        try {
            logger.debug((Object)"Put splitMultiHyperClone: url = %s, params = %s", new Object[]{url, paramMap});
            connection.put(url, paramMap);
            operationResult = new OperationResult("ism.drm.splitmultihypercloneslave.operation", true, true, new String[0]);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Split multi hyperclone slave failed. url = " + url), (Throwable)e, 90160758784001L);
            operationResult = new OperationResult("ism.drm.splitmultihypercloneslave.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return operationResult;
    }

    public void splitDoradoHyperClone(String deviceSN, String cloneId) {
        if (VerifyUtil.isEmpty((String)deviceSN) || VerifyUtil.isEmpty((String)cloneId)) {
            logger.error((Object)"device SN or cloneId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject params = new JSONObject();
        params.put((Object)"ISCLONE", (Object)true);
        params.put((Object)"ID", (Object)cloneId);
        params.put((Object)"SPLITACTION", (Object)1);
        params.put((Object)"SPLITSPEED", (Object)2);
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(deviceSN);
        String url = "/rest/${deviceID}/lunclone_split_switch";
        logger.debug((Object)"Put splitDoradoHyperClone: url = %s, params = %s", new Object[]{url, params});
        connection.put(url, (Map)params);
    }

    public DoradoHyperClone getDoradoHyperClone(String deviceSN, String cloneId) {
        return null;
    }

    public List<DoradoHyperClone> getDoradoHyperClone(String deviceSN, List<String> clones) {
        return null;
    }

    public HyperCloneTargetLun getTargetLun(String deviceSN, String srcLunId, String tgtLunId) {
        List<HyperCloneTargetLun> targetLuns = this.getTargetLuns(deviceSN, srcLunId);
        if (VerifyUtil.isEmpty(targetLuns)) {
            return null;
        }
        for (HyperCloneTargetLun targetLun : targetLuns) {
            if (!targetLun.getId().endsWith(tgtLunId)) continue;
            return targetLun;
        }
        return null;
    }

    public HyperClone getHyperClone(String deviceSN, String lunId) {
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(deviceSN);
        String queryLunUrl = "/rest/${deviceID}/lun/" + lunId;
        logger.debug((Object)"queryLunUrl: url = %s", new Object[]{queryLunUrl});
        Map lunResult = connection.get(queryLunUrl, null);
        if (VerifyUtil.isEmpty((Map)lunResult)) {
            return null;
        }
        logger.debug((Object)"queryLunUrl: result = %s", new Object[]{lunResult});
        String associatedSplitMirrorIds = (String)lunResult.get("SPLITMIRRORIDS");
        if (VerifyUtil.isEmpty((String)associatedSplitMirrorIds)) {
            return null;
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)associatedSplitMirrorIds);
        if (null == jsonArray || jsonArray.isEmpty()) {
            return null;
        }
        String hyperCloneId = String.valueOf(jsonArray.get(0));
        String queryHyperCloneUrl = "/rest/${deviceID}/splitmirror/" + hyperCloneId;
        logger.debug((Object)"queryHyperCloneUrl url = %s", new Object[]{queryHyperCloneUrl});
        Map hyperCloneResult = connection.get(queryHyperCloneUrl, null);
        logger.debug((Object)"queryHyperCloneUrl result = %s", new Object[]{hyperCloneResult});
        HyperClone hyperClone = HVSRestTransitionExtend.transitionHyperClone(hyperCloneResult, deviceSN);
        if (!hyperClone.getPriLunId().equals(lunId)) {
            return null;
        }
        return hyperClone;
    }

    public List<HyperCloneTargetLun> getTargetLuns(String deviceSN, String srcLunId) {
        List<HyperCloneTargetLun> targetLuns = new ArrayList<HyperCloneTargetLun>();
        HyperClone hyperClone = this.getHyperClone(deviceSN, srcLunId);
        if (null == hyperClone) {
            return targetLuns;
        }
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(deviceSN);
        HvsDeviceProxyExtendImpl deviceProxy = new HvsDeviceProxyExtendImpl();
        targetLuns = deviceProxy.getHyperCloneTargetLuns(connection, deviceSN, hyperClone.getId());
        return targetLuns;
    }

    public OperationResult syncHyperClone(String deviceSN, String hyperCloneId, String targetLunId) {
        OperationResult operationResult;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", targetLunId);
        paramMap.put("PARENTID", hyperCloneId);
        paramMap.put("PARENTTYPE", String.valueOf(XveMOType.SPLITMIRROR.getValue()));
        paramMap.put("TYPE", String.valueOf(XveMOType.SPLITMIRRORTARGETLUN.getValue()));
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(deviceSN);
        String url = "/rest/${deviceID}/SPLITMIRRORTARGETLUN/syn";
        try {
            logger.debug((Object)"Put syncHyperClone: url = %s, paramMap = %s", new Object[]{url, paramMap});
            connection.put(url, paramMap);
            operationResult = new OperationResult("ism.drm.synchyperclone.operation", true, true, new String[0]);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Sync hyperclone failed.", (Throwable)e, 90160758784001L);
            operationResult = new OperationResult("ism.drm.synchyperclone.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return operationResult;
    }
}

