/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.array.sdk.model.RemoteDevice;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.storage.constant.HcResourceType;
import com.huawei.ism.drm.storage.constant.RecoveryPolicy;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.hvs.handler.impl.constant.HvsRequestDefine;
import com.huawei.ism.drm.storage.hvs.model.AssociateHyperMetroPairRequest;
import com.huawei.ism.drm.storage.hvs.model.CreateHyperMetroConsistentGroupReq;
import com.huawei.ism.drm.storage.hvs.model.CreateHyperMetroConsistentGroupRes;
import com.huawei.ism.drm.storage.hvs.model.CreateHyperMetroPairRequest;
import com.huawei.ism.drm.storage.hvs.model.CreateHyperMetroPairResponse;
import com.huawei.ism.drm.storage.manager.sdk.model.StorageHyperMetroDomain;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroGroup;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.ubase.adaptor.hvs.discovery.util.HVSRestTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HvsStorageHyperMetroManager
implements IStorageHyperMetroManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageHyperMetroManager.class);
    private static final Map<String, XveEuumDefineParent.RUNNING_STATUS_E> RUNNING_STATUS_MAP = ImmutableMap.builder().put((Object)"PAUSE", (Object)XveEuumDefineParent.RUNNING_STATUS_E.PAUSE).put((Object)"SYNCHRONIZING", (Object)XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING).put((Object)"NORMAL", (Object)XveEuumDefineParent.RUNNING_STATUS_E.NORMAL).build();
    private static final List<String> NORMAL_RUNNING_STATUS = ImmutableList.builder().add((Object)String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue())).add((Object)String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue())).add((Object)String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.TO_BE_SYNCHRONIZED.getValue())).add((Object)String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.FORCED_START.getValue())).build();
    private static final List<String> NORMAL_HEALTH_STATUS = ImmutableList.of((Object)String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue())).asList();

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public HyperMetroPair queryHyperMetroPair(String devSn, String pairId, String vstoreId) {
        logger.debug((Object)"Enter queryHyperMetroPair, sn=%s, pairId=%s, vstoreId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), pairId, vstoreId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, pairId});
        RestConnection conn = this.getConn(devSn);
        String url = String.format(Locale.ENGLISH, HvsRequestDefine.QUERY_HYPER_METRO_PAIR.getUri(), pairId);
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "?vstoreId=" + vstoreId;
        }
        logger.debug((Object)"Get hyperMetroPair: url = %s.", new Object[]{url});
        Map record = conn.get(url, null);
        logger.debug((Object)"Get hyperMetro: result is %s.", new Object[]{record});
        HyperMetroPair pair = HVSRestTransitionExtend.transitionHyperMetroPair(devSn, record);
        logger.debug((Object)"Exist queryHyperMetroPair.");
        return pair;
    }

    public List<QuorumServerLink> queryQuorumServerLinks(String devSn, String serverId) {
        logger.debug((Object)"Enter queryQuorumServerLinks, sn=%s, serverId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), serverId});
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)serverId)) {
            logger.error((Object)"serverId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = this.getConn(devSn);
        String url = "/rest/${deviceID}/QuorumServerLink?PARENTID=" + serverId + "&range=[0-65536]";
        logger.debug((Object)"Get quorumServerLinks: url = %s.", new Object[]{url});
        List records = conn.getBatch(url, null);
        ArrayList<QuorumServerLink> links = new ArrayList<QuorumServerLink>();
        for (Map record : records) {
            QuorumServerLink link = HVSRestTransitionExtend.transitionQuorumServerLink(devSn, record);
            links.add(link);
        }
        logger.debug((Object)"Exit queryQuorumServerLinks.");
        return links;
    }

    public void synchronize(String devSn, String id, boolean isCg, String vstoreId) {
        logger.debug((Object)"Enter sync, sn=%s, id=%s, isCg=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), id, isCg});
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        if (isCg) {
            this.syncCg(devSn, id);
        } else {
            this.syncPair(devSn, id, vstoreId);
        }
        logger.debug((Object)"Exit sync.");
    }

    private void syncPair(String devSn, String pairId, String vstoreId) {
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", pairId);
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            paras.put("vstoreId", vstoreId);
        }
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroPair.getValue()));
        String url = "/rest/${deviceID}/HyperMetroPair/synchronize_hcpair";
        logger.debug((Object)"Put syncPair: url = %s, params = %s.", new Object[]{url, paras});
        RestConnection conn = this.getConn(devSn);
        conn.put(url, paras);
    }

    private void syncCg(String devSn, String cgId) {
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", cgId);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroConsistentGroup.getValue()));
        String url = "/rest/${deviceID}/HyperMetro_ConsistentGroup/sync";
        logger.debug((Object)"Put syncConsistentGroup: url = %s, params = %s.", new Object[]{url, paras});
        RestConnection conn = this.getConn(devSn);
        conn.put(url, paras);
    }

    public void disable(String devSn, String id, DrmEnumDefine.RoleType role, boolean isCg, String vstoreId) {
        logger.debug((Object)"Enter disable, sn=%s, id=%s, role=%s, isCg=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), id, role, isCg});
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        if (isCg) {
            this.parseCg(devSn, id, role);
        } else {
            this.pausePair(devSn, id, role, vstoreId);
        }
        logger.debug((Object)"Exit disable.");
    }

    private void pausePair(String devSn, String id, DrmEnumDefine.RoleType role, String vstoreId) {
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", id);
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            paras.put("vstoreId", vstoreId);
        }
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroPair.getValue()));
        if (role != null) {
            if (DrmEnumDefine.RoleType.PRIORITY.equals((Object)role)) {
                paras.put("ISPRIMARY", Boolean.TRUE.toString());
            } else if (DrmEnumDefine.RoleType.NONE_PRIORITY.equals((Object)role)) {
                paras.put("ISPRIMARY", Boolean.FALSE.toString());
            }
        }
        String url = HvsRequestDefine.PAUSED_HYPER_METRO_PAIR.getUri();
        logger.debug((Object)"Put disable_hcpair: url = %s, params = %s.", new Object[]{url, paras});
        RestConnection conn = this.getConn(devSn);
        conn.put(url, paras);
    }

    private void parseCg(String devSn, String id, DrmEnumDefine.RoleType role) {
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", id);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroConsistentGroup.getValue()));
        if (role != null) {
            if (DrmEnumDefine.RoleType.PRIORITY.equals((Object)role)) {
                paras.put("PRIORITYSTATIONTYPE", "0");
            } else if (DrmEnumDefine.RoleType.NONE_PRIORITY.equals((Object)role)) {
                paras.put("PRIORITYSTATIONTYPE", "1");
            }
        }
        String url = HvsRequestDefine.PAUSED_HYPER_METRO_CONSISTENT_GROUP_URL.getUri();
        logger.debug((Object)"Put stopHyperMetroConsistentGroup: url = %s, params = %s.", new Object[]{url, paras});
        RestConnection conn = this.getConn(devSn);
        conn.put(url, paras);
    }

    public void swap(String devSn, String id, Integer resourceType, boolean isCg) {
        logger.debug((Object)"Enter swap, sn=%s, id=%s, resourceType=%d, isCg=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), id, resourceType, isCg});
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        if (isCg) {
            this.swapCg(devSn, id);
        } else {
            this.swapPair(devSn, id, resourceType);
        }
        logger.debug((Object)"Exit swap.");
    }

    private void swapPair(String devSn, String id, Integer resourceType) {
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", id);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroPair.getValue()));
        int hcResourceType = HcResourceType.ST_LUN.getValue();
        if (resourceType != null) {
            hcResourceType = HcResourceType.valueOf((int)resourceType).getValue();
        }
        paras.put("HCRESOURCETYPE", Integer.toString(hcResourceType));
        String url = "/rest/${deviceID}/HyperMetroPair/swap_hcpair";
        logger.debug((Object)"Put swapPair: url = %s, params = %s.", new Object[]{url, paras});
        RestConnection conn = this.getConn(devSn);
        conn.put(url, paras);
    }

    private void swapCg(String devSn, String id) {
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", id);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroConsistentGroup.getValue()));
        String url = "/rest/${deviceID}/HyperMetro_ConsistentGroup/switch";
        logger.debug((Object)"Switch hyperMetroCG: url = %s, params = %s.", new Object[]{url, paras});
        RestConnection conn = this.getConn(devSn);
        conn.put(url, paras);
    }

    public void startup(String devSn, String pairId) {
        logger.debug((Object)"Enter startup, devSn=%s, pairId=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), pairId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, pairId});
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", pairId);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroPair.getValue()));
        paras.put("RECONVERYPOLICY", "1");
        String url = "/rest/${deviceID}/HyperMetroPair/startup_mode";
        logger.debug((Object)"Put hyperMetroPair start: url = %s, params = %s.", new Object[]{url, paras});
        RestConnection conn = this.getConn(devSn);
        conn.put(url, paras);
        logger.debug((Object)"Exit startup.");
    }

    public void shutdown(String devSn, String pairId) {
        logger.debug((Object)"Enter shutdown, devSn=%s, pairId=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), pairId});
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)pairId)) {
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", pairId);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroPair.getValue()));
        String url = "/rest/${deviceID}/HyperMetroPair/SHUTDOWN";
        logger.debug((Object)"Put hyperMetroPair shutdown: url = %s, params = %s", new Object[]{url, paras});
        RestConnection conn = this.getConn(devSn);
        conn.put(url, paras);
        logger.debug((Object)"Exit shutdown");
    }

    private RestConnection getConn(String devSn) {
        return HvsRestConnectionManager.getInstance().getConnection(devSn);
    }

    public HyperMetroConsistentGroup queryHyperMetroCGroup(String devSn, String cgId) {
        logger.debug((Object)"Enter queryHyperMetroConsistentGroup, sn=%s, cgId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), cgId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        RestConnection conn = this.getConn(devSn);
        String url = "/rest/${deviceID}/HyperMetro_ConsistentGroup/" + cgId;
        logger.debug((Object)"Start queryHyperMetroCG url = %s.", new Object[]{url});
        Map record = conn.get(url, null);
        logger.debug((Object)"End queryHyperMetroCG result = %s.", new Object[]{record});
        HyperMetroConsistentGroup cg = HVSRestTransitionExtend.transitionHyperMetroCg(devSn, record);
        logger.debug((Object)cg);
        logger.debug((Object)"Exit queryHyperMetroConsistentGroup.");
        return cg;
    }

    public List<HyperMetroPair> queryHyperMetroPairsByCg(String devSn, String cgId) {
        logger.debug((Object)"Enter queryHyperMetroPairsByCg, sn=%s, cgId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), cgId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        RestConnection conn = this.getConn(devSn);
        StringBuilder url = new StringBuilder(HvsRequestDefine.QUERY_HYPER_METRO_PAIR_LIST.getUri());
        url.append("&filter=CGID::").append(cgId);
        logger.debug((Object)"Query hyperMetroPairByCg url = %s.", new Object[]{url.toString()});
        List records = conn.getBatch(url.toString(), null);
        return this.convertHyperMetroPair(devSn, records);
    }

    public List<HyperMetroPair> queryHyperMetroPairs(String devSn, String vstoreId) {
        logger.debug((Object)"Enter batchQueryHyperMetroPairs, sn=%s, vstoreId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), vstoreId});
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"The devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String url = HvsRequestDefine.QUERY_HYPER_METRO_PAIR_LIST.getUri();
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&vstoreId=" + vstoreId;
        }
        logger.debug((Object)"The queryHyperMetroPairs url = %s.", new Object[]{url});
        RestConnection conn = this.getConn(devSn);
        List records = conn.getBatch(url, null);
        return this.convertHyperMetroPair(devSn, records);
    }

    public List<StorageHyperMetroDomain> queryHypermetroDomain(String devSn, String remoteSn, String controlClusterId) {
        logger.debug((Object)"Enter queryHyperMetroDomain, sn=%s, remoteSn=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), SecurityUtil.desensitizeId((String)remoteSn)});
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        RestConnection conn = this.getConn(devSn);
        List records = conn.getBatch(HvsRequestDefine.QUERY_HYPER_METRO_DOMAIN.getUri(), null);
        return records.stream().map(record -> HVSRestTransitionExtend.transitionHyperMetroDomain(devSn, record)).filter(domain -> VerifyUtil.isEmpty((String)remoteSn) || domain.getRemoteDevices().contains(remoteSn)).map(hyperMetroDomain -> HVSRestTransitionExtend.transitionHyperMetroDomain(devSn, hyperMetroDomain)).collect(Collectors.toList());
    }

    public List<HypermetroPair> queryHypermetroPairs(String devSn, String controlClusterId, String domainId, Map<String, String> filters) {
        logger.debug((Object)"Enter queryHyperMetroPairs, sn=%s, domainId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), domainId});
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        RestConnection conn = this.getConn(devSn);
        StringBuilder url = new StringBuilder(HvsRequestDefine.QUERY_HYPER_METRO_PAIR_LIST.getUri());
        if (!VerifyUtil.isEmpty(filters)) {
            url.append("&filter=LOCALOBJNAME::").append(filters.get("localObjName"));
        }
        logger.debug((Object)"Query hyperMetroPair url = %s.", new Object[]{url.toString()});
        List records = conn.getBatch(url.toString(), null);
        return this.convertHypermetroPair(devSn, records);
    }

    private List<HypermetroPair> convertHypermetroPair(String devSn, List<Map<String, String>> records) {
        ArrayList<HypermetroPair> pairs = new ArrayList<HypermetroPair>();
        for (Map<String, String> record : records) {
            logger.debug((Object)"Convert hypermetro pair, record: %s", new Object[]{record});
            HyperMetroPair temp = HVSRestTransitionExtend.transitionHyperMetroPair(devSn, record);
            HypermetroPair pair = HVSRestTransitionExtend.transitionHyperMetroPO2BO(temp);
            pairs.add(pair);
        }
        return pairs;
    }

    public HypermetroPair queryHypermetroPair(String devSn, String controlClusterId, String pairId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, pairId});
        HyperMetroPair hypermetroPair = this.queryHyperMetroPair(devSn, pairId, "");
        return HVSRestTransitionExtend.transitionHyperMetroPO2BO(hypermetroPair);
    }

    private List<HyperMetroPair> convertHyperMetroPair(String devSn, List<Map<String, String>> records) {
        ArrayList<HyperMetroPair> pairs = new ArrayList<HyperMetroPair>();
        for (Map<String, String> record : records) {
            logger.debug(record);
            HyperMetroPair temp = HVSRestTransitionExtend.transitionHyperMetroPair(devSn, record);
            pairs.add(temp);
        }
        return pairs;
    }

    public HypermetroPair createHypermetroPair(HypermetroPair hypermetroPair) {
        logger.debug((Object)"Start to create hypermetroPair");
        CreateHyperMetroPairRequest request = new CreateHyperMetroPairRequest();
        request.setDomainId(hypermetroPair.getDomainid());
        request.setHcResourceType(HcResourceType.ST_LUN.getValue());
        request.setLocalObjectId(hypermetroPair.getLocalobjid());
        request.setRemoteObjectId(hypermetroPair.getRemoteobjid());
        request.setFirstSync(true);
        request.setRecoveryPolicy(String.valueOf(RecoveryPolicy.EXC_AND_REC_MODE_AUTO.getValue()));
        String result = this.getConn(hypermetroPair.getSrcDevSN()).postForObject(HvsRequestDefine.CREATE_HYPER_METRO_PAIR.getUri(), (Object)request);
        logger.debug((Object)"End to create hypermetroPair:%s", new Object[]{result});
        CreateHyperMetroPairResponse response = (CreateHyperMetroPairResponse)JSONObject.toBean((String)result, CreateHyperMetroPairResponse.class);
        return HVSRestTransitionExtend.transitionHyperMetroPair(hypermetroPair.getSrcDevSN(), response);
    }

    public void pauseHypermetroPair(String devSn, String controlClusterId, String pairId, Boolean isPrimary) {
        logger.info((Object)"Start to pause hyperMetroPair.");
        VerifyUtil.checkStrs((String[])new String[]{devSn, pairId});
        this.pausePair(devSn, pairId, isPrimary != false ? DrmEnumDefine.RoleType.PRIORITY : DrmEnumDefine.RoleType.NONE_PRIORITY, null);
        logger.info((Object)"Paused hyperMetroPair success, devSn: %s, cgId: %s, isPrimary: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), pairId, isPrimary});
    }

    public void deleteHypermetroPair(String srcDevSn, String controlClusterId, String pairId, Boolean isLocalDelete) {
        VerifyUtil.checkObjs((Object[])new Object[]{srcDevSn, pairId});
        logger.info((Object)"Delete hyper metro pair %s.", new Object[]{pairId});
        String url = String.format(Locale.ENGLISH, HvsRequestDefine.DELETE_HYPER_METRO_PAIR.getUri(), pairId);
        if (isLocalDelete != null) {
            url = url + "?ISLOCALDELETE=" + isLocalDelete;
        }
        this.getConn(srcDevSn).delete(url, null);
    }

    public HypermetroGroup createHypermetroCGroup(HypermetroGroup hyperMetroGroup) {
        VerifyUtil.checkObjs((Object[])new Object[]{hyperMetroGroup});
        VerifyUtil.checkObjs((Object[])new Object[]{hyperMetroGroup.getName(), hyperMetroGroup.getDomainid(), hyperMetroGroup.getSrcDevSN()});
        CreateHyperMetroConsistentGroupReq hyperMetroConsistentGroupReq = new CreateHyperMetroConsistentGroupReq();
        hyperMetroConsistentGroupReq.setName(hyperMetroGroup.getName());
        hyperMetroConsistentGroupReq.setDomainid(hyperMetroGroup.getDomainid());
        logger.info((Object)"Create hyperMetroCGroup, hyperMetroConsistentGroupReq=%s.", new Object[]{JSONObject.fromObject((Object)hyperMetroConsistentGroupReq).toString()});
        RestConnection restConnection = this.getConn(hyperMetroGroup.getSrcDevSN());
        String result = restConnection.postForObject(HvsRequestDefine.CREATE_HYPER_METRO_CONSISTENT_GROUP_URL.getUri(), (Object)hyperMetroConsistentGroupReq);
        logger.debug((Object)"Create hyperMetroCGroup result is %s.", new Object[]{result});
        CreateHyperMetroConsistentGroupRes res = (CreateHyperMetroConsistentGroupRes)JSONObject.toBean((String)result, CreateHyperMetroConsistentGroupRes.class);
        return HVSRestTransitionExtend.transitionHyperMetroGroup(hyperMetroGroup.getControlClusterId(), hyperMetroGroup.getSrcDevSN(), res);
    }

    public void startHypermetroCGroup(String srcDevSn, String controlClusterId, String cgId) {
        VerifyUtil.checkObjs((Object[])new Object[]{srcDevSn, cgId});
        this.syncCg(srcDevSn, cgId);
        logger.info((Object)"Start hyperMetroCGroup success, cgId: %s.", new Object[]{cgId});
    }

    public boolean isAccordantExpectForRunningStatus(String value, String key) {
        VerifyUtil.checkStrs((String[])new String[]{value, key});
        return value.equals(String.valueOf(RUNNING_STATUS_MAP.get(key).getValue()));
    }

    public List<HypermetroPair> getLocalHyperMetroPairs(String srcDevSn, Set<String> lunIds) {
        VerifyUtil.checkObjs((Object[])new Object[]{srcDevSn, lunIds});
        String[] lunIdArray = lunIds.toArray(new String[0]);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", srcDevSn);
        props.put("localObjId", lunIdArray);
        List list = CommonDAOLocator.getMoDao().findMoBy(HyperMetroPair.class, props);
        if (VerifyUtil.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        ArrayList<HypermetroPair> result = new ArrayList<HypermetroPair>();
        for (HyperMetroPair pair : list) {
            result.add(HVSRestTransitionExtend.transitionHyperMetroPO2BO(pair));
        }
        return result;
    }

    public boolean isHypermetroPairStatusAvailable(HypermetroPair pair) {
        VerifyUtil.checkObject((Object)pair);
        return this.isHyperMetroPairStatusAvailable(pair, NORMAL_RUNNING_STATUS, NORMAL_HEALTH_STATUS);
    }

    public void pausedHypermetroCGroup(String srcDevSn, String controlClusterId, String cgId, Boolean isPrimary) {
        VerifyUtil.checkObjs((Object[])new Object[]{srcDevSn, cgId, isPrimary});
        this.parseCg(srcDevSn, cgId, isPrimary != false ? DrmEnumDefine.RoleType.PRIORITY : DrmEnumDefine.RoleType.NONE_PRIORITY);
        logger.info((Object)"Paused hyperMetroCGroup success, srcDevSn: %s, cgId: %s, isPrimary: %s.", new Object[]{SecurityUtil.desensitizeId((String)srcDevSn), cgId, isPrimary});
    }

    public void addHypermetroPairs(HypermetroGroup hypermetroGroup, List<HypermetroPair> pairs) {
        List<HypermetroPair> pairsInCg = this.getHypermetroPairsByCgId(hypermetroGroup.getSrcDevSN(), hypermetroGroup.getControlClusterId(), hypermetroGroup.getId());
        Set pairIdList = pairsInCg.stream().map(HypermetroPair::getId).collect(Collectors.toSet());
        List<HypermetroPair> addPairs = pairs.stream().filter(pair -> !pairIdList.contains(pair.getId())).collect(Collectors.toList());
        this.batchOperatePairsToHypermetroGroup(hypermetroGroup, addPairs, true);
    }

    public void removeHypermetroPairs(HypermetroGroup hypermetroGroup, List<HypermetroPair> pairs) {
        VerifyUtil.checkObjs((Object[])new Object[]{hypermetroGroup, pairs});
        this.batchOperatePairsToHypermetroGroup(hypermetroGroup, pairs, false);
    }

    private void batchOperatePairsToHypermetroGroup(HypermetroGroup hypermetroGroup, List<HypermetroPair> pairs, boolean isAdd) {
        if (VerifyUtil.isEmpty(pairs)) {
            logger.warn((Object)"No pair to associate or remove from cg group.");
            return;
        }
        List requestList = pairs.stream().map(pair -> {
            AssociateHyperMetroPairRequest request = new AssociateHyperMetroPairRequest();
            request.setId(hypermetroGroup.getId());
            request.setAssociateObjId(pair.getId());
            return request;
        }).collect(Collectors.toList());
        logger.info((Object)"Batch operate hyper metro pairs %s.", new Object[]{requestList});
        RestConnection conn = this.getConn(hypermetroGroup.getSrcDevSN());
        if (isAdd) {
            conn.postForObject(HvsRequestDefine.BATCH_OPERATE_HYPER_METRO_TO_GROUP.getUri(), requestList);
        } else {
            conn.deleteForObject(HvsRequestDefine.BATCH_OPERATE_HYPER_METRO_TO_GROUP.getUri(), requestList);
        }
    }

    public List<HypermetroPair> getHypermetroPairsByCgId(String devSn, String controlClusterId, String cgId) {
        List<HyperMetroPair> pairList = this.queryHyperMetroPairsByCg(devSn, cgId);
        return pairList.stream().map(HVSRestTransitionExtend::transitionHyperMetroPO2BO).collect(Collectors.toList());
    }

    public HypermetroGroup queryHypermetroCGroup(String srcDevSn, String controlClusterId, String cgId) {
        VerifyUtil.checkStrs((String[])new String[]{srcDevSn, cgId});
        HyperMetroConsistentGroup hyperMetroConsistentGroup = this.queryHyperMetroCGroup(srcDevSn, cgId);
        return HVSRestTransitionExtend.transitionHyperMetroCGroup(srcDevSn, controlClusterId, hyperMetroConsistentGroup);
    }

    public void deleteHypermetroCGroup(String srcDevSn, String controlClusterId, String cgId) {
        VerifyUtil.checkObjs((Object[])new Object[]{srcDevSn, cgId});
        logger.info((Object)"Delete hyper metro consistent group %s.", new Object[]{cgId});
        String url = String.format(Locale.ENGLISH, HvsRequestDefine.DELETE_HYPER_METRO_CONSISTENT_GROUP.getUri(), cgId);
        this.getConn(srcDevSn).delete(url, null);
    }

    public List<RemoteDevice> queryRemoteDevices(String devSn) {
        VerifyUtil.checkObjs((Object[])new Object[]{devSn});
        logger.info((Object)"Begin query remote device for storage(%s)", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
        return this.getConn(devSn).getBatch(HvsRequestDefine.BATCH_QUERY_REMOTE_DEVICES.getUri(), null).stream().map(record -> HVSRestTransition.transitionRemoteDevice((String)devSn, (Map)record)).collect(Collectors.toList());
    }
}

