/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageLunConsistencyGroupHandler;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.hvs.manager.BaseHvsStorageManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunGroupManager;
import com.huawei.ism.drm.storage.sdk.model.LunConsistencyGroup;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;

public class HvsStorageLunConsistentGroupManager
extends BaseHvsStorageManager
implements IStorageLunGroupManager {
    private static Log logger = LogFactory.getInstance(HvsStorageLunConsistentGroupManager.class);
    private IStorageLunConsistencyGroupHandler handler;
    private IStorageLunHandler lunHandler;

    public void setHandler(IStorageLunConsistencyGroupHandler handler) {
        this.handler = handler;
    }

    public void setLunHandler(IStorageLunHandler lunHandler) {
        this.lunHandler = lunHandler;
    }

    @Override
    protected boolean isResourceMapped(String devSn, String resourceId) {
        logger.warn((Object)("not supported!devSn:" + devSn));
        throw new LegoUnsupportedOperationException("not supported.");
    }

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public LunConsistencyGroup create(String devSn, String name) {
        return this.handler.createLunConsistencyGroup(devSn, name, "rd");
    }

    public void add(String devSn, String cgId, String lunId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId, lunId});
        this.handler.addLun(devSn, cgId, lunId);
    }

    public void remove(String devSn, String cgId, String lunId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId, lunId});
        this.handler.removeLun(devSn, cgId, lunId, false);
    }

    public List<Lun> queryLuns(String devSn, String cgId) {
        return this.lunHandler.queryLuns(devSn, XveMOType.LUN_CONSISTENCY_GROUP, cgId);
    }

    public void delete(String devSn, String cgId) {
        LunConsistencyGroup group = this.handler.queryConsistencyGroup(devSn, cgId);
        if (null == group) {
            logger.debug((Object)"lun consistency group not exist. CgId:[%s]", new Object[]{cgId});
            return;
        }
        this.handler.deleteConsistencyGroup(devSn, cgId);
    }

    public List<LunConsistencyGroup> queryConsistencyGroups(String devSn, XveMOType associateObjType, String associateObjId) {
        return this.handler.queryConsistencyGroups(devSn, associateObjType, associateObjId);
    }

    public LunConsistencyGroup queryConsistencyGroup(String devSn, String id) {
        return this.handler.queryConsistencyGroup(devSn, id);
    }
}

