/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.handler.IStorageMappingHandler;
import com.huawei.ism.drm.storage.hvs.manager.BaseHvsStorageManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunManager;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class HvsStorageLunManager
extends BaseHvsStorageManager
implements IStorageLunManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageLunManager.class);
    private static final int TIME_OUT = 180;
    private static final int PER_BATCH_TASK_AMOUNT = 20;
    private IStorageLunHandler handler;

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public List<Lun> queryLuns(String deviceSn, List<String> lunIds) {
        List<Object> luns = new ArrayList<Lun>();
        if (VerifyUtil.isEmpty(lunIds)) {
            return luns;
        }
        ArrayList<QueryLunTask> queryLunTasks = new ArrayList<QueryLunTask>();
        for (String lunId : lunIds) {
            QueryLunTask queryLunTask = new QueryLunTask(deviceSn, lunId);
            queryLunTasks.add(queryLunTask);
        }
        luns = ExecutionService.batchSubmit(queryLunTasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)180, (int)20);
        if (luns != null && luns.size() != lunIds.size()) {
            logger.error((Object)"Querying lun failed. LunIds:[%s].", new Object[]{lunIds});
            throw new LegoCheckedException(1073948705L);
        }
        return luns;
    }

    public List<Lun> queryLunsByNames(String deviceSn, List<String> lunNames) {
        if (VerifyUtil.isEmpty((String)deviceSn) || lunNames.stream().anyMatch(VerifyUtil::isEmpty)) {
            logger.error((Object)"Batch query luns failed! deviceSn or LunNames contains invalid name!");
            throw new LegoCheckedException(1073947393L);
        }
        List luns = ExecutionService.map(lunNames, name -> this.handler.queryStorageLunByName(deviceSn, name)).stream().filter(Objects::nonNull).collect(Collectors.toList());
        return VerifyUtil.isEmpty(luns) ? Collections.emptyList() : luns;
    }

    public boolean isLunMapped(String deviceSn, String resourceId) {
        Lun lun = this.handler.queryStorageLun(deviceSn, resourceId);
        if (lun == null) {
            logger.error((Object)"Querying lun failed. ResId:[%s].", new Object[]{resourceId});
            throw new LegoCheckedException(1073948705L);
        }
        return lun.getMapped();
    }

    public Lun createLun(Lun lun) {
        return this.handler.createLun(lun);
    }

    public void deleteLun(String devSn, List<String> lunIds, List<String> lunNames) {
        List<String> rmIds;
        boolean isIdEmpty = VerifyUtil.isEmpty(lunIds);
        if (VerifyUtil.isEmpty((String)devSn) || isIdEmpty && VerifyUtil.isEmpty(lunNames)) {
            logger.error((Object)"Delete lun fail, input param invalid.");
            return;
        }
        List<String> list = rmIds = isIdEmpty ? this.getLunIdsByNames(devSn, lunNames) : lunIds;
        if (VerifyUtil.isEmpty(rmIds)) {
            logger.error((Object)"Delete lun fail, lunNames: %s.", new Object[]{lunNames});
            return;
        }
        rmIds.forEach(lunId -> this.handler.deleteLun(devSn, lunId));
    }

    private List<String> getLunIdsByNames(String devSn, List<String> lunNames) {
        return this.queryLunsByNames(devSn, lunNames).stream().map(Lun::getLunId).collect(Collectors.toList());
    }

    public Lun getLunById(String devSn, String lunId) {
        try {
            return this.handler.queryStorageLun(devSn, lunId);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"Query Storage lun failed, errorCode: %s, ErrMsg: %s.", new Object[]{le.getErrorCode(), ExceptionUtil.getErrorMessage((Throwable)le)});
            throw le;
        }
        catch (Exception ex) {
            logger.error((Object)"Query Storage lun failed, LunId:[%s], ErrMsg: %s.", new Object[]{lunId, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1073948705L, (Throwable)ex);
        }
    }

    public Lun getLunByWWN(String devSn, String lunWwn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, lunWwn});
        return this.handler.getLunByWWN(devSn, lunWwn).orElse(null);
    }

    public Lun getLunByName(String devSn, String lunName) {
        VerifyUtil.checkObjs((Object[])new Object[]{devSn, lunName});
        try {
            return this.handler.queryStorageLunByName(devSn, lunName);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Query Storage lun by name failed, lunName:%s, ErrMsg: %s.", new Object[]{lunName, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        catch (Exception e) {
            logger.error((Object)"Query Storage lun by name failed, LunName: %s, ErrMsg: %s.", new Object[]{lunName, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948705L, (Throwable)e);
        }
    }

    public boolean expandLun(Lun lun) {
        if (lun == null) {
            logger.error((Object)"Expand lun is null, invalid input param.");
            return false;
        }
        this.handler.expandVolById(lun.getDevSn(), lun.getLunId(), lun.getCapacity());
        return true;
    }

    @Override
    protected boolean isResourceMapped(String devSn, String resourceId) {
        return this.isLunMapped(devSn, resourceId);
    }

    public OperationResult mappingLun(String devSn, String resourceId, HostVO hostVo) {
        OperationResult operationResult;
        logger.info((Object)"Enter auto mapping lun to host, resourceId=[%s].", new Object[]{resourceId});
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)resourceId)) {
            logger.error((Object)"resourceId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)hostVo)) {
            logger.error((Object)"hostVo is null.");
            throw new LegoCheckedException(1073947393L);
        }
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            Lun lun = DrmStorageUtil.getStorageLunById((String)devSn, (String)resourceId);
            if (lun == null) {
                throw new LegoCheckedException(1073947394L);
            }
            if (!this.isMapping(devSn, XveMOType.LUN, resourceId, (List)Collections.singletonList(hostVo))) {
                List<ArrayHost> hosts = this.prepareHosts(devSn, hostVo, true);
                ArrayHostGroup hostGroup = this.prepareHostGroup(devSn, hosts);
                MappingView mappingView = this.prepareMappingView(devSn, hostGroup.getHostGroupId(), XveMOType.LUN, resourceId);
                XveLunGroup lunGroup = this.prepareLunGroup(devSn, mappingView);
                mappingHandler.addObjectToLunGroup(devSn, lunGroup.getLunGroupId(), XveMOType.LUN, lun.getLunId());
            }
            operationResult = new OperationResult("ism.drm.mappingluntohost.operation", true, true, new String[]{lun.getName(), hostVo.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Mapping lun to host failed, ErrMsg: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            String[] successParameters = new String[]{resourceId, hostVo.getName()};
            operationResult = this.generateOperationResult(e, "ism.drm.mappingluntohost.operation", successParameters);
        }
        logger.info((Object)"Exit auto mapping lun to host, resourceId=[%s].", new Object[]{resourceId});
        return operationResult;
    }

    public OperationResult mappingLun(String devSn, String resourceId, HostGroupVO hgVo) {
        OperationResult operationResult;
        logger.info((Object)"Enter auto mapping lun to host group, resourceId=[%s].", new Object[]{resourceId});
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)resourceId)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (hgVo == null) {
            logger.error((Object)"Input parameter hgVo is null");
            throw new LegoCheckedException(1073947393L);
        }
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            Lun lun = DrmStorageUtil.getStorageLunById((String)devSn, (String)resourceId);
            if (lun == null) {
                throw new LegoCheckedException(1073947394L);
            }
            if (!this.isMapping(devSn, XveMOType.LUN, resourceId, hgVo.getHostVOs())) {
                ArrayList<ArrayHost> hosts = new ArrayList<ArrayHost>();
                for (HostVO hostVo : hgVo.getHostVOs()) {
                    List<ArrayHost> host = this.prepareHosts(devSn, hostVo, true);
                    hosts.addAll(host);
                }
                ArrayHostGroup hostGroup = this.prepareHostGroup(devSn, hosts);
                MappingView mappingView = this.prepareMappingView(devSn, hostGroup.getHostGroupId(), XveMOType.LUN, resourceId);
                XveLunGroup lunGroup = this.prepareLunGroup(devSn, mappingView);
                mappingHandler.addObjectToLunGroup(devSn, lunGroup.getLunGroupId(), XveMOType.LUN, lun.getResourceId());
            }
            operationResult = new OperationResult("ism.drm.mappingluntohost.operation", true, true, new String[]{lun.getName(), hgVo.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Mapping lun to host failed, ErrMsg: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            String[] successParameters = new String[]{resourceId, hgVo.getName()};
            operationResult = this.generateOperationResult(e, "ism.drm.mappingluntohost.operation", successParameters);
        }
        logger.info((Object)"Exit auto mapping lun to host group, resourceId=[%s].", new Object[]{resourceId});
        return operationResult;
    }

    public OperationResult addLunToLunGroup(String devSn, String resourceId, List<HostVO> hostVoList, String lunGroupId, Map<String, Object> caches) {
        OperationResult operationResult;
        logger.info((Object)"Enter add lun to lunGroup, resourceId=[%s], lunGroupId:[%s].", new Object[]{resourceId, lunGroupId});
        this.checkMappingLunParam(devSn, resourceId, hostVoList);
        if (VerifyUtil.isEmpty((String)lunGroupId)) {
            logger.error((Object)"LunGroupIdObj is null.lunGroupId:[%s].", new Object[]{lunGroupId});
            throw new LegoCheckedException(1073947393L);
        }
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            Lun lun = DrmStorageUtil.getStorageLunById((String)devSn, (String)resourceId);
            if (lun == null) {
                logger.error((Object)"Query lun is empty!resourceId:[%s].", new Object[]{resourceId});
                throw new LegoCheckedException(1073947394L);
            }
            if (!this.isMapping(devSn, XveMOType.LUN, resourceId, (List)hostVoList)) {
                mappingHandler.addObjectToLunGroup(devSn, lunGroupId, XveMOType.LUN, lun.getLunId());
            }
            operationResult = new OperationResult("ism.drm.mappingluntohost.operation", true, true, new String[]{lun.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Add lun to lunGroup failed. ErrMsg: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            String[] successParameters = new String[]{resourceId};
            operationResult = this.generateOperationResult(e, "ism.drm.mappingluntohost.operation", successParameters);
        }
        logger.info((Object)"Exit add lun to lunGroup, resourceId=[%s].", new Object[]{resourceId});
        return operationResult;
    }

    private void checkMappingLunParam(String devSn, String resourceId, List<HostVO> hostVoList) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"DevSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)resourceId)) {
            logger.error((Object)"ResourceId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(hostVoList)) {
            logger.error((Object)"HostVOList is null.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public OperationResult removeLunMapping(String devSn, String resourceId, HostVO hostVo) {
        OperationResult operationResult;
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            MappingView mappingView = mappingHandler.getMappingViewByLunId(devSn, resourceId);
            if (mappingView != null) {
                mappingHandler.removeLunFromMappingView(devSn, mappingView, resourceId);
            }
            operationResult = new OperationResult("ism.drm.unmappinglun.operation", true, true, new String[]{resourceId, hostVo.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Remove lun mapping failed. ErrMsg: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            String[] successParameters = new String[]{resourceId, hostVo.getName()};
            operationResult = this.generateOperationResult(e, "ism.drm.unmappinglun.operation", successParameters);
        }
        return operationResult;
    }

    public OperationResult removeLunMapping(String deviceSn, String resourceId, HostGroupVO hostGroupVo) {
        OperationResult operationResult;
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            Lun lun = DrmStorageUtil.getStorageLunById((String)deviceSn, (String)resourceId);
            if (lun == null) {
                throw new LegoCheckedException(1073947394L);
            }
            MappingView mappingView = mappingHandler.getMappingViewByLunId(deviceSn, resourceId);
            if (mappingView != null) {
                mappingHandler.removeLunFromMappingView(deviceSn, mappingView, lun);
            }
            operationResult = new OperationResult("ism.drm.unmappinglun.operation", true, true, new String[]{lun.getName(), hostGroupVo.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Remove lun mapping failed. ErrMsg: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            String[] successParameters = new String[]{resourceId, hostGroupVo.getName()};
            operationResult = this.generateOperationResult(e, "ism.drm.unmappinglun.operation", successParameters);
        }
        return operationResult;
    }

    @Override
    public String prepareMapping(String devSn, HostVO hostVo) {
        return super.prepareMapping(devSn, hostVo);
    }

    @Override
    public String prepareMapping(String devSn, HostGroupVO hostGroupVo) {
        return super.prepareMapping(devSn, hostGroupVo);
    }

    public IStorageLunHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IStorageLunHandler handler) {
        this.handler = handler;
    }

    private final class QueryLunTask
    implements Callable<Lun> {
        private String lunId;
        private String devSn;

        QueryLunTask(String devSn, String lunId) {
            this.devSn = devSn;
            this.lunId = lunId;
        }

        @Override
        public Lun call() {
            try {
                logger.debug((Object)"Start to query lun. lunId:[%s].", new Object[]{this.lunId});
                return HvsStorageLunManager.this.handler.queryStorageLun(this.devSn, this.lunId);
            }
            catch (Exception e) {
                logger.error((Object)"Not found LUN. lunId:[%s], ErrMsg: %s.", new Object[]{this.lunId, ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(1073948705L, (Throwable)e);
            }
        }
    }
}

