/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.handler.IStorageReplicationHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.hvs.handler.impl.constant.HvsRequestDefine;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReplicationManager;
import com.huawei.ism.drm.storage.replication.service.impl.AbstractReplicationService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationLink;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.fusion.IStorageReplicationFusionService;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class HvsStorageReplicationManagerAdapter
extends AbstractReplicationService
implements IStorageReplicationManager,
IStorageReplicationFusionService {
    private static final Log LOG = LogFactory.getInstance(HvsStorageReplicationManagerAdapter.class);
    private IStorageReplicationHandler replicationHandler;

    public String getStorageType() {
        LOG.debug((Object)"GetStorageType.");
        return HvsUnit.class.getName();
    }

    public List<ReplicationTargetLun> querySyncStatus(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        HashMap paramMap = new HashMap();
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        if (relation == null) {
            LOG.error((Object)"Replication does not exist. SrcDevId:%s,TgtDevId:%s,replicationId:%s,isConsistentGroup:%s", new Object[]{sourceArrayId, targetArrayId, replicationId, isConsistentGroup});
            if (isConsistentGroup) {
                throw new LegoCheckedException(1073948767L, new String[]{replicationId});
            }
            throw new LegoCheckedException(1073948677L, new String[]{replicationId});
        }
        ArrayList<ReplicationTargetLun> tgtLunList = new ArrayList<ReplicationTargetLun>();
        RestConnection conn = this.getRestConnection(relation.getDevSn());
        if (relation instanceof ReplicationGroup) {
            String url = "/rest/${deviceID}/replicationpair?filter=CGID::" + relation.getReplicationId() + "&range=[0-65536]";
            LOG.debug((Object)"querySyncStatus url = %s, params = %s.", new Object[]{url, paramMap});
            List resultMapList = conn.getBatch(url, paramMap);
            if (!VerifyUtil.isEmpty((Collection)resultMapList)) {
                for (Map repResult : resultMapList) {
                    ReplicationTargetLun tgtLun = HVSRestTransitionExtend.transitionReplicationTargetLun(repResult, relation.getDevSn());
                    tgtLunList.add(tgtLun);
                }
            }
        } else {
            String url = "/rest/${deviceID}/replicationpair/" + replicationId;
            LOG.debug((Object)"QuerySyncStatus url = %s, params = %s.", new Object[]{url, paramMap});
            Map repResult = conn.get(url, paramMap);
            ReplicationTargetLun tgtLun = HVSRestTransitionExtend.transitionReplicationTargetLun(repResult, relation.getDevSn());
            tgtLunList.add(tgtLun);
        }
        this.updateSyncInfo(tgtLunList);
        return tgtLunList;
    }

    public List<String> supportedDeviceList() {
        LOG.debug((Object)"SupportedDeviceList is null.");
        return Collections.emptyList();
    }

    public OperationResult processCommand(String deviceId, String operationName, String url, JSONObject bodyJson) {
        String urlNew = "/rest/${deviceID}/" + url.replaceFirst("^/", "");
        return super.processCommand(deviceId, operationName, urlNew, bodyJson);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, String resourceId) {
        LOG.debug((Object)"Start QueryReplications resourceId=%s.", new Object[]{resourceId});
        List replications = new ArrayList();
        try {
            replications = this.replicationHandler.queryReplicationByAssociation(deviceSn, XveMOType.LUN.getValue(), resourceId);
        }
        catch (Exception e) {
            LOG.error((Object)"QueryReplications error. ErrMsg:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        if (VerifyUtil.isEmpty(replications)) {
            try {
                replications = this.replicationHandler.queryReplicationByAssociation(deviceSn, XveMOType.FILESYSTEM.getValue(), resourceId);
            }
            catch (LegoCheckedException ex) {
                LOG.error((Object)ex);
                String code = "50331651";
                if (code.equals(Long.toString(ex.getErrorCode()))) {
                    LOG.error((Object)"Current device may not support FileSystem.");
                }
                throw ex;
            }
        }
        return replications;
    }

    public List<ReplicationPair> queryReplications(String deviceSn, Collection<String> resources) {
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            return Collections.emptyList();
        }
        List list = ExecutionService.map(resources, resoureId -> this.queryReplications(deviceSn, (String)resoureId));
        ArrayList<ReplicationPair> pairs = new ArrayList<ReplicationPair>();
        list.stream().filter(pairList -> !VerifyUtil.isEmpty((Collection)pairList)).forEach(pairs::addAll);
        this.setRepTargettLuns(deviceSn, pairs);
        return pairs;
    }

    public void changeRate(String sn, String id, boolean isCg, DmEnumDefine.SpeedLevelE rate) {
        LOG.info((Object)"Enter change repliations rate, id=%s, isCg=%s, rate=%s.", new Object[]{id, isCg, rate});
        VerifyUtil.checkStrs((String[])new String[]{sn, id});
        DmEnumDefine.SpeedLevelE sl = rate == null ? DmEnumDefine.SpeedLevelE.SPEED_LEVEL_MIDDLE : rate;
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("SPEED", sl.getValue());
        this.getReplicationHandler().modify(sn, id, isCg, params);
        LOG.info((Object)"Exit change repliations rate.");
    }

    public void modify(String sn, String id, boolean isCg, Map<String, Object> params) {
        this.getReplicationHandler().modify(sn, id, isCg, params);
    }

    public ReplicationRelation queryReplicationRelation(String sn, String id, boolean isCg) {
        return this.replicationHandler.queryReplication(sn, id, isCg);
    }

    public IStorageReplicationHandler getReplicationHandler() {
        return this.replicationHandler;
    }

    public void setReplicationHandler(IStorageReplicationHandler replicationHandler) {
        this.replicationHandler = replicationHandler;
    }

    public void dispatchCommand(String deviceId, String url, Object data) {
        this.getRestConnection(deviceId).putForObject(url, data);
    }

    public List<ReplicationPair> getAllReplicationPairs(String deviceSn, String vstoreId) {
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            return Collections.emptyList();
        }
        String url = "/rest/${deviceID}/REPLICATIONPAIR?range=[0-65536]";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&vstoreId=" + vstoreId;
        }
        LOG.debug((Object)"Get replicationPairs: url = %s.", new Object[]{url});
        RestConnection conn = this.getRestConnection(deviceSn);
        List resultMapList = conn.getBatch(url, null);
        ArrayList<ReplicationPair> replicationPairList = new ArrayList<ReplicationPair>();
        for (Map record : resultMapList) {
            try {
                ReplicationPair replicationPair = HVSRestTransitionExtend.transitionReplicationPair(record, deviceSn);
                replicationPairList.add(replicationPair);
            }
            catch (Exception e) {
                LOG.warn((Object)"Storage transition to replication pair failed.");
            }
        }
        this.setRepTargettLuns(deviceSn, replicationPairList);
        return replicationPairList;
    }

    public ReplicationGroup createReplicationGroup(ReplicationGroup group) {
        RestConnection connection;
        Map responseMap;
        String replicationId;
        if (group == null) {
            LOG.warn((Object)"End create CG, cause group param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject params = new JSONObject();
        params.put((Object)"NAME", (Object)group.getName());
        if (!VerifyUtil.isEmpty((Object)group.getReplicationMode())) {
            params.put((Object)"REPLICATIONMODEL", (Object)group.getReplicationMode());
        }
        if (VerifyUtil.isEmpty((String)(replicationId = (String)(responseMap = (connection = this.getRestConnection(group.getSrcDevSN())).post(HvsRequestDefine.CREATE_CONSISTENT_GROUP.getUri(), (Map)params)).get("ID")))) {
            LOG.error((Object)"Create CG failed, cause replication id not find.");
            throw new LegoCheckedException(2117645L);
        }
        return this.getReplicationGroup(group.getSrcDevSN(), replicationId);
    }

    public ReplicationGroup addReplicationPair(ReplicationGroup group, List<ReplicationPair> pairList) {
        if (group == null || VerifyUtil.isEmpty(pairList)) {
            LOG.error((Object)"Add replication pair to CG fail, input param is null or empty.");
            return null;
        }
        String cgId = group.getReplicationId();
        LOG.debug((Object)"Add replication pairs to CG start, cgId: %s, cg pair size: %d, add pair size: %d.", new Object[]{cgId, group.getReplicationPairs().size(), pairList.size()});
        String devSn = group.getSrcDevSN();
        RestConnection connection = this.getRestConnection(devSn);
        Set pairIdsInCg = this.queryReplicationPairByCgId(group.getSrcDevSN(), group.getReplicationId()).stream().map(ReplicationRelation::getReplicationId).collect(Collectors.toSet());
        JSONObject params = new JSONObject();
        params.put((Object)"ID", (Object)group.getReplicationId());
        for (ReplicationPair pair : pairList) {
            String pairId = pair.getReplicationId();
            if (pairIdsInCg.contains(pairId)) {
                HvsStorageReplicationManagerAdapter.updatePairRelation(group, pair);
                continue;
            }
            params.put((Object)"RMLIST", Collections.singletonList(pairId));
            try {
                connection.putForObject(HvsRequestDefine.ADD_REPLICATION_PAIR_TO_CG.getUri(), (Object)params);
                LOG.debug((Object)"Add replication pair to CG success, pairId: %s, cgId: %s.", new Object[]{pairId, cgId});
                HvsStorageReplicationManagerAdapter.updatePairRelation(group, pair);
            }
            catch (LegoCheckedException e) {
                LOG.error((Object)"Add replication pair to CG fail for:%s.", new Object[]{pairId});
            }
        }
        LOG.debug((Object)"Add replication pair to CG finished. cgId: %s, cg pair size: %d.", new Object[]{group.getReplicationId(), group.getReplicationPairs().size()});
        return group;
    }

    private static void updatePairRelation(ReplicationGroup group, ReplicationPair pair) {
        pair.setConsistentGroupId(group.getReplicationId());
        List pairList = group.getReplicationPairs();
        if (!pairList.contains(pair)) {
            pairList.add(pair);
        }
    }

    public ReplicationGroup getReplicationGroup(String devSn, String groupId) {
        ReplicationRelation replication = this.replicationHandler.queryReplication(devSn, groupId, Boolean.TRUE.booleanValue());
        if (!(replication instanceof ReplicationGroup)) {
            LOG.error((Object)"Get replicationGroup failed, cause replication not instanceof ReplicationGroup.");
            throw new LegoCheckedException(2117645L);
        }
        return (ReplicationGroup)replication;
    }

    public ReplicationPair createReplicationPair(ReplicationPair pair) {
        RestConnection connection;
        Map responseMap;
        String pairId;
        if (pair == null) {
            LOG.error((Object)"End create replication pair, cause pair param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject params = new JSONObject();
        params.put((Object)"LOCALRESID", (Object)pair.getSrcLunId());
        params.put((Object)"LOCALRESTYPE", (Object)"11");
        params.put((Object)"REMOTEDEVICEID", (Object)this.getRemoteDeviceId(pair.getSrcDevSN(), pair.getTgtDevSN()));
        params.put((Object)"REMOTERESID", (Object)pair.getTgtLunId());
        if (!VerifyUtil.isEmpty((Object)pair.getReplicationMode())) {
            params.put((Object)"REPLICATIONMODEL", (Object)pair.getReplicationMode());
        }
        if (VerifyUtil.isEmpty((String)(pairId = (String)(responseMap = (connection = this.getRestConnection(pair.getSrcDevSN())).post(HvsRequestDefine.CREATE_REPLICATION_PAIR.getUri(), (Map)params)).get("ID")))) {
            LOG.error((Object)"Failed to create replication pair, cause pairId not found.");
            throw new LegoCheckedException(2117645L);
        }
        pair.setId(pairId);
        pair.setReplicationId(pairId);
        String replicationModel = (String)responseMap.get("REPLICATIONMODEL");
        if (VerifyUtil.isEmpty((String)replicationModel)) {
            LOG.error((Object)"Failed to create replication pair, cause replicationModel not found.");
            throw new LegoCheckedException(2117645L);
        }
        pair.setReplicationMode(Integer.valueOf(replicationModel));
        return pair;
    }

    private String getRemoteDeviceId(String srcDevSn, String tgtDevSn) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("deviceId", srcDevSn);
        List linkList = CommonDAOLocator.getMoDao().findMoBy(ReplicationLink.class, props);
        Optional<String> remoteDeviceId = linkList.stream().filter(link -> tgtDevSn.equals(link.getRemoteArrayId())).map(link -> this.extractRemoteDeviceId(link.getLinkId())).findFirst();
        return remoteDeviceId.orElseThrow(() -> {
            LOG.error((Object)"Can not find remoteDeviceId from ReplicationLink.");
            throw new LegoCheckedException(1073947393L);
        });
    }

    private String extractRemoteDeviceId(String linkId) {
        if (VerifyUtil.isEmpty((String)linkId)) {
            LOG.error((Object)"Failed to extractRemoteDeviceId, cause linkId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        int extractIndex = linkId.lastIndexOf(58);
        if (extractIndex == -1) {
            LOG.error((Object)"Failed to extractRemoteDeviceId, cause linkId is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
        return linkId.substring(extractIndex + 1);
    }

    private void checkAndBuildReplicationPairDRRing(List<ReplicationPair> relations, List<ReplicationGroup> replicationGroups) {
        if (VerifyUtil.isEmpty(relations) || VerifyUtil.isEmpty(replicationGroups)) {
            return;
        }
        HashMap<String, String> replicationGroupMap = new HashMap<String, String>();
        for (ReplicationGroup replicationGroup : replicationGroups) {
            replicationGroupMap.put(replicationGroup.getReplicationId(), replicationGroup.getDrRingId());
        }
        for (ReplicationPair replicationPair : relations) {
            if (!VerifyUtil.isEmpty((String)replicationPair.getDrRingId())) continue;
            replicationPair.setDrRingId((String)replicationGroupMap.get(replicationPair.getConsistentGroupId()));
        }
    }

    public List<ReplicationGroup> getAllReplicationGroups(String deviceSn) {
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            return new ArrayList<ReplicationGroup>();
        }
        String url = "/rest/${deviceID}/CONSISTENTGROUP?range=[0-65536]";
        LOG.debug((Object)"Get replicationGroups: url = %s.", new Object[]{url});
        RestConnection conn = this.getRestConnection(deviceSn);
        List resultMapList = conn.getBatch(url, null);
        ArrayList<ReplicationGroup> replicationGroupList = new ArrayList<ReplicationGroup>();
        for (Map record : resultMapList) {
            try {
                ReplicationGroup replication = HVSRestTransitionExtend.transitionReplicationGroup(record, deviceSn);
                replicationGroupList.add(replication);
            }
            catch (Exception e) {
                LOG.warn((Object)"Storage transition to replication group failed.");
            }
        }
        return replicationGroupList;
    }

    public List<ReplicationPair> queryReplicationPairByCgId(String devSn, String cgId) {
        LOG.debug((Object)"Query replication pair by CG start. devSn=%s, cgId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), cgId});
        if (VerifyUtil.isEmpty((String)devSn)) {
            LOG.error((Object)"Param devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String url = HvsRequestDefine.GET_REPLICATION_PAIRS.getUri();
        if (!VerifyUtil.isEmpty((String)cgId)) {
            url = url + "&filter=CGID::" + cgId;
        }
        LOG.debug((Object)"Get replication pairs, url = %s.", new Object[]{url});
        RestConnection conn = this.getRestConnection(devSn);
        List resultMapList = conn.getBatch(url, null);
        List<ReplicationPair> replicationPairList = resultMapList.stream().map(record -> HVSRestTransitionExtend.transitionReplicationPair(record, devSn)).collect(Collectors.toList());
        this.setRepTargettLuns(devSn, replicationPairList);
        return replicationPairList;
    }

    private void setRepTargettLuns(String deviceSn, List<ReplicationPair> pairs) {
        List<ReplicationGroup> replicationGroups = this.getAllReplicationGroups(deviceSn);
        this.checkAndBuildReplicationPairDRRing(pairs, replicationGroups);
        for (ReplicationPair pair : pairs) {
            if (VerifyUtil.isEmpty((Object)pair) || VerifyUtil.isEmpty((Collection)pair.getChildMos())) continue;
            ReplicationTargetLun tgtLuns = (ReplicationTargetLun)pair.getChildMos().iterator().next();
            pair.setRepTgtLuns(Collections.singletonList(tgtLuns));
        }
    }

    private RestConnection getRestConnection(String deviceSn) {
        return HvsRestConnectionManager.getInstance().getConnection(deviceSn);
    }

    public ReplicationRelation getReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        Optional<ReplicationRelation> replication;
        try {
            LOG.debug((Object)"Query replication relation from sourceArray.");
            replication = this.queryReplicationWithoutException(sourceArrayId, replicationId, isConsistentGroup);
            if (replication.map(ReplicationRelation::getIsPrimary).orElse(false).booleanValue()) {
                replication.ifPresent(rep -> rep.setDevSn(sourceArrayId));
            } else {
                LOG.debug((Object)"Query replication relation from targetArray.");
                replication = Optional.ofNullable(this.queryReplicationRelation(targetArrayId, replicationId, isConsistentGroup));
                replication.ifPresent(repl -> repl.setDevSn(targetArrayId));
            }
        }
        catch (LegoCheckedException ex) {
            LOG.error((Object)"Query replication relation fail, replication id: %s.", new Object[]{replicationId});
            throw ex;
        }
        return replication.orElse(null);
    }

    private Optional<ReplicationRelation> queryReplicationWithoutException(String devSn, String replicationId, boolean isConsistentGroup) {
        try {
            return Optional.ofNullable(this.queryReplicationRelation(devSn, replicationId, isConsistentGroup));
        }
        catch (Exception e) {
            LOG.error((Object)"Query replication error, devSn: %s, replicationId: %s.", new Object[]{devSn, replicationId});
            return Optional.empty();
        }
    }

    public void deleteReplicationPair(ReplicationPair pair) {
        if (pair == null || VerifyUtil.isEmpty((String)pair.getSrcDevSN()) || VerifyUtil.isEmpty((String)pair.getTgtDevSN())) {
            LOG.warn((Object)"Delete replication pair fail, valid input params fail.");
            return;
        }
        if (!this.deleteReplicationPair(pair.getSrcDevSN(), pair.getReplicationId())) {
            LOG.warn((Object)"Retry deleteReplicationPair on peer site ...");
            boolean isSuccess = this.deleteReplicationPair(pair.getTgtDevSN(), pair.getReplicationId());
            if (!isSuccess) {
                throw new LegoCheckedException(0x300001L);
            }
        }
    }

    private boolean deleteReplicationPair(String devSn, String pairId) {
        LOG.debug((Object)"Delete replication pair, devSn=%s, pairId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), pairId});
        RestConnection connection = this.getRestConnection(devSn);
        String url = HvsRequestDefine.DELETE_REPLICATION_PAIR.getUri().replace("${id}", pairId);
        try {
            connection.delete(url + "?TOSYNCSRWHENDELETE=false", null);
            LOG.debug((Object)"Delete replication pair success, devSn=%s, pairId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), pairId});
            return true;
        }
        catch (LegoCheckedException ex) {
            LOG.error((Object)"Delete replication pair fail, devSn=%s, pairId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), pairId});
            return false;
        }
    }

    public void deleteReplicationGroup(ReplicationGroup group) {
        if (group == null || VerifyUtil.isEmpty((String)group.getReplicationId())) {
            LOG.error((Object)"Delete CG fail, input param is null.");
            return;
        }
        LOG.debug((Object)"Delete CG start. ReplicationGroup consistency id: %s.", new Object[]{group.getReplicationId()});
        RestConnection connection = this.getRestConnection(group.getSrcDevSN());
        String url = HvsRequestDefine.DELETE_CONSISTENT_GROUP.getUri().replace("${id}", group.getReplicationId());
        connection.delete(url, null);
        LOG.info((Object)"Delete CG success. CgId=%s, DevSN=%s.", new Object[]{group.getReplicationId(), SecurityUtil.desensitizeId((String)group.getSrcDevSN())});
    }

    public ReplicationPair getReplicationPair(String devSn, String pairId) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)pairId)) {
            LOG.error((Object)"Get replication pair fail, invalid param.");
            throw new LegoCheckedException(1073947393L);
        }
        ReplicationRelation relation = this.replicationHandler.queryReplication(devSn, pairId, false);
        if (relation instanceof ReplicationPair) {
            return (ReplicationPair)relation;
        }
        LOG.info((Object)"Get replication pair return null, pairId: %s.", new Object[]{pairId});
        return null;
    }

    public void removeReplicationPair(ReplicationGroup group, List<ReplicationPair> pairList) {
        VerifyUtil.checkObjs((Object[])new Object[]{group, pairList});
        Set pairIds = pairList.stream().map(pair -> pair.getReplicationId()).collect(Collectors.toSet());
        String cgId = group.getReplicationId();
        List pairsInCg = this.queryReplicationPairByCgId(group.getSrcDevSN(), cgId).stream().map(ReplicationRelation::getReplicationId).collect(Collectors.toList());
        pairIds.retainAll(pairsInCg);
        if (VerifyUtil.isEmpty(pairIds)) {
            LOG.info((Object)"The pairs are not in cg, cgId: %s", new Object[]{cgId});
            return;
        }
        JSONObject param = new JSONObject();
        param.put((Object)"ID", (Object)cgId);
        for (String pairId : pairIds) {
            param.put((Object)"RMLIST", Collections.singleton(pairId));
            try {
                ((HvsRestConnection)HvsRestConnectionManager.getInstance().getConnection(group.getSrcDevSN())).putForObject(HvsRequestDefine.REMOVE_REPLICATION_PAIR_FROM_CG.getUri(), (Object)param);
            }
            catch (LegoCheckedException exception) {
                LOG.error((Object)"Remove pairs from cg fail, pairId: %s, cgId: %s", new Object[]{pairId, cgId});
                throw exception;
            }
        }
        LOG.info((Object)"Remove pairs from cg success, pairs: %s, cgId: %s.", new Object[]{pairList, cgId});
        group.getReplicationPairs().removeAll(pairList);
    }
}

