/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.handler.IStorageSnapshotScheduleHandler;
import com.huawei.ism.drm.storage.hvs.manager.BaseHvsStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.ism.drm.util.ReplicaUtil;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class HvsStorageSnapshotScheduleManager
extends BaseHvsStorageSnapshotScheduleManager {
    private static Log logger = LogFactory.getInstance(HvsStorageSnapshotScheduleManager.class);
    private IStorageSnapshotScheduleHandler snapshotScheduleHandler;
    private IStorageLunHandler lunHandler;

    public SnapshotSchedule create(ProtectGroup protectGroup, Schedule schedule, String devSn, List<String> lunIds) {
        SnapshotSchedule newSchedule = null;
        try {
            SnapshotSchedule snapshotSchedule = SnapshotScheduleUtil.constructNewSnapshotSchedule((PolicyTemplate)protectGroup.getTemplate(), (String)devSn, (Schedule)schedule);
            newSchedule = this.snapshotScheduleHandler.create(snapshotSchedule);
            newSchedule.setScheduleType(SnapshotSchedule.SCHEDULE_TYPE.SNAPSHOT.getValue());
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(lunIds)) {
                for (String lunId : lunIds) {
                    this.snapshotScheduleHandler.addLun(devSn, newSchedule.getId(), lunId);
                }
            }
            if (!newSchedule.getEnableSchedule().booleanValue()) {
                this.snapshotScheduleHandler.enable(devSn, newSchedule.getId(), snapshotSchedule.getScheduleType(), true);
                newSchedule.setEnableSchedule(Boolean.valueOf(true));
            }
            newSchedule.setSrcLuns(lunIds);
            return newSchedule;
        }
        catch (LegoCheckedException e) {
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(newSchedule)) {
                this.delete(newSchedule.getDevSn(), newSchedule.getId(), (String)protectGroup.getProps().get("PROP_KEY_LUN_CG_KEY:" + devSn));
            }
            throw e;
        }
    }

    public Set<String> getExistLunsByScheduleId(String devSn, String snapshotScheduleId) {
        List luns = this.lunHandler.queryLuns(devSn, XveMOType.SNAPSHOTSCHEDULE, snapshotScheduleId);
        HashSet<String> existLuns = new HashSet<String>();
        if (null == luns) {
            return existLuns;
        }
        for (Lun lun : luns) {
            existLuns.add(lun.getDevSn() + ":" + lun.getLunId());
        }
        return existLuns;
    }

    public void modify(ProtectGroup protectGroup, SnapshotSchedule snapshotSchedule, Schedule modifySchedule) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObject((Object)snapshotSchedule);
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{snapshotSchedule.getDevSn(), snapshotSchedule.getId()});
        SnapshotSchedule newSchedule = SnapshotScheduleUtil.constructNewSnapshotSchedule((PolicyTemplate)protectGroup.getTemplate(), (String)snapshotSchedule.getDevSn(), (Schedule)modifySchedule);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)newSchedule)) {
            throw new LegoCheckedException(1073947394L);
        }
        if (newSchedule.getSnapshotMaxNum().equals(snapshotSchedule.getSnapshotMaxNum()) && newSchedule.getFrequencyValue().equals(snapshotSchedule.getFrequencyValue())) {
            return;
        }
        snapshotSchedule.setSnapshotMaxNum(newSchedule.getSnapshotMaxNum());
        snapshotSchedule.setFrequencyValue(newSchedule.getFrequencyValue());
        snapshotSchedule.setScheduleType(SnapshotSchedule.SCHEDULE_TYPE.SNAPSHOT.getValue());
        if (snapshotSchedule.getEnableSchedule().booleanValue()) {
            this.snapshotScheduleHandler.enable(snapshotSchedule.getDevSn(), snapshotSchedule.getId(), snapshotSchedule.getScheduleType(), false);
        }
        this.snapshotScheduleHandler.modify(snapshotSchedule);
        this.snapshotScheduleHandler.enable(snapshotSchedule.getDevSn(), snapshotSchedule.getId(), snapshotSchedule.getScheduleType(), true);
    }

    public void addLun(String devSn, String scheduleId, List<String> lunIds) {
        SnapshotSchedule schedule = this.snapshotScheduleHandler.query(devSn, scheduleId);
        if (null == schedule) {
            logger.error((Object)"addLun to snapshotSchedule failed, the schedule not exists.");
            throw new LegoCheckedException(1073947393L);
        }
        if (schedule.getEnableSchedule().booleanValue()) {
            this.snapshotScheduleHandler.enable(schedule.getDevSn(), schedule.getId(), schedule.getScheduleType(), false);
        }
        Set<String> existLuns = this.getExistLunsByScheduleId(devSn, schedule.getId());
        ArrayList<String> addSuccessedLuns = new ArrayList<String>();
        try {
            for (String lunId : lunIds) {
                if (existLuns.contains(devSn + ":" + lunId)) continue;
                this.snapshotScheduleHandler.addLun(devSn, scheduleId, lunId);
                addSuccessedLuns.add(lunId);
            }
            this.snapshotScheduleHandler.enable(schedule.getDevSn(), schedule.getId(), schedule.getScheduleType(), true);
        }
        catch (LegoCheckedException e) {
            if (!addSuccessedLuns.isEmpty()) {
                this.removeLun(devSn, scheduleId, addSuccessedLuns);
            }
            throw e;
        }
    }

    public void removeLun(String devSn, String scheduleId, List<String> lunIds) {
        SnapshotSchedule schedule = this.snapshotScheduleHandler.query(devSn, scheduleId);
        if (null == schedule) {
            logger.error((Object)"addLun to snapshotSchedule error param, schedule not exists.");
            throw new LegoCheckedException(1073947393L);
        }
        if (schedule.getEnableSchedule().booleanValue()) {
            this.snapshotScheduleHandler.enable(schedule.getDevSn(), schedule.getId(), schedule.getScheduleType(), false);
        }
        Set<String> existLuns = this.getExistLunsByScheduleId(devSn, schedule.getId());
        for (String lunId : lunIds) {
            if (!existLuns.contains(devSn + ":" + lunId)) continue;
            this.snapshotScheduleHandler.removeLun(devSn, scheduleId, lunId);
        }
        this.snapshotScheduleHandler.enable(schedule.getDevSn(), schedule.getId(), schedule.getScheduleType(), true);
    }

    public void delete(String devSn, String scheduleId, String lunConsistencyGroupId) {
        List luns;
        SnapshotSchedule schedule = this.snapshotScheduleHandler.query(devSn, scheduleId);
        if (null == schedule) {
            logger.error((Object)("snapshotSchedule is not exists. scheduleId:" + scheduleId));
            return;
        }
        if (schedule.getEnableSchedule().booleanValue()) {
            this.snapshotScheduleHandler.enable(schedule.getDevSn(), schedule.getId(), schedule.getScheduleType(), false);
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)(luns = this.lunHandler.queryLuns(devSn, XveMOType.SNAPSHOTSCHEDULE, schedule.getId())))) {
            for (Lun lun : luns) {
                this.snapshotScheduleHandler.removeLun(devSn, scheduleId, lun.getLunId());
            }
        }
        this.snapshotScheduleHandler.delete(devSn, scheduleId, schedule.getScheduleType());
    }

    public List<ProtectGroupReplica> getProtectGroupReplica(ProtectGroup protectGroup, String devSn, Schedule schedule, Map<String, String> condtions) {
        List<Snapshot> snapshots = this.queryAllSnapshotByProtectGroup(protectGroup, devSn);
        return this.generateProtectGroupReplica(protectGroup, snapshots, schedule.getProtectLocation());
    }

    public Integer getProtectGroupReplicaCount(ProtectGroup protectGroup, String devSn, Map<String, String> conditions) {
        return null;
    }

    private List<Snapshot> queryAllSnapshotByProtectGroup(ProtectGroup protectGroup, String devSn) {
        ArrayList lunIds = new ArrayList();
        ArrayList wwns = new ArrayList();
        protectGroup.distinctStorageInfo().forEach(storage -> wwns.add(storage.getLunWWN()));
        ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(wwns.toArray(new String[wwns.size()])).forEach(storageResource -> {
            if (storageResource.getDevSn().equals(devSn)) {
                lunIds.add(storageResource.getResourceId());
            }
        });
        ArrayList<Callable> taskList = new ArrayList<Callable>();
        for (String lunId : lunIds) {
            taskList.add(this.getQuerySnapshotCallable(devSn, lunId));
        }
        List result = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)100, (int)30);
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        for (List list : result) {
            if (VerifyUtil.isEmpty((Collection)list)) continue;
            snapshots.addAll(list);
        }
        return snapshots;
    }

    private List<ProtectGroupReplica> generateProtectGroupReplica(ProtectGroup protectGroup, List<Snapshot> list, int location) {
        if (VerifyUtil.isEmpty(list)) {
            return new ArrayList<ProtectGroupReplica>();
        }
        HashMap timeMap = new HashMap();
        for (Snapshot snapshot : list) {
            if (!timeMap.containsKey(snapshot.getTimeStamp())) {
                timeMap.put(snapshot.getTimeStamp(), new HashMap());
            }
            ((Map)timeMap.get(snapshot.getTimeStamp())).put(snapshot.getSrcResourceId(), snapshot);
        }
        ArrayList<ProtectGroupReplica> replicas = new ArrayList<ProtectGroupReplica>();
        for (Map.Entry entry : timeMap.entrySet()) {
            String timeStamp = (String)entry.getKey();
            Map snapshots = (Map)entry.getValue();
            ProtectGroupReplica protectGroupReplica = ExecuteReplicaManager.getInstance().buildRealTimeReplica(protectGroup, location);
            if (VerifyUtil.isEmpty((Object)protectGroupReplica)) {
                logger.error((Object)("there is no ProtectGroupReplica for " + protectGroup));
                throw new LegoCheckedException(1073947394L);
            }
            ProtectGroupReplica replica = this.constructProtectGroupReplica(protectGroupReplica, snapshots, timeStamp);
            if (null == replica) continue;
            replica.setTimeStamp(timeStamp);
            replica.setStatus(DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue());
            replica.setMountStatus(Integer.valueOf(ReplicaMountStatus.UMOUNTED.getStatus()));
            replica.setGeneration(Integer.valueOf(1));
            replicas.add(replica);
        }
        this.transformTimeStamp(replicas);
        return replicas;
    }

    private Callable getQuerySnapshotCallable(final String devSn, final String lunId) {
        Callable callable = new Callable(){

            public List<Snapshot> call() {
                IStorageSnapshotManager snapshotManager = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn);
                List snapshots = snapshotManager.querySnapshotByLun(devSn, lunId);
                HvsStorageSnapshotScheduleManager.this.filterSnapshotList(snapshots);
                return snapshots;
            }
        };
        return callable;
    }

    private ProtectGroupReplica constructProtectGroupReplica(ProtectGroupReplica protectGroupReplica, Map<Integer, Snapshot> snapshots, String timeStamp) {
        for (ProtectObjectReplica objectReplica : protectGroupReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : objectReplica.getStorageInfos()) {
                Snapshot snapshot = snapshots.get(NumberUtil.convertToInteger((Object)storageInfo.getSrcStorageId()));
                if (VerifyUtil.isEmpty((Object)snapshot)) {
                    return null;
                }
                storageInfo.setStorageId(snapshot.getSnapshotId());
                ((LocalStorageReplica)storageInfo).setSnapshotName(snapshot.getSnapshotName());
            }
        }
        String storageIds = ReplicaUtil.getReplicaStorageIds((ProtectGroupReplica)protectGroupReplica);
        protectGroupReplica.addProperty("StorageIds", storageIds);
        protectGroupReplica.setTimeStamp(timeStamp);
        return protectGroupReplica;
    }

    private void filterSnapshotList(List<Snapshot> snapshots) {
        if (VerifyUtil.isEmpty(snapshots)) {
            return;
        }
        Iterator<Snapshot> iterator = snapshots.iterator();
        while (iterator.hasNext()) {
            ArraySnapshot snapshot = (ArraySnapshot)iterator.next();
            if (snapshot.getIsScheduledSnap().booleanValue() && String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.ACTIVATED.getValue()).equals(snapshot.getRunningState())) continue;
            iterator.remove();
        }
    }

    public int getSnapshotType() {
        return SnapshotSchedule.SCHEDULE_TYPE.SNAPSHOT.getValue();
    }

    @Override
    public void setSnapshotScheduleHandler(IStorageSnapshotScheduleHandler handler) {
        this.snapshotScheduleHandler = handler;
        super.setSnapshotScheduleHandler(handler);
    }

    public void setLunHandler(IStorageLunHandler lunHandler) {
        this.lunHandler = lunHandler;
    }
}

