/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageVstoreHyperMetroPairManager;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;

public class HvsStorageVstoreHyperMetroPairManager
implements IStorageVstoreHyperMetroPairManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageVstoreHyperMetroPairManager.class);

    public VstoreHyperMetroPair queryVstoreHyperMetroPair(String devSn, String id, boolean isAssociate) {
        logger.debug((Object)("Enter queryVstoreHyperMetroPair, sn=" + devSn + ", id=" + id + ",isAssociate=" + isAssociate));
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)id)) {
            logger.error((Object)"id is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = this.getConn(devSn);
        String url = null;
        url = isAssociate ? "/rest/${deviceID}/vstore_pair/associate?ASSOCIATEOBJTYPE=16442&ASSOCIATEOBJID=" + id : "/rest/${deviceID}/vstore_pair/" + id;
        logger.debug((Object)"Get vstoreHyperMetroPair: url = %s", new Object[]{url});
        Map record = conn.get(url, null);
        if (VerifyUtil.isEmpty((Map)record)) {
            return null;
        }
        VstoreHyperMetroPair pair = HVSRestTransitionExtend.transitionVstoreHyperMetroPair(devSn, record);
        logger.debug((Object)"Exist queryVstoreHyperMetroPair.");
        return pair;
    }

    public void swap(String devSn, String pairId, boolean isForce) {
        logger.debug((Object)("Enter swapHyperMetroPair, sn=" + devSn + ", pairId=" + pairId + ",isForce=" + isForce));
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)pairId)) {
            logger.error((Object)"pairId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = this.getConn(devSn);
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", pairId);
        if (isForce) {
            paras.put("ISFORCESWAP", "1");
        } else {
            paras.put("ISFORCESWAP", "0");
        }
        String url = "/rest/${deviceID}/vstore_pair/SWAP_PRIMARY_SECONDARY";
        logger.debug((Object)"swap HyperMetroPair: url = %s, params = %s", new Object[]{url, paras});
        conn.put(url, paras);
    }

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    private RestConnection getConn(String devSn) {
        return HvsRestConnectionManager.getInstance().getConnection(devSn);
    }
}

