/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.calculator;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.IReplicationPairQuery;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtMineSideService;
import com.huawei.ism.drm.storage.protection.calculator.ArrayReplicationRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.storage.protection.calculator.RPOCalculateBean;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;

public class ArrayHyperDRRingBaseCalculator
extends ArrayReplicationRecoveryPointObjectiveCalculator {
    private static final Log logger = LogFactory.getInstance(ArrayHyperDRRingBaseCalculator.class);
    private String comma = ",";

    public List<String> getTypes() {
        return Collections.emptyList();
    }

    protected RPOCalculateBean extractArrayRPOData(PolicyTemplate policyTemplate, RPOCalculateBean rpoCalBean, Schedule schedule, ProtectGroupReplica pgr, Map<String, List<ReplicationRelationBo>> allReplicationRelation, RPOContext context) {
        logger.trace((Object)"enter extractArrayRPOData");
        if (null != pgr) {
            rpoCalBean.setRecoverySiteId(schedule.getProtectLocation() + this.comma + this.getProductSiteIdByReplica(pgr) + this.comma + pgr.getRecoverySite());
            rpoCalBean.setReplicaActive(Boolean.valueOf(pgr.getStatus() == DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue()));
        }
        rpoCalBean.setIsSyncArray(Boolean.valueOf(false));
        this.dealRDRPO(policyTemplate, schedule, rpoCalBean);
        if (null != pgr) {
            this.dealDeviceRPO(pgr, allReplicationRelation, rpoCalBean, context);
        }
        return rpoCalBean;
    }

    private void dealDeviceRPO(ProtectGroupReplica pgr, Map<String, List<ReplicationRelationBo>> allReplicationRelation, RPOCalculateBean rpoCalBean, RPOContext context) {
        String recoverySite = pgr.getRecoverySite();
        List<ReplicationRelationBo> bos = allReplicationRelation.get(recoverySite);
        if (null == bos) {
            logger.error((Object)("There is no replication. Site:" + recoverySite));
            return;
        }
        List<ReplicationTargetLun> repTgtLuns = this.getReplicationTargetLuns(rpoCalBean, context);
        for (ReplicationRelationBo bo : bos) {
            String errorMsg = "pgName:" + rpoCalBean.getPgName() + ", replicationId:" + bo.getReplicationId() + ", srcDevSn:" + bo.getSrcDeviceSn() + ", targetDevSn:" + bo.getTgtDeviceSn();
            String srcDeviceSn = bo.getSrcDeviceSn();
            boolean consistentGroup = bo.isConsistentGroup();
            int deviceStatus = this.getStorageStatus(srcDeviceSn);
            if (deviceStatus != 0) {
                rpoCalBean.setIsOkRdConnDevice(Boolean.valueOf(false));
                return;
            }
            rpoCalBean.setIsOkRdConnDevice(Boolean.valueOf(true));
            Site srcSite = this.getSiteByResourceSN(srcDeviceSn);
            if (srcSite == null) {
                logger.error((Object)("srcSite is empty!" + errorMsg), -1L);
                return;
            }
            if (VerifyUtil.isEmpty(repTgtLuns)) {
                logger.error((Object)("ReplicationTargetLun is empty!" + errorMsg), -1L);
                return;
            }
            if (consistentGroup) {
                Collection<ReplicationGroup> cgs = this.getContainsReplicationGroup(context);
                for (ReplicationGroup cg : cgs) {
                    this.dealConsistentGroup(rpoCalBean, cg, repTgtLuns);
                }
                continue;
            }
            this.dealNotConsistentGroup(rpoCalBean, repTgtLuns, false);
        }
    }

    private Collection<ReplicationGroup> getContainsReplicationGroup(RPOContext context) {
        Set<String> snCgId = this.getStandbySnCgId(context);
        List<ReplicationPair> allPair = this.getReplicationPair(context);
        IRecoveryResourceService recoveryResourceService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        HashMap<String, ReplicationGroup> normalCgs = new HashMap<String, ReplicationGroup>();
        HashMap<String, ReplicationGroup> standCgs = new HashMap<String, ReplicationGroup>();
        for (ReplicationPair replicationPair : allPair) {
            ReplicationRelation rr = recoveryResourceService.queryReplication(replicationPair.getDevSn(), replicationPair.getSrcDevSN(), replicationPair.getConsistentGroupId(), true);
            if (rr == null) {
                logger.error((Object)("the replicationGroup is null! cgId = " + replicationPair.getConsistentGroupId() + ", devSn = " + replicationPair.getDevSn()), -1L);
                continue;
            }
            ReplicationGroup rg = (ReplicationGroup)rr;
            if (snCgId.contains(rg.getDevSn() + rg.getReplicationId())) {
                standCgs.put(rg.getDrRingId(), rg);
                continue;
            }
            normalCgs.put(rg.getDrRingId(), rg);
        }
        for (ReplicationGroup cg : normalCgs.values()) {
            ReplicationGroup tempCG = (ReplicationGroup)standCgs.get(cg.getDrRingId());
            if (VerifyUtil.isEmpty((Object)tempCG) || cg.getTiming() <= tempCG.getTiming() || tempCG.getTiming() == Long.MIN_VALUE) continue;
            cg.setTiming(tempCG.getTiming());
        }
        Object isStandBy = context.getObject("isStandBy");
        if (!VerifyUtil.isEmpty((Object)isStandBy)) {
            return standCgs.values();
        }
        return normalCgs.values();
    }

    private Set<String> getStandbySnCgId(RPOContext context) {
        HashSet<String> snCgId = new HashSet<String>();
        List<ReplicationPair> tarPairs = this.getStandbyPairs(context);
        for (ReplicationPair pair : tarPairs) {
            snCgId.add(pair.getDevSn() + pair.getConsistentGroupId());
        }
        return snCgId;
    }

    private List<ReplicationPair> getStandbyPairs(RPOContext context) {
        List<ReplicationPair> allPair = this.getReplicationPair(context);
        if (VerifyUtil.isEmpty(allPair)) {
            logger.error((Object)"allPair is enmpty.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> snCgId = new ArrayList<String>();
        ArrayList<ReplicationPair> standPairs = new ArrayList<ReplicationPair>();
        for (ReplicationPair replicationPair : allPair) {
            ReplicationTargetLun tarLun;
            List tarLuns = replicationPair.getRepTgtLuns();
            String cg = replicationPair.getConsistentGroupId();
            if (VerifyUtil.isEmpty((String)cg) || cg.length() <= 4 || snCgId.contains(replicationPair.getDevSn() + cg) || VerifyUtil.isEmpty((Collection)tarLuns) || !"110".equals(String.valueOf((tarLun = (ReplicationTargetLun)tarLuns.iterator().next()).getPairStatus()))) continue;
            snCgId.add(replicationPair.getDevSn() + cg);
            standPairs.add(replicationPair);
        }
        return standPairs;
    }

    private List<ReplicationPair> getReplicationPair(RPOContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Set protectGroupReplicas = protectGroup.getReplicaList();
        Map<String, Collection<ReplicationPair>> allPairMap = null;
        for (ProtectGroupReplica replica : protectGroupReplicas) {
            Set protectObjectReplicas = replica.getReplicas();
            for (ProtectObjectReplica protectObjectReplica : protectObjectReplicas) {
                Map<String, Collection<ReplicationPair>> temp;
                Set replicaStorageInfos = protectObjectReplica.getStorageInfos();
                allPairMap = temp = DRRingUtil.getRelatedReplicationPairs(replicaStorageInfos, new IReplicationPairQuery(){

                    @Override
                    public Collection<ReplicationPair> getReplicationPairsByLun(Collection<Lun> luns) {
                        return ReplicationPairQueryAtMineSideService.getInstance().fromDevice(true).getReplicationPairsByLun(luns);
                    }

                    @Override
                    public Collection<ReplicationPair> getReplicationPairsByLun(String devSn, Collection<String> luns) {
                        return ReplicationPairQueryAtMineSideService.getInstance().fromDevice(true).getReplicationPairsByLun(devSn, luns);
                    }
                });
            }
        }
        ArrayList<ReplicationPair> allPair = new ArrayList<ReplicationPair>();
        if (null == allPairMap) {
            return allPair;
        }
        for (Collection collect : allPairMap.values()) {
            if (VerifyUtil.isEmpty((Collection)collect)) continue;
            allPair.addAll(collect);
        }
        return allPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<ReplicationTargetLun> initrepTgtLuns(List<ReplicationTargetLun> allRepTgtLuns, RPOContext context) {
        block7: {
            block6: {
                session = null;
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                srcLunAndTargetLunMap = new HashMap<String, ReplicationTargetLun>();
                allRepTgtLunsCopy = new ArrayList<ReplicationTargetLun>(allRepTgtLuns);
                protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
                type = protectGroup.getTemplate().getType();
                isStandBy = context.getObject("isStandBy");
                if (26 != type) ** GOTO lbl21
                this.classifyReplicationTargetLun(allRepTgtLuns, srcLunAndTargetLunMap, allRepTgtLunsCopy);
                if (null == isStandBy) break block6;
                var9_9 = new ArrayList<ReplicationTargetLun>(srcLunAndTargetLunMap.values());
                CommonUtil.close(session);
                return var9_9;
            }
            for (ReplicationTargetLun replicationTargetLun : allRepTgtLunsCopy) {
                this.initTiming(srcLunAndTargetLunMap, replicationTargetLun);
            }
            ** GOTO lbl35
lbl21:
            // 1 sources

            if (27 != type) ** GOTO lbl35
            pairIdLunId = this.getlunIdPairId(allRepTgtLuns, session);
            for (ReplicationTargetLun replicationTargetLun : allRepTgtLuns) {
                pairId = replicationTargetLun.getReplicationPairId();
                srcLunId = pairIdLunId.get(pairId);
                this.clearNotMatchedLunCopy(srcLunAndTargetLunMap, allRepTgtLunsCopy, replicationTargetLun, srcLunId);
            }
            if (null == isStandBy) break block7;
            var10_12 = new ArrayList<V>(srcLunAndTargetLunMap.values());
            CommonUtil.close(session);
            return var10_12;
        }
        try {
            this.setTiming(allRepTgtLunsCopy, pairIdLunId, srcLunAndTargetLunMap);
lbl35:
            // 3 sources

            var9_10 = allRepTgtLunsCopy;
        }
        catch (Throwable var14_16) {
            CommonUtil.close(session);
            throw var14_16;
        }
        CommonUtil.close(session);
        return var9_10;
    }

    private void setTiming(List<ReplicationTargetLun> allRepTgtLunsCopy, Map<String, String> pairIdLunId, Map<String, ReplicationTargetLun> srcLunAndTargetLunMap) {
        for (ReplicationTargetLun replicationTargetLun : allRepTgtLunsCopy) {
            String pairId = replicationTargetLun.getReplicationPairId();
            String srcLunId = pairIdLunId.get(pairId);
            ReplicationTargetLun replicationLun = srcLunAndTargetLunMap.get(srcLunId);
            if (VerifyUtil.isEmpty((Object)replicationLun) || replicationLun.getTiming() >= replicationTargetLun.getTiming() || replicationLun.getTiming() == Long.MIN_VALUE) continue;
            replicationTargetLun.setTiming(replicationLun.getTiming());
        }
    }

    private void initTiming(Map<String, ReplicationTargetLun> srcLunAndTargetLunMap, ReplicationTargetLun replicationTargetLun) {
        String lunId = replicationTargetLun.getTgtLunId();
        ReplicationTargetLun replicationLun = srcLunAndTargetLunMap.get(lunId);
        if (!VerifyUtil.isEmpty((Object)replicationLun) && replicationLun.getTiming() < replicationTargetLun.getTiming() && replicationLun.getTiming() != Long.MIN_VALUE) {
            replicationTargetLun.setTiming(replicationLun.getTiming());
        }
    }

    private void clearNotMatchedLunCopy(Map<String, ReplicationTargetLun> srcLunAndTargetLunMap, List<ReplicationTargetLun> allRepTgtLunsCopy, ReplicationTargetLun replicationTargetLun, String srcLunId) {
        if (!srcLunAndTargetLunMap.containsKey(srcLunId) && "110".equals(String.valueOf(replicationTargetLun.getPairStatus()))) {
            srcLunAndTargetLunMap.put(srcLunId, replicationTargetLun);
            allRepTgtLunsCopy.remove(replicationTargetLun);
        }
    }

    private void classifyReplicationTargetLun(List<ReplicationTargetLun> allRepTgtLuns, Map<String, ReplicationTargetLun> srcLunAndTargetLunMap, List<ReplicationTargetLun> allRepTgtLunsCopy) {
        for (ReplicationTargetLun replicationTargetLun : allRepTgtLuns) {
            String lunId = replicationTargetLun.getTgtLunId();
            this.clearNotMatchedLunCopy(srcLunAndTargetLunMap, allRepTgtLunsCopy, replicationTargetLun, lunId);
        }
    }

    private List<ReplicationTargetLun> getReplicationTargetLuns(RPOCalculateBean rpoCalBean, RPOContext context) {
        List<ReplicationPair> allPair = this.getReplicationPair(context);
        IRecoveryProcessBaseHandler recoveryProcHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        ArrayList allRepTgtLuns = new ArrayList();
        for (ReplicationPair pair : allPair) {
            List repTgtLuns = ((IRecoveryProcessHandler)recoveryProcHandler).querySyncStatus(pair.getDevSn(), pair.getSrcDevSN(), pair.getReplicationId(), false);
            if (VerifyUtil.isEmpty((Collection)repTgtLuns)) {
                logger.error((Object)("ReplicationTargetLun is empty! pair id :" + pair.getReplicationId() + ", sn :" + pair.getDevSn()), -1L);
                throw new LegoCheckedException(1073947393L);
            }
            allRepTgtLuns.addAll(repTgtLuns);
        }
        List<ReplicationTargetLun> allRepTgtLunsActul = this.initrepTgtLuns(new ArrayList<ReplicationTargetLun>(allRepTgtLuns), context);
        if (VerifyUtil.isEmpty(allRepTgtLunsActul)) {
            logger.error((Object)"can't get standby pair");
            throw new LegoCheckedException(1073947393L);
        }
        ReplicationTargetLun targetLun = allRepTgtLunsActul.iterator().next();
        Site product = null;
        Site recovery = null;
        if (targetLun.getDevSn().equals(targetLun.getTgtDevSN())) {
            ReplicationPair pair = this.getSrcPair(targetLun.getDevSn(), allPair);
            if (null == pair) {
                logger.error((Object)"can't get master pair");
                throw new LegoCheckedException(1073947393L);
            }
            product = this.getSiteByResourceSN(pair.getDevSn());
            recovery = this.getSiteByResourceSN(pair.getSrcDevSN());
        } else {
            product = this.getSiteByResourceSN(targetLun.getDevSn());
            recovery = this.getSiteByResourceSN(targetLun.getTgtDevSN());
        }
        if (null == product || null == recovery) {
            logger.error((Object)"get site failed.");
            throw new LegoCheckedException(0x300001L);
        }
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Object isStandBy = context.getObject("isStandBy");
        logger.debug((Object)("isStandby : " + isStandBy + ",protectGroup name : " + protectGroup.getName() + ",product : " + product.getName() + ",recovery : " + recovery.getName() + ",pair id : " + targetLun.getReplicationPairId()));
        Schedule schedule = this.getSchedule(1, protectGroup.getTemplate());
        rpoCalBean.setRecoverySiteId(schedule.getProtectLocation() + this.comma + product.getSiteId() + this.comma + recovery.getSiteId());
        return allRepTgtLunsActul;
    }

    private Map<String, String> getlunIdPairId(List<ReplicationTargetLun> allRepTgtLuns, Session session) {
        if (VerifyUtil.isEmpty(allRepTgtLuns) || VerifyUtil.isEmpty((Object)session)) {
            logger.error((Object)"allRepTgtLuns or session is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList pairs = new ArrayList();
        for (ReplicationTargetLun replicationTargetLun : allRepTgtLuns) {
            String hql = "from ReplicationPair as pair where pair.replicationId = :id and pair.devSn = :sn";
            List pairsTemp = session.createQuery(hql).setString("id", replicationTargetLun.getReplicationPairId()).setString("sn", replicationTargetLun.getDevSn()).list();
            if (VerifyUtil.isEmpty((Collection)pairsTemp)) {
                logger.error((Object)("pairs is empty . sn is : " + replicationTargetLun.getDevSn() + ", and pair id i : " + replicationTargetLun.getReplicationPairId()));
                throw new LegoCheckedException(1073947393L);
            }
            pairs.addAll(pairsTemp);
        }
        HashMap<String, String> pairAndLun = new HashMap<String, String>();
        for (ReplicationPair replicationPair : pairs) {
            pairAndLun.put(replicationPair.getReplicationId(), replicationPair.getSrcLunId());
        }
        return pairAndLun;
    }

    private ReplicationPair getSrcPair(String devSn, List<ReplicationPair> allPair) {
        for (ReplicationPair replicationPair : allPair) {
            if (!replicationPair.getDevSn().equals(devSn)) continue;
            return replicationPair;
        }
        return null;
    }

    protected Schedule getAutoSchedule(Set<Schedule> schedules) {
        if (VerifyUtil.isEmpty(schedules)) {
            logger.error((Object)"schedules is empty");
            throw new LegoCheckedException(1073947393L);
        }
        logger.trace((Object)"enter getAutoSchedule");
        for (Schedule sc : schedules) {
            if (sc.getScheduleMode() == 1 || sc.getProtectLocation() != DrmEnumDefine.ProtectLocation.C_C.getValue()) continue;
            return sc;
        }
        for (Schedule sc : schedules) {
            if (sc.getProtectLocation() != DrmEnumDefine.ProtectLocation.C_C.getValue()) continue;
            return sc;
        }
        return schedules.iterator().next();
    }

    protected ProtectGroupReplica getProtectGroupReplica(int index, Set<ProtectGroupReplica> replicaList) {
        logger.trace((Object)"enter getProtectGroupReplica");
        if (VerifyUtil.isEmpty(replicaList)) {
            return null;
        }
        for (ProtectGroupReplica pgr : replicaList) {
            if (pgr.getProtectLocation() != DrmEnumDefine.ProtectLocation.C_C.getValue()) continue;
            return pgr;
        }
        return null;
    }
}

