/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.rate;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.checker.job.IJobExecutionContextAWare;
import com.huawei.ism.drm.protection.checker.manager.RateConfigByReplicaServiceImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayAsyncReplicationFilter;
import com.huawei.ism.drm.storage.protection.util.DRRingCommUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.quartz.JobExecutionContext;

@ServiceBoundInfo(methodName="onBind", targetBeanName="rateConfigServiceMgr", properties="type:3##5")
public class SyncAsyncDRRingPairRateConfigServiceImpl
extends RateConfigByReplicaServiceImpl
implements IJobExecutionContextAWare {
    private static Log logger = LogFactory.getInstance(SyncAsyncDRRingPairRateConfigServiceImpl.class);
    private ArrayAsyncReplicationFilter asyncReplicationFilter;
    private ThreadLocal<JobExecutionContext> local = new ThreadLocal();

    public JobExecutionContext getJobExecutionContext() {
        return this.local.get();
    }

    public void setJobExecutionContext(JobExecutionContext context) {
        this.local.set(context);
    }

    public ArrayAsyncReplicationFilter getAsyncReplicationFilter() {
        return this.asyncReplicationFilter;
    }

    public void setAsyncReplicationFilter(ArrayAsyncReplicationFilter asyncReplicationFilter) {
        this.asyncReplicationFilter = asyncReplicationFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRate(DmEnumDefine.SpeedLevelE speedLevel, ProtectGroup pg, int protectionLocation) {
        try {
            super.modifyRate(speedLevel, pg, protectionLocation);
        }
        finally {
            this.local.remove();
        }
    }

    protected List<ReplicationRelationBo> getReplicationRelationBos(ProtectGroup protectGroup, Set<ProtectObjectReplica> replicas) {
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty(replicas)) {
            logger.error((Object)"pg or replicas is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        List policies = DRRingCommUtil.getProtectGroupSyncRatePolicies((JobExecutionContext)this.getJobExecutionContext());
        List storageList = CommonUtil.get((List)policies, (String)"storage", String.class);
        HashSet storageSet = new HashSet(storageList);
        if (storageSet.size() != 1) {
            logger.error((Object)"size of storage list should be 1");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupReplica pgReplica = ((ProtectObjectReplica)CommonUtil.getFirstElement(replicas)).getPgReplica();
        String syncArraySn = (String)storageSet.iterator().next();
        if (pgReplica.getProtectLocation() == DrmEnumDefine.ProtectLocation.C_C.getValue() && !pgReplica.getProductArray().equals(syncArraySn)) {
            ProtectGroupReplica syncReplic = DRRingUtil.getProtectGroupReplicaByLocation(protectGroup.getReplicaList(), DrmEnumDefine.ProtectLocation.A_B.getValue());
            Collection<ReplicationPair> pairs = this.getOtherSideAsyncPair(syncReplic, syncArraySn);
            replicas = this.buildPoReplica(replicas, this.filterPair(pairs, pgReplica.getRecoveryArray()));
        }
        return super.getReplicationRelationBos(protectGroup, replicas);
    }

    private Collection<ReplicationPair> filterPair(Collection<ReplicationPair> pairs, String recoveryArray) {
        if (VerifyUtil.isEmpty(pairs) || VerifyUtil.isEmpty((String)recoveryArray)) {
            logger.error((Object)"pairs not match. or recoveryArray is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<ReplicationPair> tempPairs = new HashSet<ReplicationPair>();
        for (ReplicationPair replicationPair : pairs) {
            for (ReplicationTargetLun tgtLun : replicationPair.getRepTgtLuns()) {
                if (!recoveryArray.equals(tgtLun.getTgtDevSN())) continue;
                tempPairs.add(replicationPair);
            }
        }
        return tempPairs;
    }

    private Set<ProtectObjectReplica> buildPoReplica(Set<ProtectObjectReplica> replicas, Collection<ReplicationPair> pairs) {
        HashSet<ProtectObjectReplica> tempPoReplicas = new HashSet<ProtectObjectReplica>();
        for (ProtectObjectReplica poReplica : replicas) {
            ProtectObjectReplica tempProtectObjectReplica = new ProtectObjectReplica();
            tempProtectObjectReplica.setPoId(poReplica.getPoId());
            tempProtectObjectReplica.setPgReplica(poReplica.getPgReplica());
            tempProtectObjectReplica.setProtectObject(poReplica.getProtectObject());
            HashSet<Object> tempRemoteStorageReplicas = new HashSet<Object>();
            for (RelicaStorageInfo storageInfo : poReplica.getStorageInfos()) {
                if (storageInfo instanceof RemoteStorageReplica) {
                    RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)RemoteStorageReplica.class.cast(storageInfo);
                    RemoteStorageReplica tempRemoteStorageReplica = new RemoteStorageReplica();
                    this.rebuildTempRemoteStorageReplica(remoteStorageReplica, tempRemoteStorageReplica, pairs);
                    tempRemoteStorageReplicas.add(tempRemoteStorageReplica);
                    continue;
                }
                tempRemoteStorageReplicas.add(storageInfo);
            }
            tempProtectObjectReplica.setStorageInfos(tempRemoteStorageReplicas);
            tempPoReplicas.add(tempProtectObjectReplica);
        }
        return tempPoReplicas;
    }

    private void rebuildTempRemoteStorageReplica(RemoteStorageReplica remoteStorageReplica, RemoteStorageReplica tempRemoteStorageReplica, Collection<ReplicationPair> pairs) {
        if (VerifyUtil.isEmpty(pairs)) {
            logger.error((Object)"input parameter pairs is null.");
            throw new LegoCheckedException(1073947393L);
        }
        for (ReplicationPair replicationPair : pairs) {
            tempRemoteStorageReplica.setConsistentGroupId(replicationPair.getConsistentGroupId());
            tempRemoteStorageReplica.setDrRingId(replicationPair.getDrRingId());
            tempRemoteStorageReplica.setReplicationPairId(replicationPair.getReplicationId());
            tempRemoteStorageReplica.setSrcStorageId(replicationPair.getSrcLunId());
            tempRemoteStorageReplica.setSrcStorageProviderSN(replicationPair.getSrcDevSN());
            tempRemoteStorageReplica.setStorageId(remoteStorageReplica.getStorageId());
            tempRemoteStorageReplica.setStorageProviderSN(replicationPair.getTgtDevSN());
            tempRemoteStorageReplica.setPoReplica(remoteStorageReplica.getPoReplica());
        }
    }

    private Collection<ReplicationPair> getOtherSideAsyncPair(ProtectGroupReplica syncReplic, String syncArraySn) {
        HashSet syncMasterLun = new HashSet();
        HashSet syncSlaveLun = new HashSet();
        DRRingCommUtil.initAllLunByPgReplica((ProtectGroupReplica)syncReplic, syncMasterLun, syncSlaveLun);
        if (syncArraySn.equals(syncReplic.getProductArray())) {
            return this.asyncReplicationFilter.getPairsByLun(syncMasterLun);
        }
        if (syncArraySn.equals(syncReplic.getRecoveryArray())) {
            return this.asyncReplicationFilter.getPairsByLun(syncSlaveLun);
        }
        logger.error((Object)"syncArraySn is not correct. syncArraySn = %s, productArray = %s, recoveryArray = %s", new Object[]{syncArraySn, syncReplic.getProductArray(), syncReplic.getRecoveryArray()});
        throw new LegoCheckedException(1073947393L);
    }
}

