/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.template.filter;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationUtil;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayAsynReplicationHyperMetroFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayAsyncHyperMetroDRRingFilter
extends ArrayAsynReplicationHyperMetroFilter {
    private static Log logger = LogFactory.getInstance(ArrayAsyncHyperMetroDRRingFilter.class);

    public int getType() {
        return 27;
    }

    protected void cascadeFilterOperation(PolicyTemplateContext context) {
        List allRelatedReplicationPairs = (List)context.getObject("DR_RING_ALL_RELATED_PAIR_LIST");
        Map<String, Collection<ReplicationPair>> productStoragePairMap = ReplicationUtil.classifyReplicationPairByProductStorageSn(allRelatedReplicationPairs);
        if (productStoragePairMap.size() != 1) {
            logger.error((Object)("the number of secodary storage should be 1, but actual is " + productStoragePairMap.size()));
            throw new LegoCheckedException(1073948191L);
        }
        Map<String, Collection<ReplicationPair>> recoveryStoragePairMap = ReplicationUtil.classifyReplicationPairBySecondaryStorageSN(allRelatedReplicationPairs);
        if (recoveryStoragePairMap.size() != 2) {
            logger.error((Object)("the number of secodary storage should be 2, but actual is " + recoveryStoragePairMap.size()));
            throw new LegoCheckedException(1073948191L);
        }
        List protectObjects = this.getProtectObjectList(context);
        List storageInfos = this.getAllStorageInfo(protectObjects);
        Map<String, Collection<ReplicationPair>> pairMap = ReplicationUtil.classifyReplicationPairByStorage(storageInfos, allRelatedReplicationPairs);
        StringBuilder pairCountNotMatched = CommonUtil.checkValueCountNotMatched(pairMap, 2);
        if (pairCountNotMatched.length() > 0) {
            logger.error((Object)("number of replication pair for each lun should be 2, but actual is " + pairCountNotMatched));
            throw new LegoCheckedException(1073948191L);
        }
        Set<String> productStorageSNList = productStoragePairMap.keySet();
        StringBuilder productStorageInconsistency = ReplicationUtil.checkProductStorageConsistency(pairMap, productStorageSNList);
        if (productStorageInconsistency.length() > 0) {
            logger.error((Object)("product storage of replication pair is inconsistent. " + productStorageInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        Set<String> recoveryStorageSNList = recoveryStoragePairMap.keySet();
        StringBuilder recoveryStorageInconsistency = ReplicationUtil.checkRecoveryStorageConsistency(pairMap, recoveryStorageSNList);
        if (recoveryStorageInconsistency.length() > 0) {
            logger.error((Object)("recovery storage of replication pair is inconsistent. " + recoveryStorageInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder drRingIdInconsistency = DRRingUtil.checkDRRingConsistency(pairMap);
        if (drRingIdInconsistency.length() > 0) {
            logger.error((Object)("DR Ring ID of replication pairs is inconsistent. " + drRingIdInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        Collection<ReplicationPair> normalSideReplicationPairs = DRRingUtil.getWhichNotContainStandby(recoveryStoragePairMap.values());
        Collection<ReplicationPair> standbySideReplicationPairs = DRRingUtil.getWhichAllItemsIsStandby(recoveryStoragePairMap.values());
        if (normalSideReplicationPairs.isEmpty() || normalSideReplicationPairs.size() != standbySideReplicationPairs.size()) {
            logger.error((Object)"replication pair number of normal side should not zero and as many as standby side, but actual is not. normal pair size:%s, standby pair size:%s", new Object[]{normalSideReplicationPairs.size(), standbySideReplicationPairs.size()});
            throw new LegoCheckedException(1073948191L);
        }
        List hyperMetroPairs = (List)context.getObject("PAIR_LIST");
        if (normalSideReplicationPairs.size() * 2 != hyperMetroPairs.size()) {
            logger.error((Object)"number of hyper metro pairs is not double of number of valid dr ring replication pairs.");
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder normalSideInconsistent = DRRingUtil.checkGroupConsistent(hyperMetroPairs, normalSideReplicationPairs);
        if (normalSideInconsistent.length() > 0) {
            logger.error((Object)new StringBuilder("consistent group member of normal side is not same.").append((CharSequence)normalSideInconsistent));
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder standbySideInconsistent = DRRingUtil.checkGroupConsistent(hyperMetroPairs, standbySideReplicationPairs);
        if (standbySideInconsistent.length() > 0) {
            logger.error((Object)new StringBuilder("consistent group member of standby side is not same.").append((CharSequence)standbySideInconsistent));
            throw new LegoCheckedException(1073948191L);
        }
        this.checkDRRingForCascadeFilter(allRelatedReplicationPairs, productStoragePairMap, protectObjects);
    }

    private void checkDRRingForCascadeFilter(Collection<ReplicationPair> allRelatedReplicationPairs, Map<String, Collection<ReplicationPair>> productStoragePairMap, List<ProtectObject> protectObjects) {
        String message = DRRingUtil.checkDRRingLimitsForProtectObjects(protectObjects, allRelatedReplicationPairs);
        if (message.length() > 0) {
            logger.error((Object)message);
            throw new LegoCheckedException(1073948191L);
        }
        Map<String, Collection<ReplicationPair>> drRingIdPairMap = DRRingUtil.classifyReplicationPairByDRRingId(allRelatedReplicationPairs);
        Set<String> usedDrRingIds = drRingIdPairMap.keySet();
        Set<String> productStorages = productStoragePairMap.keySet();
        StringBuilder notMatchedDRRings = DRRingUtil.checkRunningStatusNotMatchedRings(productStorages, usedDrRingIds, "1");
        if (notMatchedDRRings.length() != 0) {
            logger.error((Object)("running status of dr-ring list, must be enable. but actual:" + notMatchedDRRings));
            throw new LegoCheckedException(1073948191L);
        }
        DRRingUtil.checkDRRingsUsedByOtherProtectGroup(protectObjects, usedDrRingIds, productStorages);
    }

    protected boolean shouldCheckHyperMetroRunningStatus() {
        return false;
    }

    protected List<ReplicationPair> getReplicationPairsByLun(Lun ... lunArray) {
        if (lunArray == null || lunArray.length == 0) {
            return Collections.emptyList();
        }
        List pairs = super.getReplicationPairsByLun(lunArray);
        List<Lun> resources = Arrays.asList(lunArray);
        return DRRingUtil.processDRRingReplicationPairs(pairs, resources);
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        this.isMatch(protectObjects);
        List storageInfos = this.getAllStorageInfo(protectObjects);
        return DRRingUtil.getProtectLocationPaths(protectObjects, storageInfos);
    }

    protected void checkConsistentGroup(PolicyTemplateContext context, List<HyperMetroPair> pairs, Set<String> cgs) {
        Collection protectObjects = (Collection)context.getObject("PO_LIST");
        for (ProtectObject protectObject : protectObjects) {
            this.checkConsistentGroup(context, pairs, protectObject);
        }
    }

    private void checkConsistentGroup(PolicyTemplateContext context, List<HyperMetroPair> pairs, ProtectObject protectObject) {
        pairs = DRRingUtil.getTargetHyperMetroPairsOfProtectObject(pairs, protectObject);
        Collection<String> cgs = DRRingUtil.getCgidOfHyperMetroPair(pairs);
        int drRingLimits = DRRingUtil.getDRRingLimits(protectObject);
        if (drRingLimits == 0) {
            logger.error((Object)"May encounter tampering attacks, because drRingLimits should be 1 or 2, not 0");
            throw new LegoCheckedException(1073948191L);
        }
        int limits = drRingLimits * 2;
        if (VerifyUtil.isEmpty(cgs) && pairs.size() != limits) {
            logger.error((Object)new StringBuilder("size of pairs list, must be ").append(limits).append(". but actual: ").append(pairs.size()));
            throw new LegoCheckedException(1073948191L);
        }
        limits = drRingLimits;
        if (!VerifyUtil.isEmpty(cgs) && cgs.size() != limits) {
            logger.error((Object)new StringBuilder("size of cgs list, must be ").append(limits).append(". but actual: ").append(cgs.size()));
            throw new LegoCheckedException(1073948191L);
        }
        for (String cg : cgs) {
            this.checkConsistentGroupHealthStatus(context, new HashSet<String>(Arrays.asList(cg)));
        }
    }
}

