/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.template.filter;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationUtil;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayHyperMetroAsynReplicationFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class ArrayHyperMetroAsyncDRRingFilter
extends ArrayHyperMetroAsynReplicationFilter {
    private static final Log LOGGER = LogFactory.getInstance(ArrayHyperMetroAsyncDRRingFilter.class);

    public int getType() {
        return 26;
    }

    protected void cascadeFilterOperation(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        super.cascadeFilterOperation(protectObjects, context);
        this.cascadeFilterOperationForDRRing(protectObjects, context);
    }

    private void cascadeFilterOperationForDRRing(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        List allRelatedReplicationPairs = (List)context.getObject("DR_RING_ALL_RELATED_PAIR_LIST");
        Map<String, Collection<ReplicationPair>> productStoragePairMap = ReplicationUtil.classifyReplicationPairByProductStorageSn(allRelatedReplicationPairs);
        if (productStoragePairMap.size() != 2) {
            LOGGER.error((Object)("the number of product storage should be 2, but actual is " + productStoragePairMap.size()));
            throw new LegoCheckedException(1073948191L);
        }
        Map<String, Collection<ReplicationPair>> recoveryStoragePairMap = ReplicationUtil.classifyReplicationPairBySecondaryStorageSN(allRelatedReplicationPairs);
        if (recoveryStoragePairMap.size() != 1) {
            LOGGER.error((Object)("the number of secodary storage should be 1, but actual is " + recoveryStoragePairMap.size()));
            throw new LegoCheckedException(1073948191L);
        }
        List storageInfos = this.getAllStorageInfo(protectObjects);
        Map<String, Collection<ReplicationPair>> pairMap = ReplicationUtil.classifyReplicationPairByStorage(storageInfos, allRelatedReplicationPairs);
        StringBuilder pairCountNotMatched = CommonUtil.checkValueCountNotMatched(pairMap, 2);
        if (pairCountNotMatched.length() > 0) {
            LOGGER.error((Object)("number of replication pair for each lun should be 2, but actual is " + pairCountNotMatched));
            throw new LegoCheckedException(1073948191L);
        }
        this.checkStorageConsistencyForDRRing(productStoragePairMap, recoveryStoragePairMap, pairMap);
        StringBuilder targetLunInconsistency = ReplicationUtil.checkTargetLunConsistency(pairMap);
        if (targetLunInconsistency.length() > 0) {
            LOGGER.error((Object)("target luns of replication pairs is inconsistent. " + targetLunInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder drRingIdInconsistency = DRRingUtil.checkDRRingConsistency(pairMap);
        if (drRingIdInconsistency.length() > 0) {
            LOGGER.error((Object)("DR Ring ID of replication pairs is inconsistent. " + drRingIdInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        Collection<ReplicationPair> normalSideReplicationPairs = DRRingUtil.getWhichNotContainStandby(productStoragePairMap.values());
        Collection<ReplicationPair> standbySideReplicationPairs = DRRingUtil.getWhichAllItemsIsStandby(productStoragePairMap.values());
        if (normalSideReplicationPairs.isEmpty() || normalSideReplicationPairs.size() != standbySideReplicationPairs.size()) {
            LOGGER.error((Object)"replication pair number of normal side should not zero and as many as standby side, but actual is not. normal pair size:%s, standby pair size:%s", new Object[]{normalSideReplicationPairs.size(), standbySideReplicationPairs.size()});
            throw new LegoCheckedException(1073948191L);
        }
        List hyperMetroPairs = (List)context.getObject("PAIR_LIST");
        if (normalSideReplicationPairs.size() * 2 != hyperMetroPairs.size()) {
            LOGGER.error((Object)"number of hyper metro pairs is not double of number of valid dr ring replication pairs.");
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder normalSideInconsistent = DRRingUtil.checkGroupConsistent(hyperMetroPairs, normalSideReplicationPairs);
        if (normalSideInconsistent.length() > 0) {
            LOGGER.error((Object)new StringBuilder("consistent group member of normal side is not same.").append((CharSequence)normalSideInconsistent));
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder standbySideInconsistent = DRRingUtil.checkGroupConsistent(hyperMetroPairs, standbySideReplicationPairs);
        if (standbySideInconsistent.length() > 0) {
            LOGGER.error((Object)new StringBuilder("consistent group member of standby side is not same.").append((CharSequence)standbySideInconsistent));
            throw new LegoCheckedException(1073948191L);
        }
        this.checkDRRingForCascadeFilter(protectObjects, allRelatedReplicationPairs, productStoragePairMap);
    }

    private void checkStorageConsistencyForDRRing(Map<String, Collection<ReplicationPair>> productStoragePairMap, Map<String, Collection<ReplicationPair>> recoveryStoragePairMap, Map<String, Collection<ReplicationPair>> pairMap) {
        Set<String> productStorageSNList = productStoragePairMap.keySet();
        StringBuilder productStorageInconsistency = ReplicationUtil.checkProductStorageConsistency(pairMap, productStorageSNList);
        if (productStorageInconsistency.length() > 0) {
            LOGGER.error((Object)("product storage of replication pair is inconsistent. " + productStorageInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        Set<String> recoveryStorageSNList = recoveryStoragePairMap.keySet();
        StringBuilder recoveryStorageInconsistency = ReplicationUtil.checkRecoveryStorageConsistency(pairMap, recoveryStorageSNList);
        if (recoveryStorageInconsistency.length() > 0) {
            LOGGER.error((Object)("recovery storage of replication pair is inconsistent. " + recoveryStorageInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void checkDRRingForCascadeFilter(List<ProtectObject> protectObjects, Collection<ReplicationPair> allRelatedReplicationPairs, Map<String, Collection<ReplicationPair>> productStoragePairMap) {
        String message = DRRingUtil.checkDRRingLimitsForProtectObjects(protectObjects, allRelatedReplicationPairs);
        if (message.length() > 0) {
            LOGGER.error((Object)message);
            throw new LegoCheckedException(1073948191L);
        }
        Map<String, Collection<ReplicationPair>> drRingIdPairMap = DRRingUtil.classifyReplicationPairByDRRingId(allRelatedReplicationPairs);
        Set<String> usedDrRingIds = drRingIdPairMap.keySet();
        Set<String> productStorages = productStoragePairMap.keySet();
        StringBuilder notMatchedDRRings = DRRingUtil.checkRunningStatusNotMatchedRings(productStorages, usedDrRingIds, "1");
        if (notMatchedDRRings.length() != 0) {
            LOGGER.error((Object)("running status of dr-ring list, must be enable. but actual:" + notMatchedDRRings));
            throw new LegoCheckedException(1073948191L);
        }
        DRRingUtil.checkDRRingsUsedByOtherProtectGroup(protectObjects, usedDrRingIds, productStorages);
    }

    protected void checkConsistentGroup(PolicyTemplateContext context, List<HyperMetroPair> pairs, Set<String> cgs) {
        Collection protectObjects = (Collection)context.getObject("PO_LIST");
        for (ProtectObject protectObject : protectObjects) {
            this.checkConsistentGroup(context, pairs, protectObject);
        }
    }

    private void checkConsistentGroup(PolicyTemplateContext context, List<HyperMetroPair> pairs, ProtectObject protectObject) {
        pairs = DRRingUtil.getHyperMetroPairsByProtectObject(pairs, protectObject);
        Collection<String> cgs = DRRingUtil.getCgidOfHyperMetroPair(pairs);
        int drRingLimits = DRRingUtil.getDRRingLimits(protectObject);
        if (drRingLimits == 0) {
            LOGGER.error((Object)"May encounter tampering attacks, because drRingLimits should be 1 or 2, not 0");
            throw new LegoCheckedException(1073948191L);
        }
        int limits = drRingLimits * 2;
        if (VerifyUtil.isEmpty(cgs) && pairs.size() != limits) {
            LOGGER.error((Object)new StringBuilder("size of pairs list, must be ").append(limits).append(". but actual: ").append(pairs.size()));
            throw new LegoCheckedException(1073948191L);
        }
        limits = drRingLimits;
        if (!VerifyUtil.isEmpty(cgs) && cgs.size() != limits) {
            LOGGER.error((Object)new StringBuilder("size of cgs list, must be ").append(limits).append(". but actual: ").append(cgs.size()));
            throw new LegoCheckedException(1073948191L);
        }
        for (String cg : cgs) {
            this.checkConsistentGroupHealthStatus(context, new HashSet<String>(Arrays.asList(cg)));
        }
    }

    protected boolean shouldCheckHyperMetroRunningStatus() {
        return true;
    }

    protected List<ReplicationPair> getAllReplicationPair(List<StorageResource> allStorageResources) {
        List pairs = super.getAllReplicationPair(allStorageResources);
        return DRRingUtil.processDRRingReplicationPairs(pairs, allStorageResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        String pgId;
        boolean flag = false;
        if (VerifyUtil.isEmpty(protectObjects)) {
            return null;
        }
        ProtectGroup pg = protectObjects.get(0).getProtectGroup();
        String string = pgId = null == pg ? null : pg.getUuid();
        if (!VerifyUtil.isEmpty((String)pgId)) {
            Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            try {
                NativeQuery query = session.createSQLQuery("select t.PLANSTATUS from ti_recoveryplan as t where t.PLANID = (select p.PLANID from ti_drp_r_pg as p where p.PGID = :pgId)");
                query.setString("pgId", pgId);
                List status = query.list();
                if (!VerifyUtil.isEmpty((Collection)status) && status.get(0).equals(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING.getValue())) {
                    flag = true;
                }
            }
            finally {
                DBOperationUtil.closeSession((Session)session);
            }
        }
        if (!flag) {
            this.isMatch(protectObjects);
        }
        List storageInfos = this.getAllStorageInfo(protectObjects);
        return DRRingUtil.getProtectLocationPaths(protectObjects, storageInfos);
    }

    protected List<ProtectGroupReplica> queryProtectGroupReplicaByGroup(String pgId, List<ReplicationPair> allPairs) {
        List replicas = super.queryProtectGroupReplicaByGroup(pgId, allPairs);
        StringBuilder message = DRRingUtil.updateProtectGroupReplica(replicas, allPairs);
        if (message.length() > 0) {
            LOGGER.error((Object)message);
            throw new LegoCheckedException(1073948191L);
        }
        return replicas;
    }

    public boolean hasOnlyOneNormalReplicationPair(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            LOGGER.error((Object)"Param protectGroup is empty.");
            return false;
        }
        List<ProtectObject> protectObjects = Arrays.asList(protectGroup.getPolist().toArray(new ProtectObject[0]));
        Set storageInfos = this.getAllResourceIds(protectObjects);
        Collection<Lun> lunList = DRRingUtil.convertWwnToLun(storageInfos);
        if (lunList.isEmpty()) {
            return false;
        }
        Collection<String> offlineNes = DRRingUtil.getOfflineNeByLun(lunList);
        lunList.removeIf(lun -> offlineNes.contains(lun.getDevSn()));
        if (VerifyUtil.isEmpty(lunList) || lunList.size() != 1) {
            return false;
        }
        List<ReplicationPair> pairs = this.getPairsByLun(lunList);
        if (VerifyUtil.isEmpty(pairs)) {
            return false;
        }
        for (ReplicationPair pair : pairs) {
            if (!String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(pair.getRunningState()) || !String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue()).equals(pair.getHealthState())) continue;
            return true;
        }
        return false;
    }

    private List<ReplicationPair> getPairsByLun(Collection<Lun> lunList) {
        String devSn = "";
        ArrayList<String> lunIdList = new ArrayList<String>();
        for (Lun lun : lunList) {
            devSn = lun.getDevSn();
            lunIdList.add(lun.getLunId());
        }
        Site site = this.getSiteByDeviceSN(devSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            LOGGER.error((Object)"GetPairsByLun error, site is null.");
            return Collections.emptyList();
        }
        return this.getReplicationPairsByResources(devSn, lunIdList, site);
    }

    private List<ReplicationPair> getReplicationPairsByResources(String devSn, List<String> resIdList, Site site) {
        String resIds = String.join((CharSequence)";", resIdList);
        if (site.getSiteType() == 1) {
            RestClient client = SiteUtil.initClient((Site)site);
            try {
                HashMap<String, String> uriVariables = new HashMap<String, String>();
                uriVariables.put("devSn", devSn);
                uriVariables.put("resIds", resIds);
                String url = "/ws/storages/{devSn}/replicationpairs?resIds={resIds}";
                return client.getForObjects(url, uriVariables, ReplicationPair.class);
            }
            catch (LegoCheckedException ex) {
                LOGGER.error((Object)"GetPairsByLun from remote site LegoCheckedException.errorCode:%s,devSn:%s,error :%s.", new Object[]{String.valueOf(ex.getErrorCode()), devSn, ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
            catch (Exception ex) {
                LOGGER.error((Object)"GetPairsByLun from remote site Exception,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                return Collections.emptyList();
            }
        }
        return this.getStorageService().getReplicationPairsByResourceIds(devSn, resIdList);
    }
}

