/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.template.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncAsyncCascade3DCFilter;
import com.huawei.ism.drm.storage.protection.util.DRRingCommUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.TryCatchThrowable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ArraySyncAsyncCascadeDRRingFilter
extends ArraySyncAsyncCascade3DCFilter {
    private static final Log logger = LogFactory.getInstance(ArraySyncAsyncCascadeDRRingFilter.class);

    public boolean isMatch(List<ProtectObject> protectObjects) {
        return this.isMatch(protectObjects, new PolicyTemplateContext());
    }

    private boolean isMatch(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        boolean is3DCSite;
        boolean isMatchBC;
        logger.info((Object)("Start " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"), 90160758786989L);
        String arraySn = this.checkSameSrcDevice(protectObjects);
        Site site = this.getSiteFromSn(arraySn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.warn((Object)String.format(Locale.ROOT, "Check Protected group validity failed! cause: can't get site by deviceSN:%s", arraySn), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        this.getFilterContext().clear();
        this.getFilterContext().put("temp_policy_template_context", context);
        boolean isMatchAB = this.isMatchByLocation(1, DrmEnumDefine.ProtectLocation.A_B.getValue(), protectObjects, this.getType());
        if (!isMatchAB) {
            logger.warn((Object)"Cascade3DC is not MatchAB", 90160758787071L);
        }
        try {
            isMatchBC = this.isMatchByLocation(2, DrmEnumDefine.ProtectLocation.B_C.getValue(), protectObjects, this.getType());
            if (!isMatchBC) {
                logger.warn((Object)"Cascade3DC is not MatchBC", 90160758787071L);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Check Protected group validity failed! cause: Cascade3DC isMatchBC error:", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(1073948191L, (Throwable)e);
        }
        Object siteA = this.getFilterContext().get("SITE_A_3DC");
        Object siteB = this.getFilterContext().get("SITE_B_3DC");
        Object siteC = this.getFilterContext().get("SITE_C_3DC");
        if (VerifyUtil.isEmpty(siteA) || VerifyUtil.isEmpty(siteB) || VerifyUtil.isEmpty(siteC)) {
            logger.warn((Object)String.format(Locale.ROOT, "Check Protected group validity failed! cause: Cascade3DC isMatch site is null:%s-%s-%s", siteA, siteB, siteC), 90160758787071L);
            throw new LegoCheckedException(1073948211L);
        }
        boolean bl = is3DCSite = !String.valueOf(siteA).equals(String.valueOf(siteB)) && !String.valueOf(siteB).equals(String.valueOf(siteC)) && !String.valueOf(siteA).equals(String.valueOf(siteC));
        if (!is3DCSite) {
            logger.warn((Object)String.format(Locale.ROOT, "Check Protected group validity failed! cause: Cascade3DC isMatch site is same:%s-%s-%s", siteA, siteB, siteC), 90160758787071L);
            throw new LegoCheckedException(1073948211L);
        }
        logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"), 90160758786989L);
        return isMatchAB && isMatchBC;
    }

    private boolean matchDRStar(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        HashSet<String> usedDRRings;
        boolean isDRStar;
        Map abPairMap = (Map)context.getObject("DR_RING_SITE_A_SYNC_PAIR_MAP");
        if (null == abPairMap) {
            logger.error((Object)"abPairMap is null");
            return false;
        }
        String productSn = DRRingCommUtil.getSnByPair((boolean)true, (Map)abPairMap);
        String secondDevSn = DRRingCommUtil.getSnByPair((boolean)false, (Map)abPairMap);
        Map siteBPair = (Map)context.getObject("DR_RING_SITE_B_ASYNC_PAIR_MAP");
        if (null == siteBPair) {
            logger.error((Object)"siteBPair is null");
            return false;
        }
        Map bcAllPairMap = (Map)siteBPair.get(secondDevSn);
        if (null == bcAllPairMap || bcAllPairMap.isEmpty()) {
            logger.error((Object)"bcAllPairMap is null");
            return false;
        }
        Set<String> resourceIds = this.getPoStorageIds(protectObjects);
        HashMap<String, List<ReplicationPair>> bcPairMap = new HashMap<String, List<ReplicationPair>>();
        String thirdDevSn = this.getThirdDevSnAndFilterPair(bcAllPairMap, bcPairMap);
        if (null == thirdDevSn) {
            logger.error((Object)"thirdDevSn is null");
            return false;
        }
        Map acStandByPair = this.getStandbyPair(productSn, thirdDevSn, protectObjects, resourceIds);
        if (VerifyUtil.isEmpty((Map)acStandByPair) && !DRRingCommUtil.hasDRRingId((Map)abPairMap)) {
            context.addObject("support_down_grade", (Object)true);
        }
        if ((isDRStar = this.getAndCheckIsRing(abPairMap, bcPairMap, acStandByPair, usedDRRings = new HashSet<String>())) && CommonUtil.matchDRRingLimit(protectObjects, abPairMap, true)) {
            DRRingUtil.checkDRRingsUsedByOtherProtectGroup(protectObjects, usedDRRings, Arrays.asList(productSn, secondDevSn, thirdDevSn), Arrays.asList(productSn, secondDevSn));
            context.addObject("DR_RING_SITE_B_ASYNC_PAIR_MAP", bcPairMap);
            return true;
        }
        return false;
    }

    private Set<String> getPoStorageIds(List<ProtectObject> protectObjects) {
        HashSet<String> resourceIds = new HashSet<String>();
        for (ProtectObject protectObject : protectObjects) {
            for (ProtectObjectStorageInfo poStorageInfo : protectObject.getUsedStorageResourceSet()) {
                resourceIds.add(poStorageInfo.getResourceId());
            }
        }
        return resourceIds;
    }

    private String getThirdDevSnAndFilterPair(Map<String, List<ReplicationPair>> bcAllPairMap, Map<String, List<ReplicationPair>> bcPairMap) {
        AtomicReference<String> thirdDevSn = new AtomicReference<String>();
        Set<Map.Entry<String, List<ReplicationPair>>> enties = bcAllPairMap.entrySet();
        for (Map.Entry<String, List<ReplicationPair>> entry : enties) {
            for (ReplicationPair pair : entry.getValue()) {
                this.checkAndGetThirdDevSn(pair, entry.getKey(), thirdDevSn, bcPairMap);
            }
        }
        return (String)thirdDevSn.get();
    }

    private void checkAndGetThirdDevSn(ReplicationPair pair, String srcLunId, AtomicReference<String> thirdDevSn, Map<String, List<ReplicationPair>> bcPairMap) {
        for (ReplicationTargetLun tgtLun : pair.getRepTgtLuns()) {
            String tgtSn = tgtLun.getTgtDevSN();
            if (null == thirdDevSn.get()) {
                thirdDevSn.set(tgtLun.getTgtDevSN());
            }
            if (thirdDevSn.get().equals(tgtSn)) {
                if (bcPairMap.containsKey(srcLunId)) {
                    bcPairMap.get(srcLunId).add(pair);
                    continue;
                }
                ArrayList<ReplicationPair> pairs = new ArrayList<ReplicationPair>();
                pairs.add(pair);
                bcPairMap.put(srcLunId, pairs);
                continue;
            }
            logger.error((Object)("get Third DevSn error. thirdDevSn: " + thirdDevSn + ", tgtSn : " + tgtSn));
            throw new LegoCheckedException(1073948191L);
        }
    }

    protected Map<String, List<ReplicationPair>> filterStandbyBySite(String masterSn, String slaveSn, Map<String, List<ReplicationPair>> deviceSnPairMap) {
        return CommonUtil.filterStandbyBySite(masterSn, slaveSn, deviceSnPairMap);
    }

    public boolean isMatch(final List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        if (null == policyTemplate) {
            logger.error((Object)"error param.");
            return false;
        }
        final PolicyTemplateContext context = new PolicyTemplateContext();
        boolean success = this.isMatch(protectObjects, context);
        if (!success) {
            logger.error((Object)"policyTemplate not match.");
            return false;
        }
        final AtomicBoolean matchDRStar = new AtomicBoolean(false);
        new TryCatchThrowable(){

            protected void doTry() {
                matchDRStar.set(ArraySyncAsyncCascadeDRRingFilter.this.matchDRStar(protectObjects, context));
            }

            protected void doCatch(Throwable e) {
                logger.error((Object)("match DRRing failed . template type 3." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }.run();
        if (matchDRStar.get()) {
            policyTemplate.setSketch("policy_template_3_cascaded_sa_dr_star.png");
            return success;
        }
        if (!VerifyUtil.isEmpty((Object)context.getObject("support_down_grade"))) {
            policyTemplate.setSketch("policy_template_4_cascaded_sa.png");
            return success;
        }
        logger.error((Object)"refresh DRRing pg, but policyTemplate not match.");
        throw new LegoCheckedException(1073948191L);
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        PolicyTemplate tempTemplate = new PolicyTemplate();
        this.isMatch(protectObjects, tempTemplate);
        String siteA = (String)this.getFilterContext().get("SITE_A_3DC");
        String siteB = (String)this.getFilterContext().get("SITE_B_3DC");
        String siteC = (String)this.getFilterContext().get("SITE_C_3DC");
        ArrayList<ProtectLocationPath> path = new ArrayList<ProtectLocationPath>();
        path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.A_B.getValue(), siteA, siteB));
        String sketch = tempTemplate.getSketch();
        if (!VerifyUtil.isEmpty((String)sketch) && "policy_template_3_cascaded_sa_dr_star.png".equals(sketch)) {
            path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.C_C.getValue(), siteB, siteC));
        } else {
            path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.B_C.getValue(), siteB, siteC));
        }
        return path;
    }

    protected void updateRecoverPairMap(boolean needHasRepPair, Map<String, List<ReplicationPair>> devicesnPairMap, Map<String, Map<String, List<ReplicationPair>>> recoverPairMap) {
        super.updateRecoverPairMap(needHasRepPair, devicesnPairMap, recoverPairMap);
        DRRingCommUtil.addObjectToTemplateContext((Map)this.getFilterContext(), (String)"DR_RING_SITE_B_ASYNC_PAIR_MAP", recoverPairMap);
    }

    public boolean refreshPolicy(ProtectGroup protectGroup) {
        if (null == protectGroup || VerifyUtil.isEmpty((Object)protectGroup.getTemplate())) {
            return false;
        }
        Set schedules = protectGroup.getTemplate().getSchedules();
        Set pgReplicas = protectGroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)schedules) || VerifyUtil.isEmpty((Collection)pgReplicas)) {
            logger.info((Object)"schedules or pgReplicas is null or empty.");
            return false;
        }
        for (ProtectGroupReplica protectGroupReplica : pgReplicas) {
            for (Schedule schedule : schedules) {
                this.updateSchedule(protectGroup, protectGroupReplica, schedule);
            }
        }
        return true;
    }

    private void updateSchedule(ProtectGroup protectGroup, ProtectGroupReplica protectGroupReplica, Schedule schedule) {
        IProtectionTaskService service = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
        if (DrmEnumDefine.ProtectLocation.C_C.getValue() == protectGroupReplica.getProtectLocation() && (DrmEnumDefine.ProtectLocation.B_C.getValue() == schedule.getProtectLocation() || DrmEnumDefine.ProtectLocation.A_C.getValue() == schedule.getProtectLocation())) {
            schedule.setProtectLocation(DrmEnumDefine.ProtectLocation.C_C.getValue());
            this.fillStandbySpeedPolicy(schedule, protectGroupReplica, protectGroup.getReplicationReplicaByLocation(DrmEnumDefine.ProtectLocation.A_B));
            if (null != service.getTask(protectGroup.getUuid(), schedule.getScheduleId())) {
                service.updateTask(protectGroup.getUuid(), schedule);
            }
        }
        if (DrmEnumDefine.ProtectLocation.B_C.getValue() == protectGroupReplica.getProtectLocation() && DrmEnumDefine.ProtectLocation.C_C.getValue() == schedule.getProtectLocation()) {
            schedule.setProtectLocation(protectGroupReplica.getProtectLocation());
            this.deleteStandbySpeedPolicy(schedule, protectGroupReplica, protectGroup.getReplicationReplicaByLocation(DrmEnumDefine.ProtectLocation.A_B));
            if (null != service.getTask(protectGroup.getUuid(), schedule.getScheduleId())) {
                service.updateTask(protectGroup.getUuid(), schedule);
            }
        }
    }
}

