/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.util;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceProxyExtend;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceProxyLocator;
import com.huawei.ism.drm.storage.hvs.protection.util.IReplicationPairQuery;
import com.huawei.ism.drm.storage.hvs.protection.util.IReplicationPairQueryService;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtMineSideService;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationUtil;
import com.huawei.ism.drm.storage.protection.util.DRRingCommUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.unistor.sdk.model.HyperDRRing;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;

public class DRRingUtil
extends ReplicationUtil {
    public static final String PREFIX = "hyper-dr-ring-uuid#";
    public static final String STANDBY = "110";
    public static final String HYPER_DR_RING_USED_RESOURCES = "hyper-dr-ring-used-resources";
    protected static final String PROTECTGROUP_PRODUCT_STORAGE = "product.storage";
    protected static final String PROTECTGROUP_RECOVERY_STORAGE = "recovery.storage";
    private static Log logger = LogFactory.getInstance(DRRingUtil.class);

    protected DRRingUtil() {
    }

    public static int getDRRingLimits(Collection<ProtectObject> protectObjects) {
        String drRingLimits = null;
        String limitsKey = "DrRing.Limits";
        for (ProtectObject protectObject : protectObjects) {
            Map props = protectObject.getProps();
            if (drRingLimits == null) {
                drRingLimits = (String)props.get(limitsKey);
                continue;
            }
            if (drRingLimits.equals(props.get(limitsKey))) continue;
            drRingLimits = "0";
            break;
        }
        drRingLimits = drRingLimits != null ? drRingLimits : "1";
        return NumberUtil.convertToInteger((Object)drRingLimits, (int)0);
    }

    public static int getDRRingLimits(ProtectObject protectObject) {
        String limitsKey;
        if (protectObject == null) {
            return 0;
        }
        Map props = protectObject.getProps();
        String drRingLimits = (String)props.get(limitsKey = "DrRing.Limits");
        drRingLimits = drRingLimits != null ? drRingLimits : "1";
        return NumberUtil.convertToInteger((Object)drRingLimits, (int)0);
    }

    public static String getProtectGroupUuidOfProtectObjects(Collection<ProtectObject> protectObjects) {
        if (protectObjects == null) {
            return null;
        }
        String protectGroupUuid = null;
        for (ProtectObject protectObject : protectObjects) {
            if (protectObject == null || null == protectObject.getProtectGroup()) continue;
            if (null != protectGroupUuid && !protectGroupUuid.equals(protectObject.getProtectGroup().getUuid())) {
                logger.error((Object)("ProtectObjects have different ProtectGroups: first: " + protectGroupUuid + ". second:" + protectObject.getProtectGroup().getUuid()));
                throw new LegoCheckedException(1073947393L);
            }
            protectGroupUuid = protectObject.getProtectGroup().getUuid();
        }
        return protectGroupUuid;
    }

    public static void checkDRRingsUsedByOtherProtectGroup(List<ProtectObject> protectObjects, Collection<String> usedDrRingIds, Collection<String> productStorages) {
        String ownerProtectGroupUuid;
        Collection drRingUuids = DRRingCommUtil.convertDRRingIdsToDRRingUuids(usedDrRingIds, productStorages);
        Collection<Collection<Object>> hasBeenUsedDRRings = DRRingUtil.checkDRRingsUsedByOtherProtectGroup(drRingUuids, ownerProtectGroupUuid = DRRingUtil.getProtectGroupUuidOfProtectObjects(protectObjects));
        if (!hasBeenUsedDRRings.isEmpty()) {
            logger.error((Object)("Check Protected group validity failed! cause: " + "dr ring was used by other protect group: " + hasBeenUsedDRRings + ". format: [pg-name, po-name, dr-ring-uuid]"));
            throw new LegoCheckedException(1073948191L);
        }
    }

    public static void checkDRRingsUsedByOtherProtectGroup(List<ProtectObject> protectObjects, Collection<String> usedDrRingIds, Collection<String> productStorages, Collection<String> checkStorageSns) {
        DRRingUtil.checkDRRingsUsedByOtherProtectGroup(protectObjects, usedDrRingIds, productStorages);
        Collection drRingUuids = DRRingCommUtil.convertDRRingIdsToDRRingUuids(usedDrRingIds, checkStorageSns);
        String sql = "from HyperDRRing where uuid in (:rings)";
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        Session session = null;
        try {
            session = baseDao.getHibernateTemplate().getSessionFactory().openSession();
            Query query = session.createQuery(sql);
            query.setParameterList("rings", drRingUuids);
            List records = query.list();
            if (records == null || records.size() != drRingUuids.size()) {
                logger.error((Object)("dr ring was not in database, drRingUuids: " + drRingUuids));
                throw new LegoCheckedException(1073948191L);
            }
        }
        catch (HibernateException e) {
            try {
                logger.error((Object)("check dr rings in database failed. " + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DRRingUtil.close(session);
                throw throwable;
            }
        }
        DRRingUtil.close(session);
    }

    public static Collection<Collection<Object>> checkDRRingsUsedByOtherProtectGroup(Collection<String> drRingIds, String ownerProtectGroupUuid) {
        HashSet<List<Object>> hashSet;
        List records;
        Session session;
        block9: {
            if (drRingIds == null || drRingIds.isEmpty()) {
                return Collections.emptyList();
            }
            StringBuilder sql = new StringBuilder("select pg.pgname, po.poname, pop.propvalue from ti_protectobject po").append(" left join ti_po_prop pop on pop.poid = po.poid").append(" left join ti_protectgroup pg on pg.pgid = po.pgid").append(" where pop.propname like 'hyper-dr-ring-uuid#%'").append(" and pop.propvalue in(:rings)");
            if (ownerProtectGroupUuid != null) {
                sql.append(" and pg.pgid <> :pgid");
            }
            IBaseDao baseDao = CommonDAOLocator.getBaseDao();
            session = null;
            session = baseDao.getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(sql.toString());
            query.setParameterList("rings", drRingIds);
            if (ownerProtectGroupUuid != null) {
                query.setParameter("pgid", (Object)ownerProtectGroupUuid);
            }
            if ((records = query.list()) != null) break block9;
            List<Collection<Object>> list = Collections.emptyList();
            DRRingUtil.close(session);
            return list;
        }
        try {
            HashSet<List<Object>> results = new HashSet<List<Object>>();
            for (Object record : records) {
                results.add(Arrays.asList((Object[])record));
            }
            hashSet = results;
        }
        catch (HibernateException e) {
            try {
                logger.error((Object)("check dr rings used by other protect group faild. " + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DRRingUtil.close(session);
                throw throwable;
            }
        }
        DRRingUtil.close(session);
        return hashSet;
    }

    public static StringBuilder checkRunningStatusNotMatchedRings(Collection<String> storageSNList, Collection<String> drRingIds, String drStrategy) {
        if (storageSNList == null) {
            return new StringBuilder("parameter storageSNList is null");
        }
        if (storageSNList.isEmpty()) {
            return new StringBuilder("parameter storageSNList is empty");
        }
        if (drRingIds == null) {
            return new StringBuilder("parameter drRingIds is null");
        }
        if (drRingIds.isEmpty()) {
            return new StringBuilder("parameter drRingIds is empty");
        }
        drRingIds = new HashSet<String>(drRingIds);
        HashMap<String, Collection<HyperDRRing>> ringsList = new HashMap<String, Collection<HyperDRRing>>();
        Integer count = null;
        for (String storageSN : storageSNList) {
            RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(storageSN);
            HvsDeviceProxyExtend extend = HvsDeviceProxyLocator.getInstance().getHvsDeviceProxyExtend();
            List<HyperDRRing> rings = extend.getHyperDRRings(connection, new HashSet<String>(drRingIds));
            ringsList.put(storageSN, rings);
            if (count == null) {
                count = rings.size();
                continue;
            }
            if (count.intValue() == rings.size()) continue;
            return new StringBuilder("count of dr rings is inconsistent: ").append((CharSequence)DRRingUtil.join(ringsList));
        }
        if (!DRRingUtil.checkDRRingsCongruent(ringsList)) {
            return new StringBuilder("members of dr rings is inconsistent: ").append((CharSequence)DRRingUtil.join(ringsList));
        }
        Collection<HyperDRRing> rings = DRRingUtil.spread(ringsList.values());
        HashMap<String, String> notMatches = new HashMap<String, String>();
        for (HyperDRRing ring : rings) {
            String strategy;
            if (!"1".equals(ring.getRunningState())) {
                notMatches.put(ring.getId(), ring.getDevSn());
            }
            if ((strategy = ring.getDrStrategy()) != null && strategy.equals(drStrategy)) continue;
            notMatches.put(ring.getId(), ring.getDevSn());
        }
        return DRRingUtil.join(notMatches, '@');
    }

    private static boolean checkDRRingsCongruent(Map<String, Collection<HyperDRRing>> ringsMap) {
        if (ringsMap == null) {
            ringsMap = Collections.emptyMap();
        }
        Collection<Object> last = null;
        for (Collection<Object> rings : ringsMap.values()) {
            if (last == null) {
                last = rings;
                continue;
            }
            if (DRRingUtil.checkDRRingIdsCongruent(last, rings)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkDRRingIdsCongruent(Collection<HyperDRRing> a, Collection<HyperDRRing> b) {
        a = DRRingUtil.defaults(a);
        b = DRRingUtil.defaults(b);
        return DRRingUtil.checkCongruent(DRRingUtil.convertDRRingsToDRRingIds(a), DRRingUtil.convertDRRingsToDRRingIds(b));
    }

    private static Collection<String> convertDRRingsToDRRingIds(Collection<HyperDRRing> rings) {
        if (rings == null) {
            return Collections.emptyList();
        }
        HashSet<String> results = new HashSet<String>();
        for (HyperDRRing ring : rings) {
            results.add(ring.getId());
        }
        return results;
    }

    public static StringBuilder checkDRRingConsistency(Map<String, Collection<ReplicationPair>> map) {
        map = DRRingUtil.defaults(map);
        HashMap<String, StringBuilder> results = new HashMap<String, StringBuilder>();
        for (Map.Entry<String, Collection<ReplicationPair>> entry : map.entrySet()) {
            Collection<ReplicationPair> items = entry.getValue();
            int size = items.size();
            if (size <= 1) {
                StringBuilder message = new StringBuilder("replication pair size is ").append(size);
                results.put(entry.getKey(), message);
                continue;
            }
            ReplicationPair[] pairs = items.toArray(new ReplicationPair[size]);
            for (int i = 1; i < size; ++i) {
                ReplicationPair aPair = pairs[i - 1];
                ReplicationPair bPair = pairs[i];
                if (DRRingUtil.equal(aPair.getDrRingId(), bPair.getDrRingId())) continue;
                StringBuilder message = (StringBuilder)results.get(entry.getKey());
                if (message == null) {
                    message = new StringBuilder("pair list is ").append(aPair.getReplicationId()).append('@').append(aPair.getSrcDevSN());
                    results.put(entry.getKey(), message);
                }
                message.append(',').append(bPair.getReplicationId()).append('@').append(bPair.getSrcDevSN());
            }
        }
        return DRRingUtil.join(results);
    }

    private static Collection<ReplicationPair> loadReplicationPairRecords(Collection<ReplicationPair> realtimePairs) {
        if (realtimePairs == null || realtimePairs.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<String> uuids = DRRingUtil.convertReplicationPairToUuid(realtimePairs);
        try {
            List<ReplicationPair> records = DRRingUtil.find("from ReplicationPair p where p.uuid in(:uuids)", "uuids", uuids);
            records = DRRingUtil.defaults(records);
            return records;
        }
        catch (DataAccessException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private static void backfillMissedDRRingId(Collection<ReplicationPair> realtimePairs, Collection<ReplicationPair> recordedPairs) {
        realtimePairs = DRRingUtil.defaults(realtimePairs);
        recordedPairs = DRRingUtil.defaults(recordedPairs);
        for (ReplicationPair real : realtimePairs) {
            ReplicationPair record;
            if (real.getDrRingId() != null || (record = DRRingUtil.getReplicationPairByUuid(recordedPairs, real.getUuid())) == null) continue;
            real.setDrRingId(record.getDrRingId());
        }
    }

    private static void backfillMissedDRRingId(Collection<ReplicationPair> realtimePairs) {
        Collection<ReplicationPair> recordedPairs = DRRingUtil.loadReplicationPairRecords(realtimePairs);
        DRRingUtil.backfillMissedDRRingId(realtimePairs, recordedPairs);
    }

    public static Collection<ReplicationPair> backfillMissedDRRingIdAndIgnoreWeeds(Collection<ReplicationPair> realtimePairs) {
        DRRingUtil.backfillMissedDRRingId(realtimePairs);
        return DRRingUtil.getReplicationRelationInDRRing(realtimePairs);
    }

    public static List<ReplicationPair> processDRRingReplicationPairs(Collection<ReplicationPair> pairs, Collection<? extends StorageResource> resources) {
        if (pairs == null) {
            return Collections.emptyList();
        }
        resources = DRRingUtil.defaults(resources);
        pairs = DRRingUtil.backfillMissedDRRingIdAndIgnoreWeeds(pairs);
        DRRingUtil.backfillLunWWN(resources, pairs);
        pairs = DRRingUtil.filterReplicationRelationByReplicationMode(pairs, 2);
        return new ArrayList<ReplicationPair>(pairs);
    }

    public static void backfillLunWWN(Collection<? extends StorageResource> resources, Collection<ReplicationPair> pairs) {
        pairs = DRRingUtil.defaults(pairs);
        for (ReplicationPair pair : pairs) {
            DRRingUtil.backfillLunWWN(resources, pair);
        }
    }

    private static void backfillLunWWN(Collection<? extends StorageResource> resources, ReplicationPair pair) {
        if (pair == null || resources == null || resources.isEmpty()) {
            return;
        }
        String id = pair.getSrcLunId();
        String sn = pair.getSrcDevSN();
        if (id == null || sn == null) {
            return;
        }
        Collection<Lun> lunList = DRRingUtil.getItemsByClassType(resources, Lun.class);
        Lun resource = DRRingUtil.getStorageResourceByIdAndSN(lunList, id, sn);
        if (resource != null) {
            pair.setSrcLunWWN(resource.getWwn());
        }
    }

    private static Lun getStorageResourceByIdAndSN(Collection<? extends Lun> resources, String id, String sn) {
        resources = DRRingUtil.defaults(resources);
        for (Lun lun : resources) {
            if (!DRRingUtil.equal(id, lun.getLunId()) || !DRRingUtil.equal(sn, lun.getDevSn())) continue;
            return lun;
        }
        return null;
    }

    private static String getStorageProviderSn(Collection<ProtectObject> protectObjects) {
        if (protectObjects == null) {
            return null;
        }
        String sn = null;
        for (ProtectObject protectObject : protectObjects) {
            Collection<Object> usedStorageResources = protectObject.getUsedStorageResourceSet();
            usedStorageResources = DRRingUtil.defaults(usedStorageResources);
            for (ProtectObjectStorageInfo protectObjectStorageInfo : usedStorageResources) {
                if (sn == null) {
                    sn = protectObjectStorageInfo.getResourceProviderSN();
                    continue;
                }
                if (sn.equals(protectObjectStorageInfo.getResourceProviderSN())) continue;
                return null;
            }
        }
        return sn;
    }

    private static <T extends ReplicationRelation> Collection<T> filterReplicationRelationByReplicationMode(Collection<T> relations, Integer replicationMode) {
        if (relations == null) {
            return Collections.emptyList();
        }
        if (replicationMode == null) {
            return relations;
        }
        ArrayList<ReplicationRelation> items = new ArrayList<ReplicationRelation>();
        for (ReplicationRelation pair : relations) {
            if (!replicationMode.equals(pair.getReplicationMode())) continue;
            items.add(pair);
        }
        return items;
    }

    private static <T extends ReplicationRelation> Collection<T> getReplicationRelationInDRRing(Collection<T> relations) {
        if (relations == null) {
            return Collections.emptyList();
        }
        HashSet<ReplicationRelation> results = new HashSet<ReplicationRelation>();
        for (ReplicationRelation relation : relations) {
            if (relation.getDrRingId() == null) continue;
            results.add(relation);
        }
        return results;
    }

    public static <T extends ReplicationRelation> boolean isAllMatchedRunningStatus(Collection<T> relations, String expectStatus) {
        if (expectStatus == null) {
            return false;
        }
        relations = DRRingUtil.defaults(relations);
        for (ReplicationRelation relation : relations) {
            String actualStatus = DRRingUtil.getReplicationRelationRunningStatus(relation);
            if (expectStatus.equals(actualStatus)) continue;
            return false;
        }
        return true;
    }

    public static <T extends ReplicationRelation> boolean isAllMatchedStandby(Collection<T> relations) {
        return DRRingUtil.isAllMatchedRunningStatus(relations, STANDBY);
    }

    public static <T extends ReplicationRelation> boolean isAnyMatchedRunningStatus(Collection<T> relations, String expectStatus) {
        if (expectStatus == null) {
            return false;
        }
        relations = DRRingUtil.defaults(relations);
        for (ReplicationRelation relation : relations) {
            String actualStatus = DRRingUtil.getReplicationRelationRunningStatus(relation);
            if (!expectStatus.equals(actualStatus)) continue;
            return true;
        }
        return false;
    }

    public static <T extends ReplicationRelation> boolean isAnyMatchedStandby(Collection<T> relations) {
        return DRRingUtil.isAnyMatchedRunningStatus(relations, STANDBY);
    }

    public static <T extends ReplicationRelation> Collection<T> getWhichNotContainStandby(Collection<Collection<T>> candidates) {
        if (candidates == null) {
            return null;
        }
        for (Collection<T> candidate : candidates) {
            if (DRRingUtil.isAnyMatchedStandby(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static <T extends ReplicationRelation> Collection<T> getWhichAllItemsIsStandby(Collection<Collection<T>> candidates) {
        if (candidates == null) {
            return Collections.emptyList();
        }
        for (Collection<T> candidate : candidates) {
            if (!DRRingUtil.isAllMatchedStandby(candidate)) continue;
            return candidate;
        }
        return Collections.emptyList();
    }

    private static Collection<Site> getRecoverySites(String sn, Collection<ProtectObjectStorageInfo> storageInfos) {
        Collection<String> storageSNList = DRRingUtil.getRecoveryStorageSNList(sn, storageInfos);
        return DRRingUtil.getSiteByStorageSn(storageSNList);
    }

    private static Collection<String> getRecoveryStorageSNList(String sn, Collection<ProtectObjectStorageInfo> storageInfos) {
        if (sn == null) {
            return Collections.emptyList();
        }
        Collection<String> pairIdList = DRRingUtil.convertStorageInfoToPairId(sn, storageInfos);
        if (pairIdList.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> storageSNList = new HashSet<String>();
        String hql = "select tgtDevSN from ReplicationTargetLun where devSn =:a and replicationPairId =:b";
        for (String pairId : pairIdList) {
            List<?> items = DRRingUtil.find(hql, new String[]{"a", "b"}, new Object[]{sn, pairId});
            for (Object item : items) {
                storageSNList.add(item.toString());
            }
        }
        return storageSNList;
    }

    public static Collection<Site> getSiteByStorageSn(Collection<String> storageSNList) {
        ArrayList<Site> sites = new ArrayList<Site>();
        for (String storageSN : storageSNList) {
            List<?> siteIdList = DRRingUtil.find("select distinct siteId from DrStorage where deviceSn = :storageSN", new String[]{"storageSN"}, new Object[]{storageSN});
            if (siteIdList.isEmpty()) continue;
            List items = DRRingUtil.find("from Site where siteId in(:siteIdList)", "siteIdList", siteIdList);
            for (Object item : items) {
                if (!(item instanceof Site)) continue;
                Site site = (Site)item;
                sites.add(site);
            }
        }
        return sites;
    }

    private static Collection<String> convertSiteToName(Collection<Site> sites) {
        if (sites == null) {
            return Collections.emptyList();
        }
        return sites.stream().map(site -> site.getName()).collect(Collectors.toList());
    }

    private static Collection<String> convertSiteToId(Collection<Site> sites) {
        if (sites == null) {
            return Collections.emptyList();
        }
        return sites.stream().map(site -> site.getSiteId()).collect(Collectors.toList());
    }

    private static Collection<String> convertStorageInfoToResourceId(String sn, Collection<ProtectObjectStorageInfo> storageInfos) {
        if (sn == null) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (ProtectObjectStorageInfo storageInfo : storageInfos) {
            if (!sn.equals(storageInfo.getResourceProviderSN())) continue;
            results.add(storageInfo.getResourceId());
        }
        return results;
    }

    private static Collection<String> convertStorageInfoToPairId(String sn, Collection<ProtectObjectStorageInfo> storageInfos) {
        Collection<String> resourceIdList = DRRingUtil.convertStorageInfoToResourceId(sn, storageInfos);
        if (resourceIdList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String resourceId : resourceIdList) {
            List items = DRRingUtil.find("select replicationId from ReplicationPair where devSn=:devSn and srcLunId = :resourceId", new String[]{"devSn", "resourceId"}, new Object[]{sn, resourceId});
            for (Object item : items) {
                results.add(item.toString());
            }
        }
        return results;
    }

    public static Map<String, Collection<ReplicationPair>> classifyReplicationPairByDRRingId(Collection<ReplicationPair> pairs) {
        pairs = DRRingUtil.defaults(pairs);
        HashMap<String, Collection<ReplicationPair>> map = new HashMap<String, Collection<ReplicationPair>>();
        for (ReplicationPair pair : pairs) {
            String drRingId = pair.getDrRingId();
            HashSet<ReplicationPair> items = (HashSet<ReplicationPair>)map.get(drRingId);
            if (items == null) {
                items = new HashSet<ReplicationPair>();
                map.put(drRingId, items);
            }
            items.add(pair);
        }
        return map;
    }

    private static Collection<String> getProductionStorageSNList(Collection<ProtectObjectStorageInfo> storageInfos) {
        if (null == storageInfos || storageInfos.isEmpty()) {
            return Collections.emptyList();
        }
        Collection wwnList = storageInfos.stream().map(item -> item.getLunWWN()).collect(Collectors.toList());
        String hql = "select distinct devSn from Lun where wwn = :wwn";
        HashSet<String> storageSNList = new HashSet<String>();
        List items = DRRingUtil.find(hql, new String[]{"wwn"}, new Object[]{wwnList.iterator().next()});
        for (Object item2 : items) {
            storageSNList.add(item2.toString());
        }
        return storageSNList;
    }

    public static List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects, List<ProtectObjectStorageInfo> storageInfos) {
        ProtectLocationPath path = new ProtectLocationPath();
        path.setProtectLocation(DrmEnumDefine.ProtectLocation.C_C.getValue());
        String sn = DRRingUtil.getStorageProviderSn(protectObjects);
        Collection<String> productionStorageSNList = DRRingUtil.getProductionStorageSNList(storageInfos);
        Collection<Site> productionSites = DRRingUtil.getSiteByStorageSn(productionStorageSNList);
        Collection<String> productionSiteNames = DRRingUtil.convertSiteToName(productionSites);
        path.setProtectedSiteName(DRRingUtil.join(productionSiteNames, ':').toString());
        Collection<String> productionSiteIds = DRRingUtil.convertSiteToId(productionSites);
        path.setProtectedSiteId(DRRingUtil.join(productionSiteIds, ':').toString());
        path.setProtectedStorageSN(DRRingUtil.join(productionStorageSNList, ':').toString());
        Collection<Site> recoverySites = DRRingUtil.getRecoverySites(sn, storageInfos);
        DRRingUtil.filterRecoverySites(productionSites, recoverySites);
        Collection<String> recoverySiteNames = DRRingUtil.convertSiteToName(recoverySites);
        path.setRecoverySiteName(DRRingUtil.join(recoverySiteNames, ':').toString());
        Collection<String> recoverySiteIds = DRRingUtil.convertSiteToId(recoverySites);
        path.setRecoverySiteId(DRRingUtil.join(recoverySiteIds, ':').toString());
        Collection<String> recoveryStorageSNList = DRRingUtil.getRecoveryStorageSNList(sn, storageInfos);
        recoveryStorageSNList.removeIf(productionStorageSNList::contains);
        path.setRecoveryStorageSN(DRRingUtil.join(recoveryStorageSNList, ':').toString());
        return Arrays.asList(path);
    }

    private static void filterRecoverySites(Collection<Site> productionSites, Collection<Site> recoverySites) {
        HashSet<String> repeatSet = new HashSet<String>();
        block0: for (Site recoverySite : recoverySites) {
            for (Site productionSite : productionSites) {
                if (!recoverySite.getSiteId().equals(productionSite.getSiteId())) continue;
                repeatSet.add(recoverySite.getSiteId());
                continue block0;
            }
        }
        if (!repeatSet.isEmpty()) {
            logger.info((Object)"Remove repeats recoverySites,siteIds is %s.", new Object[]{repeatSet});
            recoverySites.removeIf(site -> repeatSet.contains(site.getSiteId()));
        }
    }

    public static void updateProtectGroupUsedDRRingIdAfterReplicaBuild(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            return;
        }
        Map protectGroupProps = protectGroup.getProps();
        protectGroupProps.remove(HYPER_DR_RING_USED_RESOURCES);
        Collection<ProtectObject> protectObjects = DRRingUtil.defaults(protectGroup.getPolist());
        for (ProtectObject protectObject : protectObjects) {
            DRRingUtil.clearProtectObjectUsedDRRingId(protectObject);
        }
        Collection<Object> protectGroupReplicas = protectGroup.getReplicaList();
        protectGroupReplicas = DRRingUtil.defaults(protectGroupReplicas);
        HashMap<String, Collection<String>> usedResources = new HashMap<String, Collection<String>>();
        for (ProtectGroupReplica protectGroupReplica : protectGroupReplicas) {
            Collection<Object> protectObjectReplicas = protectGroupReplica.getReplicas();
            protectObjectReplicas = DRRingUtil.defaults(protectObjectReplicas);
            for (ProtectObjectReplica protectObjectReplica : protectObjectReplicas) {
                String poId = DRRingUtil.getProtectObjectIdOfProtectObjectReplica(protectObjectReplica);
                ProtectObject protectObject = DRRingUtil.getProtectObjectByUuid(protectObjects, poId);
                DRRingUtil.updateProtectObjectUsedDRRingIdAfterReplicaBuild(protectObject, protectObjectReplica, usedResources);
            }
        }
        Collection<String> collection = DRRingUtil.convertSiteToId(DRRingUtil.getSiteByStorageSn(DRRingUtil.getOrNewSet(usedResources, PROTECTGROUP_PRODUCT_STORAGE)));
        Collection<String> collection2 = DRRingUtil.convertSiteToId(DRRingUtil.getSiteByStorageSn(DRRingUtil.getOrNewSet(usedResources, PROTECTGROUP_RECOVERY_STORAGE)));
        usedResources.put("product.site", collection);
        usedResources.put("recovery.site", collection2);
        protectGroupProps.put(HYPER_DR_RING_USED_RESOURCES, DRRingUtil.json(usedResources));
    }

    private static String getProtectObjectIdOfProtectObjectReplica(ProtectObjectReplica protectObjectReplica) {
        if (protectObjectReplica == null) {
            return null;
        }
        String poId = protectObjectReplica.getPoId();
        if (poId != null) {
            return poId;
        }
        ProtectObject protectObject = protectObjectReplica.getProtectObject();
        if (protectObject != null) {
            return protectObject.getUuid();
        }
        return null;
    }

    private static ProtectObject getProtectObjectByUuid(Collection<ProtectObject> protectObjects, String uuid) {
        protectObjects = DRRingUtil.defaults(protectObjects);
        for (ProtectObject protectObject : protectObjects) {
            if (!DRRingUtil.equal(protectObject.getUuid(), uuid)) continue;
            return protectObject;
        }
        return null;
    }

    private static void updateProtectObjectUsedDRRingIdAfterReplicaBuild(ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, Map<String, Collection<String>> usedResources) {
        if (protectObject == null) {
            return;
        }
        Collection<Object> replicaStorageInfos = protectObjectReplica.getStorageInfos();
        replicaStorageInfos = DRRingUtil.defaults(replicaStorageInfos);
        for (RelicaStorageInfo relicaStorageInfo : replicaStorageInfos) {
            if (!(relicaStorageInfo instanceof RemoteStorageReplica)) continue;
            DRRingUtil.updateProObjUsedDRRingIdAfterReplicaBuild(protectObject, relicaStorageInfo, usedResources);
        }
    }

    private static void updateProObjUsedDRRingIdAfterReplicaBuild(ProtectObject protectObject, RelicaStorageInfo replicaStorageInfo, Map<String, Collection<String>> usedResources) {
        RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)replicaStorageInfo;
        String id = remoteStorageReplica.getDrRingId();
        String sn = remoteStorageReplica.getStorageProviderSN();
        if (id != null && sn != null) {
            Collection<String> keys = DRRingUtil.getProtectObjectUsedDRRingPropKeys(protectObject);
            List<String> items = DRRingUtil.range('a', 'z');
            items.removeAll(keys);
            if (items.isEmpty()) {
                return;
            }
            String key = PREFIX + items.get(0);
            String uuid = DRRingCommUtil.convertDRRingIdToDRRingUuid((String)sn, (String)id);
            protectObject.getProps().put(key, uuid);
        }
        ReplicationPairQueryAtMineSideService query = ReplicationPairQueryAtMineSideService.getInstance();
        Collection<String> productStorageInfo = DRRingUtil.getOrNewSet(usedResources, PROTECTGROUP_PRODUCT_STORAGE);
        if (remoteStorageReplica.getSynchronization().booleanValue()) {
            productStorageInfo.add(remoteStorageReplica.getSrcStorageProviderSN());
            productStorageInfo.add(remoteStorageReplica.getStorageProviderSN());
        } else {
            Map<String, Collection<ReplicationPair>> pairMap = DRRingUtil.getRelatedReplicationPairs(Arrays.asList(remoteStorageReplica), query, true);
            Collection<ReplicationPair> pairs = DRRingUtil.spread(pairMap.values());
            Iterator<ReplicationPair> it = pairs.iterator();
            while (it.hasNext()) {
                ReplicationPair pair = it.next();
                if (pair.getReplicationMode() != 1) continue;
                it.remove();
            }
            pairMap = DRRingUtil.classifyReplicationPairByProductStorageSn(pairs);
            productStorageInfo.addAll(pairMap.keySet());
            Collection<String> recoveryStorageInfo = DRRingUtil.getOrNewSet(usedResources, PROTECTGROUP_RECOVERY_STORAGE);
            pairMap = DRRingUtil.classifyReplicationPairBySecondaryStorageSN(pairs);
            recoveryStorageInfo.addAll(pairMap.keySet());
        }
    }

    private static List<String> range(char s, char e) {
        int n = e - s;
        if (n <= 0) {
            return Collections.emptyList();
        }
        HashSet<String> results = new HashSet<String>();
        for (int i = 0; i <= n; ++i) {
            results.add(String.valueOf((char)(s + i)));
        }
        return new ArrayList<String>(results);
    }

    private static Collection<String> getProtectObjectUsedDRRingPropKeys(ProtectObject protectObject) {
        if (protectObject == null) {
            return Collections.emptyList();
        }
        Map props = protectObject.getProps();
        HashSet<String> keys = new HashSet<String>();
        for (String key : props.keySet()) {
            if (key == null || !key.startsWith(PREFIX)) continue;
            keys.add(key.substring(PREFIX.length()));
        }
        return keys;
    }

    private static void clearProtectObjectUsedDRRingId(ProtectObject protectObject) {
        if (protectObject == null) {
            return;
        }
        Map props = protectObject.getProps();
        Iterator it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key == null || !key.startsWith(PREFIX)) continue;
            it.remove();
        }
    }

    public static Collection<RemoteStorageReplica> getRemoteStorageReplicas(Collection<RelicaStorageInfo> replicas) {
        replicas = DRRingUtil.defaults(replicas);
        HashSet<RemoteStorageReplica> items = new HashSet<RemoteStorageReplica>();
        for (RelicaStorageInfo replica : replicas) {
            if (!(replica instanceof RemoteStorageReplica)) continue;
            items.add((RemoteStorageReplica)replica);
        }
        return items;
    }

    public static Collection<String> convertRelicaStorageInfoToWwn(Collection<? extends RelicaStorageInfo> storageInfos) {
        storageInfos = DRRingUtil.defaults(storageInfos);
        HashSet<String> items = new HashSet<String>();
        for (RelicaStorageInfo relicaStorageInfo : storageInfos) {
            items.add(relicaStorageInfo.getProtectObjectStorageWwn());
        }
        return items;
    }

    public static Collection<Lun> convertWwnToLun(Collection<String> wwnList) {
        if ((wwnList = DRRingUtil.defaults(wwnList)).isEmpty()) {
            return Collections.emptyList();
        }
        List<?> items = DRRingUtil.find("from Lun where wwn in(:wwnList)", "wwnList", wwnList);
        return new HashSet<Lun>(items);
    }

    public static Collection<Lun> convertRelicaStorageInfoToLun(Collection<? extends RelicaStorageInfo> storageInfos) {
        return DRRingUtil.convertWwnToLun(DRRingUtil.convertRelicaStorageInfoToWwn(storageInfos));
    }

    public static Collection<String> convertLunToLunId(Collection<Lun> luns) {
        luns = DRRingUtil.defaults(luns);
        HashSet<String> results = new HashSet<String>();
        for (Lun lun : luns) {
            results.add(lun.getLunId());
        }
        return results;
    }

    public static Map<String, Collection<Lun>> classifyLunByDevSn(Collection<Lun> lunList) {
        if ((lunList = DRRingUtil.defaults(lunList)).isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<Lun>> map = new HashMap<String, Collection<Lun>>();
        for (Lun lun : lunList) {
            String devSn = lun.getDevSn();
            HashSet<Lun> items = (HashSet<Lun>)map.get(devSn);
            if (items == null) {
                items = new HashSet<Lun>();
                map.put(devSn, items);
            }
            items.add(lun);
        }
        return map;
    }

    public static ProtectGroupReplica getProtectGroupReplicaByLocation(Collection<ProtectGroupReplica> replicas, int location) {
        replicas = DRRingUtil.defaults(replicas);
        for (ProtectGroupReplica replica : replicas) {
            if (replica == null || replica.getProtectLocation() != location) continue;
            return replica;
        }
        return null;
    }

    public static Collection<ProtectObjectReplica> getProtectObjectReplicas(ProtectGroupReplica replica) {
        if (replica == null) {
            return Collections.emptyList();
        }
        return DRRingUtil.defaults(replica.getReplicas());
    }

    public static Collection<RelicaStorageInfo> getRelicaStorageInfos(Collection<ProtectObjectReplica> replicas) {
        replicas = DRRingUtil.defaults(replicas);
        HashSet<RelicaStorageInfo> items = new HashSet<RelicaStorageInfo>();
        for (ProtectObjectReplica replica : replicas) {
            items.addAll(replica.getStorageInfos());
        }
        return items;
    }

    public static Collection<RelicaStorageInfo> getRelicaStorageInfos(ProtectGroupReplica replica) {
        return DRRingUtil.getRelicaStorageInfos(DRRingUtil.getProtectObjectReplicas(replica));
    }

    public static Collection<RemoteStorageReplica> getRemoteStorageReplicas(ProtectGroupReplica replica) {
        return DRRingUtil.getRemoteStorageReplicas(DRRingUtil.getRelicaStorageInfos(replica));
    }

    public static Map<String, Collection<ReplicationPair>> getRelatedReplicationPairs(Collection<? extends RelicaStorageInfo> storageInfos, final IReplicationPairQueryService service, final boolean fromDevice) {
        return DRRingUtil.getRelatedReplicationPairs(storageInfos, new IReplicationPairQuery(){

            @Override
            public Collection<ReplicationPair> getReplicationPairsByLun(Collection<Lun> luns) {
                return service.fromDevice(fromDevice).getReplicationPairsByLun(luns);
            }

            @Override
            public Collection<ReplicationPair> getReplicationPairsByLun(String devSn, Collection<String> luns) {
                return service.fromDevice(fromDevice).getReplicationPairsByLun(devSn, luns);
            }
        });
    }

    public static Map<String, Collection<ReplicationPair>> getRelatedReplicationPairs(Collection<? extends RelicaStorageInfo> storageInfos, IReplicationPairQuery query) {
        Collection<Lun> lunList = DRRingUtil.convertRelicaStorageInfoToLun(storageInfos);
        if (lunList.isEmpty()) {
            lunList = DRRingUtil.convertReplicationPairToSrcLunFromRemote(storageInfos);
        }
        Collection<ReplicationPair> pairs = DRRingUtil.getRelatedReplicationPairsByQuery(query, lunList);
        Collection<String> wwnList = DRRingUtil.getProtectObjectStorageWwnOfRelicaStorageInfo(storageInfos);
        return DRRingUtil.classifyReplicationPairByStorageWwn(wwnList, pairs);
    }

    private static Collection<Lun> convertReplicationPairToSrcLunFromRemote(Collection<? extends RelicaStorageInfo> storageInfos) {
        Map<RelicaStorageInfo, Collection<Lun>> lunMap = DRRingUtil.getLunByRelicaStorageInfoTarget(storageInfos);
        Map<RelicaStorageInfo, Collection<String>> wwnMap = DRRingUtil.getWwnOfLun(lunMap);
        Map<RelicaStorageInfo, Collection<ReplicationPair>> pairMap = DRRingUtil.getReplicationPairByTgtWwn(wwnMap);
        return DRRingUtil.convertReplicationPairToSrcLun(pairMap);
    }

    private static Collection<Lun> convertReplicationPairToSrcLun(Map<RelicaStorageInfo, Collection<ReplicationPair>> pairMap) {
        HashSet<Lun> luns = new HashSet<Lun>();
        for (Map.Entry<RelicaStorageInfo, Collection<ReplicationPair>> entry : pairMap.entrySet()) {
            Collection<Lun> items = DRRingUtil.convertReplicationPairToSrcLun(entry.getValue());
            for (Lun item : items) {
                item.setWwn(entry.getKey().getProtectObjectStorageWwn());
                luns.add(item);
            }
        }
        return luns;
    }

    private static Collection<Lun> convertReplicationPairToSrcLun(Collection<ReplicationPair> pairs) {
        HashSet<Lun> luns = new HashSet<Lun>();
        pairs = DRRingUtil.defaults(pairs);
        for (ReplicationPair pair : pairs) {
            Lun lun = new Lun();
            String srcDevSn = pair.getSrcDevSN();
            String srcLunId = pair.getSrcLunId();
            lun.setDevSn(srcDevSn);
            lun.setLunId(srcLunId);
            lun.setName(srcDevSn + ":" + srcLunId);
            luns.add(lun);
        }
        return luns;
    }

    private static Map<RelicaStorageInfo, Collection<ReplicationPair>> getReplicationPairByTgtWwn(Map<RelicaStorageInfo, Collection<String>> wwnMap) {
        HashMap<RelicaStorageInfo, Collection<ReplicationPair>> results = new HashMap<RelicaStorageInfo, Collection<ReplicationPair>>();
        for (Map.Entry<RelicaStorageInfo, Collection<String>> entry : wwnMap.entrySet()) {
            results.put(entry.getKey(), DRRingUtil.getReplicationPairByTgtWwn(entry.getValue()));
        }
        return results;
    }

    private static Collection<ReplicationPair> getReplicationPairByTgtWwn(Collection<String> wwnList) {
        wwnList = DRRingUtil.defaults(wwnList);
        Collection<Lun> luns = DRRingUtil.findLunByWwn(wwnList);
        String hql = "from ReplicationTargetLun where tgtLunId = :id and tgtDevSN = :sn";
        List<String> params = Arrays.asList("id", "sn");
        HashSet<ReplicationPair> pairs = new HashSet<ReplicationPair>();
        for (Lun lun : luns) {
            ArrayList<String> values = new ArrayList<String>(Arrays.asList(lun.getLunId(), lun.getDevSn()));
            Collection<ReplicationTargetLun> targets = DRRingUtil.find(hql, params, values, ReplicationTargetLun.class);
            Map<String, Collection<ReplicationTargetLun>> targetMap = DRRingUtil.classify(targets, "replicationPairId", String.class);
            pairs.addAll(DRRingUtil.findReplicationPairById(lun.getDevSn(), targetMap));
        }
        return pairs;
    }

    private static Collection<ReplicationPair> findReplicationPairById(String devSn, Map<String, Collection<ReplicationTargetLun>> targetMap) {
        HashSet<ReplicationPair> pairs = new HashSet<ReplicationPair>();
        for (Map.Entry<String, Collection<ReplicationTargetLun>> entry : targetMap.entrySet()) {
            Collection<ReplicationPair> items = DRRingUtil.findReplicationPairOfSecondaryInDrRingById(devSn, entry.getKey());
            for (ReplicationPair item : items) {
                item.setRepTgtLuns(DRRingUtil.getReplicationTargetLunByDevSn(entry.getValue(), item.getDevSn()));
                pairs.add(item);
            }
        }
        return pairs;
    }

    private static List<ReplicationTargetLun> getReplicationTargetLunByDevSn(Collection<ReplicationTargetLun> targets, String devSn) {
        ArrayList<ReplicationTargetLun> results = new ArrayList<ReplicationTargetLun>();
        targets = DRRingUtil.defaults(targets);
        for (ReplicationTargetLun target : targets) {
            if (!DRRingUtil.equal(devSn, target.getDevSn())) continue;
            results.add(target);
        }
        return results;
    }

    private static Collection<ReplicationPair> findReplicationPairOfSecondaryInDrRingById(String devSn, String replicationId) {
        List<String> params = Arrays.asList("id", "sn");
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(replicationId, devSn));
        return DRRingUtil.find("from ReplicationPair where replicationId = :id and devSn = :sn and drRingId is not null", params, values, ReplicationPair.class);
    }

    private static Map<RelicaStorageInfo, Collection<String>> getWwnOfLun(Map<RelicaStorageInfo, Collection<Lun>> lunMap) {
        HashMap<RelicaStorageInfo, Collection<String>> results = new HashMap<RelicaStorageInfo, Collection<String>>();
        for (Map.Entry<RelicaStorageInfo, Collection<Lun>> entry : lunMap.entrySet()) {
            results.put(entry.getKey(), DRRingUtil.getWwnOfLun(entry.getValue()));
        }
        return results;
    }

    private static Collection<String> getWwnOfLun(Collection<Lun> luns) {
        return DRRingUtil.get(luns, "wwn", String.class);
    }

    private static Map<RelicaStorageInfo, Collection<Lun>> getLunByRelicaStorageInfoTarget(Collection<? extends RelicaStorageInfo> storageInfos) {
        storageInfos = DRRingUtil.defaults(storageInfos);
        HashMap<RelicaStorageInfo, Collection<Lun>> map = new HashMap<RelicaStorageInfo, Collection<Lun>>();
        for (RelicaStorageInfo relicaStorageInfo : storageInfos) {
            HashSet<Lun> luns = (HashSet<Lun>)map.get(relicaStorageInfo);
            if (luns == null) {
                luns = new HashSet<Lun>();
                map.put(relicaStorageInfo, luns);
            }
            luns.addAll(DRRingUtil.getLunByRelicaStorageInfoTarget(relicaStorageInfo));
        }
        return map;
    }

    private static Collection<Lun> getLunByRelicaStorageInfoTarget(RelicaStorageInfo storageInfo) {
        if (storageInfo == null) {
            return null;
        }
        return DRRingUtil.getLunByIdAndSn(storageInfo.getStorageId(), storageInfo.getStorageProviderSN());
    }

    private static Collection<Lun> getLunByIdAndSn(String id, String sn) {
        List<String> params = Arrays.asList("id", "sn");
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(id, sn));
        return DRRingUtil.find("from Lun where lunId=:id and devSn = :sn", params, values, Lun.class);
    }

    private static Collection<ReplicationPair> getRelatedReplicationPairsByQuery(IReplicationPairQuery query, Collection<Lun> lunList) {
        Map<String, Collection<Lun>> devSnLunMap = DRRingUtil.classifyLunByDevSn(lunList);
        HashMap<String, Collection<ReplicationPair>> results = new HashMap<String, Collection<ReplicationPair>>();
        for (Map.Entry<String, Collection<Lun>> entry : devSnLunMap.entrySet()) {
            Collection<Lun> luns = entry.getValue();
            Collection<ReplicationPair> reals = query.getReplicationPairsByLun(luns);
            reals = DRRingUtil.defaults(reals);
            Collection<ReplicationPair> fills = DRRingUtil.backfillMissedDRRingIdAndIgnoreWeeds(reals);
            DRRingUtil.backfillLunWWN(luns, fills);
            results.put(entry.getKey(), fills);
        }
        Collection<ReplicationPair> pairs = DRRingUtil.spread(results.values());
        return pairs;
    }

    public static Collection<String> getProtectObjectStorageWwnOfRelicaStorageInfo(Collection<? extends RelicaStorageInfo> relicaStorageInfos) {
        return DRRingUtil.get(relicaStorageInfos, "protectObjectStorageWwn", String.class);
    }

    public static Map<String, Collection<ReplicationPair>> getRelatedReplicationPairsAndUpdateRunningStatus(Collection<? extends RelicaStorageInfo> storageInfos, IReplicationPairQueryService service) {
        Map<String, Collection<ReplicationPair>> recordedResults = DRRingUtil.getRelatedReplicationPairs(storageInfos, service, false);
        Map<String, Collection<ReplicationPair>> realtimeResults = DRRingUtil.getRelatedReplicationPairs(storageInfos, service, true);
        for (Map.Entry<String, Collection<ReplicationPair>> entry : recordedResults.entrySet()) {
            Collection<ReplicationPair> recordedPairs = entry.getValue();
            Collection<ReplicationPair> realtimePairs = realtimeResults.get(entry.getKey());
            DRRingUtil.updateRecodedPairStatusByRealtimePair(recordedPairs, realtimePairs);
        }
        return recordedResults;
    }

    private static void updateRecodedPairStatusByRealtimePair(Collection<ReplicationPair> recordedPairs, Collection<ReplicationPair> realtimePairs) {
        recordedPairs = DRRingUtil.defaults(recordedPairs);
        realtimePairs = DRRingUtil.defaults(realtimePairs);
        for (ReplicationPair recordedPair : recordedPairs) {
            ReplicationPair realtimePair = DRRingUtil.getReplicationPairByUuid(realtimePairs, recordedPair.getUuid());
            String status = realtimePair != null ? DRRingUtil.getReplicationPairRunningStatus(realtimePair) : null;
            Integer state = NumberUtil.convertToInteger((Object)status, (int)XveEuumDefineParent.RUNNING_STATUS_E.INVALID.getValue());
            DRRingUtil.updateReplicationPairStatus(recordedPair, state);
        }
    }

    private static void updateReplicationPairStatus(ReplicationPair pair, Integer status) {
        pair.setRunningState(String.valueOf(status));
        Collection<ReplicationTargetLun> targets = DRRingUtil.defaults(pair.getRepTgtLuns());
        for (ReplicationTargetLun target : targets) {
            target.setPairStatus(status);
        }
    }

    public static boolean checkReplicaMatched(RemoteStorageReplica replica, ReplicationPair pair) {
        boolean matched = DRRingUtil.equal(replica.getSrcStorageId(), pair.getSrcLunId());
        matched = matched && DRRingUtil.equal(replica.getSrcStorageProviderSN(), pair.getDevSn());
        matched = matched && DRRingUtil.getReplicationTargetLunByTgtLunIdAndDevSn(pair.getRepTgtLuns(), replica.getStorageId(), replica.getStorageProviderSN()) != null;
        return matched;
    }

    public static boolean checkAllRemoteStorageReplicasMatched(Collection<RemoteStorageReplica> replicas, Collection<ReplicationPair> pairs) {
        pairs = DRRingUtil.defaults(pairs);
        replicas = DRRingUtil.defaults(replicas);
        for (RemoteStorageReplica replica : replicas) {
            ReplicationPair pair = DRRingUtil.getReplicationPairByRemoteStorageReplica(pairs, replica);
            if (pair != null) continue;
            return false;
        }
        return true;
    }

    public static Collection<ReplicationPair> getWhichMatchAllRemoteStorageReplicas(Collection<Collection<ReplicationPair>> candidates, Collection<RemoteStorageReplica> replicas) {
        for (Collection<ReplicationPair> candidate : candidates) {
            if (!DRRingUtil.checkAllRemoteStorageReplicasMatched(replicas, candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static StringBuilder checkGroupConsistent(Collection<HyperMetroPair> hyperMetroPairs, Collection<ReplicationPair> replicationPairs) {
        hyperMetroPairs = DRRingUtil.defaults(hyperMetroPairs);
        replicationPairs = DRRingUtil.defaults(replicationPairs);
        Map<String, Collection<HyperMetroPair>> hyperMetroPairGroups = DRRingUtil.classify(hyperMetroPairs, "cgId", String.class);
        Collection<Collection<ReplicationPair>> replicationPairGroups = DRRingUtil.classify(replicationPairs, "consistentGroupId", String.class).values();
        HashMap<String, Collection<String>> message = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, Collection<HyperMetroPair>> entry : hyperMetroPairGroups.entrySet()) {
            Collection<HyperMetroPair> hyperMetroPairGroup = entry.getValue();
            Collection<String> wwnList = DRRingUtil.get(hyperMetroPairGroup, "resourceWwn", String.class);
            Collection<ReplicationPair> pairs = DRRingUtil.getReplicationPairBySrcWwn(replicationPairGroups, wwnList);
            if (pairs == null) {
                pairs = DRRingUtil.getReplicationPairByTgtWwn(replicationPairGroups, wwnList);
            }
            if (pairs != null) continue;
            message.put("hypermetro pair " + entry.getKey(), wwnList);
        }
        return DRRingUtil.join(message);
    }

    public static StringBuilder updateProtectGroupReplica(List<ProtectGroupReplica> replicas, List<ReplicationPair> pairs) {
        Map<String, Collection<ReplicationPair>> pairMap = ReplicationUtil.classifyReplicationPairByHyperMetroSide(pairs);
        if (null == pairMap) {
            return new StringBuilder("pair map is empty.");
        }
        Collection<ReplicationPair> normalSideReplicationPairs = DRRingUtil.getWhichNotContainStandby(pairMap.values());
        Collection<ReplicationPair> standbySideReplicationPairs = DRRingUtil.getWhichAllItemsIsStandby(pairMap.values());
        if (normalSideReplicationPairs.size() != standbySideReplicationPairs.size()) {
            return new StringBuilder("number of replication pairs at both side are not the same");
        }
        if (normalSideReplicationPairs.isEmpty()) {
            return new StringBuilder("replication pair list should not be empty.");
        }
        boolean intersection = DRRingUtil.checkIntersection(normalSideReplicationPairs, standbySideReplicationPairs);
        if (intersection) {
            return new StringBuilder("running status of replication pairs is messy,").append(" replication pair can not contained by both side");
        }
        Collection<String> normalSideProductionArrays = DRRingUtil.getSrcDevSNOfReplicationPair(normalSideReplicationPairs);
        Collection<String> normalSideRecoveryArrays = DRRingUtil.getTgtDevSNOfReplicationPair(normalSideReplicationPairs);
        if (normalSideProductionArrays.size() != normalSideRecoveryArrays.size()) {
            return new StringBuilder("storage number of production and recovery are not the same");
        }
        if (normalSideProductionArrays.size() != 1) {
            return new StringBuilder("storage number of production and recovery are not one");
        }
        HashMap<String, StringBuilder> messages = new HashMap<String, StringBuilder>();
        for (ProtectGroupReplica replica : replicas) {
            StringBuilder message = DRRingUtil.updateProtectGroupReplica(pairMap, normalSideReplicationPairs, standbySideReplicationPairs, replica);
            if (message.length() <= 0) continue;
            messages.put(replica.getId(), message);
        }
        StringBuilder message = DRRingUtil.join(messages);
        if (message.length() > 0) {
            message = new StringBuilder("update protect group replica filed. ").append((CharSequence)message);
        }
        return message;
    }

    private static StringBuilder updateProtectGroupReplica(Map<String, Collection<ReplicationPair>> pairMap, Collection<ReplicationPair> normalSideReplicationPairs, Collection<ReplicationPair> standbySideReplicationPairs, ProtectGroupReplica replica) {
        int nr;
        String currentHyperMetroNormalSide = replica.getProductArray();
        Collection<ReplicationPair> currentSideReplicationPairs = pairMap.get(currentHyperMetroNormalSide);
        if (currentSideReplicationPairs == null) {
            currentHyperMetroNormalSide = replica.getRecoveryArray();
            currentSideReplicationPairs = pairMap.get(currentHyperMetroNormalSide);
        }
        if (currentSideReplicationPairs == null) {
            return new StringBuilder("not found replication pairs for the current side of replica");
        }
        Collection<String> normalSideProductionArrays = DRRingUtil.getSrcDevSNOfReplicationPair(normalSideReplicationPairs);
        Collection<String> normalSideRecoveryArrays = DRRingUtil.getTgtDevSNOfReplicationPair(normalSideReplicationPairs);
        int np = normalSideProductionArrays.size();
        if (np != (nr = normalSideRecoveryArrays.size()) || np != 1) {
            return new StringBuilder("storage number of production and recovery both should be one");
        }
        String normalSideProductionArray = new ArrayList<String>(normalSideProductionArrays).get(0);
        String normalSideRecoveryArray = new ArrayList<String>(normalSideRecoveryArrays).get(0);
        if (standbySideReplicationPairs.equals(currentSideReplicationPairs)) {
            replica.setProductArray(normalSideProductionArray);
            replica.setRecoveryArray(normalSideRecoveryArray);
        }
        return new StringBuilder();
    }

    public static String checkDRRingLimitsForProtectObjects(List<ProtectObject> protectObjects, Collection<ReplicationPair> allRelatedReplicationPairs) {
        ArrayList<StringBuilder> messages = new ArrayList<StringBuilder>();
        for (ProtectObject protectObject : protectObjects) {
            StringBuilder message = DRRingUtil.checkDRRingLimitsForProtectObjects(protectObject, allRelatedReplicationPairs);
            if (message.length() <= 0) continue;
            messages.add(message);
        }
        return messages.isEmpty() ? "" : ((Object)messages).toString();
    }

    private static StringBuilder checkDRRingLimitsForProtectObjects(ProtectObject protectObject, Collection<ReplicationPair> allRelatedReplicationPairs) {
        allRelatedReplicationPairs = DRRingUtil.getReplicationPairsByProtectObject(allRelatedReplicationPairs, protectObject);
        int drRingLimits = DRRingUtil.getDRRingLimits(protectObject);
        if (drRingLimits == 0) {
            return new StringBuilder("May encounter tampering attacks, because drRingLimits should be 1 or 2, not 0");
        }
        Map<String, Collection<ReplicationPair>> drRingIdPairMap = DRRingUtil.classifyReplicationPairByDRRingId(allRelatedReplicationPairs);
        Set<String> usedDrRingIds = drRingIdPairMap.keySet();
        if (usedDrRingIds.size() != drRingLimits) {
            return new StringBuilder("size limit of dr-ring list must be ").append(drRingLimits).append("(size limit 0 may be have error in DrRing.Limits of PO ). but ring count actual is ").append(drRingIdPairMap.size()).append(". protect object id: ").append(protectObject.getUuid()).append(", protect object name:").append(protectObject.getName()).append(", dr-ring list: ").append(usedDrRingIds);
        }
        return new StringBuilder();
    }

    public static Collection<Lun> getLunByRelicaStorageInfo(Collection<? extends RelicaStorageInfo> storageInfos) {
        Collection<Lun> lunList = DRRingUtil.convertRelicaStorageInfoToLun(storageInfos);
        if (lunList.isEmpty()) {
            lunList = DRRingUtil.convertReplicationPairToSrcLunFromRemote(storageInfos);
        }
        return lunList;
    }

    public static Collection<String> getOfflineNe(Collection<RemoteStorageReplica> replicas) {
        Collection<Lun> lunCollection = DRRingUtil.getLunByRelicaStorageInfo(replicas);
        return DRRingUtil.getOfflineNeByLun(lunCollection);
    }

    public static Collection<String> getOfflineNeByLun(Collection<Lun> lunCollection) {
        if (VerifyUtil.isEmpty(lunCollection)) {
            return Collections.emptySet();
        }
        HashSet<String> storagesSns = new HashSet<String>();
        for (Lun lun : lunCollection) {
            if (VerifyUtil.isEmpty((String)lun.getDevSn())) continue;
            storagesSns.add(lun.getDevSn());
        }
        return DRRingCommUtil.getOfflineNeBySn(storagesSns);
    }

    public static Map<String, Collection<ReplicationPair>> getRelatedReplicationPairs(Collection<? extends RelicaStorageInfo> storageInfos, Collection<String> offlineNeSn, IReplicationPairQuery query) {
        Collection<Lun> lunList = DRRingUtil.getLunByRelicaStorageInfo(storageInfos);
        lunList.removeIf(lun -> offlineNeSn.contains(lun.getDevSn()));
        Collection<ReplicationPair> pairs = DRRingUtil.getRelatedReplicationPairsByQuery(query, lunList);
        Collection<String> wwnList = DRRingUtil.getProtectObjectStorageWwnOfRelicaStorageInfo(storageInfos);
        return DRRingUtil.classifyReplicationPairByStorageWwn(wwnList, pairs);
    }

    public static Map<String, Collection<ReplicationPair>> getRelatedReplicationPairsInDb(Collection<? extends RelicaStorageInfo> storageInfos) {
        Collection<Lun> lunList = DRRingUtil.convertRelicaStorageInfoToLun(storageInfos);
        ArrayList<ReplicationPair> pairs = new ArrayList<ReplicationPair>();
        for (Lun lun : lunList) {
            Collection<?> records;
            String hql;
            try {
                List<String> paramNames = Arrays.asList("srcLunId", "srcDevSN", "relationType", "isPrimary");
                List<Object> values = Arrays.asList(lun.getLunId(), lun.getDevSn(), 0, true);
                hql = "from ReplicationPair p where p.srcLunId=:srcLunId and p.srcDevSN=:srcDevSN and p.relationType=:relationType and p.isPrimary=:isPrimary";
                records = DRRingUtil.find(hql, paramNames, values);
                records = DRRingUtil.defaults(records);
                pairs.addAll(records);
            }
            catch (DataAccessException ex) {
                logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
                throw new LegoCheckedException(-1L, (Throwable)ex);
            }
            for (ReplicationPair pair : records) {
                pair.setSrcLunWWN(lun.getWwn());
                hql = "from ReplicationTargetLun where replicationPairId=:replicationPairId and devSn=:devSn";
                pair.setRepTgtLuns(DRRingUtil.find(hql, Arrays.asList("replicationPairId", "devSn"), Arrays.asList(pair.getReplicationId(), pair.getSrcDevSN())));
            }
        }
        Collection<String> wwnList = DRRingUtil.getProtectObjectStorageWwnOfRelicaStorageInfo(storageInfos);
        return DRRingUtil.classifyReplicationPairByStorageWwn(wwnList, pairs);
    }
}

