/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtMineSideService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ReplicationPairQueryAtBothSideService
extends ReplicationPairQueryAtMineSideService {
    private static Log logger = LogFactory.getInstance(ReplicationPairQueryAtBothSideService.class);
    private static final ReplicationPairQueryAtBothSideService INSTANCE = new ReplicationPairQueryAtBothSideService();
    private ISiteService siteService;
    private IResourceService resourceService;

    protected ReplicationPairQueryAtBothSideService() {
    }

    public ISiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteService siteService) {
        this.siteService = siteService;
    }

    public IResourceService getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(IResourceService resourceService) {
        this.resourceService = resourceService;
    }

    @Override
    public Collection<ReplicationPair> getReplicationPairsByLun(String devSn, Collection<String> luns) {
        Collection<ReplicationPair> pairs;
        Site site = this.getSiteByDeviceSN(devSn);
        if (site == null) {
            logger.error((Object)"site param is null");
            return Collections.emptyList();
        }
        if (1 == site.getSiteType()) {
            RestClient client = SiteUtil.initClient((Site)site);
            try {
                HashMap<String, Object> uriVariabels = new HashMap<String, Object>();
                uriVariabels.put("devSn", devSn);
                uriVariabels.put("lunIds", DRRingUtil.join(luns, ';'));
                uriVariabels.put("isFromDevice", this.fromDevice());
                Collection<Object> pairs2 = client.getForObjects("/ws/storages/{devSn}/action/getReplicationPairBySrcLunIds?lunIds={lunIds}&isFromDevice={isFromDevice}", uriVariabels, ReplicationPair.class);
                pairs2 = DRRingUtil.defaults(pairs2);
                for (ReplicationPair replicationPair : pairs2) {
                    if (!VerifyUtil.isEmpty((String)replicationPair.getUuid())) continue;
                    String uuid = DRRingUtil.convertReplicationPairToUuid(replicationPair);
                    replicationPair.setUuid(uuid);
                }
                return pairs2;
            }
            catch (Exception e) {
                logger.error((Object)("getPairsByLun from remote site LegoCheckedException., lunIds:" + luns + ", devSn:" + devSn + ExceptionUtil.getErrorMessage((Throwable)e)));
                pairs = null;
            }
        } else {
            pairs = super.getReplicationPairsByLun(devSn, luns);
        }
        return DRRingUtil.defaults(pairs);
    }

    protected Site getSiteByDeviceSN(String deviceSN) {
        if (deviceSN == null) {
            logger.error((Object)"deviceSN param is null");
            return null;
        }
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null != drResource) {
            return this.getSiteService().getSiteById(drResource.getSiteId());
        }
        return null;
    }

    public static ReplicationPairQueryAtBothSideService getInstance() {
        return INSTANCE;
    }
}

