/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.util;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.IReplicationPairQuery;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtBothSideService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ReplicationUtil
extends CommonUtil {
    protected ReplicationUtil() {
    }

    public static List<ReplicationPair> getReplicationPairsByWwn(Collection<ReplicationPair> pairs, String wwn) {
        if (pairs == null || wwn == null) {
            return Collections.emptyList();
        }
        ArrayList<ReplicationPair> items = new ArrayList<ReplicationPair>();
        for (ReplicationPair pair : pairs) {
            if (!wwn.equals(pair.getSrcLunWWN())) continue;
            items.add(pair);
        }
        return items;
    }

    public static List<ReplicationPair> getReplicationPairsByWwn(Collection<ReplicationPair> pairs, Collection<String> wwnList) {
        wwnList = ReplicationUtil.defaults(wwnList);
        ArrayList<ReplicationPair> items = new ArrayList<ReplicationPair>();
        for (String wwn : wwnList) {
            items.addAll(ReplicationUtil.getReplicationPairsByWwn(pairs, wwn));
        }
        return items;
    }

    public static List<ReplicationPair> getReplicationPairsByProtectObject(Collection<ReplicationPair> pairs, ProtectObject protectObject) {
        Collection<String> wwnList = DRRingUtil.getLunWWNOfProtectObjectStorageInfo(protectObject);
        return ReplicationUtil.getReplicationPairsByWwn(pairs, wwnList);
    }

    public static List<HyperMetroPair> getHyperMetroPairsByWwn(Collection<HyperMetroPair> pairs, String wwn) {
        pairs = ReplicationUtil.defaults(pairs);
        ArrayList<HyperMetroPair> items = new ArrayList<HyperMetroPair>();
        if (wwn == null) {
            return items;
        }
        for (HyperMetroPair pair : pairs) {
            if (!wwn.equals(pair.getResourceWwn())) continue;
            items.add(pair);
        }
        return items;
    }

    public static List<HyperMetroPair> getHyperMetroPairsByWwn(Collection<HyperMetroPair> pairs, Collection<String> wwnList) {
        wwnList = ReplicationUtil.defaults(wwnList);
        ArrayList<HyperMetroPair> items = new ArrayList<HyperMetroPair>();
        for (String wwn : wwnList) {
            items.addAll(ReplicationUtil.getHyperMetroPairsByWwn(pairs, wwn));
        }
        return items;
    }

    public static List<HyperMetroPair> getHyperMetroPairsByProtectObject(Collection<HyperMetroPair> pairs, ProtectObject protectObject) {
        Collection<String> wwnList = DRRingUtil.getLunWWNOfProtectObjectStorageInfo(protectObject);
        return ReplicationUtil.getHyperMetroPairsByWwn(pairs, wwnList);
    }

    public static List<HyperMetroPair> getTargetHyperMetroPairsOfProtectObject(Collection<HyperMetroPair> pairs, ProtectObject protectObject) {
        ArrayList<HyperMetroPair> results = new ArrayList<HyperMetroPair>();
        Collection<ReplicationTargetLun> targets = ReplicationUtil.getTargetLunOfProtectObject(protectObject);
        for (HyperMetroPair pair : pairs) {
            ReplicationTargetLun target = ReplicationUtil.getReplicationTargetLunByTgtLunIdAndDevSn(targets, pair.getLocalObjId(), pair.getDevSn());
            if (target == null) continue;
            results.add(pair);
        }
        return results;
    }

    public static Collection<ReplicationTargetLun> getTargetLunOfProtectObject(ProtectObject protectObject) {
        if (protectObject == null) {
            return Collections.emptyList();
        }
        return ReplicationUtil.getTargetLunOfProtectObjectStorageInfo(protectObject.getUsedStorageResourceSet());
    }

    public static Collection<ReplicationTargetLun> getTargetLunOfProtectObjectStorageInfo(Collection<ProtectObjectStorageInfo> storages) {
        Collection<String> productionLunWwnList = ReplicationUtil.getLunWWNOfProtectObjectStorageInfo(storages);
        Collection<Lun> productionLunList = ReplicationUtil.findLunByWwn(productionLunWwnList);
        IReplicationPairQuery query = ReplicationPairQueryAtBothSideService.getInstance().fromDevice(false);
        Collection<ReplicationPair> pairs = query.getReplicationPairsByLun(productionLunList);
        return ReplicationUtil.getAllTargetLunOfReplicationPairs(pairs);
    }

    public static Collection<Lun> findLunByWwn(Collection<String> wwnList) {
        if ((wwnList = ReplicationUtil.defaults(wwnList)).isEmpty()) {
            return Collections.emptyList();
        }
        List<?> items = ReplicationUtil.find("from Lun where wwn in(:wwnList)", "wwnList", wwnList);
        return ReplicationUtil.getItemsByClassType(items, Lun.class);
    }

    public static String getReplicationRelationRunningStatus(ReplicationRelation relation) {
        String actual = relation instanceof ReplicationPair ? ReplicationUtil.getReplicationPairRunningStatus((ReplicationPair)ReplicationPair.class.cast(relation)) : (relation instanceof ReplicationGroup ? ReplicationUtil.getReplicationGroupRunningStatus((ReplicationGroup)ReplicationGroup.class.cast(relation)) : null);
        return actual;
    }

    private static String getReplicationGroupRunningStatus(ReplicationGroup replicationGroup) {
        if (replicationGroup == null) {
            return null;
        }
        String runningState = replicationGroup.getRunningState();
        if (runningState != null) {
            return runningState;
        }
        Collection<ReplicationPair> pairs = ReplicationUtil.getItemsByClassType(replicationGroup.getChildMos(), ReplicationPair.class);
        if (pairs.isEmpty()) {
            return null;
        }
        for (ReplicationPair pair : pairs) {
            if (runningState == null) {
                runningState = ReplicationUtil.getReplicationPairRunningStatus(pair);
                continue;
            }
            if (ReplicationUtil.equal(ReplicationUtil.getReplicationPairRunningStatus(pair), runningState)) continue;
            return null;
        }
        return runningState;
    }

    public static String getReplicationPairRunningStatus(ReplicationPair pair) {
        Integer status;
        if (pair == null) {
            return null;
        }
        List targets = pair.getRepTgtLuns();
        String runningState = targets != null && !targets.isEmpty() ? ((status = ((ReplicationTargetLun)targets.get(0)).getPairStatus()) != null ? status.toString() : null) : null;
        if (runningState == null) {
            runningState = pair.getRunningState();
        }
        return runningState;
    }

    public static ReplicationPair getReplicationPairByWwn(Collection<ReplicationPair> pairs, String wwn) {
        List<ReplicationPair> matches = ReplicationUtil.getReplicationPairsByWwn(pairs, wwn);
        return matches != null ? matches.get(0) : null;
    }

    public static ReplicationPair getReplicationPairBySrcLunIdAndDevSn(Collection<ReplicationPair> pairs, String srcLunId, String devSn) {
        if (srcLunId == null || devSn == null) {
            return null;
        }
        pairs = ReplicationUtil.defaults(pairs);
        for (ReplicationPair pair : pairs) {
            if (!srcLunId.equals(pair.getSrcLunId()) || !devSn.equals(pair.getDevSn())) continue;
            return pair;
        }
        return null;
    }

    public static ReplicationPair getReplicationPairByRemoteStorageReplica(Collection<ReplicationPair> pairs, RemoteStorageReplica replica) {
        if (replica == null) {
            return null;
        }
        pairs = ReplicationUtil.defaults(pairs);
        for (ReplicationPair pair : pairs) {
            boolean matched = DRRingUtil.checkReplicaMatched(replica, pair);
            if (!matched) continue;
            return pair;
        }
        return null;
    }

    public static ReplicationPair getReplicationPairByUuid(Collection<ReplicationPair> pairs, String uuid) {
        if (pairs == null || uuid == null) {
            return null;
        }
        for (ReplicationPair pair : pairs) {
            if (!uuid.equals(pair.getUuid())) continue;
            return pair;
        }
        return null;
    }

    public static ReplicationTargetLun getReplicationTargetLunByTgtLunIdAndDevSn(Collection<ReplicationTargetLun> targets, String lunId, String devSn) {
        if (lunId == null || devSn == null) {
            return null;
        }
        targets = ReplicationUtil.defaults(targets);
        for (ReplicationTargetLun target : targets) {
            if (!lunId.equals(target.getTgtLunId()) || !devSn.equals(target.getTgtDevSN())) continue;
            return target;
        }
        return null;
    }

    public static Map<String, Collection<ReplicationPair>> classifyReplicationPairByHyperMetroSide(Collection<ReplicationPair> pairs) {
        Map<String, Collection<ReplicationPair>> storageSnPairMap = ReplicationUtil.classifyReplicationPairByProductStorageSn(pairs);
        if (storageSnPairMap.size() != 2) {
            storageSnPairMap = ReplicationUtil.classifyReplicationPairBySecondaryStorageSN(pairs);
        }
        return storageSnPairMap.size() == 2 ? storageSnPairMap : null;
    }

    public static Map<String, Collection<ReplicationPair>> classifyReplicationPairByHyperMetroSide(Map<String, Collection<ReplicationPair>> pairMap) {
        return ReplicationUtil.classifyReplicationPairByHyperMetroSide(ReplicationUtil.spread(pairMap.values()));
    }

    public static Map<String, Collection<ReplicationPair>> classifyReplicationPairBySecondaryStorageSN(Collection<ReplicationPair> pairs) {
        if (pairs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<ReplicationPair>> pairMap = new HashMap<String, Collection<ReplicationPair>>();
        for (ReplicationPair pair : pairs) {
            List targetLuns = pair.getRepTgtLuns();
            if (targetLuns == null) continue;
            for (ReplicationTargetLun targetLun : targetLuns) {
                String storage = targetLun.getTgtDevSN();
                if (storage == null) continue;
                HashSet<ReplicationPair> items = (HashSet<ReplicationPair>)pairMap.get(storage);
                if (items == null) {
                    items = new HashSet<ReplicationPair>();
                    pairMap.put(storage, items);
                }
                items.add(pair);
            }
        }
        return pairMap;
    }

    public static Map<String, Collection<ReplicationPair>> classifyReplicationPairByProductStorageSn(Collection<ReplicationPair> pairs) {
        if (pairs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<ReplicationPair>> pairMap = new HashMap<String, Collection<ReplicationPair>>();
        for (ReplicationPair pair : pairs) {
            String sn = pair.getSrcDevSN();
            HashSet<ReplicationPair> items = (HashSet<ReplicationPair>)pairMap.get(sn);
            if (items == null) {
                items = new HashSet<ReplicationPair>();
                pairMap.put(sn, items);
            }
            items.add(pair);
        }
        return pairMap;
    }

    public static StringBuilder checkTargetLunConsistency(Map<String, Collection<ReplicationPair>> map) {
        map = ReplicationUtil.defaults(map);
        HashMap<String, StringBuilder> results = new HashMap<String, StringBuilder>();
        for (Map.Entry<String, Collection<ReplicationPair>> entry : map.entrySet()) {
            Collection<ReplicationPair> items = entry.getValue();
            int size = items.size();
            if (size <= 1) {
                StringBuilder message = new StringBuilder("replication pair size is ").append(size);
                results.put(entry.getKey(), message);
                continue;
            }
            ReplicationPair[] pairs = items.toArray(new ReplicationPair[size]);
            for (int i = 1; i < size; ++i) {
                List bTargetLuns;
                ReplicationPair aPair = pairs[i - 1];
                ReplicationPair bPair = pairs[i];
                List aTargetLuns = aPair.getRepTgtLuns();
                if (ReplicationUtil.checkTargetLunCongruent(aTargetLuns, bTargetLuns = bPair.getRepTgtLuns())) continue;
                StringBuilder message = (StringBuilder)results.get(entry.getKey());
                if (message == null) {
                    message = new StringBuilder("pair list is ").append(aPair.getReplicationId()).append('@').append(aPair.getSrcDevSN());
                    results.put(entry.getKey(), message);
                }
                message.append(',').append(bPair.getReplicationId()).append('@').append(bPair.getSrcDevSN());
            }
        }
        return ReplicationUtil.join(results);
    }

    private static boolean checkTargetLunCongruent(Collection<ReplicationTargetLun> a, Collection<ReplicationTargetLun> b) {
        return ReplicationUtil.checkCongruent(ReplicationUtil.convertReplicationTargetLunToUuid(a), ReplicationUtil.convertReplicationTargetLunToUuid(b));
    }

    private static Collection<String> convertReplicationTargetLunToUuid(Collection<ReplicationTargetLun> targets) {
        targets = ReplicationUtil.defaults(targets);
        HashSet<String> results = new HashSet<String>();
        for (ReplicationTargetLun target : targets) {
            results.add(ReplicationUtil.convertReplicationTargetLunToUuid(target));
        }
        return results;
    }

    public static Map<String, Collection<ReplicationPair>> classifyReplicationPairByStorage(Collection<ProtectObjectStorageInfo> storageInfos, Collection<ReplicationPair> pairs) {
        Collection<String> wwnList = ReplicationUtil.getWwnOfProtectObjectStorageInfo(storageInfos);
        return ReplicationUtil.classifyReplicationPairByStorageWwn(wwnList, pairs);
    }

    public static Collection<String> getWwnOfProtectObjectStorageInfo(Collection<ProtectObjectStorageInfo> storageInfos) {
        return ReplicationUtil.get(storageInfos, "lunWWN", String.class);
    }

    public static Map<String, Collection<ReplicationPair>> classifyReplicationPairByStorageWwn(Collection<String> wwnList, Collection<ReplicationPair> pairs) {
        wwnList = ReplicationUtil.defaults(wwnList);
        pairs = ReplicationUtil.defaults(pairs);
        HashMap<String, Collection<ReplicationPair>> map = new HashMap<String, Collection<ReplicationPair>>();
        for (String wwn : wwnList) {
            HashSet<ReplicationPair> items = (HashSet<ReplicationPair>)map.get(wwn);
            if (items == null) {
                items = new HashSet<ReplicationPair>();
                map.put(wwn, items);
            }
            items.addAll(ReplicationUtil.getReplicationPairsByWwn(pairs, wwn));
        }
        return map;
    }

    private static Collection<String> convertReplicationPairToTgtDevSN(Collection<ReplicationPair> pairs) {
        pairs = ReplicationUtil.defaults(pairs);
        HashSet<String> items = new HashSet<String>();
        for (ReplicationPair pair : pairs) {
            Collection<ReplicationTargetLun> targets = ReplicationUtil.defaults(pair.getRepTgtLuns());
            for (ReplicationTargetLun target : targets) {
                items.add(target.getTgtDevSN());
            }
        }
        return items;
    }

    public static StringBuilder checkRecoveryStorageConsistency(Map<String, Collection<ReplicationPair>> map, Collection<String> recoveryStorageSNList) {
        map = ReplicationUtil.defaults(map);
        HashMap<String, Collection<String>> results = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, Collection<ReplicationPair>> entry : map.entrySet()) {
            Collection<ReplicationPair> items = entry.getValue();
            if (ReplicationUtil.checkCongruent(ReplicationUtil.convertReplicationPairToTgtDevSN(items = ReplicationUtil.defaults(items)), recoveryStorageSNList)) continue;
            results.put(entry.getKey(), ReplicationUtil.convertReplicationPairToUuid(items));
        }
        return ReplicationUtil.join(results);
    }

    public static StringBuilder checkProductStorageConsistency(Map<String, Collection<ReplicationPair>> map, Collection<String> productStorageSNList) {
        map = ReplicationUtil.defaults(map);
        HashMap<String, Collection<String>> results = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, Collection<ReplicationPair>> entry : map.entrySet()) {
            Collection<ReplicationPair> items = entry.getValue();
            if (ReplicationUtil.checkCongruent(ReplicationUtil.convertReplicationPairToSrcDevSN(items = ReplicationUtil.defaults(items)), productStorageSNList)) continue;
            results.put(entry.getKey(), ReplicationUtil.convertReplicationPairToUuid(items));
        }
        return ReplicationUtil.join(results);
    }

    private static String convertReplicationTargetLunToUuid(ReplicationTargetLun target) {
        if (target == null) {
            return null;
        }
        String sn = target.getTgtDevSN();
        String lunId = target.getTgtLunId();
        return new XveUUID(sn, XveMOType.REMOTEREPLICATIONMEMBERLUN, lunId).toString();
    }

    public static Collection<String> convertReplicationPairToUuid(Collection<ReplicationPair> pairs) {
        if (pairs == null) {
            return Collections.emptyList();
        }
        HashSet<String> results = new HashSet<String>();
        for (ReplicationPair pair : pairs) {
            results.add(ReplicationUtil.convertReplicationPairToUuid(pair));
        }
        return results;
    }

    public static String convertReplicationPairToUuid(ReplicationPair pair) {
        if (pair == null) {
            return null;
        }
        String replicationId = pair.getReplicationId();
        String moType = XveMOType.REMOTEREPLICATION.name();
        String srcDevSN = pair.getDevSn();
        String vstorePairId = pair.getVstorePairId();
        String ownerId = srcDevSN;
        if (!VerifyUtil.isEmpty((String)vstorePairId)) {
            ownerId = ownerId + "_vstorePairId=" + vstorePairId;
        }
        return DrmStorageUtil.generateMoUuid((String)replicationId, (String)moType, (String)ownerId);
    }

    private static Collection<String> convertReplicationPairToSrcDevSN(Collection<ReplicationPair> pairs) {
        pairs = ReplicationUtil.defaults(pairs);
        HashSet<String> items = new HashSet<String>();
        for (ReplicationPair pair : pairs) {
            items.add(pair.getSrcDevSN());
        }
        return items;
    }

    public static boolean checkReplicationPairConsistentByTgtWwn(Collection<ReplicationPair> replicationPairs, Collection<String> wwnList) {
        replicationPairs = ReplicationUtil.defaults(replicationPairs);
        wwnList = ReplicationUtil.defaults(wwnList);
        Collection<ReplicationTargetLun> targets = ReplicationUtil.getAllTargetLunOfReplicationPairs(replicationPairs);
        Collection<Lun> lunList = ReplicationUtil.convertReplicationTargetLunToLun(targets);
        Collection allWwn = ReplicationUtil.get(lunList, "wwn", String.class);
        return allWwn.containsAll(wwnList);
    }

    private static Collection<ReplicationTargetLun> getAllTargetLunOfReplicationPairs(Collection<ReplicationPair> replicationPairs) {
        Collection<List> items = ReplicationUtil.get(replicationPairs, "repTgtLuns", List.class);
        HashSet collection = new HashSet();
        for (List item : items) {
            collection.addAll(item);
        }
        Collection<ReplicationTargetLun> targets = ReplicationUtil.getItemsByClassType(collection, ReplicationTargetLun.class);
        return targets;
    }

    private static Collection<Lun> convertReplicationTargetLunToLun(Collection<ReplicationTargetLun> targets) {
        if ((targets = ReplicationUtil.defaults(targets)).isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Lun> lunList = new HashSet<Lun>();
        IStorageService service = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        HashMap snLunIds = new HashMap();
        for (ReplicationTargetLun replicationTargetLun : targets) {
            String tgtSn = replicationTargetLun.getTgtDevSN();
            List lunIds = (List)snLunIds.get(tgtSn);
            if (VerifyUtil.isEmpty((Collection)lunIds)) {
                ArrayList<String> lunIdsTemp = new ArrayList<String>();
                lunIdsTemp.add(replicationTargetLun.getTgtLunId());
                snLunIds.put(tgtSn, lunIdsTemp);
                continue;
            }
            lunIds.add(replicationTargetLun.getTgtLunId());
        }
        for (Map.Entry entry : snLunIds.entrySet()) {
            String sn = (String)entry.getKey();
            List tgtLuns = service.getLunsByDeviceSnAndLunIds(sn, (List)snLunIds.get(sn));
            lunList.addAll(ReplicationUtil.getItemsByClassType(tgtLuns, Lun.class));
        }
        return lunList;
    }

    public static Collection<ReplicationPair> getReplicationPairByTgtWwn(Collection<Collection<ReplicationPair>> group, Collection<String> wwnList) {
        group = ReplicationUtil.defaults(group);
        for (Collection<ReplicationPair> pairs : group) {
            if (!ReplicationUtil.checkReplicationPairConsistentByTgtWwn(pairs, wwnList)) continue;
            return pairs;
        }
        return null;
    }

    public static Collection<String> getSrcDevSNOfReplicationPair(Collection<ReplicationPair> pairs) {
        return ReplicationUtil.get(pairs, "srcDevSN", String.class);
    }

    public static Collection<String> getTgtDevSNOfReplicationPair(Collection<ReplicationPair> pairs) {
        Collection<List> normalSideTargetLunCollections = ReplicationUtil.get(pairs, "repTgtLuns", List.class);
        HashSet normalSideTargetLuns = new HashSet();
        for (List normalSideTargetLunCollection : normalSideTargetLunCollections) {
            normalSideTargetLuns.addAll(normalSideTargetLunCollection);
        }
        return ReplicationUtil.getTgtDevSNOfReplicationTargetLun(ReplicationUtil.getItemsByClassType(normalSideTargetLuns, ReplicationTargetLun.class));
    }

    public static Collection<String> getTgtDevSNOfReplicationTargetLun(Collection<ReplicationTargetLun> targets) {
        return ReplicationUtil.get(targets, "tgtDevSN", String.class);
    }

    public static Collection<String> getLunWWNOfProtectObjectStorageInfo(Collection<ProtectObjectStorageInfo> protectObjectStorageInfos) {
        return ReplicationUtil.get(protectObjectStorageInfos, "lunWWN", String.class);
    }

    public static Collection<String> getLunWWNOfProtectObjectStorageInfo(ProtectObject protectObject) {
        if (protectObject == null) {
            return Collections.emptyList();
        }
        return ReplicationUtil.getLunWWNOfProtectObjectStorageInfo(protectObject.getUsedStorageResourceSet());
    }

    public static Collection<String> getCgidOfHyperMetroPair(Collection<HyperMetroPair> pairs) {
        pairs = ReplicationUtil.defaults(pairs);
        HashSet<String> items = new HashSet<String>();
        Collection<String> cgids = DRRingUtil.get(pairs, "cgId", String.class);
        for (String cgid : cgids) {
            if (VerifyUtil.isEmpty((String)cgid)) continue;
            items.add(cgid);
        }
        return items;
    }

    public static Map<String, Collection<ReplicationPair>> classifyReplicationPairByDevSN(Collection<ReplicationPair> pairs) {
        if (pairs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<ReplicationPair>> pairMap = new HashMap<String, Collection<ReplicationPair>>();
        for (ReplicationPair pair : pairs) {
            String storage = pair.getDevSn();
            if (storage == null) continue;
            HashSet<ReplicationPair> items = (HashSet<ReplicationPair>)pairMap.get(storage);
            if (items == null) {
                items = new HashSet<ReplicationPair>();
                pairMap.put(storage, items);
            }
            items.add(pair);
        }
        return pairMap;
    }
}

