/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.IReplicationPairQueryService;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.twaver.Link;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RingTopologyUtil
extends DRRingUtil {
    public static final String STANDBY_ICON = "/theme/recoverydirector/images/topo/ic_asynchronous_standby.png";
    private static final Log logger = LogFactory.getInstance(RingTopologyUtil.class);

    protected RingTopologyUtil() {
    }

    public static Map<String, Collection<ReplicationPair>> prepare(ProtectGroup protectGroup, IReplicationPairQueryService query) {
        HashMap<String, Collection<ReplicationPair>> wwnPairMap;
        ArrayList<ReplicationPair> pairList;
        HashMap rerouceMap;
        HashMap lunWwnMap;
        ProtectGroupReplica siteABReplica;
        LinkedHashSet linkedReplicaList = new LinkedHashSet(protectGroup.getReplicaList());
        protectGroup.setReplicaList(linkedReplicaList);
        Set pgArrayKeySet = protectGroup.getReplicaList().stream().map(pgRep -> CommUtil.combineString((String[])new String[]{pgRep.getProductArray(), pgRep.getRecoveryArray()})).collect(Collectors.toSet());
        ProtectGroupReplica replica = RingTopologyUtil.getProtectGroupReplicaByLocation(protectGroup.getReplicaList(), DrmEnumDefine.ProtectLocation.C_C.getValue());
        Map<Object, Object> pairMap = new HashMap();
        if (!VerifyUtil.isEmpty((Object)replica)) {
            pairMap = RingTopologyUtil.getRelatedReplicationPairsAndUpdateRunningStatus(RingTopologyUtil.getRemoteStorageReplicas(replica), query);
            ProtectGroupReplica dumpReplica = RingTopologyUtil.dump(replica, pairMap);
            if (dumpReplica != null && !pgArrayKeySet.contains(CommUtil.combineString((String[])new String[]{dumpReplica.getProductArray(), dumpReplica.getRecoveryArray()}))) {
                protectGroup.addProtectGroupReplica(dumpReplica);
            } else {
                pairMap.clear();
            }
        }
        if (!VerifyUtil.isEmpty((Object)(siteABReplica = RingTopologyUtil.getProtectGroupReplicaByLocation(protectGroup.getReplicaList(), DrmEnumDefine.ProtectLocation.A_B.getValue())))) {
            lunWwnMap = new HashMap();
            rerouceMap = new HashMap();
            siteABReplica.getReplicas().stream().forEach(poRep -> poRep.getStorageInfos().stream().forEach(relicaStorageInfo -> {
                CommUtil.addSetToMap((Map)rerouceMap, (Object)relicaStorageInfo.getSrcStorageProviderSN(), (Object)relicaStorageInfo.getSrcStorageId());
                lunWwnMap.put(relicaStorageInfo.getSrcStorageId(), relicaStorageInfo.getProtectObjectStorageWwn());
            }));
            pairList = new ArrayList<ReplicationPair>();
            for (Map.Entry entry : rerouceMap.entrySet()) {
                pairList.addAll(query.fromDevice(false).getReplicationPairsByLun((String)entry.getKey(), new ArrayList<String>((Collection)entry.getValue())));
            }
            wwnPairMap = new HashMap();
            pairList.stream().forEach(pair -> {
                pair.setSrcLunWWN((String)lunWwnMap.get(pair.getSrcLunId()));
                CommUtil.addToMap((Map)wwnPairMap, (String)pair.getSrcLunWWN(), (Object)pair);
            });
            ProtectGroupReplica protectGroupReplica = RingTopologyUtil.dump(siteABReplica, wwnPairMap);
            if (protectGroupReplica != null && !pgArrayKeySet.contains(CommUtil.combineString((String[])new String[]{protectGroupReplica.getProductArray(), protectGroupReplica.getRecoveryArray()}))) {
                pairMap = wwnPairMap;
                protectGroup.addProtectGroupReplica(protectGroupReplica);
            }
        }
        if (!VerifyUtil.isEmpty((Object)siteABReplica)) {
            lunWwnMap = new HashMap();
            rerouceMap = new HashMap();
            siteABReplica.getReplicas().stream().forEach(poRep -> poRep.getStorageInfos().stream().forEach(relicaStorageInfo -> {
                CommUtil.addSetToMap((Map)rerouceMap, (Object)relicaStorageInfo.getStorageProviderSN(), (Object)relicaStorageInfo.getStorageId());
                lunWwnMap.put(relicaStorageInfo.getStorageId(), relicaStorageInfo.getProtectObjectStorageWwn());
            }));
            pairList = new ArrayList();
            for (Map.Entry entry : rerouceMap.entrySet()) {
                pairList.addAll(query.fromDevice(false).getReplicationPairsByLun((String)entry.getKey(), new ArrayList<String>((Collection)entry.getValue())));
            }
            wwnPairMap = new HashMap<String, Collection<ReplicationPair>>();
            pairList.stream().forEach(pair -> {
                pair.setSrcLunWWN((String)lunWwnMap.get(pair.getSrcLunId()));
                CommUtil.addToMap((Map)wwnPairMap, (String)pair.getSrcLunWWN(), (Object)pair);
            });
            ProtectGroupReplica protectGroupReplica = RingTopologyUtil.dump(siteABReplica, wwnPairMap);
            if (protectGroupReplica != null && !pgArrayKeySet.contains(CommUtil.combineString((String[])new String[]{protectGroupReplica.getProductArray(), protectGroupReplica.getRecoveryArray()}))) {
                pairMap = wwnPairMap;
                protectGroup.addProtectGroupReplica(protectGroupReplica);
            }
        }
        return pairMap;
    }

    public static Collection<ProtectGroupReplica> dump(ProtectGroup protectGroup, Collection<ProtectGroupReplica> replicas) {
        HashSet<ProtectGroupReplica> results = new HashSet<ProtectGroupReplica>();
        replicas = RingTopologyUtil.defaults(replicas);
        protectGroup.setReplicaList(new HashSet<ProtectGroupReplica>(replicas));
        for (ProtectGroupReplica replica : replicas) {
            results.add(replica);
            Map props = RingTopologyUtil.getProtectGroupStorageProps(protectGroup.getUuid());
            Collection productStorages = RingTopologyUtil.getOrNewSet(props, "product.storage");
            Collection recoveryStorages = RingTopologyUtil.getOrNewSet(props, "recovery.storage");
            if (productStorages.size() > 1) {
                productStorages.remove(replica.getProductArray());
            }
            if (recoveryStorages.size() > 1) {
                recoveryStorages.remove(replica.getRecoveryArray());
            }
            if (productStorages.size() != 1 || recoveryStorages.size() != 1) continue;
            String productStorage = (String)new ArrayList(productStorages).get(0);
            String recoveryStorage = (String)new ArrayList(recoveryStorages).get(0);
            ProtectGroupReplica another = new ProtectGroupReplica();
            another.setProductArray(productStorage);
            another.setRecoveryArray(recoveryStorage);
            another.setType(replica.getType());
            results.add(another);
        }
        return results;
    }

    private static Map<String, Collection<String>> getProtectGroupStorageProps(String uuid) {
        HashMap<String, Collection<String>> props = new HashMap<String, Collection<String>>();
        String sql = "select PROPVALUE from ti_protectgroup_prop where PROPNAME = ? and PGID=?";
        Collection<Object> items = CommonDAOLocator.getBaseDao().executeNativeSql(sql, new Object[]{"hyper-dr-ring-used-resources", uuid});
        items = RingTopologyUtil.defaults(items);
        for (Object item : items) {
            String json = item.toString();
            Map datas = (Map)JSONObject.toBean((String)json, Map.class);
            RingTopologyUtil.appendPropValue(props, datas, "product.storage");
            RingTopologyUtil.appendPropValue(props, datas, "recovery.storage");
        }
        return props;
    }

    private static void appendPropValue(Map<String, Collection<String>> props, Map<String, Collection<String>> datas, String key) {
        Collection prop = RingTopologyUtil.getOrNewSet(props, key);
        Collection data = RingTopologyUtil.getOrNewSet(datas, key);
        prop.addAll(data);
    }

    public static void updateReplicationPairStatus(TopoBaseContext context, Collection<ReplicationPair> pairs) {
        pairs = RingTopologyUtil.defaults(pairs);
        for (ReplicationPair pair : pairs) {
            String runningStatus;
            String linkId = RingTopologyUtil.getReplicationPairLinkId(pair);
            Link link = (Link)context.getElementByID((Object)linkId);
            if (link == null || !"110".equals(runningStatus = ReplicationUtil.getReplicationRelationRunningStatus((ReplicationRelation)pair))) continue;
            link.setStyle("icons.names", (Object)STANDBY_ICON);
        }
    }

    private static String getReplicationPairLinkId(ReplicationPair pair) {
        return pair.getSrcDevSN() + ':' + pair.getSrcLunId() + ':' + RingTopologyUtil.getReplicationPairTgtDevSn(pair) + ':' + RingTopologyUtil.getReplicationPairTgtLunId(pair);
    }

    private static String getReplicationPairTgtLunId(ReplicationPair pair) {
        List targets = pair.getRepTgtLuns();
        if (targets == null || targets.isEmpty()) {
            return null;
        }
        return ((ReplicationTargetLun)targets.get(0)).getTgtLunId();
    }

    private static String getReplicationPairTgtDevSn(ReplicationPair pair) {
        List targets = pair.getRepTgtLuns();
        if (targets == null || targets.isEmpty()) {
            return null;
        }
        return ((ReplicationTargetLun)targets.get(0)).getTgtDevSN();
    }

    private static ProtectGroupReplica dump(ProtectGroupReplica protectGroupReplica, Map<String, Collection<ReplicationPair>> pairMap) {
        Collection<ProtectObjectReplica> dumpProtectObjectReplicas = RingTopologyUtil.dump(protectGroupReplica.getReplicas(), pairMap);
        if (dumpProtectObjectReplicas.isEmpty()) {
            return null;
        }
        Collection<RelicaStorageInfo> dumpReplicas = RingTopologyUtil.getRelicaStorageInfos(dumpProtectObjectReplicas);
        Collection<String> dumpRecoveryArraySnList = RingTopologyUtil.get(dumpReplicas, "storageProviderSN", String.class);
        if (dumpRecoveryArraySnList.size() != 1) {
            return null;
        }
        Collection<Site> recoverySites = RingTopologyUtil.getSiteByStorageSn(dumpRecoveryArraySnList);
        if (recoverySites.size() != 1) {
            return null;
        }
        ProtectGroupReplica dumpProtectGroupReplica = new ProtectGroupReplica();
        for (ProtectObjectReplica dumpProtectObjectReplica : dumpProtectObjectReplicas) {
            dumpProtectGroupReplica.addProtectObjectReplica(dumpProtectObjectReplica);
        }
        dumpProtectGroupReplica.setProductArray((String)RingTopologyUtil.get(dumpReplicas, "srcStorageProviderSN", String.class).stream().findFirst().get());
        String dumpRecoveryArray = new ArrayList<String>(dumpRecoveryArraySnList).get(0);
        dumpProtectGroupReplica.setRecoveryArray(dumpRecoveryArray);
        Site recoverySite = new ArrayList<Site>(recoverySites).get(0);
        dumpProtectGroupReplica.setRecoverySite(recoverySite.getSiteId());
        dumpProtectGroupReplica.setProtectLocation(DrmEnumDefine.ProtectLocation.C_C.getValue());
        dumpProtectGroupReplica.setType(protectGroupReplica.getType());
        dumpProtectGroupReplica.setId(UUIDGenerator.getUUID());
        return dumpProtectGroupReplica;
    }

    public static Collection<ProtectObjectReplica> dump(Collection<ProtectObjectReplica> protectObjectReplicas, Map<String, Collection<ReplicationPair>> pairMap) {
        HashSet<ProtectObjectReplica> dumpProtectObjectReplicas = new HashSet<ProtectObjectReplica>();
        protectObjectReplicas = RingTopologyUtil.defaults(protectObjectReplicas);
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicas) {
            ProtectObjectReplica dumpProtectObjectReplica = RingTopologyUtil.dump(protectObjectReplica, pairMap);
            if (dumpProtectObjectReplica == null) continue;
            dumpProtectObjectReplicas.add(dumpProtectObjectReplica);
        }
        return dumpProtectObjectReplicas;
    }

    private static ProtectObjectReplica dump(ProtectObjectReplica protectObjectReplica, Map<String, Collection<ReplicationPair>> pairMap) {
        ProtectObjectReplica dumpProtectObjectReplica = new ProtectObjectReplica();
        dumpProtectObjectReplica.setPoId(protectObjectReplica.getPoId());
        dumpProtectObjectReplica.setPgReplica(protectObjectReplica.getPgReplica());
        Collection<RemoteStorageReplica> remoteStorageReplicas = RingTopologyUtil.getRemoteStorageReplicas(protectObjectReplica.getStorageInfos());
        for (RemoteStorageReplica remoteStorageReplica : remoteStorageReplicas) {
            Collection<ReplicationPair> pairs;
            RemoteStorageReplica dumpRemoteStorageReplica = RingTopologyUtil.dump(remoteStorageReplica, pairs = pairMap.get(remoteStorageReplica.getProtectObjectStorageWwn()));
            if (dumpRemoteStorageReplica == null) continue;
            dumpProtectObjectReplica.addRelicaStorageInfo((RelicaStorageInfo)dumpRemoteStorageReplica);
        }
        if (RingTopologyUtil.defaults(dumpProtectObjectReplica.getStorageInfos()).isEmpty()) {
            dumpProtectObjectReplica = null;
        }
        return dumpProtectObjectReplica;
    }

    public static RemoteStorageReplica dump(RemoteStorageReplica remoteStorageReplica, Collection<ReplicationPair> pairs) {
        String wwn = remoteStorageReplica.getProtectObjectStorageWwn();
        ArrayList<ReplicationPair> pairList = new ArrayList<ReplicationPair>(pairs);
        ReplicationPair pair = ReplicationUtil.getReplicationPairByRemoteStorageReplica(pairList, remoteStorageReplica);
        Iterator it = pairList.iterator();
        while (it.hasNext()) {
            ReplicationPair item = (ReplicationPair)it.next();
            if (item != pair) continue;
            it.remove();
        }
        ReplicationPair replicationPair = pair = !pairList.isEmpty() ? (ReplicationPair)pairList.get(0) : null;
        if (pair == null) {
            logger.error((Object)("not find the other side replication pair for remote storage replica. wwn = " + wwn));
            return null;
        }
        List targets = pair.getRepTgtLuns();
        if (targets == null || targets.size() != 1) {
            logger.error((Object)new StringBuilder("number of target lun of replication pair should be 2, but actual is ").append(". replication pair is ").append(pair.getUuid()));
            throw new LegoCheckedException(-1L);
        }
        ReplicationTargetLun target = (ReplicationTargetLun)targets.get(0);
        RemoteStorageReplica dumpRemoteStorageReplica = new RemoteStorageReplica();
        dumpRemoteStorageReplica.setProtectObjectStorageWwn(wwn);
        dumpRemoteStorageReplica.setReplicationPairId(pair.getReplicationId());
        dumpRemoteStorageReplica.setConsistentGroupId(pair.getConsistentGroupId());
        dumpRemoteStorageReplica.setDrRingId(pair.getDrRingId());
        dumpRemoteStorageReplica.setSrcStorageId(pair.getSrcLunId());
        dumpRemoteStorageReplica.setSrcStorageProviderSN(pair.getSrcDevSN());
        dumpRemoteStorageReplica.setStorageId(target.getTgtLunId());
        dumpRemoteStorageReplica.setStorageProviderSN(target.getTgtDevSN());
        return dumpRemoteStorageReplica;
    }
}

