/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.recovery;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.process.IReplicationRecoveryTaskConstructor;
import com.huawei.ism.drm.recovery.framework.process.ParameterEntity;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessHandler;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ReplicationRecoveryTaskConstructor
implements IReplicationRecoveryTaskConstructor {
    private static final Log logger = LogFactory.getInstance(ReplicationRecoveryTaskConstructor.class);
    private static final String REPLICA = "replica";
    private static final String STANDBY = "standby";
    private static final String ALL_RELATED_REPLICATION_PAIRS = "all-related-replication-pairs";
    private static final String CONSTRUCT_RETRY_TIME_KEY = "recovery.task.construct.retry.time";
    private static final int CONSTRUCT_RETRY_TIME_DEFAULT = 3;
    private static final int CONSTRUCT_RETRY_TIME_MAX = 10;
    private static final long CONSTRUCT_RETRY_INTERVAL_MILLIS = 10000L;
    private RecoveryProcessHandler handler;

    public RecoveryProcessHandler getHandler() {
        return this.handler;
    }

    public void setHandler(RecoveryProcessHandler handler) {
        this.handler = handler;
        if (handler != null) {
            handler.setReplicationRecoveryTaskConstructor((IReplicationRecoveryTaskConstructor)this);
        }
    }

    public void constructReplicationRecoveryTask(ParameterEntity paramEntity, RemoteStorageReplica remoteStorageReplica, String associatedHostId, Map<String, RecoveryTask> recoveryTasks) {
        String drRingId = remoteStorageReplica.getDrRingId();
        if (VerifyUtil.isEmpty((String)drRingId) || drRingId.startsWith("--")) {
            this.handler.constructReplicationRecoveryTask(paramEntity, remoteStorageReplica, associatedHostId, recoveryTasks);
            return;
        }
        long retryTime = LegoConfig.getInstance().getNumber(CONSTRUCT_RETRY_TIME_KEY, 3L);
        retryTime = Math.max(1L, retryTime);
        retryTime = Math.min(10L, retryTime);
        int realRetryTime = 1;
        while (retryTime-- > 0L) {
            if (this.constructReplicationRecoveryTaskForDRRing(paramEntity, remoteStorageReplica, associatedHostId, recoveryTasks)) {
                return;
            }
            logger.warn((Object)"Construct task for DR ring failed, retry time: %s", new Object[]{String.valueOf(realRetryTime++)});
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"Waiting for retrying to construct task for DR ring  was interrupted.");
                break;
            }
        }
        logger.warn((Object)"Construct task for DR ring failed, construct normal task instead.");
        this.handler.constructReplicationRecoveryTask(paramEntity, remoteStorageReplica, associatedHostId, recoveryTasks);
    }

    private boolean constructReplicationRecoveryTaskForDRRing(ParameterEntity paramEntity, RemoteStorageReplica replica, String associatedHostId, Map<String, RecoveryTask> recoveryTasks) {
        Collection<Object> pairs = new ArrayList();
        try {
            pairs = this.getRelicationPairByReplicaTarget(replica);
            if (VerifyUtil.isEmpty(pairs)) {
                pairs = this.getRelicationPairByReplicaSrc(replica);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"constructReplicationRecoveryTaskForDRRing error", (Throwable)e);
        }
        if (pairs.size() != 2) {
            logger.info((Object)"the number of replication pairs is not 2. no need to construct recovery task for standby");
            return false;
        }
        for (ReplicationPair replicationPair : pairs) {
            RemoteStorageReplica realReplica = this.constructReplica(replicationPair, replica);
            if (realReplica == null) continue;
            this.handler.constructReplicationRecoveryTask(paramEntity, realReplica, associatedHostId, recoveryTasks);
            String key = RecoveryProcessHandler.generateRecoveryTaskKey((RemoteStorageReplica)realReplica);
            RecoveryTask recoveryTask = recoveryTasks.get(key);
            HashMap<String, Object> params = new HashMap<String, Object>();
            recoveryTask.setParams(params);
            params.put(REPLICA, realReplica);
            params.put(STANDBY, "110".equals(ReplicationUtil.getReplicationRelationRunningStatus((ReplicationRelation)replicationPair)));
            Collection<ReplicationPair> allRelatedPairs = this.addReplicationPair(recoveryTasks, replicationPair);
            params.put(ALL_RELATED_REPLICATION_PAIRS, allRelatedPairs);
        }
        return true;
    }

    private Collection<ReplicationPair> getRelicationPairByReplicaSrc(RemoteStorageReplica replica) {
        return this.getRelicationPairByReplica(replica.getStorageProviderSN(), replica.getStorageId(), true);
    }

    private Collection<ReplicationPair> addReplicationPair(Map<String, RecoveryTask> recoveryTasks, ReplicationPair pair) {
        Collection<ReplicationPair> pairs = this.getAllReplicationPairs(recoveryTasks);
        if (pairs == null) {
            pairs = new HashSet<ReplicationPair>();
        }
        pairs.add(pair);
        return pairs;
    }

    private Collection<ReplicationPair> getAllReplicationPairs(Map<String, RecoveryTask> recoveryTasks) {
        return this.getAllReplicationPairs(recoveryTasks.values());
    }

    private Collection<ReplicationPair> getAllReplicationPairs(Collection<RecoveryTask> recoveryTasks) {
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Object allRelatedReplicationPairs;
            Map params = recoveryTask.getParams();
            if (VerifyUtil.isEmpty((Map)params) || (allRelatedReplicationPairs = params.get(ALL_RELATED_REPLICATION_PAIRS)) == null) continue;
            if (!Collection.class.isInstance(allRelatedReplicationPairs)) {
                return null;
            }
            Collection collection = (Collection)Collection.class.cast(allRelatedReplicationPairs);
            for (Object item : collection) {
                if (ReplicationPair.class.isInstance(item)) continue;
                return null;
            }
            return collection;
        }
        return null;
    }

    private RemoteStorageReplica constructReplica(ReplicationPair pair, RemoteStorageReplica recordedReplica) {
        if (pair == null) {
            return null;
        }
        List targets = pair.getRepTgtLuns();
        if (targets == null || targets.isEmpty()) {
            return null;
        }
        RemoteStorageReplica realtimeReplica = new RemoteStorageReplica();
        realtimeReplica.setPoReplica(recordedReplica.getPoReplica());
        realtimeReplica.setReplicationPairId(pair.getReplicationId());
        realtimeReplica.setConsistentGroupId(pair.getConsistentGroupId());
        realtimeReplica.setSynchronization(realtimeReplica.getSynchronization());
        realtimeReplica.setVstorePairId(pair.getVstorePairId());
        realtimeReplica.setDrRingId(pair.getDrRingId());
        realtimeReplica.setProtectObjectStorageWwn(pair.getSrcLunWWN());
        realtimeReplica.setSrcStorageId(pair.getSrcLunId());
        realtimeReplica.setSrcStorageProviderSN(pair.getSrcDevSN());
        ReplicationTargetLun target = (ReplicationTargetLun)targets.get(0);
        realtimeReplica.setStorageId(target.getTgtLunId());
        realtimeReplica.setStorageProviderSN(target.getTgtDevSN());
        return realtimeReplica;
    }

    private Collection<ReplicationPair> getRelicationPairByReplicaTarget(RemoteStorageReplica replica) {
        return this.getRelicationPairByReplica(replica.getStorageProviderSN(), replica.getStorageId(), false);
    }

    private Collection<ReplicationPair> getRelicationPairByReplica(String devSn, String lunId, boolean isPrimary) {
        DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class);
        return drmStorageService.getRelicationPairByLun(devSn, Arrays.asList(lunId), isPrimary);
    }

    public void checkRecoveryTasks(Collection<RecoveryTask> recoveryTasks, RecoveryPlan recoveryPlan, RecoveryProcessor processor) {
        Collection<ReplicationPair> pairs = this.getAllReplicationPairs(recoveryTasks);
        if (pairs == null) {
            return;
        }
        if (processor.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            return;
        }
        Map<String, Collection<ReplicationPair>> pairMap = ReplicationUtil.classifyReplicationPairByHyperMetroSide(pairs);
        if (null == pairMap) {
            logger.error((Object)"pair map is null.");
            throw new LegoCheckedException(1073948462L);
        }
        Collection normalSide = DRRingUtil.getWhichNotContainStandby(pairMap.values());
        if (normalSide == null) {
            logger.error((Object)"not find the side which is not contain standby pairs");
            throw new LegoCheckedException(1073948462L);
        }
    }
}

