/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.topology;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtBothSideService;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtMineSideService;
import com.huawei.ism.drm.storage.hvs.protection.util.RingTopologyUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.topology.ArrayDoubleActiveTopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.twaver.Node;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-26")
public class ArrayHyperMetroReplicationRingTopoBuilder
extends ArrayDoubleActiveTopoBuilder {
    private ReplicationPairQueryAtBothSideService bothSideQueryService;

    public ReplicationPairQueryAtMineSideService getBothSideQueryService() {
        return this.bothSideQueryService;
    }

    public void setBothSideQueryService(ReplicationPairQueryAtBothSideService mineSideQueryService) {
        this.bothSideQueryService = mineSideQueryService;
    }

    public void buildTopo(TopoBaseContext context) {
        Map<String, Collection<ReplicationPair>> pairMap = RingTopologyUtil.prepare(context.getProtectGroup(), this.bothSideQueryService);
        super.buildTopo(context);
        RingTopologyUtil.updateReplicationPairStatus(context, RingTopologyUtil.spread(pairMap.values()));
    }

    protected Node addProductLun(TopoBaseContext context, String siteId, Node storageNode, Lun lun) {
        Node node = super.addProductLun(context, siteId, storageNode, lun);
        Collection<Node> endingNodes = this.getRelatedEndings(context, lun);
        Object target = node.getID();
        for (Node endingNode : endingNodes) {
            String id = "link-" + endingNode.getID() + "-" + target;
            context.linkTo(endingNode, target, (Object)id, new Skin[0]);
        }
        return node;
    }

    private Collection<Node> getRelatedEndings(TopoBaseContext context, Lun lun) {
        HashSet<Node> endingNodes = new HashSet<Node>();
        Map endings = (Map)context.find((Object)"endings");
        for (Map.Entry ending : endings.entrySet()) {
            String[] key = (String[])ending.getKey();
            String wwn = key[0];
            if (wwn == null || !wwn.equalsIgnoreCase(lun.getWwn())) continue;
            Node endingNode = (Node)ending.getValue();
            endingNodes.add(endingNode);
        }
        return endingNodes;
    }

    protected boolean hasReplication(int templateType) {
        return true;
    }
}

