/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.topology;

import com.huawei.ism.array.sdk.model.HvsStorage;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.QuorumServer;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.base.util.MOUtil;
import com.huawei.ism.cbb.discover.commons.DeviceOperationLock;
import com.huawei.ism.cbb.discover.commons.OperationLock;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceProxyExtend;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceProxyLocator;
import com.huawei.ism.drm.storage.sdk.model.ReplicationLink;
import com.huawei.ism.drm.topo.sdk.poll.ITopoPoller;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.ubase.adaptor.hvs.discovery.process.HVSDeviceProxyImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoPollerManager", properties="type:topoPoller-storage-hvs")
public class HvsTopoPoller
implements ITopoPoller {
    private static Log logger = LogFactory.getInstance(HvsTopoPoller.class);
    private static final int LINK_TYPE_FC = 1;
    private static final int LINK_TYPE_ISCSI = 2;
    private static final int LINK_TYPE_IP = 3;
    private static final int LINK_UP = 10;
    private String sourceSn;

    public void pollResource(String paramSourceSn) {
        logger.debug((Object)("HvsTopoPoller start, sn=" + paramSourceSn));
        if (VerifyUtil.isEmpty((String)paramSourceSn)) {
            return;
        }
        this.sourceSn = paramSourceSn;
        IMoDao moDao = CommonDAOLocator.getMoDao();
        StorageNE storage = (StorageNE)moDao.getMo(StorageNE.class, "sn", (Object)paramSourceSn);
        if (storage == null) {
            return;
        }
        int storageStatus = storage.getStatus();
        HvsUnit hvsUnit = (HvsUnit)moDao.getMo(HvsUnit.class, "devSn", (Object)paramSourceSn);
        if (null == hvsUnit) {
            logger.error((Object)("hvsUnit is empty. DeviceSN:" + paramSourceSn), 90160758784001L);
            return;
        }
        this.refreshData(paramSourceSn, moDao, storageStatus, hvsUnit);
        logger.debug((Object)("HvsTopoPoller finish, sn=" + paramSourceSn));
    }

    private void refreshData(String paramSourceSn, IMoDao moDao, int storageStatus, HvsUnit hvsUnit) {
        try {
            this.updateInitiators(paramSourceSn, storageStatus, moDao, hvsUnit);
        }
        catch (Exception e) {
            logger.error((Object)("updateInitiators failed. DeviceSN:" + paramSourceSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        try {
            this.updateLinkInfo(paramSourceSn, storageStatus, moDao, hvsUnit);
        }
        catch (Exception e) {
            logger.error((Object)("updateLinkInfo failed. DeviceSN:" + paramSourceSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        try {
            this.updateQuorumServerInfo(paramSourceSn, storageStatus, moDao, hvsUnit);
        }
        catch (Exception e) {
            logger.error((Object)("updateQuorumServerInfo failed. DeviceSN:" + paramSourceSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public void updateQuorumServerInfo(String devSn, int status, IMoDao moDao, HvsUnit hvsUnit) {
        if (status == -1) {
            this.setLinkdownStatus(devSn, moDao);
            return;
        }
        HvsDeviceProxyExtend hsvProxy = HvsDeviceProxyLocator.getInstance().getHvsDeviceProxyExtend();
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(devSn);
        List<QuorumServer> quorumServers = hsvProxy.getQuorumServers(connection);
        for (QuorumServer quorumServer : quorumServers) {
            quorumServer.setParentMo((ManagedObject)hvsUnit);
            quorumServer.setTopMoUuid(hvsUnit.getTopMoUuid());
        }
        List<QuorumServerLink> quorumServerLinks = hsvProxy.getQuorumServerLinks(connection);
        for (QuorumServerLink each : quorumServerLinks) {
            each.setParentMo((ManagedObject)hvsUnit);
            each.setTopMoUuid(hvsUnit.getTopMoUuid());
        }
        List<QuorumServerLink> list = this.getQuorumServerLinks(devSn, moDao);
        List<QuorumServer> quorumServersFromDb = this.getQuorumServers(devSn, moDao);
        HvsUnit unit = (HvsUnit)moDao.getMo(HvsUnit.class, "devSn", (Object)devSn);
        if (VerifyUtil.isEmpty((Object)unit)) {
            logger.error((Object)("hvsUnit is empty. DeviceSN:" + devSn), 90160758784001L);
            return;
        }
        if (this.isMoLocked(devSn)) {
            return;
        }
        MOUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, quorumServers, quorumServersFromDb);
        if (this.isMoLocked(devSn)) {
            return;
        }
        MOUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, quorumServerLinks, list);
    }

    private void setLinkdownStatus(String devSn, IMoDao moDao) {
        logger.trace((Object)("the devsn: " + devSn));
        String unknownState = String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.UNKNOWN.getValue());
        List<QuorumServer> quorumServers = this.getQuorumServers(devSn, moDao);
        if (this.isMoLocked(devSn)) {
            return;
        }
        this.updateQuorumServer(quorumServers, moDao, unknownState);
        List<QuorumServerLink> quorumServerLinks = this.getQuorumServerLinks(devSn, moDao);
        if (this.isMoLocked(devSn)) {
            return;
        }
        for (QuorumServerLink eachLink : quorumServerLinks) {
            if (unknownState.equals(eachLink.getRunningState())) continue;
            eachLink.setRunningState(unknownState);
            moDao.update((Object)eachLink);
        }
    }

    private void updateQuorumServer(List<QuorumServer> quorumServers, IMoDao moDao, String unknownState) {
        for (QuorumServer eachServer : quorumServers) {
            if (unknownState.equals(eachServer.getRunningState())) continue;
            eachServer.setRunningState(unknownState);
            moDao.update((Object)eachServer);
        }
    }

    private List<QuorumServer> getQuorumServers(String devSn, IMoDao moDao) {
        logger.trace((Object)("the devsn: " + devSn));
        List quorumServers = moDao.getMoList(QuorumServer.class, "devSn", (Object)devSn);
        return quorumServers;
    }

    private List<QuorumServerLink> getQuorumServerLinks(String devSn, IMoDao moDao) {
        logger.trace((Object)("the devsn: " + devSn));
        List quorumServerLinks = moDao.getMoList(QuorumServerLink.class, "devSn", (Object)devSn);
        return quorumServerLinks;
    }

    private void updateLinkInfo(String paramSourceSn, int status, IMoDao moDao, HvsUnit hvsUnit) {
        if (status == -1) {
            HashMap<String, String> iprops = new HashMap<String, String>();
            iprops.put("deviceId", paramSourceSn);
            List oldReplicationLinkList = moDao.findMoBy(ReplicationLink.class, iprops);
            if (this.isMoLocked(paramSourceSn)) {
                return;
            }
            this.updateRepLinkWhenLinkDown(oldReplicationLinkList, moDao);
            return;
        }
        RestConnection hvsConnection = HvsRestConnectionManager.getInstance().getConnection(paramSourceSn);
        List resultMapList = hvsConnection.getBatch("/rest/${deviceID}/remote_device", null);
        HashMap<String, String> deviceWWNAndSNMAP = new HashMap<String, String>();
        HashMap<String, String> deviceIDAndSNMAP = new HashMap<String, String>();
        this.getDeviceMapInfo(resultMapList, deviceWWNAndSNMAP, deviceIDAndSNMAP, paramSourceSn);
        ArrayList<ReplicationLink> newReplicationLinkList = new ArrayList<ReplicationLink>();
        this.queryFcLink(newReplicationLinkList, hvsUnit, paramSourceSn, deviceWWNAndSNMAP, hvsConnection);
        this.queryIscsiLink(newReplicationLinkList, hvsUnit, paramSourceSn, deviceIDAndSNMAP, hvsConnection);
        this.queryIpLink(newReplicationLinkList, hvsUnit, paramSourceSn, deviceIDAndSNMAP, hvsConnection);
        HashMap<String, String> iprops = new HashMap<String, String>();
        iprops.put("deviceId", paramSourceSn);
        List oldReplicationLinkList = moDao.findMoBy(ReplicationLink.class, iprops);
        HvsUnit unit = (HvsUnit)moDao.getMo(HvsUnit.class, "devSn", (Object)paramSourceSn);
        if (VerifyUtil.isEmpty((Object)unit)) {
            logger.error((Object)("hvsUnit is empty. DeviceSN:" + paramSourceSn), 90160758784001L);
            return;
        }
        if (this.isMoLocked(paramSourceSn)) {
            return;
        }
        MOUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, newReplicationLinkList, (List)oldReplicationLinkList);
    }

    private void updateRepLinkWhenLinkDown(List<ReplicationLink> oldReplicationLinkList, IMoDao moDao) {
        for (ReplicationLink eachLink : oldReplicationLinkList) {
            if (eachLink.getLinkStatus() != 10) continue;
            eachLink.setLinkStatus(0);
            moDao.update((Object)eachLink);
        }
    }

    private void queryFcLink(List<ReplicationLink> replicationLinkList, HvsUnit hvsUnit, String deviceSN, Map<String, String> deviceWWNAndSNMAP, RestConnection hvsConnection) {
        List resultLinkMapList = hvsConnection.getBatch("/rest/${deviceID}/fc_link", null);
        for (Map record : resultLinkMapList) {
            try {
                if ("false".equalsIgnoreCase((String)record.get("LINKUSAGE"))) continue;
                ReplicationLink replicationLink = new ReplicationLink();
                replicationLink.setDeviceId(deviceSN);
                replicationLink.setLinkType(1);
                replicationLink.setLinkId(deviceSN + ":" + (String)record.get("DEVICEID"));
                replicationLink.setUuid(replicationLink.getLinkId());
                String strWWN = (String)record.get("DEVICEWWN");
                replicationLink.setRemoteArrayId(deviceWWNAndSNMAP.get(strWWN));
                replicationLink.setLinkStatus(Integer.parseInt((String)record.get("RUNNINGSTATUS")));
                replicationLink.setParentMo((ManagedObject)hvsUnit);
                replicationLink.setTopMoUuid(hvsUnit.getTopMoUuid());
                replicationLinkList.add(replicationLink);
            }
            catch (Exception e) {
                logger.warn((Object)("Storage[" + deviceSN + "] transition to FC replication link failed"), 90160777658373L);
            }
        }
    }

    private void queryIscsiLink(List<ReplicationLink> replicationLinkList, HvsUnit hvsUnit, String deviceSN, Map<String, String> deviceIDAndSNMAP, RestConnection hvsConnection) {
        List resultIscsiLinkMapList = hvsConnection.getBatch("/rest/${deviceID}/iscsi_link", null);
        for (Map record : resultIscsiLinkMapList) {
            try {
                if ("false".equalsIgnoreCase((String)record.get("LINKUSAGE"))) continue;
                ReplicationLink replicationLink = new ReplicationLink();
                replicationLink.setDeviceId(deviceSN);
                replicationLink.setLinkType(2);
                String strDevID = (String)record.get("DEVICEID");
                replicationLink.setLinkId(deviceSN + ":" + strDevID);
                replicationLink.setUuid(replicationLink.getLinkId());
                replicationLink.setRemoteArrayId(deviceIDAndSNMAP.get(strDevID));
                replicationLink.setLinkStatus(Integer.parseInt((String)record.get("RUNNINGSTATUS")));
                replicationLink.setParentMo((ManagedObject)hvsUnit);
                replicationLink.setTopMoUuid(hvsUnit.getTopMoUuid());
                replicationLinkList.add(replicationLink);
            }
            catch (Exception e) {
                logger.warn((Object)("Storage[" + deviceSN + "] transition to iscsi replication link failed"), 90160777658373L);
            }
        }
    }

    private void queryIpLink(List<ReplicationLink> replicationLinkList, HvsUnit hvsUnit, String deviceSN, Map<String, String> deviceIDAndSNMAP, RestConnection hvsConnection) {
        try {
            List resultIscsiLinkMapList = hvsConnection.getBatch("/rest/${deviceID}/iplink", null);
            for (Map record : resultIscsiLinkMapList) {
                if ("false".equalsIgnoreCase((String)record.get("LINKUSAGE"))) continue;
                ReplicationLink replicationLink = new ReplicationLink();
                replicationLink.setDeviceId(deviceSN);
                String strDevID = (String)record.get("DEVICEID");
                replicationLink.setLinkId(deviceSN + ":" + strDevID);
                replicationLink.setLinkType(3);
                replicationLink.setUuid(replicationLink.getLinkId());
                replicationLink.setRemoteArrayId(deviceIDAndSNMAP.get(strDevID));
                replicationLink.setLinkStatus(Integer.parseInt((String)record.get("RUNNINGSTATUS")));
                replicationLink.setParentMo((ManagedObject)hvsUnit);
                replicationLink.setTopMoUuid(hvsUnit.getTopMoUuid());
                replicationLinkList.add(replicationLink);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Storage[" + deviceSN + "] transition to ip replication link failed"), 90160777658373L);
        }
    }

    private void getDeviceMapInfo(List<Map<String, String>> resultMapList, Map<String, String> deviceWWNAndSNMAP, Map<String, String> deviceIDAndSNMAP, String deviceSN) {
        if (null == resultMapList) {
            return;
        }
        for (Map<String, String> record : resultMapList) {
            try {
                String strWWN = record.get("WWN");
                String strSN = record.get("SN");
                String strDevID = record.get("ID");
                if (strSN == null) continue;
                this.setInfo(deviceWWNAndSNMAP, deviceIDAndSNMAP, strWWN, strSN, strDevID);
            }
            catch (Exception e) {
                logger.warn((Object)("Storage[" + deviceSN + "] transition to remote device failed"), 90160777658373L);
            }
        }
    }

    private void setInfo(Map<String, String> deviceWWNAndSNMAP, Map<String, String> deviceIDAndSNMAP, String strWWN, String strSN, String strDevID) {
        if (strWWN != null) {
            deviceWWNAndSNMAP.put(strWWN, strSN);
        }
        if (strDevID != null) {
            deviceIDAndSNMAP.put(strDevID, strSN);
        }
    }

    private boolean isMoLocked(String devSn) {
        OperationLock lock = DeviceOperationLock.getLock((String)devSn);
        if (null != lock && !VerifyUtil.isEmpty((String)lock.getOwnerName())) {
            logger.warn((Object)("the devsn is locked, sn: " + devSn + "owernerThread:" + lock.getOwnerName()), 90160777658373L);
            return true;
        }
        return false;
    }

    private void updateInitiators(String paramSourceSn, int status, IMoDao moDao, HvsUnit hvsUnit) {
        if (status == -1) {
            HashMap<String, Long> iprops = new HashMap<String, Long>();
            iprops.put("parentMo.moId", hvsUnit.getMoId());
            List oldInitiatorList = moDao.findMoBy(Initiator.class, iprops);
            if (this.isMoLocked(paramSourceSn)) {
                return;
            }
            this.updateWhenLinkDown(oldInitiatorList, moDao);
            return;
        }
        List<Initiator> newInitiatorList = this.queryInitiatorsFromDevice(paramSourceSn, hvsUnit);
        HashMap<String, Long> iprops = new HashMap<String, Long>();
        iprops.put("parentMo.moId", hvsUnit.getMoId());
        List oldInitiatorList = moDao.findMoBy(Initiator.class, iprops);
        HvsUnit unit = (HvsUnit)moDao.getMo(HvsUnit.class, "devSn", (Object)paramSourceSn);
        if (VerifyUtil.isEmpty((Object)unit)) {
            logger.error((Object)("hvsUnit is empty. DeviceSN:" + paramSourceSn), 90160758784001L);
            return;
        }
        if (this.isMoLocked(paramSourceSn)) {
            return;
        }
        MOUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, newInitiatorList, (List)oldInitiatorList);
    }

    private List<Initiator> queryInitiatorsFromDevice(String paramSourceSn, HvsUnit hvsUnit) {
        RestConnection connection = HvsRestConnectionManager.getInstance().getConnection(paramSourceSn);
        HVSDeviceProxyImpl deviceProxy = new HVSDeviceProxyImpl();
        HvsUnit newUnit = new HvsUnit();
        newUnit.setMoId(hvsUnit.getMoId());
        newUnit.setDevSn(hvsUnit.getDevSn());
        newUnit.setTopMoUuid(hvsUnit.getTopMoUuid());
        List newInitiatorList = deviceProxy.getInitiators(connection, newUnit);
        return newInitiatorList;
    }

    private void updateWhenLinkDown(List<Initiator> oldInitiatorList, IMoDao moDao) {
        for (Initiator eachInitiator : oldInitiatorList) {
            if (VerifyUtil.isEmpty((Object)eachInitiator.getRunningStatus()) || eachInitiator.getRunningStatus() == 4) continue;
            eachInitiator.setRunningStatus(Integer.valueOf(4));
            moDao.update((Object)eachInitiator);
        }
    }

    public void pollResource(String ipAddress, String port) {
        logger.trace((Object)"no need to pollResource");
    }

    public String getResourceType() {
        logger.trace((Object)"getResourceType");
        return HvsStorage.class.getName();
    }

    public String getResourceSN() {
        return this.sourceSn;
    }
}

