/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.license.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.DrFm;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IGalaxSiteResService;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.license.sdk.IDRVMPlatinicInter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GalaxDRVMPlatinicInterImpl
implements IDRVMPlatinicInter {
    private static final Log logger = LogFactory.getInstance(GalaxDRVMPlatinicInterImpl.class);
    private static final int FC_LICENSE_GOLD = 2;
    private static final int FC_LICENSE_RUNNING = 3;
    private IGalaxSiteResService galaxResService;
    private IFmService fmService;

    public void setGalaxResService(IGalaxSiteResService galaxResService) {
        this.galaxResService = galaxResService;
    }

    public void setFmService(IFmService fmService) {
        this.fmService = fmService;
    }

    public boolean isDRVMPlatinic() {
        logger.info((Object)"enter GalaxDRVMPlatinicInterImpl:isDRVMPlatinic.", 90160758787071L);
        try {
            List<VRM> vrmsList = this.getRegistedVrm();
            if (VerifyUtil.isEmpty(vrmsList)) {
                logger.info((Object)"there is no FusionCompute in local site.", 90160758787071L);
                return false;
            }
            for (VRM vrm : vrmsList) {
                if (3 != vrm.getLicenseVersion() && 2 != vrm.getLicenseVersion()) continue;
                logger.info((Object)("find the gold license FC, ip=" + vrm.getLinkIp()), 90160758787071L);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("get VRM license version catch exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        logger.info((Object)"there is no gold license FC.", 90160758787071L);
        return false;
    }

    private List<VRM> getRegistedVrm() {
        ArrayList<VRM> vrmsList = new ArrayList<VRM>();
        List vrms = VrmUtil.getAllMo(VRM.class);
        if (VerifyUtil.isEmpty((Collection)vrms)) {
            logger.info((Object)"there is no FusionCompute in system.", 90160758787071L);
            return vrmsList;
        }
        ArrayList<String> sns = new ArrayList<String>();
        for (VRM vrm : vrms) {
            sns.add(vrm.getSn());
        }
        List drVrms = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getResourceList(sns, DrVrm.class, "deviceSn");
        if (VerifyUtil.isEmpty((Collection)vrms)) {
            logger.info((Object)"there is no FusionCompute in site.", 90160758787071L);
            return vrmsList;
        }
        block1: for (VRM vrmTmp : vrms) {
            for (DrVrm drVrm : drVrms) {
                if (!vrmTmp.getSn().equals(drVrm.getDeviceSn())) continue;
                vrmsList.add(vrmTmp);
                continue block1;
            }
        }
        return vrmsList;
    }

    public boolean isDRVMPlatinic(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            return false;
        }
        if (12 != protectGroup.getPoType()) {
            return false;
        }
        try {
            DrResource cloudInfo = this.galaxResService.getDrResourceBySn(protectGroup.getPoProviderSN());
            if (null == cloudInfo) {
                logger.error((Object)("cloud is not reg:" + protectGroup.getPoProviderSN()));
                return false;
            }
            Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(protectGroup.getProductSiteId());
            if (null == site) {
                logger.error((Object)("site is null:" + protectGroup.getProductSiteId()));
                return false;
            }
            if (1 == site.getSiteType()) {
                return this.checkInRemote(cloudInfo, site);
            }
            logger.debug((Object)("check license on local site:" + site.getName()));
            return this.checkInLocal(cloudInfo);
        }
        catch (Exception e) {
            logger.error((Object)("get VRM license version catch exception." + ExceptionUtil.getErrorMessage((Throwable)e)));
            logger.debug((Object)"there is no gold license FC.");
            return false;
        }
    }

    private boolean checkInRemote(DrResource cloudInfo, Site site) {
        logger.debug((Object)("check license on remote site:" + site.getName()));
        ICloudService cloudService = (ICloudService)ServiceLocator.getInstance().getService(ICloudService.class);
        if (cloudInfo instanceof DrVrm) {
            VRM vrm = cloudService.getRemoteVrmByVrgSn(site, cloudInfo.getDeviceSn());
            if (null == vrm) {
                logger.error((Object)("get vrm from remote is null:" + cloudInfo.getDeviceSn()));
                return false;
            }
            logger.debug((Object)("vrm LicenseVersion is " + vrm.getLicenseVersion()));
            if (3 == vrm.getLicenseVersion() || 2 == vrm.getLicenseVersion()) {
                logger.debug((Object)("VRM(" + vrm.getName() + ") is platinic"));
                return true;
            }
        } else if (cloudInfo instanceof DrFm) {
            List vrms = cloudService.getRemoteRegistedFcOfSpecfiedFm(site, cloudInfo.getDeviceSn());
            for (VRM vrm : vrms) {
                logger.debug((Object)("vrm(" + vrm.getName() + ")'LicenseVersion is " + vrm.getLicenseVersion()));
                if (3 != vrm.getLicenseVersion() && 2 != vrm.getLicenseVersion()) continue;
                logger.debug((Object)("FM(" + cloudInfo.getName() + ") is platinic because of VRM(" + vrm.getName() + ")"));
                return true;
            }
        }
        return false;
    }

    private boolean checkInLocal(DrResource cloudInfo) {
        if (cloudInfo instanceof DrVrm) {
            VRM vrm = (VRM)CommonDAOLocator.getMoDao().getMo(VRM.class, "uuid", (Object)cloudInfo.getDeviceSn());
            if (3 == vrm.getLicenseVersion() || 2 == vrm.getLicenseVersion()) {
                logger.debug((Object)("VRM(" + vrm.getName() + ") is platinic"));
                return true;
            }
        } else if (cloudInfo instanceof DrFm) {
            List vrms = this.fmService.getRegistedFcOfSpecfiedFm(cloudInfo.getDeviceSn());
            for (VRM vrm : vrms) {
                if (3 != vrm.getLicenseVersion() && 2 != vrm.getLicenseVersion()) continue;
                logger.debug((Object)("FM(" + cloudInfo.getName() + ") is platinic because of VRM(" + vrm.getName() + ")"));
                return true;
            }
        }
        return false;
    }
}

