/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.license.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.galax.sdk.model.DrFm;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IGalaxSiteResService;
import com.huawei.ism.drm.license.sdk.ILicenseBaseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;

public class GalaxVmLicenseCheckObserverImpl
implements IObjectObserver {
    private static final Log logger = LogFactory.getInstance(GalaxVmLicenseCheckObserverImpl.class);
    private static final int FC_LICENSE_GOLD = 2;
    private static final int FC_LICENSE_RUNNING = 3;
    private IGalaxSiteResService galaxResService;
    private IFmService fmService;

    public void setGalaxResService(IGalaxSiteResService galaxResService) {
        this.galaxResService = galaxResService;
    }

    public void setFmService(IFmService fmService) {
        this.fmService = fmService;
    }

    public void before(MessageEvent event) {
        VirtualizationCommonUtil commonUtil = VirtualizationCommonUtil.getInstance();
        List objectList = event.getObjectList();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup)) continue;
            ProtectGroup protectGroup = (ProtectGroup)object;
            if (!this.isNeedToCheck(protectGroup)) {
                logger.debug((Object)("pg is not need to check:" + protectGroup.getName() + "###" + protectGroup.getPoProviderSN()));
                continue;
            }
            if (messageType == 0) {
                logger.debug((Object)("begin check License for pg:" + protectGroup.getName()));
                commonUtil.checkLicense(protectGroup.getTemplate().getType(), protectGroup.getPoCount());
            }
            if (messageType != 3) continue;
            ProtectGroup curPg = ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).getProtectGroupByID(protectGroup.getUuid());
            int addPoCount = protectGroup.getPoCount() - curPg.getPoCount();
            logger.debug((Object)("begin check License for pg:" + protectGroup.getName()));
            commonUtil.checkLicense(protectGroup.getTemplate().getType(), addPoCount);
        }
    }

    public void after(MessageEvent event) {
        List objectList = event.getObjectList();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            ILicenseBaseControl licenseCtr;
            if (!(object instanceof ProtectGroup)) continue;
            ProtectGroup protectGroup = (ProtectGroup)object;
            if (!this.isNeedToCheck(protectGroup)) {
                logger.debug((Object)("pg is not need to check:" + protectGroup.getName() + "###" + protectGroup.getPoProviderSN()));
                continue;
            }
            if (messageType == 0 || messageType == 3) {
                logger.debug((Object)("begin check License for pg:" + protectGroup.getName()));
                licenseCtr = (ILicenseBaseControl)ServiceLocator.getInstance().getService(ILicenseBaseControl.class);
                licenseCtr.checkLicenseOutOfControlAlarm();
            }
            if (messageType != 2 && messageType != 4) continue;
            logger.debug((Object)("begin check License for pg:" + protectGroup.getName()));
            licenseCtr = (ILicenseBaseControl)ServiceLocator.getInstance().getService(ILicenseBaseControl.class);
            licenseCtr.checkLicenseOutOfControlAlarm(true);
        }
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private boolean isNeedToCheck(ProtectGroup protectGroup) {
        if (12 != protectGroup.getPoType()) {
            return false;
        }
        DrResource cloudInfo = this.galaxResService.getDrResourceBySn(protectGroup.getPoProviderSN());
        if (null == cloudInfo) {
            logger.debug((Object)("cloudInfo is null:" + protectGroup.getPoProviderSN()));
            return false;
        }
        Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(cloudInfo.getSiteId());
        if (null == site || 1 == site.getSiteType()) {
            logger.debug((Object)("site is null or is not in local:" + cloudInfo.getSiteId()));
            return false;
        }
        if (cloudInfo instanceof DrVrm) {
            VRM vrm = (VRM)CommonDAOLocator.getMoDao().getMo(VRM.class, "uuid", (Object)cloudInfo.getDeviceSn());
            if (3 == vrm.getLicenseVersion() || 2 == vrm.getLicenseVersion()) {
                logger.debug((Object)("VRM(" + vrm.getName() + ") is platinic"));
                return false;
            }
            return true;
        }
        if (cloudInfo instanceof DrFm) {
            List vrms = this.fmService.getRegistedFcOfSpecfiedFm(cloudInfo.getDeviceSn());
            for (VRM vrm : vrms) {
                if (3 != vrm.getLicenseVersion() && 2 != vrm.getLicenseVersion()) continue;
                logger.debug((Object)("FM(" + cloudInfo.getName() + ") is platinic because of VRM(" + vrm.getName() + ")"));
                return false;
            }
            return true;
        }
        return false;
    }
}

