/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.monitor.balance;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.monitor.balance.VMBalanceTask;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class VMBalancePoller
implements IPoller {
    private static final Log LOGGER = LogFactory.getInstance(VMBalancePoller.class);
    private static ExecutorService executor = Executors.newCachedThreadPool();
    private String pollerId = null;
    private String pollerType = null;

    public VMBalancePoller(String pollerId, String pollerType) {
        this.pollerId = pollerId;
        this.pollerType = pollerType;
    }

    public void run() {
        try {
            LOGGER.info((Object)"begin balance vm poller.", 90160758786816L);
            List vrms = CommonDAOLocator.getMoDao().getAllMo(VRM.class);
            if (VerifyUtil.isEmpty((Collection)vrms)) {
                LOGGER.info((Object)"there is no vrm in this system.", 90160758786816L);
                return;
            }
            for (VRM vrm : vrms) {
                if (null == vrm) continue;
                VMBalanceTask balanceTask = new VMBalanceTask(vrm.getSn());
                executor.execute(balanceTask);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("some exceptions happened in balance poller:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    public String getPollerID() {
        return this.pollerId;
    }

    public String getPollerType() {
        return this.pollerType;
    }
}

