/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.monitor.balance;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.pg.host.service.IRecoveryVmController;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmBalanceData;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public class VMBalanceTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance(VMBalanceTask.class);
    private static final String FS_HOST_BUNDLE = "DRM_FusionShpere_HRA";
    private String sn;

    public VMBalanceTask(String sn) {
        this.sn = sn;
    }

    @Override
    public void run() {
        try {
            this.handleBalanceTask();
        }
        catch (Exception e) {
            LOGGER.error((Object)("balance task of VRM catch exception, sn=" + this.sn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    private void handleBalanceTask() {
        LOGGER.info((Object)("begin vm balance in vrm, sn=" + this.sn), 90160758786816L);
        if (VerifyUtil.isEmpty((String)this.sn)) {
            LOGGER.error((Object)"parameter sn is null, so return.", 90160758787071L);
            return;
        }
        VrmObject vrmObject = VrmUtil.getRecoveryVrmObject((String)this.sn);
        if (null == vrmObject) {
            LOGGER.error((Object)("can not find VRM by sn, sn=" + this.sn), 90160758787071L);
            return;
        }
        Set<String> urnSet = this.getClusterUrnByVrm(this.sn);
        if (VerifyUtil.isEmpty(urnSet)) {
            return;
        }
        Set<String> cluterUris = this.getClusterUriByUrn(urnSet);
        if (VerifyUtil.isEmpty(cluterUris)) {
            LOGGER.warn((Object)("there is not cluster information in vrm, sn=" + this.sn), 90160758786816L);
            return;
        }
        ArrayList<VmBalanceData> balanceDatas = new ArrayList<VmBalanceData>();
        for (String clusterUri : cluterUris) {
            List<VmBalanceData> dataTemps = this.getNeedBalanceVm(clusterUri, vrmObject);
            if (VerifyUtil.isEmpty(dataTemps)) {
                LOGGER.info((Object)("there is no need balance vm in cluster, uri=" + clusterUri), 90160758786816L);
                continue;
            }
            balanceDatas.addAll(dataTemps);
        }
        if (balanceDatas.isEmpty()) {
            LOGGER.info((Object)"there is no vm need to balance.", 90160758786816L);
            return;
        }
        this.balanceVms(balanceDatas, this.sn);
        LOGGER.info((Object)("end vm balance in vrm, sn=" + this.sn), 90160758786816L);
    }

    private Set<String> getClusterUrnByVrm(String vrmSn) {
        List smList;
        String hsql = "from ResourceMapping as rm where rm.resourceType = 0 and (rm.productResourceProviderId = ? or rm.recoveryResourceProviderId = ?)";
        try {
            smList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hsql, new Object[]{vrmSn, vrmSn});
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"get cluster mapping information exception", (Throwable)e, 90160758787071L);
            return null;
        }
        if (VerifyUtil.isEmpty((Collection)smList)) {
            LOGGER.info((Object)("there is no cluster mapping information, vrm=" + vrmSn), 90160758786816L);
            return null;
        }
        HashSet<String> urnSet = new HashSet<String>();
        for (ResourceMapping rMapping : smList) {
            if (vrmSn.equalsIgnoreCase(rMapping.getProductResourceProviderId())) {
                urnSet.add(rMapping.getProductResourceId());
                continue;
            }
            urnSet.add(rMapping.getRecoveryResourceId());
        }
        return urnSet;
    }

    private Set<String> getClusterUriByUrn(Collection<String> clusterUrns) {
        HashSet<String> uriSet = new HashSet<String>();
        if (VerifyUtil.isEmpty(clusterUrns)) {
            return uriSet;
        }
        for (String clusterUrn : clusterUrns) {
            List clusters = CommonDAOLocator.getMoDao().getMoList(ComputeCluster.class, "urn", (Object)clusterUrn);
            if (VerifyUtil.isEmpty((Collection)clusters)) {
                LOGGER.warn((Object)("can not find the cluster by urn, urn=" + clusterUrn), 90160758786816L);
                continue;
            }
            uriSet.add(((ComputeCluster)clusters.get(0)).getUri());
        }
        return uriSet;
    }

    private List<VmBalanceData> getNeedBalanceVm(String clusterUri, VrmObject vrmObject) {
        if (VerifyUtil.isEmpty((String)clusterUri)) {
            return null;
        }
        try {
            IVirtualResourceManager vResourceManager = VrmManager.getInstance().getVrmVirtualResService();
            return vResourceManager.queryVMBalanceDr(vrmObject, clusterUri);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("get balance vm catch LegoCheckedException, uri=" + clusterUri), (Throwable)e, 90160758787071L);
            return null;
        }
    }

    private void balanceVms(List<VmBalanceData> balanceDatas, String fcSn) {
        IRecoveryVmController recoveryVmService = (IRecoveryVmController)ServiceLocator.getBundleService((String)FS_HOST_BUNDLE, (String)IRecoveryVmController.class.getName());
        try {
            recoveryVmService.changeVmHostAgent(balanceDatas, fcSn);
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to change host agent of vrg vm." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }
}

