/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.monitor.dsware;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.vrg.base.model.ResponseVolume;
import com.huawei.ism.drm.galax.sdk.vrg.base.model.VRGObject;
import com.huawei.ism.drm.galax.sdk.vrg.base.model.VRGVmConfigInfo;
import com.huawei.ism.drm.galax.sdk.vrg.base.model.WriteAgentConfigBase;
import com.huawei.ism.drm.galax.sdk.vrg.base.model.r5c10.RecoveryVolume;
import com.huawei.ism.drm.galax.sdk.vrg.base.model.r5c10.WriteAgentConfig;
import com.huawei.ism.drm.galax.sdk.vrg.service.IVRGController;
import com.huawei.ism.drm.galax.sdk.vrm.model.VolumeData;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DSWareMgrIpTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance(DSWareMgrIpTask.class);
    private static final String FS_VRG_BUNDLE = "DRM_FusionShpere_VRG";
    private static final long CONERR = 51L;
    private static final int VM_CONFIG_DR_FLAG = 2;
    private static final int CONFIG_VM_MAX_RETRY_TIMES = 3;
    private static final int SLEEP_TIMES = 500;
    private VRM vrm;

    public DSWareMgrIpTask(VRM vrm) {
        this.vrm = vrm;
    }

    @Override
    public void run() {
        try {
            this.dsWareMgrIpBuss();
        }
        catch (Exception e) {
            LOGGER.error((Object)("monitor dsware manager ip failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    private void dsWareMgrIpBuss() {
        VrmObject vrmObject = VrmUtil.generateVrmObj((String)String.valueOf(this.vrm.getMoId()));
        if (!CommonUtil.isVrmMoreR5C00((VrmObject)vrmObject)) {
            LOGGER.info((Object)"this version is r5c00, not need to monitor dsware.", 90160758786816L);
            return;
        }
        List<VRG> vrgs = this.getVrgByResouceMapping(this.vrm.getSn());
        Map<String, List<VRGVmConfigInfo>> vmConfigMap = this.getVmConfigInVrg(vrgs);
        if (VerifyUtil.isEmpty(vmConfigMap)) {
            return;
        }
        Map<String, VolumeData> volMap = this.getDSWareVolume();
        if (VerifyUtil.isEmpty(volMap)) {
            return;
        }
        this.compareDSWareMgrIp(vmConfigMap, volMap);
    }

    private List<VRG> getVrgByResouceMapping(String vrmSn) {
        List mappings = VrmManager.getInstance().getDaoAdapter().getResourceMappingByType(Integer.valueOf(ResTypeEnum.VRG.getResType()));
        if (VerifyUtil.isEmpty((Collection)mappings)) {
            LOGGER.info((Object)"there is no resource mapping of vrg.", 90160758786816L);
            return null;
        }
        ArrayList<ResourceMapping> tempMappings = new ArrayList<ResourceMapping>();
        for (ResourceMapping mapping : mappings) {
            if (!vrmSn.equals(mapping.getProductResourceProviderId()) && !vrmSn.equals(mapping.getRecoveryResourceProviderId())) continue;
            tempMappings.add(mapping);
        }
        if (VerifyUtil.isEmpty(tempMappings)) {
            LOGGER.info((Object)("there is no resource mapping of vrg under fc, sn=" + vrmSn), 90160758786816L);
            return null;
        }
        List allVrgs = CommonDAOLocator.getMoDao().getAllMo(VRG.class);
        if (VerifyUtil.isEmpty((Collection)allVrgs)) {
            LOGGER.info((Object)"there is no vrg in system.", 90160758786816L);
            return null;
        }
        ArrayList<VRG> tempVrgs = new ArrayList<VRG>();
        for (VRG vrg : allVrgs) {
            for (ResourceMapping mapping : tempMappings) {
                if (!vrg.getSn().equals(mapping.getProductResourceId()) && !vrg.getSn().equals(mapping.getRecoveryResourceId())) continue;
                tempVrgs.add(vrg);
            }
        }
        return tempVrgs;
    }

    private Map<String, List<VRGVmConfigInfo>> getVmConfigInVrg(List<VRG> vrgs) {
        HashMap<String, List<VRGVmConfigInfo>> configInfoMap = new HashMap<String, List<VRGVmConfigInfo>>();
        if (VerifyUtil.isEmpty(vrgs)) {
            LOGGER.info((Object)"there is no vrg under resouce mapping.", 90160758786816L);
            return configInfoMap;
        }
        IVRGController vrgCtrl = (IVRGController)this.getBundleService(FS_VRG_BUNDLE, IVRGController.class.getName());
        for (VRG vrg : vrgs) {
            VRGObject vrgObject = this.getVrgObject(vrg.getMoId());
            List vmConfigInfos = vrgCtrl.getAllVmConfigInfo(vrgObject);
            if (VerifyUtil.isEmpty((Collection)vmConfigInfos)) continue;
            ArrayList<VRGVmConfigInfo> tempConfigInfos = new ArrayList<VRGVmConfigInfo>();
            for (VRGVmConfigInfo configInfo : vmConfigInfos) {
                if (2 != configInfo.getFlag()) continue;
                tempConfigInfos.add(configInfo);
            }
            configInfoMap.put(vrg.getSn(), tempConfigInfos);
        }
        return configInfoMap;
    }

    private VRGObject getVrgObject(Long vrgId) {
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(NeMgrProtocolExtend.class, (Serializable)vrgId);
        if (null == extend) {
            LOGGER.error((Object)("Extend(" + vrgId + ")'NeMgrProtocolExtend dosen't exist.Failed to get."), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        return new VRGObject(extend);
    }

    private Map<String, VolumeData> getDSWareVolume() {
        HashMap<String, VolumeData> volumeMap = new HashMap<String, VolumeData>();
        List<DataStore> dataStores = this.getDataStoreByMapping();
        if (VerifyUtil.isEmpty(dataStores)) {
            LOGGER.info((Object)"there is no datastore from mapping.", 90160758786816L);
            return volumeMap;
        }
        VrmObject vrmInfo = VrmUtil.generateVrmObj((String)String.valueOf(this.vrm.getMoId()));
        for (DataStore dataStore : dataStores) {
            List volDatas = VrmManager.getInstance().getVrmVirtualResService().queryVolumeByDataStoreUrn(vrmInfo, dataStore.getUrn(), true);
            if (VerifyUtil.isEmpty((Collection)volDatas)) continue;
            for (VolumeData data : volDatas) {
                LOGGER.info((Object)("volume date is:" + data.toString()), 90160758786816L);
                volumeMap.put(data.getUuid(), data);
            }
        }
        return volumeMap;
    }

    private List<DataStore> getDataStoreByMapping() {
        List dataStores = VrmManager.getInstance().getDaoAdapter().getSubListMo(DataStore.class, this.vrm.getMoId(), null);
        if (null == dataStores) {
            LOGGER.info((Object)("there is no datastore under vrm, sn=" + this.vrm.getSn()), 90160758786816L);
            return null;
        }
        ArrayList<DataStore> tempDataStores = new ArrayList<DataStore>();
        for (DataStore dataStore : dataStores) {
            if (!"DSWARE".equalsIgnoreCase(dataStore.getStorageType())) continue;
            tempDataStores.add(dataStore);
        }
        if (VerifyUtil.isEmpty(tempDataStores)) {
            LOGGER.info((Object)("there is no dsware datastore under vrm, sn=" + this.vrm.getSn()), 90160758786816L);
            return null;
        }
        List mappings = VrmManager.getInstance().getDaoAdapter().getResourceMappingByType(Integer.valueOf(ResTypeEnum.DATASTORE.getResType()));
        if (VerifyUtil.isEmpty((Collection)mappings)) {
            LOGGER.info((Object)"there is no resource mapping of datastore.", 90160758786816L);
            return null;
        }
        ArrayList<DataStore> tmpDataStoreMappings = new ArrayList<DataStore>();
        for (DataStore dataStore : tempDataStores) {
            for (ResourceMapping mapping : mappings) {
                if (!dataStore.getUuid().equals(mapping.getProductResourceId()) && !dataStore.getUuid().equals(mapping.getRecoveryResourceId())) continue;
                tmpDataStoreMappings.add(dataStore);
            }
        }
        return tmpDataStoreMappings;
    }

    private void compareDSWareMgrIp(Map<String, List<VRGVmConfigInfo>> vmConfigMap, Map<String, VolumeData> volMap) {
        Set<Map.Entry<String, List<VRGVmConfigInfo>>> vmCfgSet = vmConfigMap.entrySet();
        for (Map.Entry<String, List<VRGVmConfigInfo>> vmCfg : vmCfgSet) {
            List<VRGVmConfigInfo> configInfos = vmCfg.getValue();
            for (VRGVmConfigInfo configInfo : configInfos) {
                boolean isDswareChanged = false;
                List volumes = configInfo.getVolList();
                for (ResponseVolume volume : volumes) {
                    VolumeData volData = volMap.get(volume.getVolUuid());
                    if (null == volData) {
                        LOGGER.error((Object)("volume not exsit from fc, uuid=" + volume.getVolUuid()), 90160758787071L);
                        continue;
                    }
                    String drExtParam = volData.getDrExtParams();
                    if (VerifyUtil.isEmpty((String)drExtParam)) {
                        LOGGER.error((Object)("there is no Dsware manage ip, maybe some wrong happend, uuid=" + volume.getVolUuid()), 90160758787071L);
                        continue;
                    }
                    String vrgExtParam = volume.getDrExtParams();
                    if (VerifyUtil.isEmpty((String)vrgExtParam)) {
                        isDswareChanged = true;
                        volume.setDrExtParams(drExtParam);
                        continue;
                    }
                    if (vrgExtParam.equals(drExtParam)) continue;
                    isDswareChanged = true;
                    volume.setDrExtParams(drExtParam);
                    StringBuilder logInfos = new StringBuilder();
                    logInfos.append("dsware manage ip changed, vmId=");
                    logInfos.append(configInfo.getVmId());
                    logInfos.append(", vmName=");
                    logInfos.append(configInfo.getVmName());
                    logInfos.append(", old manage info =");
                    logInfos.append(vrgExtParam);
                    logInfos.append(", new manage info =");
                    logInfos.append(drExtParam);
                    LOGGER.info((Object)logInfos.toString(), 90160758786816L);
                }
                if (!isDswareChanged) continue;
                this.reconfigVM(vmCfg.getKey(), configInfo, volMap);
            }
        }
    }

    private void reconfigVM(String vrgSn, VRGVmConfigInfo configInfo, Map<String, VolumeData> volMap) {
        IVRGController vrgService = (IVRGController)this.getBundleService(FS_VRG_BUNDLE, IVRGController.class.getName());
        VRGVmConfigInfo tempCfg = vrgService.getVmConfigInfo(vrgSn, configInfo.getVmUuid());
        if (null == tempCfg) {
            LOGGER.warn((Object)("the vm config not exsit in vrg, vmUuid=" + configInfo.getVmUuid()), 90160758786816L);
            return;
        }
        for (int idx = 0; idx < 3; ++idx) {
            try {
                vrgService.configWriteAgent(vrgSn, this.getWriteConfigParam(configInfo, volMap));
                break;
            }
            catch (Exception e) {
                LOGGER.error((Object)("config vm on vrg falied, so retry do it. volUuid=" + configInfo.getVmUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    LOGGER.error((Object)"this thread sleep failed.", 90160758787071L);
                }
                continue;
            }
        }
    }

    private WriteAgentConfigBase getWriteConfigParam(VRGVmConfigInfo configInfo, Map<String, VolumeData> volMap) {
        WriteAgentConfig agentConfig = new WriteAgentConfig();
        agentConfig.setAgentIp(configInfo.getAgentIp());
        agentConfig.setAgentPort(configInfo.getAgentPort().intValue());
        agentConfig.setHostUrn(configInfo.getHostUrn());
        agentConfig.setVmId(configInfo.getVmId());
        agentConfig.setVmName(configInfo.getVmName());
        agentConfig.setVmUuid(configInfo.getVmUuid());
        ArrayList<RecoveryVolume> confVols = new ArrayList<RecoveryVolume>();
        List rspVolumes = configInfo.getVolList();
        for (ResponseVolume repVol : rspVolumes) {
            RecoveryVolume recoveryVolume = new RecoveryVolume();
            recoveryVolume.setDrExtParams(repVol.getDrExtParams());
            recoveryVolume.setDsUrn(repVol.getDstVolDsurn());
            recoveryVolume.setSeqNum(repVol.getSeqNum().intValue());
            recoveryVolume.setVolType(repVol.getDstVolType());
            recoveryVolume.setVolUuid(repVol.getVolUuid());
            LOGGER.info((Object)("volume date is:" + repVol.toString()), 90160758786816L);
            VolumeData volumeData = volMap.get(repVol.getVolUuid());
            if (null != volumeData) {
                recoveryVolume.setVolumeUrl(volumeData.getVolNameOnDev());
            } else {
                LOGGER.error((Object)("this volume can not find the volume url, volUuid=" + repVol.getVolUuid()), 90160758787071L);
            }
            confVols.add(recoveryVolume);
        }
        agentConfig.setVolList(confVols);
        return agentConfig;
    }

    private Object getBundleService(String bundle, String service) {
        ServiceContext context = ServiceContext.getInstance();
        LOGGER.info((Object)("bundle:" + bundle), 653110170615808L);
        LOGGER.info((Object)("service:" + service), 653110170615808L);
        Object obj = context.lookup(bundle + "/" + service);
        if (obj == null) {
            String[] parStrArr = new String[]{"lego.dic.module." + bundle};
            LegoCheckedException le = new LegoCheckedException(51L, parStrArr);
            LOGGER.error((Object)("getBundleService error :" + bundle + "/" + service), (Throwable)le, 653110170615808L);
            throw le;
        }
        return obj;
    }
}

