/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.monitor.topo;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.constant.cloudenum.HostStatusEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VrgMapStatusEnum;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DrFm;
import com.huawei.ism.drm.galax.sdk.model.DrVRG;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.pg.model.GalaxCNAInfo;
import com.huawei.ism.drm.galax.sdk.pg.model.GalaxCNATopoData;
import com.huawei.ism.drm.galax.topo.sdk.element.CloudElement;
import com.huawei.ism.drm.galax.topo.sdk.element.VrgElement;
import com.huawei.ism.drm.galax.topology.GalaXTopoResourceHelper;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.topo.builder.AbstractGlobalTopoBaseBuilder;
import com.huawei.ism.drm.topo.element.StorageElement;
import com.huawei.ism.drm.topo.sdk.builder.ITopoBaseBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.twaver.Element;
import com.huawei.twaver.ElementBox;
import com.huawei.twaver.Group;
import com.huawei.twaver.IData;
import com.huawei.twaver.Link;
import com.huawei.twaver.Node;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:Global-Topology-0-12##Global-Topology-1-12##Global-Topology-11-12##Global-Topology-8-12##Global-Topology-10-12##Global-Topology-13-12##Global-Topology-15-12##Global-Topology-18-12##Global-Topology-19-12##Global-Topology-23-12##Global-Topology-24-12##Global-Topology-3-12##Global-Topology-4-12##Global-Topology-5-12##Global-Topology-6-12##Global-Topology-20-12##Global-Topology-7-12##Global-Topology-28-12##Global-Topology-33-12##Global-Topology-26-12##Global-Topology-27-12##Global-Topology-39-12##Global-Topology-51-12##Global-Topology-52-12##Global-Topology-2-12")
public class GalaXGlobalTopoBuilder
extends AbstractGlobalTopoBaseBuilder {
    private static final Log logger = LogFactory.getInstance(GalaXGlobalTopoBuilder.class);
    private static final List<Integer> SAN_ACTIVE_TEMPLATE_TYPE_LIST = new ArrayList<Integer>(Arrays.asList(15, 18, 23, 28, 19, 26, 27));
    private static final List<Integer> REPLICATION_TEMPLATES = Arrays.asList(1, 0, 20, 18, 24, 23, 33, 39, 3, 4, 5, 6, 26, 27, 52, 51);
    private static final String SN_CONNECT_SITE = "---";
    private static final String USEFUL = "useful";
    private static final String CENTER = "center";
    private static final String COUNT = "count";
    private static final int COLUMN_NUM = 2;
    private static final double INIT_X = 200.0;
    private static final double INIT_Y = 100.0;
    private static final double GROUP_INC_X = 600.0;
    private static final double GROUP_INC_Y = 400.0;
    private static final double PT_FC = 400.0;
    private static final double PT_VRG_STORAGE = 600.0;
    private static final double RC_FM = 1200.0;
    private static final double RC_FC = 1000.0;
    private static final double RC_VRG_STORAGE = 800.0;
    private static final double INC_NODE_Y = 70.0;

    public void buildTopo(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"GalaXGlobalTopoBuilder protectGroup is null. ");
            return;
        }
        if (this.getPoCountByPgUuid(protectGroup.getUuid()) <= 0L) {
            logger.error((Object)"Data poList is empty,protectGroupName is %s.", new Object[]{protectGroup.getName()});
            return;
        }
        ElementBox layout = (ElementBox)context.find((Object)"layout");
        int templateType = protectGroup.getTemplate().getType();
        if (SAN_ACTIVE_TEMPLATE_TYPE_LIST.contains(templateType)) {
            this.hyperMetroTopology(context, protectGroup, layout, templateType);
            return;
        }
        String siteId = protectGroup.getProductSiteId();
        Site productStorageSite = this.getSiteInContext(context, siteId);
        Group group = this.getOrCreateGroup(context.getElementBox(), productStorageSite, layout);
        String providerSn = protectGroup.getPoProviderSN();
        if (templateType == 11) {
            GalaXTopoResourceHelper topoHelper = new GalaXTopoResourceHelper(protectGroup);
            this.createProductCloudPlatFormTopo(providerSn, group, topoHelper, context, layout);
            List<String> productFcSns = this.getProductFcSns(providerSn, topoHelper);
            if (VerifyUtil.isEmpty(productFcSns)) {
                logger.error((Object)"Data productFcSns is empty, protectGroupName is %s.", new Object[]{protectGroup.getName()});
                return;
            }
            for (String productFcSn : productFcSns) {
                this.createVrgTopo(context, topoHelper, productFcSn, layout);
            }
        } else {
            this.createVisOrArrayCNATopo(protectGroup, (Node)group, layout, context, productStorageSite);
            ITopoBaseBuilder visBuilder = templateType == 20 || templateType == 24 ? context.getTopoBuilderManager().getTopoBuilder("Global-Topology-20") : context.getTopoBuilderManager().getTopoBuilder("Global-Topology-5");
            visBuilder.buildTopo(context);
        }
    }

    private void hyperMetroTopology(TopoBaseContext context, ProtectGroup protectGroup, ElementBox layout, int templateType) {
        this.createHyperMetroTopo(context, protectGroup, layout);
        ITopoBaseBuilder sanBuilder = templateType == 26 ? context.getTopoBuilderManager().getTopoBuilder("Global-Topology-26") : (templateType == 27 ? context.getTopoBuilderManager().getTopoBuilder("Global-Topology-27") : context.getTopoBuilderManager().getTopoBuilder("Global-Topology-15"));
        sanBuilder.buildTopo(context);
    }

    private void createHyperMetroTopo(TopoBaseContext context, ProtectGroup protectGroup, ElementBox layout) {
        ElementBox box = context.getElementBox();
        String topoInfo = (String)protectGroup.getProps().get(PgExParamsEnum.PG_GLOBAL_TOPO.getValue());
        List infos = (List)CommonUtil.json2Bean((String)topoInfo, GalaxCNATopoData[].class);
        if (VerifyUtil.isEmpty((Collection)infos)) {
            logger.error((Object)"GlobalTopo Data is empty. ", 90160758787071L);
            return;
        }
        for (GalaxCNATopoData info : infos) {
            List hosts = info.getHosts();
            for (GalaxCNAInfo host : hosts) {
                DrResource drHostSystem = this.getDrResourceInContext(context, host.getHostUuid());
                Site prodSite = this.getSiteInContext(context, drHostSystem.getSiteId());
                Group group = this.getOrCreateGroup(box, prodSite, layout);
                Node hostNode = (Node)box.getElementByID((Object)(host.getHostUuid() + SN_CONNECT_SITE + "GalaX"));
                if (hostNode == null) {
                    hostNode = this.createHostNode(host.getHostUuid(), host.getHostname(), host.getHostStatus(), prodSite, info.getClusterName());
                    this.initNodeLocation(hostNode, (Node)group, layout);
                    group.addChild((IData)hostNode);
                    TopoServiceUtil.addElementToBox((ElementBox)box, (IData)hostNode);
                    this.addIdtoList(context.getHostNodeIds(), (String)hostNode.getID());
                }
                context.getVmEsxNode().add(hostNode);
                this.addProtectGroupIDToElement((Element)hostNode, protectGroup.getUuid());
            }
        }
    }

    private void createVisOrArrayCNATopo(ProtectGroup pg, Node fatherNode, ElementBox layout, TopoBaseContext context, Site site) {
        int templateType = pg.getTemplate().getType();
        String topoInfo = (String)pg.getProps().get(PgExParamsEnum.PG_GLOBAL_TOPO.getValue());
        List infos = (List)CommonUtil.json2Bean((String)topoInfo, GalaxCNATopoData[].class);
        if (VerifyUtil.isEmpty((Collection)infos)) {
            logger.error((Object)"GlobalTopo Data is empty. ", 90160758787071L);
            return;
        }
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (GalaxCNATopoData info : infos) {
            if (info.isClusterFlg()) {
                List<Node> nodes = this.createArrayClusterTopo(info, fatherNode, layout, context, site);
                nodeList.addAll(nodes);
                continue;
            }
            if (null == info.getHosts() || info.getHosts().isEmpty()) continue;
            GalaxCNAInfo host = (GalaxCNAInfo)info.getHosts().get(0);
            Node node = this.createArrayComputeNodeTopo(host, fatherNode, layout, context, site);
            nodeList.add(node);
        }
        if (REPLICATION_TEMPLATES.contains(templateType)) {
            this.createHostStorageLinkTopo(context, nodeList, layout);
        }
    }

    private void createHostStorageLinkTopo(TopoBaseContext context, List<Node> nodeList, ElementBox layout) {
        ProtectGroup pg = context.getProtectGroup();
        ProtectObjectStorageInfo poStorageInfo = context.getTopoBaseService().getProtectObjectStorageInfoByPgId(pg.getUuid());
        String ptStgSn = poStorageInfo.getResourceProviderSN();
        Node productArrayNode = this.addStorageNode(ptStgSn, context, layout, pg);
        for (Node hostNode : nodeList) {
            this.createCNAHostStorageLink(context, pg, hostNode, productArrayNode);
        }
    }

    private Node addStorageNode(String sn, TopoBaseContext context, ElementBox layout, ProtectGroup protectGroup) {
        ElementBox box = context.getElementBox();
        DrStorage drStorage = (DrStorage)this.getDrResourceInContext(context, sn);
        if (drStorage == null) {
            return null;
        }
        String productStorageSiteID = drStorage.getSiteId();
        Site productStorageSite = this.getSiteInContext(context, productStorageSiteID);
        Group productStorageSiteGroup = this.getOrCreateGroup(box, productStorageSite, layout);
        Node productArrayNode = (Node)box.getElementByID((Object)(drStorage.getDeviceSn() + SN_CONNECT_SITE + productStorageSiteID));
        if (productArrayNode == null) {
            productArrayNode = this.createStorageNode(drStorage);
            this.initNodeLocation(productArrayNode, (Node)productStorageSiteGroup, layout);
            productStorageSiteGroup.addChild((IData)productArrayNode);
            TopoServiceUtil.addElementToBox((ElementBox)box, (IData)productArrayNode);
        }
        this.addProtectGroupIDToElement((Element)productArrayNode, protectGroup.getUuid());
        return productArrayNode;
    }

    protected void createCNAHostStorageLink(TopoBaseContext context, ProtectGroup protectGroup, Node from, Node to) {
        Link link = TopoServiceUtil.getExistLinkBetweenNodes((Node)from, (Node)to);
        if (link == null) {
            String linkID = "hostlink-" + protectGroup.getUuid() + from.getID();
            link = new Link((Object)linkID, from, to);
            link.setStyle("link.color", (Object)"0x31bd16");
            link.setStyle("arrow.to.color", (Object)"0x31bd16");
            link.setClient("linkToXOffset", 10.0);
            link.setStyle("link.width", 1.0);
            link.setStyle("arrow.to", true);
            link.setStyle("arrow.to.width", (Object)REPLICATION_ARROW_IO_WIDTH);
            link.setStyle("arrow.to.height", (Object)REPLICATION_ARROW_IO_HIGHTH);
            link.setStyle("arrow.to.shape", (Object)"arrow.delta");
            link.setStyle("select.alpha", 1.0);
            link.setStyle("select.style", (Object)"none");
            TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)link);
        }
        try {
            this.setLinkDetail(context, link, from, to);
        }
        catch (Exception e) {
            logger.error((Object)("setLinkDetail error!" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
    }

    private List<Node> createArrayClusterTopo(GalaxCNATopoData info, Node fatherNode, ElementBox layout, TopoBaseContext context, Site site) {
        ElementBox box = context.getElementBox();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (GalaxCNAInfo cn : info.getHosts()) {
            Node hostNode = (Node)box.getElementByID((Object)(cn.getHostUuid() + SN_CONNECT_SITE + "GalaX"));
            if (hostNode == null) {
                hostNode = this.createHostTopo(cn, box, layout, fatherNode, site, info);
            }
            context.getVmEsxNode().add(hostNode);
            this.addIdtoList(context.getHostNodeIds(), (String)hostNode.getID());
            this.addProtectGroupIDToElement((Element)hostNode, context.getProtectGroup().getUuid());
            nodes.add(hostNode);
        }
        return nodes;
    }

    private Node createArrayComputeNodeTopo(GalaxCNAInfo info, Node fatherNode, ElementBox layout, TopoBaseContext context, Site site) {
        ElementBox box = context.getElementBox();
        Node hostNode = (Node)box.getElementByID((Object)(info.getHostUuid() + SN_CONNECT_SITE + "GalaX"));
        if (hostNode == null) {
            hostNode = this.createHostTopo(info, box, layout, fatherNode, site, new GalaxCNATopoData());
        }
        context.getVmEsxNode().add(hostNode);
        this.addIdtoList(context.getHostNodeIds(), (String)hostNode.getID());
        this.addProtectGroupIDToElement((Element)hostNode, context.getProtectGroup().getUuid());
        return hostNode;
    }

    private Node createHostTopo(ComputeNode cn, ElementBox box, ElementBox layout, Node fatherNode, Site site, ComputeCluster cluster) {
        Node hostNode = this.createHostNode(cn.getUuid(), cn.getName(), cn.getHostStatus(), site, cluster.getName());
        super.initNodeLocation(hostNode, fatherNode, layout);
        fatherNode.addChild((IData)hostNode);
        TopoServiceUtil.addElementToBox((ElementBox)box, (IData)hostNode);
        return hostNode;
    }

    private Node createHostTopo(GalaxCNAInfo cn, ElementBox box, ElementBox layout, Node fatherNode, Site site, GalaxCNATopoData info) {
        Node hostNode = this.createHostNode(cn.getHostUuid(), cn.getHostname(), cn.getHostStatus(), site, info.getClusterName());
        super.initNodeLocation(hostNode, fatherNode, layout);
        fatherNode.addChild((IData)hostNode);
        TopoServiceUtil.addElementToBox((ElementBox)box, (IData)hostNode);
        return hostNode;
    }

    private Node createHostNode(String uuid, String name, String status, Site site, String clusterName) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        Node hostNode = new Node((Object)(uuid + SN_CONNECT_SITE + "GalaX"));
        hostNode.setStyle("label.bold", false);
        hostNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        this.setFusionSphereHostImage(hostNode, status);
        if (site.getSiteType() == 0) {
            hostNode.setClient("isHostOrStorage", (Object)"isvsphere");
            hostNode.setClient("devSN", (Object)uuid);
            hostNode.setClient("srcSiteID", (Object)site.getSiteId());
            hostNode.setClient("srcSiteName", (Object)("<![CDATA[" + site.getName() + "]]>"));
            hostNode.setClient("topoHostName", (Object)("<![CDATA[" + name + "]]>"));
        }
        hostNode.setClient("imageWidth", 48.0);
        hostNode.setClient("imageHeight", 60.0);
        hostNode.setClient("netWorkPrimalName", (Object)name);
        hostNode.setName(TopoServiceUtil.getNodeShowName((String)name));
        hostNode.setToolTip(this.createFusionSphereHostToolTip(name, status));
        this.setNodeExtName(hostNode, name, clusterName, "ism.drm.topo.hypermetro.cluster");
        String[] nameArray = new String[1];
        String langInfo = resourceManager.getLangInfo();
        nameArray[0] = "zh".equals(langInfo) ? "/theme/recoverydirector/images/topo/virtualization_server_icon_cn.png" : "/theme/recoverydirector/images/topo/virtualization_server_icon_en.png";
        hostNode.setStyle("icons.names", (Object)nameArray);
        hostNode.setStyle("icons.position", (Object)"top.top");
        hostNode.setStyle("icons.xgap", 5.0);
        hostNode.setStyle("icons.ygap", -20.0);
        hostNode.setStyle("select.alpha", 1.0);
        hostNode.setStyle("select.style", (Object)"none");
        hostNode.setStyle("label.color", 35020);
        return hostNode;
    }

    private void setFusionSphereHostImage(Node node, String hostStatus) {
        if (HostStatusEnum.NORMAL.getValue().equalsIgnoreCase(hostStatus)) {
            node.setImage("/theme/recoverydirector/images/topo/esxserver.png");
        } else if (HostStatusEnum.REBOOTING.getValue().equalsIgnoreCase(hostStatus) || HostStatusEnum.INITIAL.getValue().equalsIgnoreCase(hostStatus) || HostStatusEnum.BOOTING.getValue().equalsIgnoreCase(hostStatus) || HostStatusEnum.SHUTDOWNING.getValue().equalsIgnoreCase(hostStatus)) {
            node.setImage("/theme/recoverydirector/images/topo/esxserver_warning.png");
        } else if (HostStatusEnum.FAULT.getValue().equalsIgnoreCase(hostStatus)) {
            node.setImage("/theme/recoverydirector/images/topo/esxserver_faulty.png");
        } else if (HostStatusEnum.POWEROFF.getValue().equalsIgnoreCase(hostStatus)) {
            node.setImage("/theme/recoverydirector/images/topo/esxserver_offline.png");
        } else {
            node.setImage("/theme/recoverydirector/images/topo/esxserver_unknown.png");
        }
    }

    private String createFusionSphereHostToolTip(String name, String status) {
        StringBuilder tooltipBuilder = new StringBuilder();
        TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.host.name", (String)name);
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        String hostStatus = resourceManager.getText("ism.drm.topo.instance.app.fusionphere.host.status." + status);
        TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.storage.status", (String)hostStatus);
        return tooltipBuilder.toString();
    }

    private long getPoCountByPgUuid(String pgid) {
        String hql = "select count(uuid) from ProtectObject where protectGroup.pgId = ?";
        List list = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{pgid});
        if (VerifyUtil.isEmpty((Collection)list)) {
            return 0L;
        }
        Long count = (Long)list.get(0);
        return count != null ? count : 0L;
    }

    private List<String> getProductFcSns(String providerSn, GalaXTopoResourceHelper topoHelper) {
        List<String> productFcSns;
        if (!providerSn.startsWith("Dr_Vrm")) {
            productFcSns = topoHelper.getProductFcListByFmSn(providerSn);
        } else {
            productFcSns = new ArrayList<String>();
            productFcSns.add(providerSn);
        }
        return productFcSns;
    }

    private void createVrgTopo(TopoBaseContext context, GalaXTopoResourceHelper topoHelper, String productFcSn, ElementBox layout) {
        List<String> productVrgs = topoHelper.getProductVrgListByFcSn(productFcSn);
        if (VerifyUtil.isEmpty(productVrgs)) {
            logger.error((Object)"GalaXGlobalTopoBuilder createStorageOrVrgTopo: productVrgs is null.", 90160758787071L);
            return;
        }
        for (String productVrgSn : productVrgs) {
            this.opterationVrgs(context, topoHelper, productFcSn, productVrgSn, layout);
        }
    }

    private void opterationVrgs(TopoBaseContext context, GalaXTopoResourceHelper topoHelper, String productFcSn, String productVrgSn, ElementBox layout) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ElementBox topoBox = context.getElementBox();
        String ptSiteId = protectGroup.getProductSiteId();
        Site productStorageSite = this.getSiteInContext(context, ptSiteId);
        Group ptGroup = this.getOrCreateGroup(topoBox, productStorageSite, layout);
        this.createVrgTopo(productVrgSn, ptGroup, topoHelper, context, layout);
        Node from = (Node)topoBox.getElementByID((Object)(productFcSn + SN_CONNECT_SITE + ptSiteId));
        Node to = (Node)topoBox.getElementByID((Object)(productVrgSn + SN_CONNECT_SITE + ptSiteId));
        this.createLink(topoBox, from, to);
        String recoveryVrg = topoHelper.getRecoveryVrg(productVrgSn);
        String recoveryFcSn = topoHelper.getRecoveryFcSnByVrgSn(recoveryVrg);
        DrResource drResource = this.getDrResourceInContext(context, recoveryFcSn);
        if (VerifyUtil.isEmpty((Object)drResource)) {
            logger.error((Object)("getDrResource null: recoveryFcSn=" + recoveryFcSn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        DrVrm drVrm = (DrVrm)drResource;
        String rcSiteId = drVrm.getSiteId();
        Site rcStorageSite = this.getSiteInContext(context, rcSiteId);
        Group rcGroup = this.getOrCreateGroup(topoBox, rcStorageSite, layout);
        this.createVrgTopo(recoveryVrg, rcGroup, topoHelper, context, layout);
        from = (Node)topoBox.getElementByID((Object)(productVrgSn + SN_CONNECT_SITE + ptSiteId));
        to = (Node)topoBox.getElementByID((Object)(recoveryVrg + SN_CONNECT_SITE + rcSiteId));
        this.createVrgLink(topoBox, protectGroup, productVrgSn, from, recoveryVrg, to);
        this.createFcTopo(recoveryFcSn, rcGroup, topoHelper, context, layout);
        from = (Node)topoBox.getElementByID((Object)(recoveryFcSn + SN_CONNECT_SITE + rcSiteId));
        to = (Node)topoBox.getElementByID((Object)(recoveryVrg + SN_CONNECT_SITE + rcSiteId));
        this.createLink(topoBox, from, to);
    }

    private void createProductCloudPlatFormTopo(String providerSn, Group group, GalaXTopoResourceHelper topoHelper, TopoBaseContext context, ElementBox layout) {
        ElementBox topoBox = context.getElementBox();
        if (!providerSn.startsWith("Dr_Vrm")) {
            DrResource drResource = this.getDrResourceInContext(context, providerSn);
            if (VerifyUtil.isEmpty((Object)drResource)) {
                logger.error((Object)("getDrResource null: providerSn=" + providerSn), 90160758787071L);
                throw new LegoCheckedException(1073947394L);
            }
            DrFm drFm = (DrFm)drResource;
            this.createFmTopo(drFm.getDeviceSn(), group, context, layout);
            List<String> productFcSns = topoHelper.getProductFcListByFmSn(providerSn);
            if (VerifyUtil.isEmpty(productFcSns)) {
                logger.error((Object)("productFcSns null: providerSn=" + providerSn), 90160758787071L);
                return;
            }
            for (String productFcSn : productFcSns) {
                this.createFcTopo(productFcSn, group, topoHelper, context, layout);
                Node from = (Node)topoBox.getElementByID((Object)(drFm.getDeviceSn() + SN_CONNECT_SITE + drFm.getSiteId()));
                Node to = (Node)topoBox.getElementByID((Object)(productFcSn + SN_CONNECT_SITE + drFm.getSiteId()));
                this.createLink(topoBox, from, to);
            }
        } else {
            this.createFcTopo(providerSn, group, topoHelper, context, layout);
        }
    }

    private void createFcTopo(String fcSn, Group group, GalaXTopoResourceHelper topoHelper, TopoBaseContext context, ElementBox layout) {
        ElementBox topoBox = context.getElementBox();
        DrResource drResource = this.getDrResourceInContext(context, fcSn);
        if (VerifyUtil.isEmpty((Object)drResource)) {
            logger.error((Object)("getDrResource null: fcSn=" + fcSn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        DrVrm drVrm = (DrVrm)drResource;
        String siteId = drVrm.getSiteId();
        Node arrayNode = (Node)topoBox.getElementByID((Object)(drVrm.getDeviceSn() + SN_CONNECT_SITE + siteId));
        if (arrayNode != null) {
            return;
        }
        String fmSn = topoHelper.checkFmByFc(siteId, fcSn);
        DrFm drFm = null;
        if (!VerifyUtil.isEmpty((String)fmSn)) {
            drResource = this.getDrResourceInContext(context, fmSn);
            if (VerifyUtil.isEmpty((Object)drResource)) {
                logger.error((Object)("getDrResource null: fmSn=" + fmSn), 90160758787071L);
                throw new LegoCheckedException(1073947394L);
            }
            drFm = (DrFm)drResource;
            Node fmNode = (Node)topoBox.getElementByID((Object)(drFm.getDeviceSn() + SN_CONNECT_SITE + siteId));
            if (fmNode == null) {
                fmNode = this.createFmNode(drFm);
                this.initNodeLocation(fmNode, (Node)group, layout);
                group.addChild((IData)fmNode);
                TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)fmNode);
            }
        }
        arrayNode = this.createFcNode(drVrm);
        this.initNodeLocation(arrayNode, (Node)group, layout);
        group.addChild((IData)arrayNode);
        TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)arrayNode);
        if (!VerifyUtil.isEmpty((Object)drFm)) {
            Node from = (Node)topoBox.getElementByID((Object)(drFm.getDeviceSn() + SN_CONNECT_SITE + drVrm.getSiteId()));
            Node to = (Node)topoBox.getElementByID((Object)(fcSn + SN_CONNECT_SITE + drVrm.getSiteId()));
            this.createLink(topoBox, from, to);
        }
    }

    private Node createFcNode(DrVrm drVrm) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        Node fcNode = new Node((Object)(drVrm.getDeviceSn() + SN_CONNECT_SITE + drVrm.getSiteId()));
        CloudElement.setGlobalImageByStatus((Node)fcNode, (String)drVrm.getStatus(), (boolean)true);
        fcNode.setStyle("label.bold", false);
        fcNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        fcNode.setClient("imageWidth", 48.0);
        fcNode.setClient("imageHeight", 60.0);
        fcNode.setName(TopoServiceUtil.getNodeShowName((String)drVrm.getName()));
        fcNode.setToolTip(CloudElement.createCloudToolTip((DrResource)drVrm, (String)"ism.drm.topo.app.fc.name"));
        return fcNode;
    }

    private void createFmTopo(String productFmSn, Group group, TopoBaseContext context, ElementBox layout) {
        ElementBox topoBox = context.getElementBox();
        DrResource drResource = this.getDrResourceInContext(context, productFmSn);
        if (VerifyUtil.isEmpty((Object)drResource)) {
            logger.error((Object)("getDrResource null: productFmSn=" + productFmSn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        DrFm drFm = (DrFm)drResource;
        String siteId = drFm.getSiteId();
        Node fmNode = (Node)topoBox.getElementByID((Object)(drFm.getDeviceSn() + SN_CONNECT_SITE + siteId));
        if (fmNode == null) {
            fmNode = this.createFmNode(drFm);
            this.initNodeLocation(fmNode, (Node)group, layout);
            group.addChild((IData)fmNode);
            TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)fmNode);
        }
    }

    private Node createFmNode(DrFm drFm) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        Node fmNode = new Node((Object)(drFm.getDeviceSn() + SN_CONNECT_SITE + drFm.getSiteId()));
        CloudElement.setGlobalImageByStatus((Node)fmNode, (String)drFm.getStatus(), (boolean)false);
        fmNode.setStyle("label.bold", false);
        fmNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        fmNode.setClient("imageWidth", 48.0);
        fmNode.setClient("imageHeight", 60.0);
        fmNode.setName(TopoServiceUtil.getNodeShowName((String)drFm.getName()));
        fmNode.setToolTip(CloudElement.createCloudToolTip((DrResource)drFm, (String)"ism.drm.topo.app.fm.name"));
        return fmNode;
    }

    private void createVrgTopo(String vrgSn, Group group, GalaXTopoResourceHelper topoHelper, TopoBaseContext context, ElementBox layout) {
        ElementBox topoBox = context.getElementBox();
        DrResource drResource = this.getDrResourceInContext(context, vrgSn);
        if (VerifyUtil.isEmpty((Object)drResource)) {
            logger.error((Object)("getDrResource null: vrgSn=" + vrgSn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        DrVRG drVrg = (DrVRG)drResource;
        String siteId = drVrg.getSiteId();
        Site site = this.getSiteInContext(context, siteId);
        Node arrayNode = (Node)topoBox.getElementByID((Object)(drVrg.getDeviceSn() + SN_CONNECT_SITE + siteId));
        if (arrayNode == null) {
            int vrgStatus = 0;
            if (site.getSiteType() != 1) {
                VRG vrg = topoHelper.getVRGBySn(vrgSn);
                if (!VerifyUtil.isEmpty((Object)vrg)) {
                    vrgStatus = vrg.getVrgStauts();
                }
            } else {
                String vrgStatusStr = topoHelper.getVrgStatus(vrgSn, site);
                if (!VerifyUtil.isEmpty((String)vrgStatusStr)) {
                    vrgStatus = NumberUtil.convertToInteger((Object)vrgStatusStr);
                }
            }
            drVrg.setStatus(topoHelper.configVrgStatus(drVrg.getStatus(), vrgStatus));
            arrayNode = this.createVrgNode(drVrg);
            this.initNodeLocation(arrayNode, (Node)group, layout);
            group.addChild((IData)arrayNode);
            TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)arrayNode);
        }
    }

    private Node createVrgNode(DrVRG drVrg) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        Node vrgNode = new Node((Object)(drVrg.getDeviceSn() + SN_CONNECT_SITE + drVrg.getSiteId()));
        VrgElement.setGlobalImageByStatus((Node)vrgNode, (int)NumberUtil.convertToInteger((Object)drVrg.getStatus()));
        vrgNode.setStyle("label.bold", false);
        vrgNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        vrgNode.setClient("imageWidth", 48.0);
        vrgNode.setClient("imageHeight", 60.0);
        vrgNode.setName(TopoServiceUtil.getNodeShowName((String)drVrg.getName()));
        vrgNode.setToolTip(VrgElement.createVrgToolTip((Node)vrgNode, (DrResource)drVrg));
        return vrgNode;
    }

    private Node createStorageNode(DrStorage drStorage) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        Node storageNode = new Node((Object)(drStorage.getDeviceSn() + SN_CONNECT_SITE + drStorage.getSiteId()));
        StorageElement.setImageByStatus((Node)storageNode, (Integer)NumberUtil.convertToInteger((Object)drStorage.getStatus()));
        storageNode.setStyle("label.bold", false);
        storageNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        storageNode.setClient("isHostOrStorage", (Object)"isstorage");
        storageNode.setClient("imageWidth", 48.0);
        storageNode.setClient("imageHeight", 60.0);
        storageNode.setName(TopoServiceUtil.getNodeShowName((String)drStorage.getName()));
        storageNode.setToolTip(StorageElement.createStorageTooltip((DrStorage)drStorage));
        return storageNode;
    }

    private Link createLink(ElementBox topoBox, Node from, Node to) {
        Link link = TopoServiceUtil.getExistLinkBetweenNodes((Node)from, (Node)to);
        if (from != null && to != null && link == null) {
            String linkID = "link-" + from.getID() + to.getID();
            link = new Link((Object)linkID, from, to);
            link.setStyle("link.color", (Object)"0x31bd16");
            link.setStyle("arrow.to.color", (Object)"0x31bd16");
            link.setClient("linkToXOffset", 10.0);
            link.setStyle("link.width", 1.0);
            link.setStyle("arrow.to.width", (Object)REPLICATION_ARROW_IO_WIDTH);
            link.setStyle("arrow.to.height", (Object)REPLICATION_ARROW_IO_HIGHTH);
            link.setStyle("arrow.to.shape", (Object)"arrow.delta");
            TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)link);
        }
        return link;
    }

    private void createVrgLink(ElementBox topoBox, ProtectGroup protectGroup, String productVrgSN, Node productVrgNode, String recoverVrgSN, Node recoverVrgNode) {
        String sLinkID = "Vrglink-" + protectGroup.getUuid() + ":" + productVrgSN + "->" + recoverVrgSN;
        Link link = TopoServiceUtil.getExistLinkBetweenNodes((Node)productVrgNode, (Node)recoverVrgNode);
        if (productVrgNode != null && recoverVrgNode != null && link == null) {
            link = new Link((Object)sLinkID, productVrgNode, recoverVrgNode);
            link.setClient("linkToXOffset", 10.0);
            link.setClient("devSN", (Object)productVrgSN);
            link.setClient("trgSN", (Object)recoverVrgSN);
            link.setClient("devName", (Object)productVrgNode.getName());
            link.setClient("trgName", (Object)recoverVrgNode.getName());
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
            link.setStyle("link.width", 1.0);
            link.setStyle("arrow.to", true);
            link.setStyle("arrow.to.width", (Object)REPLICATION_ARROW_IO_WIDTH);
            link.setStyle("arrow.to.height", (Object)REPLICATION_ARROW_IO_HIGHTH);
            link.setStyle("arrow.to.shape", (Object)"arrow.delta");
            StringBuilder storageLinkTips = new StringBuilder();
            GalaXTopoResourceHelper topoHelper = new GalaXTopoResourceHelper(protectGroup);
            VRG vrg = this.queryVRG(productVrgSN, recoverVrgSN, protectGroup, topoHelper);
            int linkStatus = vrg.getMapStatus();
            this.optVRGLinkColorAndTooltip(linkStatus, link, storageLinkTips);
            link.setToolTip(storageLinkTips.toString());
            TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)link);
        }
    }

    private void optVRGLinkColorAndTooltip(int linkStatus, Link link, StringBuilder storageLinkTips) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        int[] dashedLine = new int[]{10, 5};
        storageLinkTips.append(resourceManager.getText("ism.drm.topo.vrg.pairStatus"));
        if (linkStatus == VrgMapStatusEnum.NORMAL.getStatus()) {
            link.setStyle("link.color", (Object)"0x31bd16");
            link.setStyle("arrow.to.color", (Object)"0x31bd16");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.vrg.pair.status.1"));
        } else if (linkStatus == VrgMapStatusEnum.MAPPING.getStatus()) {
            link.setStyle("link.color", (Object)"0x31bd16");
            link.setStyle("arrow.to.color", (Object)"0x31bd16");
            link.setStyle("link.pattern", (Object)dashedLine);
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.vrg.pair.status.2"));
        } else if (linkStatus == VrgMapStatusEnum.MAPPING_FAILED.getStatus()) {
            link.setStyle("link.color", (Object)"0xfc4133");
            link.setStyle("arrow.to.color", (Object)"0xfc4133");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.vrg.pair.status.3"));
        } else if (linkStatus == VrgMapStatusEnum.UNMAPPED.getStatus()) {
            link.setStyle("link.color", (Object)"0xbbbbbb");
            link.setStyle("arrow.to.color", (Object)"0xbbbbbb");
            link.setStyle("link.pattern", (Object)dashedLine);
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.vrg.pair.status.4"));
        } else if (linkStatus == VrgMapStatusEnum.LINK_DOWN.getStatus()) {
            link.setStyle("link.color", (Object)"0xbbbbbb");
            link.setStyle("arrow.to.color", (Object)"0xbbbbbb");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.vrg.pair.status.5"));
        } else if (linkStatus == VrgMapStatusEnum.UNKNOWN.getStatus()) {
            link.setStyle("link.color", (Object)"0xbbbbbb");
            link.setStyle("arrow.to.color", (Object)"0xbbbbbb");
            String statusText = "ism.drm.topo.instance.app.fusionphere.host.status.unknown";
            storageLinkTips.append(resourceManager.getText(statusText));
        } else {
            link.setStyle("link.color", (Object)"0xbbbbbb");
            link.setStyle("arrow.to.color", (Object)"0xbbbbbb");
            storageLinkTips.append("--");
        }
    }

    private VRG queryVRG(String productVrgSn, String recoverVrgSN, ProtectGroup protectGroup, GalaXTopoResourceHelper topoHelper) {
        VRG vrg = protectGroup.isPrimary() ? topoHelper.getVRGBySn(productVrgSn) : topoHelper.getVRGBySn(recoverVrgSN);
        return vrg;
    }

    protected void initGroupLocation(Group group, Node fatherNode, ElementBox layout) {
        Group savedGroup = (Group)layout.getDataByID(group.getID());
        if (savedGroup != null) {
            group.setLocation(savedGroup.getLocation());
            group.setExpanded(savedGroup.isExpanded());
            layout.setClient(USEFUL, (Object)true);
            return;
        }
        Point center = (Point)layout.getClient(CENTER);
        AtomicInteger count = (AtomicInteger)layout.getClient(COUNT);
        double x = 200.0;
        double y = center.getY();
        if (0 == count.intValue()) {
            y = 100.0;
        } else if (count.intValue() % 2 == 0) {
            y += 400.0;
        } else {
            x += 600.0;
        }
        group.setLocation(x, y);
        count.getAndIncrement();
        center.setLocation(x, y);
    }

    protected void initNodeLocation(Node node, Node fatherNode, ElementBox layout) {
        if (layout != null && layout.containsByID(node.getID())) {
            node.setLocation(((Node)layout.getDataByID(node.getID())).getLocation());
            layout.setClient(USEFUL, (Object)true);
        } else {
            double x = this.calcNodeX(node, fatherNode);
            double y = this.calcNodeY(node, fatherNode);
            node.setLocation(x, y);
        }
    }

    private double calcNodeX(Node node, Node fatherNode) {
        double x = 200.0;
        if (node.getImage().contains("fm") && fatherNode.getLocation().getX() >= 600.0) {
            x = 1200.0;
        } else if (node.getImage().contains("fc")) {
            x = 400.0;
            if (fatherNode.getLocation().getX() > 600.0) {
                x = 1000.0;
            }
        } else if (!node.getImage().contains("fm") && !node.getImage().contains("fc")) {
            x = 600.0;
            if (fatherNode.getLocation().getX() > 600.0) {
                x = 800.0;
            }
        }
        return x;
    }

    private double calcNodeY(Node node, Node fatherNode) {
        double y = 100.0;
        if (fatherNode.getLocation().getY() > 400.0) {
            y += (fatherNode.getLocation().getY() - 100.0) / 400.0 * 400.0;
        }
        List childs = fatherNode.getChildren();
        for (Node nd : childs) {
            if (node.getImage().contains("fm") && nd.getImage().contains("fm")) {
                y += 70.0;
                continue;
            }
            if (node.getImage().contains("fc") && nd.getImage().contains("fc")) {
                y += 70.0;
                continue;
            }
            if (node.getImage().contains("fm") || node.getImage().contains("fc") || nd.getImage().contains("fm") || nd.getImage().contains("fc")) continue;
            y += 70.0;
        }
        return y;
    }
}

