/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.monitor.topo;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.galax.constant.cloudenum.HostStatusEnum;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DrComputeNode;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.topo.sdk.service.IGalaxTopoPoller;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopoCloudPoller
implements IGalaxTopoPoller {
    private Log logger = LogFactory.getInstance(TopoCloudPoller.class);
    private INeMgrProtocolExtendService neMgrservcice;

    public void pollResource(String sourceSn) {
        if (VerifyUtil.isEmpty((String)sourceSn)) {
            this.logger.warn((Object)"sn is empty.", 90160758787071L);
            return;
        }
        if (sourceSn.startsWith("Dr_Vrm")) {
            ManagedObject mo = CommonDAOLocator.getMoDao().getMo(VRM.class, "sn", (Object)sourceSn);
            if (null == mo || null == mo.getMoId()) {
                return;
            }
            NeMgrProtocolExtend extend = this.neMgrservcice.findByMoId(mo.getMoId());
            if (null == extend) {
                this.logger.error((Object)("cloudplatform(" + sourceSn + ")'NeMgrProtocolExtend dosen't exist."), 90160758787071L);
                return;
            }
            this.updateHostStatus(mo.getMoId(), extend);
        }
    }

    private void getUpdateHost(List<ComputeNode> existHosts, List<ManagedObject> updateList) {
        for (ComputeNode existHost : existHosts) {
            if (HostStatusEnum.UNKNOWN.getValue().equals(existHost.getHostStatus())) continue;
            existHost.setHostStatus(HostStatusEnum.UNKNOWN.getValue());
            updateList.add((ManagedObject)existHost);
        }
    }

    private void updateHosts(Long vrmId, NeMgrProtocolExtend extend, boolean isVrmNormal) {
        ArrayList<ManagedObject> updateList = new ArrayList<ManagedObject>();
        List existHosts = CommonDAOLocator.getMoDao().getAllSubMo(vrmId.longValue(), ComputeNode.class);
        if (VerifyUtil.isEmpty((Collection)existHosts)) {
            return;
        }
        if (!isVrmNormal) {
            this.getUpdateHost(existHosts, updateList);
        } else {
            VrmObject vrmInfo;
            IVirtualResourceManager vrmVirtualResService = VrmManager.getInstance().getVrmVirtualResService();
            ArrayList<ComputeNode> hosts = vrmVirtualResService.queryAllComputeNode(vrmInfo = VrmUtil.generateVrmObj((NeMgrProtocolExtend)extend));
            if (null == hosts) {
                hosts = new ArrayList<ComputeNode>();
            }
            for (ComputeNode existHost : existHosts) {
                this.findStatusChangedHost(existHost, hosts, updateList);
            }
            hosts.clear();
        }
        existHosts.clear();
        if (VerifyUtil.isEmpty(updateList)) {
            return;
        }
        CommonDAOLocator.getMoDao().saveOrUpdateMoList(updateList);
        for (ManagedObject mObject : updateList) {
            if (!(mObject instanceof ComputeNode)) continue;
            this.updateHostResource((ComputeNode)mObject);
        }
    }

    private void findStatusChangedHost(ComputeNode existHost, List<ComputeNode> hosts, List<ManagedObject> updateList) {
        boolean hostExist = false;
        for (ComputeNode host : hosts) {
            if (!existHost.getUuid().equals(host.getUuid())) continue;
            hostExist = true;
            if (host.getHostStatus().equals(existHost.getHostStatus())) break;
            existHost.setHostStatus(host.getHostStatus());
            updateList.add((ManagedObject)existHost);
            break;
        }
        if (hostExist) {
            return;
        }
        if (!HostStatusEnum.UNKNOWN.getValue().equals(existHost.getHostStatus())) {
            existHost.setHostStatus(HostStatusEnum.UNKNOWN.getValue());
            updateList.add((ManagedObject)existHost);
        }
    }

    private void updateHostStatus(Long vrmId, NeMgrProtocolExtend extend) {
        boolean isOnline = false;
        try {
            VRM cloud = VrmManager.getInstance().getVrmResService().loginVrm(extend);
            if (null != cloud) {
                isOnline = true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to load cloud platform when update cloud platform status." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        this.updateHosts(vrmId, extend, isOnline);
    }

    private void updateHostResource(ComputeNode existHost) {
        List drHosts = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrComputeNode where deviceSn = ?", new Object[]{existHost.getUrn()});
        if (VerifyUtil.isEmpty((Collection)drHosts)) {
            return;
        }
        DrComputeNode drComputeNode = (DrComputeNode)drHosts.get(0);
        drComputeNode.setStatus(String.valueOf(existHost.getStatus()));
        drComputeNode.setHostStatus(existHost.getHostStatus());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)drComputeNode);
    }

    public void pollResource(String ipAddress, String port) {
    }

    public String getResourceType() {
        return "VRMandFM";
    }

    public void setNeMgrservcice(INeMgrProtocolExtendService neMgrservcice) {
        this.neMgrservcice = neMgrservcice;
    }

    public INeMgrProtocolExtendService getNeMgrservcice() {
        return this.neMgrservcice;
    }
}

