/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.msg;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.virtualization.sdk.service.IDataStoreGroupService;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

public class CloudMessageSubscriber
extends MessageTaskManager {
    private static final Log LOGGER = LogFactory.getInstance(CloudMessageSubscriber.class);

    public CloudMessageSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public void onMessage(MessageUnit mu) {
        long msgType = mu.getCmdcode();
        if (105L != msgType) {
            LOGGER.error((Object)("Message was not subscribed, msgType: " + msgType), 90160758786876L);
            return;
        }
        Object msg = mu.getObj();
        if (!(msg instanceof Map)) {
            return;
        }
        Map objs = (Map)msg;
        for (Object obj : objs.values()) {
            if (!(obj instanceof VRM) && !(obj instanceof FusionManager)) continue;
            NetworkEntity ne = (NetworkEntity)obj;
            this.deleteRegistCloud(ne);
            this.deleteDataStoreGroup(ne);
        }
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(105L);
        return mrs;
    }

    private void deleteRegistCloud(NetworkEntity ne) {
        String siteHql = "from DrResource as dh where dh.deviceSn = ? ";
        Object[] condition = new String[]{ne.getUuid()};
        try {
            List vrgs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(siteHql, condition);
            if (VerifyUtil.isEmpty((Collection)vrgs)) {
                return;
            }
            for (DrResource res : vrgs) {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)res);
            }
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"delete regist Cloud failed.", (Throwable)ex, 90160758787071L);
        }
    }

    private void deleteDataStoreGroup(NetworkEntity ne) {
        try {
            ((IDataStoreGroupService)ServiceLocator.getInstance().getService(IDataStoreGroupService.class)).deleteDataStoreGroupByProvider(ne.getSn());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"delete DataStoreGroup failed.", (Throwable)e, 90160758787071L);
        }
    }
}

