/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.protection;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanSyncService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.sdk.service.IGalaxObjectObserver;
import com.huawei.ism.drm.galax.util.RecoveryUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class GalaxProtectGroupMonitor
implements IObjectObserver,
IGalaxObjectObserver {
    private static final Log logger = LogFactory.getInstance(GalaxProtectGroupMonitor.class);

    public void before(MessageEvent event) {
    }

    public void after(MessageEvent event) {
        logger.info((Object)("after enter.event.getMessageType() = " + event.getMessageType()), 90160758786816L);
        if (event.getMessageType() == 1) {
            for (DRMObject drmObj : event.getObjectList()) {
                if (!(drmObj instanceof ProtectGroup)) continue;
                this.refreshRecoverySetting((ProtectGroup)drmObj);
            }
        }
    }

    private void refreshRecoverySetting(ProtectGroup pg) {
        if (pg.getPoType() != DrmEnumDefine.AppType.GALAX_VM.getValue()) {
            return;
        }
        logger.info((Object)("refreshRecoverySetting enter. pg is " + pg.getName()), 90160758786816L);
        RecoveryPlan recoveryPlan = this.getRecoveryPlanByPgId(pg.getUuid());
        if (recoveryPlan != null) {
            logger.info((Object)("refreshRecoverySetting enter. recoveryPlan is " + recoveryPlan.getName()), 90160758786816L);
            try {
                this.updateStartupSettings(recoveryPlan);
                this.saveOrUpdateRecoverySettings(recoveryPlan, new ArrayList<RecoverySetting>(recoveryPlan.getRecoverySettings()));
            }
            catch (Exception e) {
                String planId = recoveryPlan.getPlanId();
                logger.error((Object)("Failed to updateRecoveryPlan by getRecoveryPlan in GalaXRecoveryPlanService! PlanID is " + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }
    }

    private void saveOrUpdateRecoverySettings(RecoveryPlan recoveryPlan, List<RecoverySetting> settings) {
        RecoveryServiceUtil.checkRecoveryOperationPrivilegeBySite((RecoveryPlan)recoveryPlan, null);
        this.saveOrUpdateRecoverySettingsToLocal(recoveryPlan);
        List remoteSites = RecoveryServiceUtil.getRemoteSites((RecoveryPlan)recoveryPlan);
        if (!VerifyUtil.isEmpty((Collection)remoteSites)) {
            try {
                ((IRecoveryPlanSyncService)ServiceLocator.getInstance().getService(IRecoveryPlanSyncService.class)).syncRecoverySettingsToRemote((Site)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)remoteSites), recoveryPlan.getPlanId(), settings);
            }
            catch (Exception e) {
                logger.error((Object)("Sync recovery settings to remote failed. PlanId:" + recoveryPlan.getPlanId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOrUpdateRecoverySettingsToLocal(RecoveryPlan recoveryPlan) {
        DrmEnumDefine.RecoveryPlanStatusE status = DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus());
        if (null == status) {
            logger.error((Object)("Save or update recovery settings to local failed. PlanId:" + recoveryPlan.getPlanId()), 90160758784001L);
            throw new LegoCheckedException(-1L);
        }
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)status, (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING);
        HashSet<ProtectObject> poSet = new HashSet<ProtectObject>();
        for (ProtectGroup pg : recoveryPlan.getProtectGroups()) {
            poSet.addAll(pg.getPolist());
        }
        Session session = null;
        try {
            HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            session.beginTransaction();
            for (RecoverySetting recoverySetting : recoveryPlan.getRecoverySettings()) {
                if (!this.isPoExistInPoSet(poSet, recoverySetting.getOwnerId())) {
                    session.delete((Object)recoverySetting);
                    continue;
                }
                session.saveOrUpdate((Object)recoverySetting);
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"Save or update recovery settings to local failed.", (long)-1L, null, (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    private void updateStartupSettings(RecoveryPlan plan) {
        HashSet vmRecoverySettings = plan.getRecoverySettings();
        if (null == vmRecoverySettings) {
            vmRecoverySettings = new HashSet();
            plan.setRecoverySettings(vmRecoverySettings);
        }
        String productSiteId = (String)plan.getGlobalSettings().get("PRODUCT_SITE_ID");
        String recoverySiteId = (String)plan.getGlobalSettings().get("SELECT_DISASTER_SITE_KEY");
        for (ProtectGroup pg : plan.getProtectGroups()) {
            if (productSiteId == null) {
                productSiteId = pg.getProductSiteId();
            }
            if (recoverySiteId == null) {
                recoverySiteId = ((ProtectGroupReplica)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)pg.getReplicaList())).getRecoverySite();
            }
            for (ProtectObject po : pg.getPolist()) {
                this.updatePoRecoverySetting(plan, po, "startOrder", String.valueOf(10), String.valueOf(0));
                this.updatePoRecoverySetting(plan, po, "isStart", String.valueOf(Boolean.TRUE), String.valueOf(Boolean.FALSE));
                this.updatePoRecoverySetting(plan, po, "APP_IS_ENABLE_SETTING_KEY", String.valueOf(Boolean.FALSE), String.valueOf(Boolean.TRUE));
                this.updatePoRecoverySetting(plan, po, "prd_drs_vm_id_list", FsRecoveryUtil.getDrsVmIdList(po, productSiteId, recoverySiteId), "");
            }
        }
    }

    private void updatePoRecoverySetting(RecoveryPlan plan, ProtectObject po, String settingKey, String settingValue, String templateValue) {
        Set vmRecoverySettings = plan.getRecoverySettings();
        RecoverySetting setting = RecoveryUtil.getVmStartupSetting((Set)vmRecoverySettings, (String)po.getUuid(), (String)settingKey);
        if (null == setting) {
            setting = this.generatePoRecoverySetting(po, plan, settingKey, settingValue, templateValue);
            vmRecoverySettings.add(setting);
        } else if (RecoveryUtil.isTemplate((ProtectObject)po)) {
            setting.setValue(templateValue);
        } else if ("APP_IS_ENABLE_SETTING_KEY".equals(settingKey)) {
            setting.setValue(settingValue);
        } else if ("prd_drs_vm_id_list".equals(settingKey)) {
            setting.setValue(settingValue);
        }
    }

    private RecoverySetting generatePoRecoverySetting(ProtectObject protectObject, RecoveryPlan recoveryPlan, String settingName, String settingValue, String templateValue) {
        RecoverySetting appStartPriSetting = new RecoverySetting();
        appStartPriSetting.setRecoveryPlan(recoveryPlan);
        appStartPriSetting.setOwnerId(protectObject.getUuid());
        appStartPriSetting.setName(settingName);
        if (RecoveryUtil.isTemplate((ProtectObject)protectObject)) {
            appStartPriSetting.setValue(templateValue);
        } else {
            appStartPriSetting.setValue(settingValue);
        }
        return appStartPriSetting;
    }

    private boolean isPoExistInPoSet(Set<ProtectObject> pos, String poId) {
        for (ProtectObject po : pos) {
            if (!po.getUuid().equals(poId)) continue;
            return true;
        }
        return false;
    }

    private RecoveryPlan getRecoveryPlanByPgId(String pgId) {
        List allRp = ((IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class)).getAllRecoveryPlan();
        for (RecoveryPlan recoveryPlan : allRp) {
            Set pgs = recoveryPlan.getProtectGroups();
            for (ProtectGroup protectGroup : pgs) {
                if (!protectGroup.getUuid().equals(pgId)) continue;
                return ((IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class)).getRecoveryPlan(recoveryPlan.getPlanId());
            }
        }
        return null;
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }
}

