/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.protection.adapter;

import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectCloudProvider;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import java.util.HashMap;
import java.util.Map;

public class GalaxProtectObjectCloudProviderAdapter {
    private static final String PROVIDER_TYPE = "PROVIDER_TYPE";
    private static GalaxProtectObjectCloudProviderAdapter instance = new GalaxProtectObjectCloudProviderAdapter();
    private Map<String, IGalaxProtectObjectCloudProvider> poCloudProviders = new HashMap<String, IGalaxProtectObjectCloudProvider>();

    private GalaxProtectObjectCloudProviderAdapter() {
    }

    public static GalaxProtectObjectCloudProviderAdapter getInstance() {
        return instance;
    }

    public void onBind(IGalaxProtectObjectCloudProvider poCloudProvider, Map properties) {
        if (poCloudProvider != null) {
            this.poCloudProviders.put(poCloudProvider.getCloudType(), poCloudProvider);
        }
    }

    public void onUnbind(IGalaxProtectObjectCloudProvider poCloudProvider, Map properties) {
        if (poCloudProvider != null) {
            this.poCloudProviders.remove(poCloudProvider.getCloudType());
        }
    }

    public IGalaxProtectObjectCloudProvider getGalaxPoProviderByCloud(String cloudType) {
        return this.poCloudProviders.get(cloudType);
    }

    public IGalaxProtectObjectCloudProvider getGalaxPoProviderByProviderType(String providerType) {
        if (providerType == null) {
            return null;
        }
        for (IGalaxProtectObjectCloudProvider provider : this.poCloudProviders.values()) {
            if (!providerType.equals(provider.getProviderType())) continue;
            return provider;
        }
        return null;
    }

    public IGalaxProtectObjectCloudProvider getGalaxPoProviderByProtectGroup(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            return null;
        }
        return this.getGalaxPoProviderByProviderType(this.getProviderType(protectGroup));
    }

    public String getProviderType(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            return null;
        }
        Map props = protectGroup.getProps();
        if (props == null) {
            return null;
        }
        return (String)props.get(PROVIDER_TYPE);
    }
}

