/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.common;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolCommonServiceV2Stub;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmRecoveryCmdEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmTypeEnum;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingServiceUtils;
import com.huawei.ism.drm.galax.sdk.model.DrsMapping;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.pg.model.FixLengthProps;
import com.huawei.ism.drm.galax.sdk.service.IDrsMappingService;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMOperateResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigPropertiesType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmTaskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.c10.VmConfigPropsTypeExt;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.galax.util.rest.JSONUtils;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.springframework.dao.DataAccessException;

public class FsRecoveryUtil {
    private static final int NUM_PAGELIST = 10;
    private static Log logger = LogFactory.getInstance(FsRecoveryUtil.class);

    public static Object excuteCmdToCloud(String siteId, String cloudSn, String params, String cmdType) {
        String response;
        Site sitePro = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(siteId);
        logger.info((Object)("sitePro is:" + sitePro), 90160758786816L);
        String url = "";
        try {
            String result;
            if (sitePro.getSiteType() == 0) {
                result = FusionSphereServiceManager.getInstance().getVrmService().excuteCmdToVm(cloudSn, params, cmdType);
            } else {
                RestClient client = SiteUtil.initClient((Site)sitePro);
                url = String.format("/ws/vrm/excuteCmdToVm?vrmSn=%s&vmUri=%s&cmdType=%s", cloudSn, params, cmdType);
                logger.debug((Object)("start excuteCmdToCloud, cmd url is:" + url), 90160758786816L);
                result = client.get(url, null);
                logger.debug((Object)("end excuteCmdToCloud, cmd url is:" + url + ", result:" + result));
            }
            response = FusionSphereServiceManager.getInstance().getVrmService().isVrmSn(cloudSn) && !VmRecoveryCmdEnum.SCAN_FM_DS.toString().equals(cmdType) ? (VMOperateResponseType)CommonUtil.jsonToBean((String)result, VMOperateResponseType.class) : result;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("cmd url is:" + url + ", failed to excute vm cmd."), (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            response = null;
            logger.error((Object)("cmd url is:" + url + ", failed to excute vm cmd:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            ExceptionUtil.rethrowException((Throwable)e, (String)"Failed to excute vm cmd.", (long)-1L, null, (Log)logger);
        }
        return response;
    }

    public static VrmObject getRecoveryVrmObject(String vrmSn) {
        return VrmUtil.getRecoveryVrmObject((String)vrmSn);
    }

    public static Object queryVmResult(String siteId, String cloudSn, String taskUri) {
        Object taskResult;
        Site sitePro = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(siteId);
        logger.info((Object)("siteId is:" + siteId), 90160758786816L);
        String url = "";
        try {
            String result;
            if (sitePro.getSiteType() == 0) {
                result = FusionSphereServiceManager.getInstance().getVrmService().queryVmResult(cloudSn, taskUri);
            } else {
                RestClient client = SiteUtil.initClient((Site)sitePro);
                url = String.format("/ws/vrm/queryVmResult?vrmSn=%s&taskUri=%s", cloudSn, taskUri);
                logger.debug((Object)("start queryVm, QueryCmd url is:" + url), 90160758786816L);
                result = client.get(url, null);
                logger.debug((Object)("end queryVm, queryCmd url is:" + url + ", result:" + result));
            }
            taskResult = FusionSphereServiceManager.getInstance().getVrmService().isVrmSn(cloudSn) ? CommonUtil.jsonToBean((String)result, VrmTaskType.class) : CommonUtil.jsonToBean((String)result, ResourcepoolCommonServiceV2Stub.QueryTaskResp.class);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("queryCmd url is:" + url + ",failed to query vm task."), (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            taskResult = null;
            logger.error((Object)("queryCmd url is:" + url + ", failed to query vm task:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            ExceptionUtil.rethrowException((Throwable)e, (String)"Failed to query vm task.", (long)-1L, null, (Log)logger);
        }
        return taskResult;
    }

    public static void setConfigPropertiesExt(String srcVmCfg, VmConfigType vmConfig) {
        if (VerifyUtil.isEmpty((String)srcVmCfg) || null == vmConfig) {
            logger.error((Object)"parameter is invalid.", 90160758787071L);
            return;
        }
        String cfgPropsTmp = FsRecoveryUtil.getValueFromJsonKey(srcVmCfg, "properties");
        if (!VerifyUtil.isEmpty((String)cfgPropsTmp)) {
            VmConfigPropsTypeExt propsTypeExt = (VmConfigPropsTypeExt)CommonUtil.jsonToBean((String)cfgPropsTmp, VmConfigPropsTypeExt.class);
            if (null != propsTypeExt) {
                vmConfig.setProperties((VmConfigPropertiesType)propsTypeExt);
            } else {
                logger.warn((Object)("parse to vmvonfig properties failed, msg=" + cfgPropsTmp), 90160758787071L);
            }
        } else {
            logger.warn((Object)"the vm config has no properties value.", 90160758787071L);
        }
    }

    public static List<ResourceMapping> getRemoteResourceMappings(Site recoverySite, QueryCondition cond) {
        ArrayList<ResourceMapping> list = new ArrayList<ResourceMapping>();
        ResTypeEnum[] resTypes = new ResTypeEnum[]{ResTypeEnum.CLUSTER_RESOURCE, ResTypeEnum.NETWORK, ResTypeEnum.COMPUTE_NODE};
        ArrayList<Future> futures = new ArrayList<Future>();
        for (ResTypeEnum resTypeEnum : resTypes) {
            futures.add(ExecutionService.submit((Callable)new ResourceMappingCallable(resTypeEnum, cond.getPropName(), String.valueOf(cond.getPropValue()), recoverySite)));
            String newName = ResourceMappingServiceUtils.replaceRmParamName(String.valueOf(cond.getPropName()));
            futures.add(ExecutionService.submit((Callable)new ResourceMappingCallable(resTypeEnum, newName, String.valueOf(cond.getPropValue()), recoverySite)));
        }
        JSONArray jsonArray = new JSONArray();
        try {
            for (Future future : futures) {
                jsonArray.addAll((Collection)future.get());
            }
        }
        catch (Exception e) {
            logger.error((Object)"catch InterruptedException, getFromFuture error:", (Throwable)e);
            ExceptionUtil.rethrowException((Throwable)e, (String)"", (long)-1L, null, (Log)logger);
        }
        FsRecoveryUtil.genResourceMapping(list, jsonArray);
        return list;
    }

    private static void genResourceMapping(List<ResourceMapping> list, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jObj = jsonArray.getJSONObject(i);
            if (null == jObj) continue;
            ResourceMapping resourceMapping = new ResourceMapping();
            resourceMapping.setMappingId(FsRecoveryUtil.getJsonStrIfExist(jObj, "mappingId"));
            Integer resourceType = FsRecoveryUtil.getJsonIntIfExist(jObj, "resourceType");
            if (null != resourceType) {
                resourceMapping.setResourceType(resourceType.intValue());
            }
            resourceMapping.setProductSiteId(FsRecoveryUtil.getJsonStrIfExist(jObj, "productSiteId"));
            resourceMapping.setProductSiteName(FsRecoveryUtil.getJsonStrIfExist(jObj, "productSiteName"));
            resourceMapping.setProductResourceProviderId(FsRecoveryUtil.getJsonStrIfExist(jObj, "productResourceProviderId"));
            resourceMapping.setProductResourceProviderName(FsRecoveryUtil.getJsonStrIfExist(jObj, "productResourceProviderName"));
            resourceMapping.setProductVpcId(FsRecoveryUtil.getJsonStrIfExist(jObj, "productVpcId"));
            resourceMapping.setProductVpcName(FsRecoveryUtil.getJsonStrIfExist(jObj, "productVpcName"));
            resourceMapping.setProductResourceId(FsRecoveryUtil.getJsonStrIfExist(jObj, "productResourceId"));
            resourceMapping.setProductResourceName(FsRecoveryUtil.getJsonStrIfExist(jObj, "productResourceName"));
            resourceMapping.setRecoverySiteId(FsRecoveryUtil.getJsonStrIfExist(jObj, "recoverySiteId"));
            resourceMapping.setRecoverySiteName(FsRecoveryUtil.getJsonStrIfExist(jObj, "recoverySiteName"));
            resourceMapping.setRecoveryResourceProviderId(FsRecoveryUtil.getJsonStrIfExist(jObj, "recoveryResourceProviderId"));
            resourceMapping.setRecoveryResourceProviderName(FsRecoveryUtil.getJsonStrIfExist(jObj, "recoveryResourceProviderName"));
            resourceMapping.setRecoveryVpcId(FsRecoveryUtil.getJsonStrIfExist(jObj, "recoveryVpcId"));
            resourceMapping.setRecoveryVpcName(FsRecoveryUtil.getJsonStrIfExist(jObj, "recoveryVpcName"));
            resourceMapping.setRecoveryResourceId(FsRecoveryUtil.getJsonStrIfExist(jObj, "recoveryResourceId"));
            resourceMapping.setRecoveryResourceName(FsRecoveryUtil.getJsonStrIfExist(jObj, "recoveryResourceName"));
            Integer role = FsRecoveryUtil.getJsonIntIfExist(jObj, "role");
            if (null != role) {
                resourceMapping.setRole(role.intValue());
            }
            list.add(resourceMapping);
        }
    }

    private static String getJsonStrIfExist(JSONObject jObj, String key) {
        if (jObj.containsKey((Object)key)) {
            return jObj.getString(key);
        }
        return null;
    }

    private static Integer getJsonIntIfExist(JSONObject jObj, String key) {
        if (jObj.containsKey((Object)key)) {
            return jObj.getInt(key);
        }
        return null;
    }

    private static JSONArray getRemoteRecords(String recoverySite, String url, Map<String, Object> uriVariables) {
        logger.debug((Object)"start getRemoteRecords, url: %s, recoverySite: %s, uriVariables: %s", new Object[]{url, recoverySite, uriVariables});
        RestClient client = SiteUtil.initClient((String)recoverySite);
        String response = client.get(url, uriVariables);
        logger.debug((Object)"end getRemoteRecords, url: %s, reponse: %s", new Object[]{url, response});
        if (VerifyUtil.isEmpty((String)response)) {
            return new JSONArray();
        }
        JSONObject returnObject = JSONObject.fromObject((Object)response);
        String records = returnObject.getString("records");
        if (VerifyUtil.isEmpty((String)records)) {
            return new JSONArray();
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)records);
        return jsonArray;
    }

    public static ResourceMapping getResourceMapping(String location, boolean isBindingHost, String dbItem, String productSiteId, String recoverySiteId) {
        ResTypeEnum type = !isBindingHost ? ResTypeEnum.CLUSTER_RESOURCE : ResTypeEnum.COMPUTE_NODE;
        return FsRecoveryUtil.getResourceMapping(location, type.getResType(), dbItem, productSiteId, recoverySiteId);
    }

    public static ResourceMapping getResourceMapping(String value, int type, String dbItem, String productSiteId, String recoverySiteId) {
        ArrayList<QueryCondition> props = new ArrayList<QueryCondition>();
        QueryCondition conditionType = new QueryCondition("resourceType", (Object)type);
        QueryCondition conditionHostOrClustor = new QueryCondition(dbItem, (Object)value);
        props.add(conditionType);
        props.add(conditionHostOrClustor);
        if (!VerifyUtil.isEmpty((String)productSiteId) && !VerifyUtil.isEmpty((String)recoverySiteId)) {
            QueryCondition conditionRecoverySiteId = new QueryCondition("recoverySiteId", (Object)recoverySiteId);
            props.add(conditionRecoverySiteId);
        }
        ResourceMapping res = FsRecoveryUtil.getResourceMapping(props, dbItem, value);
        return res;
    }

    public static ResourceMapping getResourceMapping(List<QueryCondition> props, String item, String value) {
        Page page = FusionSphereServiceManager.getInstance().getResourceMappingService().pageQueryResourceMapping(0, 10, item, true, props);
        if (null == page || null == page.getResult() || page.getTotalCount() <= 0L) {
            logger.info((Object)("Page is null or has no result.props is:" + props), 90160758786816L);
            return null;
        }
        List listMapping = page.getResult();
        if (VerifyUtil.isEmpty((Collection)listMapping)) {
            logger.debug((Object)"the pg of polist is null");
            logger.info((Object)"ResourceMapping is empty", 90160758786816L);
            return null;
        }
        logger.info((Object)("Value is:" + value), 90160758786816L);
        for (ResourceMapping rm : listMapping) {
            logger.info((Object)("ResourceMapping's productResourceId is " + rm.getProductResourceId()), 90160758786816L);
            if (!rm.getProductResourceId().equals(value)) continue;
            logger.info((Object)("ResourceMapping is " + rm), 90160758786816L);
            return rm;
        }
        logger.info((Object)("ResourceMapping is not found,and value is:" + value), 90160758786816L);
        return (ResourceMapping)listMapping.get(0);
    }

    public static String getVrmSnByPg(ProtectGroup pg, boolean isProduct, String productSiteId, String recoverySiteId) {
        String cloudSn = pg.getPoProviderSN();
        if (FusionSphereServiceManager.getInstance().getVrmService().isVrmSn(cloudSn) && isProduct) {
            return cloudSn;
        }
        if (VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            return null;
        }
        Iterator iterator = pg.getPolist().iterator();
        if (iterator.hasNext()) {
            ProtectObject po = (ProtectObject)iterator.next();
            JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
            String location = jo.getString(RpExParamsEnum.LOCATION.getValue());
            boolean isHostLoc = jo.getBoolean(RpExParamsEnum.HOST_LOC.getValue());
            ResourceMapping rm = FsRecoveryUtil.getResourceMapping(location, isHostLoc, "productResourceId", productSiteId, recoverySiteId);
            return FsRecoveryUtil.getVrmSn(rm, isProduct);
        }
        return null;
    }

    public static JSONObject getVmMgrInfo(ProtectObject po) {
        FixLengthProps poRecoveryProps = new FixLengthProps(po.getProps(), 8192);
        String vmMgrJson = poRecoveryProps.getValue(PoExParamsEnum.VM_MGR_INFO.getValue());
        if (!VerifyUtil.isEmpty((String)vmMgrJson)) {
            return JSONUtils.fromString((String)vmMgrJson);
        }
        return new JSONObject();
    }

    public static String getValueFromJsonKey(String json, String key) {
        if (VerifyUtil.isEmpty((String)json) || VerifyUtil.isEmpty((String)key)) {
            logger.debug((Object)"params json: %s, key: %s", new Object[]{json, key});
            return null;
        }
        try {
            JSONObject resultObj = JSONObject.fromObject((Object)json);
            if (resultObj.containsKey((Object)key)) {
                return resultObj.getString(key);
            }
            return null;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"convert json error", (Throwable)e);
            return null;
        }
    }

    public static List<GalaxVM> getFilterVms(String poProviderSn, Map<String, Object> extendCondition) {
        logger.info((Object)"enter getFilterVms", 90160758786816L);
        NetworkEntity cloudPlatform = FsRecoveryUtil.getPlatform(poProviderSn);
        if (cloudPlatform instanceof FusionManager) {
            return FsRecoveryUtil.getFMFilterVms((FusionManager)cloudPlatform, extendCondition);
        }
        if (cloudPlatform instanceof VRM) {
            return FsRecoveryUtil.getVmByCloudSn(new String[]{cloudPlatform.getUuid()}, GalaxVM.VMProviderType.FC, extendCondition);
        }
        logger.error((Object)"cloudPlatform is neither FM or FC", 1073947393L);
        return Collections.emptyList();
    }

    public static String getGlobalSettingFromPlan(RecoveryPlan plan, String key) {
        if (null == plan || VerifyUtil.isEmpty((String)key)) {
            logger.debug((Object)"params plan or key is null");
            return null;
        }
        Map settingMap = plan.getGlobalSettings();
        if (VerifyUtil.isEmpty((Map)settingMap)) {
            return null;
        }
        for (Map.Entry entry : settingMap.entrySet()) {
            if (!key.equals(entry.getKey())) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    private static List<GalaxVM> getFMFilterVms(FusionManager fm, Map<String, Object> extendCondition) {
        List vrms = FusionSphereServiceManager.getInstance().getFmService().getRegistedFcOfSpecfiedFm(fm.getSn());
        if (VerifyUtil.isEmpty((Collection)vrms)) {
            logger.info((Object)("no FC under FM(" + fm.getSn() + ")"), 90160758786816L);
            return Collections.emptyList();
        }
        String[] vrmUuidArray = new String[vrms.size()];
        for (int i = 0; i < vrms.size(); ++i) {
            vrmUuidArray[i] = ((VRM)vrms.get(i)).getUuid();
        }
        List<GalaxVM> ret = FsRecoveryUtil.getVmByCloudSn(vrmUuidArray, GalaxVM.VMProviderType.FM, extendCondition);
        logger.info((Object)("vm under FM size is " + ret.size()), 90160758786816L);
        return ret;
    }

    private static List<GalaxVM> getVmByCloudSn(String[] uuidArray, GalaxVM.VMProviderType providerType, Map<String, Object> extendCondition) {
        int length;
        boolean isPoAllow = false;
        boolean isTemplateAllow = false;
        if (null != extendCondition) {
            isPoAllow = Boolean.valueOf(String.valueOf(extendCondition.get("isPoAllow")));
            isTemplateAllow = Boolean.valueOf(String.valueOf(extendCondition.get("isTemplateAllow")));
        }
        if ((length = uuidArray.length) == 0) {
            return Collections.EMPTY_LIST;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb = sb.append("from GalaxVM as vm where vm.topMoUuid in (");
            Object[] params = new Object[length + 2];
            int i = 0;
            for (String dataStore : uuidArray) {
                params[i] = dataStore;
                sb.append("?");
                if (i == length - 1) continue;
                sb.append(',');
                ++i;
            }
            sb.append(") and vm.providerID=? ").append(" and vm.vmType!=? ");
            if (!isTemplateAllow) {
                sb.append(" and vm.template=false ");
            }
            if (!isPoAllow) {
                sb.append(" and vm.uuid not in (select moUuid from ProtectObject)");
            }
            sb.append(" order by vm.name asc");
            params[length] = providerType.getValue();
            params[length + 1] = VmTypeEnum.PLACE_HOLDER_VM.getStatus();
            return CommonDAOLocator.getBaseDao().getHibernateTemplate().find(sb.toString(), params);
        }
        catch (DataAccessException e) {
            logger.error((Object)"get Galax VM for create protect group failed", 90160758784002L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private static NetworkEntity getPlatform(String remoteCloudSn) {
        NetworkEntity cloudPlatform = (NetworkEntity)FusionSphereServiceManager.getInstance().getMoDao().getMo(NetworkEntity.class, "sn", (Object)remoteCloudSn);
        if (VerifyUtil.isEmpty((Object)cloudPlatform)) {
            logger.error((Object)"@@cloudPlatform is not exist.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        return cloudPlatform;
    }

    private static String getVrmSn(ResourceMapping rm, boolean isProduct) {
        if (null != rm) {
            if (isProduct) {
                return rm.getProductResourceProviderId();
            }
            return rm.getRecoveryResourceProviderId();
        }
        return null;
    }

    public static List<String> getInvalidSharedDiskVms(String pgId) {
        IProtectGroupBaseService pgService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        ProtectGroup pg = pgService.getProtectGroupByID(pgId);
        Set polist = pg.getPolist();
        ProtectObject po = (ProtectObject)polist.iterator().next();
        HashMap<String, Object> extendCondition = new HashMap<String, Object>();
        extendCondition.put("isPoAllow", true);
        extendCondition.put("isTemplateAllow", true);
        List<GalaxVM> fcVmList = FsRecoveryUtil.getFilterVms(po.getProviderSN(), extendCondition);
        List shareVmList = VrmUtil.findVmShareNotAllInGroup((Set)polist, fcVmList);
        ArrayList<String> result = new ArrayList<String>();
        if (!shareVmList.isEmpty()) {
            for (GalaxVM vm : shareVmList) {
                result.add(vm.getName());
            }
        }
        return result;
    }

    public static String getDrsVmIdList(ProtectObject po, String productSiteId, String recoverySiteId) {
        ProtectGroup protectGroup;
        if (VerifyUtil.isEmpty((String)productSiteId) || VerifyUtil.isEmpty((String)recoverySiteId)) {
            logger.error((Object)"Params error,productSiteId or recoverySiteId is null.");
            return "";
        }
        JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
        ResourceMapping res = FsRecoveryUtil.getResourceMapping(jo.getString("location"), jo.getBoolean("hostLoc"), "productResourceId", productSiteId, recoverySiteId);
        if (res == null) {
            ArrayList<QueryCondition> props = new ArrayList<QueryCondition>();
            QueryCondition conditionRecoverySiteId = new QueryCondition("recoverySiteId", (Object)productSiteId);
            QueryCondition conditionType = new QueryCondition("resourceType", (Object)ResTypeEnum.CLUSTER_RESOURCE.getResType());
            props.add(conditionRecoverySiteId);
            props.add(conditionType);
            res = FsRecoveryUtil.getResourceMapping(props, "productResourceProviderId", po.getProviderSN());
            if (res == null) {
                logger.error((Object)"Operate error,resourceMapping is null.");
                return "";
            }
        }
        String siteId = (protectGroup = po.getProtectGroup()).getProductSiteId().equals(recoverySiteId) ? recoverySiteId : productSiteId;
        IDrsMappingService drsMappingService = (IDrsMappingService)ServiceLocator.getInstance().getService(IDrsMappingService.class);
        List allMappingList = drsMappingService.getTotalDrsMapping(res.getMappingId());
        List activeDrsMappingList = allMappingList.stream().filter(DrsMapping::getIsValid).collect(Collectors.toList());
        logger.info((Object)"The queried drs mapping is %s, and the valid is %s", new Object[]{allMappingList.size(), activeDrsMappingList.size()});
        if (!activeDrsMappingList.isEmpty()) {
            Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(siteId);
            Map drsVmMap = drsMappingService.getVmsOfGroup(activeDrsMappingList, site);
            return JSONObject.fromObject((Object)drsVmMap).toString();
        }
        return "";
    }

    private static class ResourceMappingCallable
    implements Callable<JSONArray> {
        private ResTypeEnum resType;
        private String propName;
        private String propValue;
        private Site recoverySite;

        public ResourceMappingCallable(ResTypeEnum resType, String propName, String propValue, Site recoverySite) {
            this.resType = resType;
            this.propName = propName;
            this.propValue = propValue;
            this.recoverySite = recoverySite;
        }

        @Override
        public JSONArray call() throws Exception {
            HashMap<String, Object> uriVariables = new HashMap<String, Object>();
            uriVariables.put("resourceType", this.resType.getResType());
            uriVariables.put("filterName", this.propName);
            uriVariables.put("filterValue", this.propValue);
            String url = "/ws/resourcemapping?resourceType={resourceType}&filterName={filterName}&filterValue={filterValue}";
            JSONArray jsonArray = FsRecoveryUtil.getRemoteRecords(this.recoverySite.getSiteId(), url, uriVariables);
            return jsonArray;
        }
    }
}

