/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.common;

import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmStatusEnum;
import com.huawei.ism.drm.galax.recovery.common.ProtectObjectUtils;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;

public class ProtectObjectExtendUtils {
    private static final Log LOG = LogFactory.getInstance(ProtectObjectUtils.class);

    public static void generateVmBaseInfo(List<GalaxVM> vms, ProtectObject po, String providerSn) {
        if (null == po) {
            LOG.error((Object)"po is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(vms)) {
            return;
        }
        boolean vmNotExisted = true;
        for (GalaxVM vm : vms) {
            if (!vm.getUuid().equals(po.getMoUuid())) continue;
            vmNotExisted = false;
            po.setMoUuid(vm.getUuid());
            po.setName(vm.getName());
            po.setPoType(12);
            po.setProviderSN(providerSn);
            HashMap<String, String> props = po.getProps();
            if (props == null) {
                props = new HashMap<String, String>();
            }
            String vmId = vm.getUri().split("vms")[1].replace("/", "");
            props.put(PoExParamsEnum.VM_ID.getValue(), vmId);
            props.put(PoExParamsEnum.VM_OS_TYPE.getValue(), vm.getOsType());
            VmStatusEnum statusEnum = VmStatusEnum.findStatusByKey((int)vm.getStatus());
            props.put("VMSTATUS", null == statusEnum ? VmStatusEnum.UNKNOWN.getValue() : statusEnum.getValue());
            po.setProps(props);
            break;
        }
        if (vmNotExisted) {
            LOG.error((Object)"vm is not existed.");
            throw new LegoCheckedException(1073947394L);
        }
    }
}

