/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.common;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.HostToPowerOn;
import com.huawei.ism.drm.galax.sdk.model.NicInfoEntity;
import com.huawei.ism.drm.galax.sdk.model.TestNetwork;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmNicSpecification;
import com.huawei.ism.drm.galax.sdk.vrm.model.NicSpecification;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigNicType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.license.sdk.ILicenseBaseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.virtualization.sdk.model.DataStoreInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class RecoveryPlanUtil {
    private static Log logger = LogFactory.getInstance(RecoveryPlanUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ComputeNode> getAvaliableComputeNode(String recoveryUrn) {
        if (VerifyUtil.isEmpty((String)recoveryUrn)) {
            return new ArrayList<ComputeNode>();
        }
        ArrayList<ComputeNode> computeNodeList = new ArrayList();
        Session session = null;
        try {
            HibernateTemplate template = CommonDAOLocator.getMoDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            String queryHQL = "from ComputeNode cn where cn.computeClusterUrn=:recoveryUrn";
            Query query = session.createQuery(queryHQL);
            query.setString("recoveryUrn", recoveryUrn);
            computeNodeList = query.list();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Getting recovery logs failed. Id:" + recoveryUrn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                RecoveryPlanUtil.closeSession(session);
                throw throwable;
            }
            RecoveryPlanUtil.closeSession(session);
        }
        RecoveryPlanUtil.closeSession(session);
        return computeNodeList;
    }

    private static void closeSession(Session session) {
        DBOperationUtil.closeSession((Session)session);
    }

    public static List<ComputeNode> getPowerOnHost(RecoveryPlan plan) {
        if (null == plan) {
            return null;
        }
        Map globalSetting = plan.getGlobalSettings();
        if (VerifyUtil.isEmpty((Map)globalSetting) || VerifyUtil.isEmpty((String)((String)globalSetting.get("PoweronHost")))) {
            logger.info((Object)"@@globalSetting or the poweronHost is null ", 90160758786816L);
            return null;
        }
        String json = (String)globalSetting.get("PoweronHost");
        List hostList = (List)CommonUtil.json2Bean((String)json, HostToPowerOn[].class);
        ArrayList<ComputeNode> computeNodeList = new ArrayList<ComputeNode>();
        for (HostToPowerOn host : hostList) {
            ComputeNode cn = (ComputeNode)CommonDAOLocator.getMoDao().getMo(ComputeNode.class, "uuid", (Object)host.getUrn());
            if (VerifyUtil.isEmpty((Object)cn)) {
                logger.info((Object)("host is not exist, hostUrn is " + host.getUrn()), 90160758786816L);
                continue;
            }
            computeNodeList.add(cn);
        }
        Collections.sort(computeNodeList, new Comparator<ComputeNode>(){

            @Override
            public int compare(ComputeNode arg0, ComputeNode arg1) {
                if (arg0.getName() == null || arg1.getName() == null) {
                    return -1;
                }
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return computeNodeList;
    }

    public static List<NicInfoEntity> getNecsequenceNumListByPo(ProtectObject po) {
        ArrayList<NicInfoEntity> nicList;
        block4: {
            ResourcepoolVMServiceV2Stub.Nic[] fmNicArray;
            String vmConfig;
            String vmProviderType;
            block3: {
                nicList = new ArrayList<NicInfoEntity>();
                if (null == po) {
                    return nicList;
                }
                JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
                vmProviderType = jo.getString(RpExParamsEnum.VM_TYPE.getValue());
                vmConfig = jo.getString(RpExParamsEnum.VM_CONFIG.getValue());
                if (!GalaxVM.VMProviderType.FC.getValue().equals(vmProviderType)) break block3;
                VmConfigType vmConfigType = (VmConfigType)CommonUtil.jsonToBean((String)vmConfig, VmConfigType.class);
                List fcNics = vmConfigType.getNics();
                for (VmConfigNicType fcNic : fcNics) {
                    NicInfoEntity nicInfoEntity = new NicInfoEntity();
                    nicInfoEntity.setSequenceNum(fcNic.getSequenceNum());
                    nicInfoEntity.setName(fcNic.getName());
                    nicList.add(nicInfoEntity);
                }
                break block4;
            }
            if (!GalaxVM.VMProviderType.FM.getValue().equals(vmProviderType)) break block4;
            ResourcepoolVMServiceV2Stub.VmConfigSetE vmConfigType = (ResourcepoolVMServiceV2Stub.VmConfigSetE)CommonUtil.jsonToBean((String)vmConfig, ResourcepoolVMServiceV2Stub.VmConfigSetE.class);
            for (ResourcepoolVMServiceV2Stub.Nic nic : fmNicArray = vmConfigType.getNics()) {
                NicInfoEntity nicInfoEntity = new NicInfoEntity();
                nicInfoEntity.setSequenceNum(Integer.valueOf(nic.getSequenceNum()));
                nicInfoEntity.setName(nic.getName());
                nicList.add(nicInfoEntity);
            }
        }
        return nicList;
    }

    private static String getRecoveryPlanNicInfoJson(RecoveryPlan recoveryPlan, String poId) {
        RecoveryPlanProxy rpProxy = new RecoveryPlanProxy(recoveryPlan);
        RecoverySetting recoverySetting = rpProxy.getRecoverySetting(poId, "NicInfo");
        if (null == recoverySetting) {
            logger.info((Object)"recoverySetting is null.", 90160758786816L);
            return "";
        }
        String nicValue = recoverySetting.getValue();
        return nicValue;
    }

    public static List<NicSpecification> getFcNicInfoList(RecoveryPlan recoveryPlan, String poId) {
        List<Object> fcNicSpecList = new ArrayList<NicSpecification>();
        if (null == recoveryPlan || VerifyUtil.isEmpty((String)poId)) {
            return fcNicSpecList;
        }
        String nicInfoJson = RecoveryPlanUtil.getRecoveryPlanNicInfoJson(recoveryPlan, poId);
        if (null == nicInfoJson) {
            return fcNicSpecList;
        }
        fcNicSpecList = (List)CommonUtil.json2Bean((String)nicInfoJson, NicSpecification[].class);
        if (null == fcNicSpecList) {
            return new ArrayList<NicSpecification>();
        }
        return fcNicSpecList;
    }

    public static List<FmNicSpecification> getFmNicInfoList(RecoveryPlan recoveryPlan, String poId) {
        List<Object> fmNicSpecList = new ArrayList<FmNicSpecification>();
        if (null == recoveryPlan || VerifyUtil.isEmpty((String)poId)) {
            return fmNicSpecList;
        }
        String nicInfoJson = RecoveryPlanUtil.getRecoveryPlanNicInfoJson(recoveryPlan, poId);
        if (null == nicInfoJson) {
            return fmNicSpecList;
        }
        fmNicSpecList = (List)CommonUtil.json2Bean((String)nicInfoJson, FmNicSpecification[].class);
        if (null == fmNicSpecList) {
            return new ArrayList<FmNicSpecification>();
        }
        return fmNicSpecList;
    }

    public static void setUpdateFcNicList(List<Integer> proList, List<Integer> reList, List<Integer> addList, List<Integer> deleteList) {
        if (null == proList || null == reList || null == addList || null == deleteList) {
            logger.error((Object)"paramter is invalid.", 90160758787071L);
            return;
        }
        for (Integer reSequenceNum : reList) {
            deleteList.add(reSequenceNum);
        }
        for (Integer proSequenceNum : proList) {
            boolean flag = false;
            for (Integer reSequenceNum : reList) {
                if (!proSequenceNum.equals(reSequenceNum)) continue;
                flag = true;
                break;
            }
            if (flag) {
                deleteList.remove(proSequenceNum);
                continue;
            }
            addList.add(proSequenceNum);
        }
    }

    public static <T> void addEmptyNicToList(List<T> nicList, List<Integer> addList, Class<T> clazz) {
        if (null == nicList || null == addList || null == clazz) {
            logger.error((Object)"paramter is invalid.", 90160758787071L);
            return;
        }
        if (NicSpecification.class == clazz) {
            for (Integer sequenceNum : addList) {
                NicSpecification nicFc = new NicSpecification();
                nicFc.setSequenceNum(sequenceNum);
                nicList.add(clazz.cast(nicFc));
            }
        } else {
            for (Integer sequenceNum : addList) {
                FmNicSpecification nicFm = new FmNicSpecification();
                nicFm.setSequenceNum(sequenceNum);
                nicFm.setAdddns("");
                nicFm.setAdddns6("");
                nicFm.setSetdns("");
                nicFm.setSetdns6("");
                nicList.add(clazz.cast(nicFm));
            }
        }
    }

    public static <T> void deleteNic(List<T> nicList, List<Integer> deleteList, Class<T> clazz) {
        if (null == nicList || null == deleteList || null == clazz) {
            logger.error((Object)"paramter is invalid.", 90160758787071L);
            return;
        }
        if (NicSpecification.class == clazz) {
            RecoveryPlanUtil.deleteSpecifNic(nicList, deleteList);
        } else {
            RecoveryPlanUtil.deleteFmNicNic(nicList, deleteList);
        }
    }

    private static <T> void deleteSpecifNic(List<T> nicList, List<Integer> deleteList) {
        for (Integer sequenceNum : deleteList) {
            NicSpecification fcNic = null;
            for (T t : nicList) {
                NicSpecification nic = (NicSpecification)NicSpecification.class.cast(t);
                if (!sequenceNum.equals(nic.getSequenceNum())) continue;
                fcNic = nic;
                break;
            }
            if (null == fcNic) continue;
            nicList.remove(fcNic);
        }
    }

    private static <T> void deleteFmNicNic(List<T> nicList, List<Integer> deleteList) {
        for (Integer sequenceNum : deleteList) {
            FmNicSpecification fmNic = null;
            for (T t : nicList) {
                FmNicSpecification nic = (FmNicSpecification)FmNicSpecification.class.cast(t);
                if (!sequenceNum.equals(nic.getSequenceNum())) continue;
                fmNic = nic;
                break;
            }
            if (null == fmNic) continue;
            nicList.remove(fmNic);
        }
    }

    public static <T> void updateNicList(List<T> nicList, T nic, Class<T> clazz) {
        if (null == nicList || null == nic || null == clazz) {
            logger.error((Object)"paramter is invalid.", 90160758787071L);
            return;
        }
        int oldNicInfoLocation = -1;
        if (NicSpecification.class == clazz) {
            for (int i = 0; i < nicList.size(); ++i) {
                T t = nicList.get(i);
                NicSpecification fcNicInfoTemp = (NicSpecification)NicSpecification.class.cast(t);
                NicSpecification updateFcNicInfo = (NicSpecification)NicSpecification.class.cast(nic);
                if (!fcNicInfoTemp.getSequenceNum().equals(updateFcNicInfo.getSequenceNum())) continue;
                oldNicInfoLocation = i;
                break;
            }
        } else {
            for (int i = 0; i < nicList.size(); ++i) {
                T t = nicList.get(i);
                FmNicSpecification fmNicInfoTemp = (FmNicSpecification)FmNicSpecification.class.cast(t);
                FmNicSpecification updateFmNicInfo = (FmNicSpecification)FmNicSpecification.class.cast(nic);
                if (!fmNicInfoTemp.getSequenceNum().equals(updateFmNicInfo.getSequenceNum())) continue;
                oldNicInfoLocation = i;
                break;
            }
        }
        if (oldNicInfoLocation >= 0) {
            nicList.set(oldNicInfoLocation, nic);
        } else {
            nicList.add(nic);
        }
    }

    public static void saveRePlanNicInfo(RecoveryPlan recoveryPlan, String poId, String jsonRePlanNicInfo) {
        if (null == recoveryPlan || null == poId) {
            logger.error((Object)"paramter is invalid.", 90160758787071L);
            return;
        }
        RecoveryPlanProxy rpProxy = new RecoveryPlanProxy(recoveryPlan);
        RecoverySetting recoverySetting = rpProxy.getRecoverySetting(poId, "NicInfo");
        if (null == recoverySetting) {
            logger.info((Object)"can not get RecoverySetting from RecoveryPlan,create a new RecoverSetting.", 90160758786816L);
            recoverySetting = new RecoverySetting();
            recoverySetting.setName("NicInfo");
            recoverySetting.setOwnerId(poId);
            recoverySetting.setRecoveryPlan(recoveryPlan);
            String disasterSiteId = rpProxy.getRecoverySite();
            recoverySetting.setDisasterSiteId(disasterSiteId);
            recoverySetting.setValue(jsonRePlanNicInfo);
            recoveryPlan.getRecoverySettings().add(recoverySetting);
        } else {
            recoverySetting.setValue(jsonRePlanNicInfo);
        }
        logger.info((Object)("Nic info is : " + jsonRePlanNicInfo), 90160758786816L);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
    }

    public static List<TestNetwork> getRemoteTestNetworks(Site site, String planId) {
        ArrayList<TestNetwork> testNetworkList = new ArrayList<TestNetwork>();
        if (null == site || null == planId) {
            logger.error((Object)"paramter is invalid.", 90160758787071L);
            return testNetworkList;
        }
        RestClient client = SiteUtil.initClient((Site)site);
        StringBuilder request = new StringBuilder();
        request.append("/ws/resourcemapping/action/getTestnetworks?planId=").append(planId).append("&recoverySiteId=").append(site.getSiteId());
        String jsonStr = client.getReourceCollect(request.toString());
        try {
            JSONObject obj = JSONObject.fromObject((Object)jsonStr);
            JSONArray array = obj.getJSONArray("testNetworkList");
            if (null == array) {
                return testNetworkList;
            }
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                TestNetwork network = new TestNetwork();
                network.setProUrn(jsonObject.getString("proUrn"));
                network.setProName(jsonObject.getString("proName"));
                network.setDrUrn(jsonObject.getString("drUrn"));
                network.setDrName(jsonObject.getString("drName"));
                network.setTestUrn(jsonObject.getString("testUrn"));
                network.setTestName(jsonObject.getString("testName"));
                testNetworkList.add(network);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("create json object error. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return testNetworkList;
    }

    public static List<TestNetwork> getRemoteAllNetworks(Site site, String planId, String urn) {
        ArrayList<TestNetwork> testNetworkList = new ArrayList<TestNetwork>();
        if (null == site || null == planId || null == urn) {
            logger.error((Object)"paramter is invalid.", 90160758787071L);
            return testNetworkList;
        }
        RestClient client = SiteUtil.initClient((Site)site);
        StringBuilder request = new StringBuilder();
        request.append("/ws/fusionsphere/networks?planId=").append(planId).append("&").append("recNetworkUrn=").append(urn);
        String jsonStr = client.getReourceCollect(request.toString());
        try {
            JSONArray array = JSONArray.fromObject((Object)jsonStr);
            for (int i = 0; i < array.size(); ++i) {
                Object json = array.get(i);
                JSONObject jsonObject = JSONObject.fromObject((Object)json);
                TestNetwork network = new TestNetwork();
                network.setTestUrn(jsonObject.getString("testUrn"));
                network.setTestName(jsonObject.getString("testName"));
                testNetworkList.add(network);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("create json object error. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return testNetworkList;
    }

    public static List<DataStore> getDataStoreFromPg(ProtectGroup pg) {
        if (null == pg) {
            logger.error((Object)"parameter pg is null.", 90160758787071L);
            return null;
        }
        String dsInfosStr = (String)pg.getProps().get("pgDsInfo");
        if (null == dsInfosStr || dsInfosStr.isEmpty()) {
            logger.error((Object)"parameter pgDsInfo is empty.");
            return null;
        }
        JSONArray dsArray = JSONArray.fromObject((Object)dsInfosStr);
        List dataStoreInfoSet = JSONArray.toCollection((JSONArray)dsArray, DataStoreInfo.class);
        if (null == dataStoreInfoSet) {
            logger.error((Object)"parameter dataStoreInfoSet is empty.");
            return null;
        }
        HashSet<String> dsUuidSet = new HashSet<String>();
        for (DataStoreInfo storeInfo : dataStoreInfoSet) {
            dsUuidSet.add(storeInfo.getDataStoreUuid());
        }
        QueryCondition qc = new QueryCondition("uuid", (Object)dsUuidSet.toArray(), 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        return CommonDAOLocator.getMoDao().findMoBy(DataStore.class, qcList);
    }

    public static String createRecoveryPlan(ProtectGroup pg) {
        RecoveryPlan recoveryPlan = new RecoveryPlan();
        recoveryPlan.setName(pg.getName());
        recoveryPlan.setDescription(pg.getDescription());
        recoveryPlan.setRecoverySettings(new HashSet());
        HashMap<String, String> globalSettings = new HashMap<String, String>();
        globalSettings.put("isReserved", "true");
        recoveryPlan.setGlobalSettings(globalSettings);
        HashSet<ProtectGroup> pgSet = new HashSet<ProtectGroup>();
        pgSet.add(pg);
        recoveryPlan.setProtectGroups(pgSet);
        IRecoveryPlanBaseService planService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        ILicenseBaseControl licenseControl = (ILicenseBaseControl)ServiceLocator.getInstance().getService(ILicenseBaseControl.class);
        licenseControl.checkEnablePgCount(pg);
        recoveryPlan.setPlanType(planService.getSuitablePlanType(pg).getValue());
        return planService.createRecoveryPlan(pg.getOwnerId().longValue(), recoveryPlan);
    }
}

