/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.excuter;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.util.common.task.controller.BatchExecuteTaskManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ProcessConcurrentExcuter {
    private static final Log logger = LogFactory.getInstance(ProcessConcurrentExcuter.class);
    private static final int TOTALPROCESSRATIO = 100;
    private RecoveryProcessorContext context;
    private RecoveryPlan recoveryPlan;
    private RecoveryProcessor parrentProcess;

    public ProcessConcurrentExcuter(RecoveryProcessorContext context, RecoveryProcessor parrentProcess) {
        this.context = context;
        this.parrentProcess = parrentProcess;
        this.recoveryPlan = (RecoveryPlan)context.getAttribute("RecoveryPlan");
    }

    private int getPoNum() {
        Set protectGroups = this.recoveryPlan.getProtectGroups();
        int count = 0;
        for (ProtectGroup pg : protectGroups) {
            count += pg.getPolist().size();
        }
        return count;
    }

    public Map<Integer, Set<RecoveryProcessor>> caculateProcessorQueue(boolean isAsc) {
        int count = this.getPoNum();
        TreeMap<Integer, Set<RecoveryProcessor>> mapQueue = new TreeMap<Integer, Set<RecoveryProcessor>>();
        for (RecoveryProcessor recProcess : this.parrentProcess.getChildProc()) {
            this.calculateStartupProcessor(mapQueue, recProcess, count, isAsc);
        }
        return mapQueue;
    }

    private void calculateStartupProcessor(Map<Integer, Set<RecoveryProcessor>> mapQueue, RecoveryProcessor processor, int defaultCount, boolean isAsc) {
        Integer startupNo = this.getProcessorStartupNo((GalaxBaseSubRecoveryProcessor)processor, defaultCount, isAsc);
        Set<RecoveryProcessor> listRP = mapQueue.get(startupNo);
        if (null == listRP) {
            listRP = new HashSet<RecoveryProcessor>();
        }
        listRP.add(processor);
        mapQueue.put(startupNo, listRP);
    }

    private Integer getProcessorStartupNo(GalaxBaseSubRecoveryProcessor processor, int defaultCount, boolean isAsc) {
        Integer startupNo = defaultCount;
        int flag = isAsc ? 1 : -1;
        RecoveryPlanProxy rpProxy = new RecoveryPlanProxy(this.recoveryPlan);
        int orinalStarup = rpProxy.getVmStartupOrder(processor.getGalaxId());
        if (orinalStarup != Integer.MAX_VALUE) {
            startupNo = orinalStarup * flag;
        }
        return startupNo;
    }

    private List<IProcessor> getProcessorsByOrder(boolean isAsc) {
        Map<Integer, Set<RecoveryProcessor>> mapStartup = this.caculateProcessorQueue(isAsc);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.parrentProcess.getProcType());
        ArrayList<IProcessor> listProcessor = new ArrayList<IProcessor>();
        Set<Map.Entry<Integer, Set<RecoveryProcessor>>> entrySet = mapStartup.entrySet();
        for (Map.Entry<Integer, Set<RecoveryProcessor>> entry : entrySet) {
            RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(entry.getValue(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
            if (null != recoveryTemplate) {
                listProcessor.add((IProcessor)recoveryTemplate);
            }
            logger.info((Object)("Recovery Setp OrderVm:StartupNo(" + entry.getKey() + ")'s process:" + listProcessor), 90160758786816L);
        }
        return listProcessor;
    }

    private List<IProcessor> getConcurrentProcessorsByOrder(boolean isAsc) {
        Map<Integer, Set<RecoveryProcessor>> mapStartup = this.caculateProcessorQueue(isAsc);
        ArrayList<IProcessor> listProcessor = new ArrayList<IProcessor>();
        Set<Map.Entry<Integer, Set<RecoveryProcessor>>> entrySet = mapStartup.entrySet();
        for (Map.Entry<Integer, Set<RecoveryProcessor>> entry : entrySet) {
            RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(entry.getValue()));
            if (null != recoveryTemplate) {
                listProcessor.add((IProcessor)recoveryTemplate);
            }
            logger.info((Object)("Recovery Setp OrderVm:StartupNo(" + entry.getKey() + ")'s process:" + listProcessor), 90160758786816L);
        }
        return listProcessor;
    }

    public void excuteProcessByOrder(String poolName, boolean isAsc) {
        List<IProcessor> listProcessor = this.getProcessorsByOrder(isAsc);
        this.updateProgressRatio();
        for (IProcessor recoveryTemplate : listProcessor) {
            recoveryTemplate.process(this.context);
            this.concurrentExcuteProcessorTemplate(poolName);
        }
    }

    public void serialExecuteProcess(String poolName) {
        List<IProcessor> listProcessor = this.getSerialProcessors();
        this.updateProgressRatio();
        for (IProcessor recoveryTemplate : listProcessor) {
            recoveryTemplate.process(this.context);
            this.concurrentExcuteProcessorTemplate(poolName);
        }
    }

    private List<IProcessor> getSerialProcessors() {
        ArrayList<IProcessor> listProcessor = new ArrayList<IProcessor>();
        for (RecoveryProcessor recProcess : this.parrentProcess.getChildProc()) {
            RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(Collections.singletonList(recProcess));
            if (recoveryTemplate != null) {
                listProcessor.add((IProcessor)recoveryTemplate);
            }
            logger.info((Object)"Serial Execution:(%s)'s process:%s.", new Object[]{recProcess.getName(), listProcessor});
        }
        return listProcessor;
    }

    public void excuteProcessByOrder(String poolName, boolean isAsc, boolean isNeedAllSuccess) {
        List<IProcessor> listProcessor = this.getConcurrentProcessorsByOrder(isAsc);
        this.updateProgressRatio();
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.parrentProcess.getProcType());
        RecoveryProcessSerialExecutor serialExecutor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(listProcessor, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (serialExecutor != null) {
            serialExecutor.process(this.context);
        }
    }

    public void concurrentExcuteSubProcessors(String poolName) {
        this.excuteProcessorTemplate();
        this.concurrentExcuteProcessorTemplate(poolName);
    }

    public void excuteProcessorTemplate() {
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.parrentProcess.getProcType());
        if (VerifyUtil.isEmpty((Collection)this.parrentProcess.getChildProc())) {
            logger.info((Object)("Sub processor is empty,name is" + this.parrentProcess.getName()), 90160758786816L);
            return;
        }
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.parrentProcess.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == recoveryTemplate) {
            logger.info((Object)("get recovery Template error in" + this.parrentProcess.getName()), 90160758786816L);
            return;
        }
        recoveryTemplate.process(this.context);
    }

    private void concurrentExcuteProcessorTemplate(String poolName) {
        if (VerifyUtil.isEmpty((String)poolName)) {
            logger.info((Object)("PoolName is empty,parrent processor name is" + this.parrentProcess.getName()), 90160758786816L);
            return;
        }
        boolean flag = BatchExecuteTaskManager.getInstance((String)poolName).waitTask(this.parrentProcess.getProcId());
        if (!flag) {
            BatchExecuteTaskManager.getInstance((String)poolName).shutDownAllTask(this.parrentProcess.getProcId());
        }
    }

    private void updateProgressRatio() {
        ArrayList processors = new ArrayList(this.parrentProcess.getChildProc());
        if (processors.isEmpty()) {
            return;
        }
        int totalProgressRatio = 100;
        RecoveryProcessor proc = (RecoveryProcessor)processors.get(0);
        if (null != proc.getParentProc()) {
            totalProgressRatio = proc.getParentProc().getProgressRatio();
        }
        int avgProgressRatio = totalProgressRatio / processors.size();
        int index = 0;
        int countProgressRatio = 0;
        for (Object obj : processors) {
            RecoveryProcessor pp = (RecoveryProcessor)obj;
            if (++index == processors.size()) {
                pp.setProgressRatio(totalProgressRatio - countProgressRatio);
                continue;
            }
            countProgressRatio += avgProgressRatio;
            pp.setProgressRatio(avgProgressRatio);
        }
    }
}

