/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SafeBufferedReader;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GalaxExecuteScriptProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6881483931515474905L;
    private static final Log LOGGER = LogFactory.getInstance(GalaxExecuteScriptProcessor.class);
    private static final String BACK_PATH = "/Runtime/LegoRuntime/tools";
    private static final long THRITY_MINUTES = 1800000L;
    private static final String SUCCESS_RSULT = "Result:0";
    private static final String CODE_UTF_8 = "UTF-8";
    private String processorName;
    private String scriptName;
    private String installPath = "";

    public String getProcessorName() {
        return this.processorName;
    }

    public void setProcessorName(String processorName) {
        this.processorName = processorName;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)("@@Begin to excute script" + this.getProcessorName() + this.getScriptName()), 90160758786816L);
        this.updateProcessName(this.getProcessorName());
        int successStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        if (successStatus == this.getProcStatus()) {
            LOGGER.info((Object)("@@the script has been excuted successfully" + this.getScriptName()), 90160758786816L);
            return true;
        }
        Boolean isContinueIfFailed = Boolean.parseBoolean((String)this.getProps().get("EXECUTE_POLICY"));
        boolean excuteResult = this.executeCustomScript();
        if (!excuteResult && !isContinueIfFailed.booleanValue()) {
            LOGGER.info((Object)"@@Failed to excute script.", 90160758787071L);
            return false;
        }
        if (excuteResult) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    private boolean executeCustomScript() {
        String fileName = this.getScriptName();
        LOGGER.info((Object)("@@the script name is :" + fileName), 90160758786816L);
        if (!this.fileIsValid(fileName)) {
            this.updateProcessDetail("ism.drm.recovery.process.script.file.name.is.invalid", new String[0]);
            LOGGER.error((Object)("@@file name Is invalid " + fileName), 90160758787071L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        String filePath = this.getFilePath();
        if (!this.fileIsExist(filePath)) {
            this.updateProcessDetail("ism.drm.recovery.process.script.file.is.not.exist", new String[0]);
            LOGGER.error((Object)"@@file Is not exist.", 90160758787071L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (!this.fileCanExcute(filePath)) {
            this.updateProcessDetail("ism.drm.recovery.process.script.file.is.not.accesible", new String[0]);
            LOGGER.error((Object)"@@file can not be accessible.", 90160758787071L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        boolean excuteResult = this.excuteScript(filePath);
        if (!excuteResult) {
            LOGGER.info((Object)"@@Failed to excute script.", 90160758787071L);
            return false;
        }
        return true;
    }

    private boolean fileCanExcute(String filePath) {
        if (VerifyUtil.isEmpty((String)filePath)) {
            LOGGER.error((Object)"@@filePath is empty", 90160758787071L);
            return false;
        }
        StringBuilder path = new StringBuilder();
        path.append(filePath).append(File.separator).append(this.getScriptName());
        File scriptFile = new File(path.toString());
        if (scriptFile.canExecute()) {
            return true;
        }
        LOGGER.error((Object)"@@file can not be executed", 90160758787071L);
        return false;
    }

    private boolean fileIsValid(String fileName) {
        if (VerifyUtil.isEmpty((String)fileName)) {
            LOGGER.error((Object)"@@fileName is empty", 90160758787071L);
            return false;
        }
        String reg = "^([a-zA-Z0-9_\u4e00-\u9fa5]{1}[\u4e00-\u9fa5\\w-]*(\\.bat|\\.sh){1})$";
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFKC);
        Matcher matcher = Pattern.compile(reg).matcher(fileName);
        if (!matcher.matches()) {
            LOGGER.error((Object)"@@fileName is invalid", 90160758787071L);
            return false;
        }
        return true;
    }

    private boolean excuteScript(String filePath) {
        boolean runResult;
        if (VerifyUtil.isEmpty((String)filePath)) {
            LOGGER.error((Object)"@@filePath is empty", 90160758787071L);
            return false;
        }
        StringBuilder path = new StringBuilder();
        path.append(filePath).append(File.separator).append(this.getScriptName());
        String cmd = path.toString();
        try {
            runResult = this.runShell(cmd);
        }
        catch (Exception e) {
            LOGGER.error((Object)("@@cmdUtil.runShell failed for the exception is " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return false;
        }
        return runResult;
    }

    private boolean runShell(String shStr) {
        Process process;
        String[] cmds = this.generateCmd(shStr);
        ProcessBuilder builder = new ProcessBuilder(cmds);
        try {
            process = builder.start();
        }
        catch (IOException e) {
            LOGGER.error((Object)("@@runShell failed for the exception is " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.updateProcessDetail("ism.drm.recovery.process.excute.script.failed", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        InputStream tempErrorStream = process.getErrorStream();
        InputStream tempInputStream = process.getInputStream();
        ExecuteThread errorStream = new ExecuteThread(tempErrorStream);
        ExecuteThread inputStream = new ExecuteThread(tempInputStream);
        errorStream.start();
        inputStream.start();
        try {
            errorStream.join(1800000L);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"@@runShell failed for reading errorStream timeout", (Throwable)e, 90160758787071L);
            this.updateProcessDetail("ism.drm.recovery.process.excute.script.timeout", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        try {
            inputStream.join(1800000L);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"@@runShell failed for reading inputStream timeout", (Throwable)e, 90160758787071L);
            this.updateProcessDetail("ism.drm.recovery.process.excute.script.timeout", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        String errstr = errorStream.getReturnValue().toString().trim();
        String sucstr = inputStream.getReturnValue().toString().trim();
        Worker worker = new Worker(process);
        worker.start();
        try {
            worker.join(1800000L);
            Integer result = worker.exit;
            if (result != null) {
                if (0 != result) {
                    if (sucstr.contains(SUCCESS_RSULT)) {
                        return true;
                    }
                    this.updateProcessDetail("ism.drm.recovery.process.excute.script.failed", new String[0]);
                    this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                    LOGGER.error((Object)("@@rusnShell failed because of " + errstr), -1L);
                    return false;
                }
                return true;
            }
            LOGGER.error((Object)"@@runShell failed for timeout", 90160758787071L);
            this.updateProcessDetail("ism.drm.recovery.process.excute.script.timeout", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (InterruptedException ex) {
            worker.interrupt();
            Thread.currentThread().interrupt();
            LOGGER.error((Object)"@@runShell failed for timeout", (Throwable)ex, 90160758787071L);
            this.updateProcessDetail("ism.drm.recovery.process.excute.script.timeout", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
    }

    private boolean fileIsExist(String filePath) {
        File dir = new File(filePath);
        if (!dir.isDirectory()) {
            LOGGER.error((Object)"@@filePath is not a directory.", 90160758787071L);
            return false;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".sh") || name.endsWith(".bat");
            }
        };
        File[] fileList = dir.listFiles(filter);
        ArrayList<String> fileNames = new ArrayList<String>();
        if (fileList != null) {
            for (File file : fileList) {
                fileNames.add(file.getName());
            }
        }
        if (fileNames.contains(this.getScriptName())) {
            LOGGER.info((Object)("@@fileName is :" + ((Object)fileNames).toString()), 90160758786816L);
            return true;
        }
        return false;
    }

    private String getFilePath() {
        String userDir = RecoveryToolsUtil.getInstance().getUserDirectoryInSystemProperties();
        if (VerifyUtil.isEmpty((String)userDir)) {
            LOGGER.error((Object)"there is no directory from system roperty user.dir", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        int pos = userDir.lastIndexOf("LegoRuntime");
        if (pos < 0) {
            LOGGER.error((Object)"there is not the install directory of system.", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        String installFile = userDir.substring(0, pos) + "bin" + File.separator + "RDInstalled.xml";
        File file = new File(installFile);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            CommonUtil.setSecurityFeatures((DocumentBuilderFactory)factory);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nl = doc.getElementsByTagName("install");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element bookElement = (Element)nl.item(i);
                NodeList childNodes = bookElement.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node node = childNodes.item(j);
                    this.degradeParseXML(node);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"@@parseXML error:", (long)-1L, null, (Log)LOGGER);
        }
        return this.installPath + BACK_PATH;
    }

    private void degradeParseXML(Node node) {
        if (node.getNodeType() == 1 && "installpath".equals(node.getNodeName())) {
            NamedNodeMap nnm = node.getAttributes();
            this.installPath = nnm.getNamedItem("path").getNodeValue();
        }
    }

    protected String generateResultKey() {
        return null;
    }

    private String[] generateCmd(String shStr) {
        String[] resultCmdArray = new String[]{"", "", ""};
        resultCmdArray[0] = "/bin/sh";
        resultCmdArray[1] = shStr;
        return resultCmdArray;
    }

    private static class Worker
    extends Thread {
        private final Process process;
        private Integer exit;

        public Worker(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                this.exit = this.process.waitFor();
            }
            catch (InterruptedException ignore) {
                LOGGER.error((Object)"@@get the result of the excuite script exception", (Throwable)ignore, -1L);
            }
        }
    }

    static class ExecuteThread
    extends Thread {
        private InputStreamReader inputStreamReader;
        private StringBuilder returnValue;
        private List<String> readValueList = new ArrayList<String>();

        public ExecuteThread(InputStream inputStream) {
            try {
                if (null != inputStream) {
                    this.inputStreamReader = new InputStreamReader(inputStream, GalaxExecuteScriptProcessor.CODE_UTF_8);
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.info((Object)("uft-8 not support:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
            this.returnValue = new StringBuilder();
        }

        public StringBuilder getReturnValue() {
            return this.returnValue;
        }

        public List<String> getReadValueList() {
            return this.readValueList;
        }

        public void setReadValueList(List<String> readValueList) {
            this.readValueList = readValueList;
        }

        public void setReturnValue(StringBuilder returnValue) {
            this.returnValue = returnValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SafeBufferedReader bufferedReader = new SafeBufferedReader((Reader)this.inputStreamReader);
            try {
                String readValue;
                while (null != (readValue = bufferedReader.readLine())) {
                    this.returnValue.append(readValue);
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)ExceptionUtil.getErrorMessage((Throwable)e), -1L);
            }
            catch (Exception e) {
                LOGGER.warn((Object)ExceptionUtil.getErrorMessage((Throwable)e), -1L);
            }
            finally {
                this.closeStream((Closeable)bufferedReader);
                this.closeStream(this.inputStreamReader);
            }
        }

        public void closeStream(Closeable close) {
            if (close != null) {
                try {
                    close.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Close IOException", (Throwable)e, -1L);
                }
            }
        }
    }
}

