/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.excuter.ProcessConcurrentExcuter;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.factory.ISubProcessorFactory;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Set;

public class StartVmRecoveryProcessor
extends GalaxBaseRecoveryProcessor {
    private static final long serialVersionUID = 493868033731479235L;
    private static final Log logger = LogFactory.getInstance(StartVmRecoveryProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"Ready to start vms.");
        this.setContextRef(context);
        this.updateProcessName(this.calcProcessName());
        this.updateSubProcessors(context);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"No vm need start.");
            return this.endRecoveryProcessWithoutProcessor("ism.drm.recovery.process.no.need", true);
        }
        ProcessConcurrentExcuter excuter = new ProcessConcurrentExcuter(context, (RecoveryProcessor)this);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            excuter.concurrentExcuteSubProcessors("vrm_batchExecuteStartVM");
        } else {
            excuter.excuteProcessByOrder("vrm_batchExecuteStartVM", true);
        }
        logger.info((Object)"Complete the process of start vm.");
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.calcProcessResultBySubProc();
            return true;
        }
        boolean ret = this.calcExcuteResult();
        this.aferExcuteProcssor(context);
        return ret;
    }

    protected void aferExcuteProcssor(RecoveryProcessorContext context) {
    }

    private boolean updateSubProcessors(RecoveryProcessorContext context) {
        ISubProcessorFactory subProcessorFactory = this.getSubProcessorFactory();
        if (subProcessorFactory == null) {
            return false;
        }
        Set<RecoveryProcessor> subProcessors = subProcessorFactory.createStartVmSubProcessors(context, (RecoveryProcessor)this);
        return this.saveProcessors(subProcessors);
    }

    public void updateProcessName() {
        this.setProcName(this.calcProcessName());
    }

    private String calcProcessName() {
        String processName = DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType() ? "ism.drm.clean.startvm.host.process.name" : ((Object)((Object)this)).getClass().getName();
        return processName;
    }

    public void updateDescription() {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.galax.storage.recovery.process.VsRecoveryNoncriticalVmProcessor.des");
        }
    }
}

